/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum GuidanceResponseStatus {
    SUCCESS,
    DATAREQUESTED,
    DATAREQUIRED,
    INPROGRESS,
    FAILURE,
    ENTEREDINERROR,
    NULL;


    public static GuidanceResponseStatus fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("success".equals(codeString)) {
            return SUCCESS;
        }
        if ("data-requested".equals(codeString)) {
            return DATAREQUESTED;
        }
        if ("data-required".equals(codeString)) {
            return DATAREQUIRED;
        }
        if ("in-progress".equals(codeString)) {
            return INPROGRESS;
        }
        if ("failure".equals(codeString)) {
            return FAILURE;
        }
        if ("entered-in-error".equals(codeString)) {
            return ENTEREDINERROR;
        }
        throw new FHIRException("Unknown GuidanceResponseStatus code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case SUCCESS: {
                return "success";
            }
            case DATAREQUESTED: {
                return "data-requested";
            }
            case DATAREQUIRED: {
                return "data-required";
            }
            case INPROGRESS: {
                return "in-progress";
            }
            case FAILURE: {
                return "failure";
            }
            case ENTEREDINERROR: {
                return "entered-in-error";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/guidance-response-status";
    }

    public String getDefinition() {
        switch (this) {
            case SUCCESS: {
                return "The request was processed successfully.";
            }
            case DATAREQUESTED: {
                return "The request was processed successfully, but more data may result in a more complete evaluation.";
            }
            case DATAREQUIRED: {
                return "The request was processed, but more data is required to complete the evaluation.";
            }
            case INPROGRESS: {
                return "The request is currently being processed.";
            }
            case FAILURE: {
                return "The request was not processed successfully.";
            }
            case ENTEREDINERROR: {
                return "The response was entered in error.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case SUCCESS: {
                return "Success";
            }
            case DATAREQUESTED: {
                return "Data Requested";
            }
            case DATAREQUIRED: {
                return "Data Required";
            }
            case INPROGRESS: {
                return "In Progress";
            }
            case FAILURE: {
                return "Failure";
            }
            case ENTEREDINERROR: {
                return "Entered In Error";
            }
        }
        return "?";
    }
}

