/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ImmunizationFundingSource {
    PRIVATE,
    PUBLIC,
    NULL;


    public static ImmunizationFundingSource fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("private".equals(codeString)) {
            return PRIVATE;
        }
        if ("public".equals(codeString)) {
            return PUBLIC;
        }
        throw new FHIRException("Unknown ImmunizationFundingSource code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PRIVATE: {
                return "private";
            }
            case PUBLIC: {
                return "public";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/immunization-funding-source";
    }

    public String getDefinition() {
        switch (this) {
            case PRIVATE: {
                return "The vaccine was purchased with private funds.";
            }
            case PUBLIC: {
                return "The vaccine was purchased with public funds.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PRIVATE: {
                return "Private";
            }
            case PUBLIC: {
                return "Public";
            }
        }
        return "?";
    }
}

