/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.InvoiceStatus;

public class InvoiceStatusEnumFactory
implements EnumFactory<InvoiceStatus> {
    @Override
    public InvoiceStatus fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("draft".equals(codeString)) {
            return InvoiceStatus.DRAFT;
        }
        if ("issued".equals(codeString)) {
            return InvoiceStatus.ISSUED;
        }
        if ("balanced".equals(codeString)) {
            return InvoiceStatus.BALANCED;
        }
        if ("cancelled".equals(codeString)) {
            return InvoiceStatus.CANCELLED;
        }
        if ("entered-in-error".equals(codeString)) {
            return InvoiceStatus.ENTEREDINERROR;
        }
        throw new IllegalArgumentException("Unknown InvoiceStatus code '" + codeString + "'");
    }

    @Override
    public String toCode(InvoiceStatus code) {
        if (code == InvoiceStatus.DRAFT) {
            return "draft";
        }
        if (code == InvoiceStatus.ISSUED) {
            return "issued";
        }
        if (code == InvoiceStatus.BALANCED) {
            return "balanced";
        }
        if (code == InvoiceStatus.CANCELLED) {
            return "cancelled";
        }
        if (code == InvoiceStatus.ENTEREDINERROR) {
            return "entered-in-error";
        }
        return "?";
    }

    @Override
    public String toSystem(InvoiceStatus code) {
        return code.getSystem();
    }
}

