/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ListOrder;

public class ListOrderEnumFactory
implements EnumFactory<ListOrder> {
    @Override
    public ListOrder fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("user".equals(codeString)) {
            return ListOrder.USER;
        }
        if ("system".equals(codeString)) {
            return ListOrder.SYSTEM;
        }
        if ("event-date".equals(codeString)) {
            return ListOrder.EVENTDATE;
        }
        if ("entry-date".equals(codeString)) {
            return ListOrder.ENTRYDATE;
        }
        if ("priority".equals(codeString)) {
            return ListOrder.PRIORITY;
        }
        if ("alphabetic".equals(codeString)) {
            return ListOrder.ALPHABETIC;
        }
        if ("category".equals(codeString)) {
            return ListOrder.CATEGORY;
        }
        if ("patient".equals(codeString)) {
            return ListOrder.PATIENT;
        }
        throw new IllegalArgumentException("Unknown ListOrder code '" + codeString + "'");
    }

    @Override
    public String toCode(ListOrder code) {
        if (code == ListOrder.USER) {
            return "user";
        }
        if (code == ListOrder.SYSTEM) {
            return "system";
        }
        if (code == ListOrder.EVENTDATE) {
            return "event-date";
        }
        if (code == ListOrder.ENTRYDATE) {
            return "entry-date";
        }
        if (code == ListOrder.PRIORITY) {
            return "priority";
        }
        if (code == ListOrder.ALPHABETIC) {
            return "alphabetic";
        }
        if (code == ListOrder.CATEGORY) {
            return "category";
        }
        if (code == ListOrder.PATIENT) {
            return "patient";
        }
        return "?";
    }

    @Override
    public String toSystem(ListOrder code) {
        return code.getSystem();
    }
}

