/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum ObservationRangeCategory {
    REFERENCE,
    CRITICAL,
    ABSOLUTE,
    NULL;


    public static ObservationRangeCategory fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("reference".equals(codeString)) {
            return REFERENCE;
        }
        if ("critical".equals(codeString)) {
            return CRITICAL;
        }
        if ("absolute".equals(codeString)) {
            return ABSOLUTE;
        }
        throw new FHIRException("Unknown ObservationRangeCategory code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case REFERENCE: {
                return "reference";
            }
            case CRITICAL: {
                return "critical";
            }
            case ABSOLUTE: {
                return "absolute";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/observation-range-category";
    }

    public String getDefinition() {
        switch (this) {
            case REFERENCE: {
                return "Reference (Normal) Range for Ordinal and Continuous Observations.";
            }
            case CRITICAL: {
                return "Critical Range for Ordinal and Continuous Observations. Results outside this range are critical.";
            }
            case ABSOLUTE: {
                return "Absolute Range for Ordinal and Continuous Observations. Results outside this range are not possible.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case REFERENCE: {
                return "reference range";
            }
            case CRITICAL: {
                return "critical range";
            }
            case ABSOLUTE: {
                return "absolute range";
            }
        }
        return "?";
    }
}

