/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum OperationKind {
    OPERATION,
    QUERY,
    NULL;


    public static OperationKind fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("operation".equals(codeString)) {
            return OPERATION;
        }
        if ("query".equals(codeString)) {
            return QUERY;
        }
        throw new FHIRException("Unknown OperationKind code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case OPERATION: {
                return "operation";
            }
            case QUERY: {
                return "query";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/operation-kind";
    }

    public String getDefinition() {
        switch (this) {
            case OPERATION: {
                return "This operation is invoked as an operation.";
            }
            case QUERY: {
                return "This operation is a named query, invoked using the search mechanism.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case OPERATION: {
                return "Operation";
            }
            case QUERY: {
                return "Query";
            }
        }
        return "?";
    }
}

