/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.ProductCategory;

public class ProductCategoryEnumFactory
implements EnumFactory<ProductCategory> {
    @Override
    public ProductCategory fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("organ".equals(codeString)) {
            return ProductCategory.ORGAN;
        }
        if ("tissue".equals(codeString)) {
            return ProductCategory.TISSUE;
        }
        if ("fluid".equals(codeString)) {
            return ProductCategory.FLUID;
        }
        if ("cells".equals(codeString)) {
            return ProductCategory.CELLS;
        }
        if ("biologicalAgent".equals(codeString)) {
            return ProductCategory.BIOLOGICALAGENT;
        }
        throw new IllegalArgumentException("Unknown ProductCategory code '" + codeString + "'");
    }

    @Override
    public String toCode(ProductCategory code) {
        if (code == ProductCategory.ORGAN) {
            return "organ";
        }
        if (code == ProductCategory.TISSUE) {
            return "tissue";
        }
        if (code == ProductCategory.FLUID) {
            return "fluid";
        }
        if (code == ProductCategory.CELLS) {
            return "cells";
        }
        if (code == ProductCategory.BIOLOGICALAGENT) {
            return "biologicalAgent";
        }
        return "?";
    }

    @Override
    public String toSystem(ProductCategory code) {
        return code.getSystem();
    }
}

