/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum RequestIntent {
    PROPOSAL,
    PLAN,
    DIRECTIVE,
    ORDER,
    ORIGINALORDER,
    REFLEXORDER,
    FILLERORDER,
    INSTANCEORDER,
    OPTION,
    NULL;


    public static RequestIntent fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("proposal".equals(codeString)) {
            return PROPOSAL;
        }
        if ("plan".equals(codeString)) {
            return PLAN;
        }
        if ("directive".equals(codeString)) {
            return DIRECTIVE;
        }
        if ("order".equals(codeString)) {
            return ORDER;
        }
        if ("original-order".equals(codeString)) {
            return ORIGINALORDER;
        }
        if ("reflex-order".equals(codeString)) {
            return REFLEXORDER;
        }
        if ("filler-order".equals(codeString)) {
            return FILLERORDER;
        }
        if ("instance-order".equals(codeString)) {
            return INSTANCEORDER;
        }
        if ("option".equals(codeString)) {
            return OPTION;
        }
        throw new FHIRException("Unknown RequestIntent code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case PROPOSAL: {
                return "proposal";
            }
            case PLAN: {
                return "plan";
            }
            case DIRECTIVE: {
                return "directive";
            }
            case ORDER: {
                return "order";
            }
            case ORIGINALORDER: {
                return "original-order";
            }
            case REFLEXORDER: {
                return "reflex-order";
            }
            case FILLERORDER: {
                return "filler-order";
            }
            case INSTANCEORDER: {
                return "instance-order";
            }
            case OPTION: {
                return "option";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://hl7.org/fhir/request-intent";
    }

    public String getDefinition() {
        switch (this) {
            case PROPOSAL: {
                return "The request is a suggestion made by someone/something that does not have an intention to ensure it occurs and without providing an authorization to act.";
            }
            case PLAN: {
                return "The request represents an intention to ensure something occurs without providing an authorization for others to act.";
            }
            case DIRECTIVE: {
                return "The request represents a legally binding instruction authored by a Patient or RelatedPerson.";
            }
            case ORDER: {
                return "The request represents a request/demand and authorization for action by a Practitioner.";
            }
            case ORIGINALORDER: {
                return "The request represents an original authorization for action.";
            }
            case REFLEXORDER: {
                return "The request represents an automatically generated supplemental authorization for action based on a parent authorization together with initial results of the action taken against that parent authorization.";
            }
            case FILLERORDER: {
                return "The request represents the view of an authorization instantiated by a fulfilling system representing the details of the fulfiller's intention to act upon a submitted order.";
            }
            case INSTANCEORDER: {
                return "An order created in fulfillment of a broader order that represents the authorization for a single activity occurrence.  E.g. The administration of a single dose of a drug.";
            }
            case OPTION: {
                return "The request represents a component or option for a RequestGroup that establishes timing, conditionality and/or other constraints among a set of requests.  Refer to [[[RequestGroup]]] for additional information on how this status is used.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case PROPOSAL: {
                return "Proposal";
            }
            case PLAN: {
                return "Plan";
            }
            case DIRECTIVE: {
                return "Directive";
            }
            case ORDER: {
                return "Order";
            }
            case ORIGINALORDER: {
                return "Original Order";
            }
            case REFLEXORDER: {
                return "Reflex Order";
            }
            case FILLERORDER: {
                return "Filler Order";
            }
            case INSTANCEORDER: {
                return "Instance Order";
            }
            case OPTION: {
                return "Option";
            }
        }
        return "?";
    }
}

