/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.SecondaryFinding;

public class SecondaryFindingEnumFactory
implements EnumFactory<SecondaryFinding> {
    @Override
    public SecondaryFinding fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("acmg-version1".equals(codeString)) {
            return SecondaryFinding.ACMGVERSION1;
        }
        if ("acmg-version2".equals(codeString)) {
            return SecondaryFinding.ACMGVERSION2;
        }
        throw new IllegalArgumentException("Unknown SecondaryFinding code '" + codeString + "'");
    }

    @Override
    public String toCode(SecondaryFinding code) {
        if (code == SecondaryFinding.ACMGVERSION1) {
            return "acmg-version1";
        }
        if (code == SecondaryFinding.ACMGVERSION2) {
            return "acmg-version2";
        }
        return "?";
    }

    @Override
    public String toSystem(SecondaryFinding code) {
        return code.getSystem();
    }
}

