/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.exceptions.FHIRException;

public enum StatisticType {
    RELATIVERR,
    RELATIVEOR,
    RELATIVEHR,
    ABSOLUTEARD,
    ABSOLUTEMEANDIFF,
    ABSOLUTESMD,
    ABSOLUTEMEDIANDIFF,
    PROPORTION,
    DERIVEDPROPORTION,
    MEAN,
    MEDIAN,
    COUNT,
    DESCRIPTIVE,
    NULL;


    public static StatisticType fromCode(String codeString) throws FHIRException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("relative-RR".equals(codeString)) {
            return RELATIVERR;
        }
        if ("relative-OR".equals(codeString)) {
            return RELATIVEOR;
        }
        if ("relative-HR".equals(codeString)) {
            return RELATIVEHR;
        }
        if ("absolute-ARD".equals(codeString)) {
            return ABSOLUTEARD;
        }
        if ("absolute-MeanDiff".equals(codeString)) {
            return ABSOLUTEMEANDIFF;
        }
        if ("absolute-SMD".equals(codeString)) {
            return ABSOLUTESMD;
        }
        if ("absolute-MedianDiff".equals(codeString)) {
            return ABSOLUTEMEDIANDIFF;
        }
        if ("proportion".equals(codeString)) {
            return PROPORTION;
        }
        if ("derivedProportion".equals(codeString)) {
            return DERIVEDPROPORTION;
        }
        if ("mean".equals(codeString)) {
            return MEAN;
        }
        if ("median".equals(codeString)) {
            return MEDIAN;
        }
        if ("count".equals(codeString)) {
            return COUNT;
        }
        if ("descriptive".equals(codeString)) {
            return DESCRIPTIVE;
        }
        throw new FHIRException("Unknown StatisticType code '" + codeString + "'");
    }

    public String toCode() {
        switch (this) {
            case RELATIVERR: {
                return "relative-RR";
            }
            case RELATIVEOR: {
                return "relative-OR";
            }
            case RELATIVEHR: {
                return "relative-HR";
            }
            case ABSOLUTEARD: {
                return "absolute-ARD";
            }
            case ABSOLUTEMEANDIFF: {
                return "absolute-MeanDiff";
            }
            case ABSOLUTESMD: {
                return "absolute-SMD";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "absolute-MedianDiff";
            }
            case PROPORTION: {
                return "proportion";
            }
            case DERIVEDPROPORTION: {
                return "derivedProportion";
            }
            case MEAN: {
                return "mean";
            }
            case MEDIAN: {
                return "median";
            }
            case COUNT: {
                return "count";
            }
            case DESCRIPTIVE: {
                return "descriptive";
            }
        }
        return "?";
    }

    public String getSystem() {
        return "http://terminology.hl7.org/CodeSystem/statistic-type";
    }

    public String getDefinition() {
        switch (this) {
            case RELATIVERR: {
                return "relative risk (a type of relative effect estimate).";
            }
            case RELATIVEOR: {
                return "odds ratio (a type of relative effect estimate).";
            }
            case RELATIVEHR: {
                return "hazard ratio (a type of relative effect estimate).";
            }
            case ABSOLUTEARD: {
                return "absolute risk difference (a type of absolute effect estimate).";
            }
            case ABSOLUTEMEANDIFF: {
                return "mean difference (a type of absolute effect estimate).";
            }
            case ABSOLUTESMD: {
                return "standardized mean difference (a type of absolute effect estimate).";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "median difference (a type of absolute effect estimate).";
            }
            case PROPORTION: {
                return "dichotomous measure (present of absent) reported as a ratio compared to the denominator of 1 (A percentage is a proportion with denominator of 100).";
            }
            case DERIVEDPROPORTION: {
                return "A special use case where the proportion is derived from a formula rather than derived from summary evidence.";
            }
            case MEAN: {
                return "continuous numerical measure reported as an average.";
            }
            case MEDIAN: {
                return "continuous numerical measure reported as the middle of the range.";
            }
            case COUNT: {
                return "descriptive measure reported as total number of items.";
            }
            case DESCRIPTIVE: {
                return "descriptive measure reported as narrative.";
            }
        }
        return "?";
    }

    public String getDisplay() {
        switch (this) {
            case RELATIVERR: {
                return "relative risk";
            }
            case RELATIVEOR: {
                return "odds ratio";
            }
            case RELATIVEHR: {
                return "hazard ratio";
            }
            case ABSOLUTEARD: {
                return "absolute risk difference";
            }
            case ABSOLUTEMEANDIFF: {
                return "mean difference";
            }
            case ABSOLUTESMD: {
                return "standardized mean difference";
            }
            case ABSOLUTEMEDIANDIFF: {
                return "median difference";
            }
            case PROPORTION: {
                return "proportion";
            }
            case DERIVEDPROPORTION: {
                return "derivedProportion";
            }
            case MEAN: {
                return "Mean";
            }
            case MEDIAN: {
                return "Median";
            }
            case COUNT: {
                return "Count";
            }
            case DESCRIPTIVE: {
                return "descriptive";
            }
        }
        return "?";
    }
}

