/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model.codesystems;

import org.hl7.fhir.r5.model.EnumFactory;
import org.hl7.fhir.r5.model.codesystems.StatisticType;

public class StatisticTypeEnumFactory
implements EnumFactory<StatisticType> {
    @Override
    public StatisticType fromCode(String codeString) throws IllegalArgumentException {
        if (codeString == null || "".equals(codeString)) {
            return null;
        }
        if ("relative-RR".equals(codeString)) {
            return StatisticType.RELATIVERR;
        }
        if ("relative-OR".equals(codeString)) {
            return StatisticType.RELATIVEOR;
        }
        if ("relative-HR".equals(codeString)) {
            return StatisticType.RELATIVEHR;
        }
        if ("absolute-ARD".equals(codeString)) {
            return StatisticType.ABSOLUTEARD;
        }
        if ("absolute-MeanDiff".equals(codeString)) {
            return StatisticType.ABSOLUTEMEANDIFF;
        }
        if ("absolute-SMD".equals(codeString)) {
            return StatisticType.ABSOLUTESMD;
        }
        if ("absolute-MedianDiff".equals(codeString)) {
            return StatisticType.ABSOLUTEMEDIANDIFF;
        }
        if ("proportion".equals(codeString)) {
            return StatisticType.PROPORTION;
        }
        if ("derivedProportion".equals(codeString)) {
            return StatisticType.DERIVEDPROPORTION;
        }
        if ("mean".equals(codeString)) {
            return StatisticType.MEAN;
        }
        if ("median".equals(codeString)) {
            return StatisticType.MEDIAN;
        }
        if ("count".equals(codeString)) {
            return StatisticType.COUNT;
        }
        if ("descriptive".equals(codeString)) {
            return StatisticType.DESCRIPTIVE;
        }
        throw new IllegalArgumentException("Unknown StatisticType code '" + codeString + "'");
    }

    @Override
    public String toCode(StatisticType code) {
        if (code == StatisticType.RELATIVERR) {
            return "relative-RR";
        }
        if (code == StatisticType.RELATIVEOR) {
            return "relative-OR";
        }
        if (code == StatisticType.RELATIVEHR) {
            return "relative-HR";
        }
        if (code == StatisticType.ABSOLUTEARD) {
            return "absolute-ARD";
        }
        if (code == StatisticType.ABSOLUTEMEANDIFF) {
            return "absolute-MeanDiff";
        }
        if (code == StatisticType.ABSOLUTESMD) {
            return "absolute-SMD";
        }
        if (code == StatisticType.ABSOLUTEMEDIANDIFF) {
            return "absolute-MedianDiff";
        }
        if (code == StatisticType.PROPORTION) {
            return "proportion";
        }
        if (code == StatisticType.DERIVEDPROPORTION) {
            return "derivedProportion";
        }
        if (code == StatisticType.MEAN) {
            return "mean";
        }
        if (code == StatisticType.MEDIAN) {
            return "median";
        }
        if (code == StatisticType.COUNT) {
            return "count";
        }
        if (code == StatisticType.DESCRIPTIVE) {
            return "descriptive";
        }
        return "?";
    }

    @Override
    public String toSystem(StatisticType code) {
        return code.getSystem();
    }
}

