/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorOutputStream;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.model.ContactDetail;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.cache.PackageGenerator;

public class NPMPackageGenerator {
    private String destFile;
    private Set<String> created = new HashSet<String>();
    private TarArchiveOutputStream tar;
    private ByteArrayOutputStream OutputStream;
    private BufferedOutputStream bufferedOutputStream;
    private GzipCompressorOutputStream gzipOutputStream;
    private JsonObject packageJ;

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, String genDate) throws FHIRException, IOException {
        System.out.println("create package file at " + destFile);
        this.destFile = destFile;
        this.start();
        ArrayList<String> fhirVersion = new ArrayList<String>();
        for (Enumeration<Enumerations.FHIRVersion> v : ig.getFhirVersion()) {
            fhirVersion.add(v.asStringValue());
        }
        this.buildPackageJson(canonical, kind, url, genDate, ig, fhirVersion);
    }

    public static NPMPackageGenerator subset(NPMPackageGenerator master, String destFile, String id, String name) throws FHIRException, IOException {
        JsonObject p = master.packageJ.deepCopy();
        p.remove("name");
        p.addProperty("name", id);
        p.remove("type");
        p.addProperty("type", PackageGenerator.PackageType.SUBSET.getCode());
        p.remove("title");
        p.addProperty("title", name);
        return new NPMPackageGenerator(destFile, p);
    }

    public NPMPackageGenerator(String destFile, String canonical, String url, PackageGenerator.PackageType kind, ImplementationGuide ig, String genDate, List<String> fhirVersion) throws FHIRException, IOException {
        System.out.println("create package file at " + destFile);
        this.destFile = destFile;
        this.start();
        this.buildPackageJson(canonical, kind, url, genDate, ig, fhirVersion);
    }

    public NPMPackageGenerator(String destFile, JsonObject npm) throws FHIRException, IOException {
        System.out.println("create package file at " + destFile);
        this.destFile = destFile;
        this.start();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)npm);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.packageJ = npm;
    }

    private void buildPackageJson(String canonical, PackageGenerator.PackageType kind, String web, String genDate, ImplementationGuide ig, List<String> fhirVersion) throws FHIRException, IOException {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        if (!ig.hasPackageId()) {
            b.append("packageId");
        }
        if (!ig.hasVersion()) {
            b.append("version");
        }
        if (!ig.hasFhirVersion()) {
            b.append("fhirVersion");
        }
        if (!ig.hasLicense()) {
            b.append("license");
        }
        for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
            if (d.hasVersion()) continue;
            b.append("dependsOn.version(" + d.getUri() + ")");
        }
        JsonObject npm = new JsonObject();
        npm.addProperty("name", ig.getPackageId());
        npm.addProperty("version", ig.getVersion());
        npm.addProperty("tools-version", (Number)3);
        npm.addProperty("type", kind.getCode());
        if (ig.hasLicense()) {
            npm.addProperty("license", ig.getLicense().toCode());
        }
        npm.addProperty("canonical", canonical);
        npm.addProperty("url", web);
        if (ig.hasTitle()) {
            npm.addProperty("title", ig.getTitle());
        }
        if (ig.hasDescription()) {
            npm.addProperty("description", ig.getDescription() + " (built " + genDate + this.timezone() + ")");
        }
        if (kind != PackageGenerator.PackageType.CORE) {
            JsonObject dep = new JsonObject();
            npm.add("dependencies", (JsonElement)dep);
            for (String v : fhirVersion) {
                dep.addProperty("hl7.fhir.core", v);
            }
            for (ImplementationGuide.ImplementationGuideDependsOnComponent d : ig.getDependsOn()) {
                dep.addProperty(d.getPackageId(), d.getVersion());
            }
        }
        if (ig.hasPublisher()) {
            npm.addProperty("author", ig.getPublisher());
        }
        JsonArray m = new JsonArray();
        for (ContactDetail t : ig.getContact()) {
            String email = this.email(t.getTelecom());
            String url = this.url(t.getTelecom());
            if (!(t.hasName() & (email != null || url != null))) continue;
            JsonObject md = new JsonObject();
            m.add((JsonElement)md);
            md.addProperty("name", t.getName());
            if (email != null) {
                md.addProperty("email", email);
            }
            if (url == null) continue;
            md.addProperty("url", url);
        }
        if (m.size() > 0) {
            npm.add("maintainers", (JsonElement)m);
        }
        if (ig.getManifest().hasRendering()) {
            npm.addProperty("homepage", ig.getManifest().getRendering());
        }
        JsonObject dir = new JsonObject();
        npm.add("directories", (JsonElement)dir);
        dir.addProperty("lib", "package");
        dir.addProperty("example", "example");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String json = gson.toJson((JsonElement)npm);
        try {
            this.addFile(Category.RESOURCE, "package.json", json.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        this.packageJ = npm;
    }

    private String timezone() {
        TimeZone tz = TimeZone.getDefault();
        Calendar cal = GregorianCalendar.getInstance(tz);
        int offsetInMillis = tz.getOffset(cal.getTimeInMillis());
        String offset = String.format("%02d:%02d", Math.abs(offsetInMillis / 3600000), Math.abs(offsetInMillis / 60000 % 60));
        offset = (offsetInMillis >= 0 ? "+" : "-") + offset;
        return offset;
    }

    private String url(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.URL) continue;
            return cp.getValue();
        }
        return null;
    }

    private String email(List<ContactPoint> telecom) {
        for (ContactPoint cp : telecom) {
            if (cp.getSystem() != ContactPoint.ContactPointSystem.EMAIL) continue;
            return cp.getValue();
        }
        return null;
    }

    private void start() throws IOException {
        this.OutputStream = new ByteArrayOutputStream();
        this.bufferedOutputStream = new BufferedOutputStream(this.OutputStream);
        this.gzipOutputStream = new GzipCompressorOutputStream((OutputStream)this.bufferedOutputStream);
        this.tar = new TarArchiveOutputStream((OutputStream)this.gzipOutputStream);
    }

    public void addFile(Category cat, String name, byte[] content) throws IOException {
        String path = cat.getDirectory() + name;
        if (this.created.contains(path)) {
            System.out.println("Duplicate package file " + path);
        } else {
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
        }
    }

    public void finish() throws IOException {
        this.tar.finish();
        this.tar.close();
        this.gzipOutputStream.close();
        this.bufferedOutputStream.close();
        this.OutputStream.close();
        TextFile.bytesToFile((byte[])this.OutputStream.toByteArray(), (String)this.destFile);
    }

    public String filename() {
        return this.destFile;
    }

    public void loadDir(String rootDir, String name) throws IOException {
        this.loadFiles(rootDir, new File(Utilities.path((String[])new String[]{rootDir, name})), new String[0]);
    }

    public void loadFiles(String root, File dir, String ... noload) throws IOException {
        for (File f : dir.listFiles()) {
            if (Utilities.existsInList((String)f.getName(), (String[])noload)) continue;
            if (f.isDirectory()) {
                this.loadFiles(root, f, new String[0]);
                continue;
            }
            String path = f.getAbsolutePath().substring(root.length() + 1);
            byte[] content = TextFile.fileToBytes((File)f);
            if (this.created.contains(path)) {
                System.out.println("Duplicate package file " + path);
                continue;
            }
            this.created.add(path);
            TarArchiveEntry entry = new TarArchiveEntry(path);
            entry.setSize((long)content.length);
            this.tar.putArchiveEntry((ArchiveEntry)entry);
            this.tar.write(content);
            this.tar.closeArchiveEntry();
        }
    }

    public static enum Category {
        RESOURCE,
        EXAMPLE,
        OPENAPI,
        SCHEMATRON,
        RDF,
        OTHER,
        TOOL,
        TEMPLATE,
        JEKYLL;


        private String getDirectory() {
            switch (this) {
                case RESOURCE: {
                    return "/package/";
                }
                case EXAMPLE: {
                    return "/example/";
                }
                case OPENAPI: {
                    return "/openapi/";
                }
                case SCHEMATRON: {
                    return "/xml/";
                }
                case RDF: {
                    return "/rdf/";
                }
                case OTHER: {
                    return "/other/";
                }
                case TEMPLATE: {
                    return "/other/";
                }
                case JEKYLL: {
                    return "/jekyll/";
                }
                case TOOL: {
                    return "/bin/";
                }
            }
            return "/";
        }
    }
}

