/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.comparison;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.comparison.ComparisonSession;
import org.hl7.fhir.r5.comparison.ResourceComparer;
import org.hl7.fhir.r5.comparison.StructuralMatch;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DataType;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.i18n.RenderingI18nContext;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.xhtml.HierarchicalTableGenerator;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public abstract class CanonicalResourceComparer
extends ResourceComparer {
    public CanonicalResourceComparer(ComparisonSession session) {
        super(session);
    }

    protected boolean compareMetadata(CanonicalResource left, CanonicalResource right, Map<String, StructuralMatch<String>> comp, CanonicalResourceComparison<? extends CanonicalResource> res, List<String> changes, Base parent) {
        boolean changed = false;
        if (this.comparePrimitivesWithTracking("url", left.getUrlElement(), right.getUrlElement(), comp, ValidationMessage.IssueSeverity.ERROR, res, parent)) {
            changed = true;
            changes.add("url");
        }
        if (!this.session.isAnnotate() && this.comparePrimitivesWithTracking("version", left.getVersionElement(), right.getVersionElement(), comp, ValidationMessage.IssueSeverity.ERROR, res, parent)) {
            changed = true;
            changes.add("version");
        }
        if (this.comparePrimitivesWithTracking("name", left.getNameElement(), right.getNameElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("name");
        }
        if (this.comparePrimitivesWithTracking("title", left.getTitleElement(), right.getTitleElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("title");
        }
        if (this.comparePrimitivesWithTracking("status", left.getStatusElement(), right.getStatusElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("status");
        }
        if (this.comparePrimitivesWithTracking("experimental", left.getExperimentalElement(), right.getExperimentalElement(), comp, ValidationMessage.IssueSeverity.WARNING, res, parent)) {
            changed = true;
            changes.add("experimental");
        }
        if (!this.session.isAnnotate() && this.comparePrimitivesWithTracking("date", left.getDateElement(), right.getDateElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("date");
        }
        if (this.comparePrimitivesWithTracking("publisher", left.getPublisherElement(), right.getPublisherElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("publisher");
        }
        if (this.comparePrimitivesWithTracking("description", left.getDescriptionElement(), right.getDescriptionElement(), comp, ValidationMessage.IssueSeverity.NULL, res, parent)) {
            changed = true;
            changes.add("description");
        }
        if (this.comparePrimitivesWithTracking("purpose", left.getPurposeElement(), right.getPurposeElement(), comp, ValidationMessage.IssueSeverity.NULL, res, parent)) {
            changed = true;
            changes.add("purpose");
        }
        if (this.comparePrimitivesWithTracking("copyright", left.getCopyrightElement(), right.getCopyrightElement(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, parent)) {
            changed = true;
            changes.add("copyright");
        }
        if (this.compareCodeableConceptList("jurisdiction", left.getJurisdiction(), right.getJurisdiction(), comp, ValidationMessage.IssueSeverity.INFORMATION, res, res.getUnion().getJurisdiction(), res.getIntersection().getJurisdiction())) {
            changed = true;
            changes.add("jurisdiction");
        }
        return changed;
    }

    protected boolean compareCodeableConceptList(String name, List<CodeableConcept> left, List<CodeableConcept> right, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, List<CodeableConcept> union, List<CodeableConcept> intersection) {
        boolean result = false;
        ArrayList<CodeableConcept> matchR = new ArrayList<CodeableConcept>();
        StructuralMatch combined = new StructuralMatch();
        for (CodeableConcept l : left) {
            CodeableConcept r = this.findCodeableConceptInList(right, l);
            if (r == null) {
                union.add(l);
                result = true;
                combined.getChildren().add(new StructuralMatch<String>(this.gen(l), this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + this.gen(l) + "'", this.fhirType() + "." + name, res.getMessages())));
                continue;
            }
            matchR.add(r);
            union.add(r);
            intersection.add(r);
            StructuralMatch<String> sm = new StructuralMatch<String>(this.gen(l), this.gen(r));
            combined.getChildren().add(sm);
            if (!sm.isDifferent()) continue;
            result = true;
        }
        for (CodeableConcept r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            result = true;
            combined.getChildren().add(new StructuralMatch<String>(this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + this.gen(r) + "'", this.fhirType() + "." + name, res.getMessages()), this.gen(r)));
        }
        comp.put(name, combined);
        return result;
    }

    private CodeableConcept findCodeableConceptInList(List<CodeableConcept> list, CodeableConcept item) {
        for (CodeableConcept t : list) {
            if (!t.matches(item)) continue;
            return t;
        }
        return null;
    }

    protected String gen(CodeableConcept cc) {
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
        for (Coding c : cc.getCoding()) {
            b.append(this.gen(c));
        }
        return b.toString();
    }

    protected String gen(Coding c) {
        return c.getSystem() + (String)(c.hasVersion() ? "|" + c.getVersion() : "") + "#" + c.getCode();
    }

    protected void compareCanonicalList(String name, List<CanonicalType> left, List<CanonicalType> right, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, List<CanonicalType> union, List<CanonicalType> intersection) {
        ArrayList<CanonicalType> matchR = new ArrayList<CanonicalType>();
        StructuralMatch combined = new StructuralMatch();
        for (CanonicalType l : left) {
            CanonicalType r = this.findCanonicalInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<String>((String)l.getValue(), this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + (String)l.getValue() + "'", this.fhirType() + "." + name, res.getMessages())));
                continue;
            }
            matchR.add(r);
            union.add(r);
            intersection.add(r);
            StructuralMatch<String> sm = new StructuralMatch<String>((String)l.getValue(), (String)r.getValue());
            combined.getChildren().add(sm);
        }
        for (CanonicalType r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<String>(this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + (String)r.getValue() + "'", this.fhirType() + "." + name, res.getMessages()), (String)r.getValue()));
        }
        comp.put(name, combined);
    }

    private CanonicalType findCanonicalInList(List<CanonicalType> list, CanonicalType item) {
        for (CanonicalType t : list) {
            if (!((String)t.getValue()).equals(item.getValue())) continue;
            return t;
        }
        return null;
    }

    protected void compareCodeList(String name, List<CodeType> left, List<CodeType> right, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, List<CodeType> union, List<CodeType> intersection) {
        ArrayList<CodeType> matchR = new ArrayList<CodeType>();
        StructuralMatch combined = new StructuralMatch();
        for (CodeType l : left) {
            CodeType r = this.findCodeInList(right, l);
            if (r == null) {
                union.add(l);
                combined.getChildren().add(new StructuralMatch<String>((String)l.getValue(), this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + (String)l.getValue() + "'", this.fhirType() + "." + name, res.getMessages())));
                continue;
            }
            matchR.add(r);
            union.add(r);
            intersection.add(r);
            StructuralMatch<String> sm = new StructuralMatch<String>((String)l.getValue(), (String)r.getValue());
            combined.getChildren().add(sm);
        }
        for (CodeType r : right) {
            if (matchR.contains(r)) continue;
            union.add(r);
            combined.getChildren().add(new StructuralMatch<String>(this.vm(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + (String)r.getValue() + "'", this.fhirType() + "." + name, res.getMessages()), (String)r.getValue()));
        }
        comp.put(name, combined);
    }

    private CodeType findCodeInList(List<CodeType> list, CodeType item) {
        for (CodeType t : list) {
            if (!((String)t.getValue()).equals(item.getValue())) continue;
            return t;
        }
        return null;
    }

    protected boolean comparePrimitives(String name, PrimitiveType l, PrimitiveType r, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res) {
        StructuralMatch<Object> match = null;
        if (l.isEmpty() && r.isEmpty()) {
            match = new StructuralMatch<Object>(null, null, null);
        } else if (l.isEmpty()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + r.primitiveValue() + "'", this.fhirType() + "." + name));
        } else if (r.isEmpty()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + l.primitiveValue() + "'", this.fhirType() + "." + name));
        } else if (!l.hasValue() && !r.hasValue()) {
            match = new StructuralMatch<Object>(null, null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value", this.fhirType() + "." + name));
        } else if (!l.hasValue()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Left", this.fhirType() + "." + name));
        } else if (!r.hasValue()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Right", this.fhirType() + "." + name));
        } else if (l.getValue().equals(r.getValue())) {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), null);
        } else {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), this.vmI(level, "Values Differ", this.fhirType() + "." + name));
            if (level != ValidationMessage.IssueSeverity.NULL) {
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, this.fhirType() + "." + name, "Values for " + name + " differ: '" + l.primitiveValue() + "' vs '" + r.primitiveValue() + "'", level));
            }
        }
        comp.put(name, match);
        return match.isDifferent();
    }

    protected boolean comparePrimitivesWithTracking(String name, List<? extends PrimitiveType> ll, List<? extends PrimitiveType> rl, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, Base parent) {
        boolean def = false;
        ArrayList<PrimitiveType> matchR = new ArrayList<PrimitiveType>();
        for (PrimitiveType primitiveType : ll) {
            PrimitiveType r = this.findInList(rl, primitiveType);
            if (r == null) {
                this.session.markDeleted(parent, "element", primitiveType);
                continue;
            }
            matchR.add(r);
            def = this.comparePrimitivesWithTracking(name, primitiveType, r, comp, level, res, parent) || def;
        }
        for (PrimitiveType primitiveType : rl) {
            if (matchR.contains(primitiveType)) continue;
            this.session.markAdded(primitiveType);
        }
        return def;
    }

    private PrimitiveType findInList(List<? extends PrimitiveType> rl, PrimitiveType l) {
        for (PrimitiveType primitiveType : rl) {
            if (!primitiveType.equalsDeep(l)) continue;
            return primitiveType;
        }
        return null;
    }

    protected boolean comparePrimitivesWithTracking(String name, PrimitiveType l, PrimitiveType r, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, Base parent) {
        StructuralMatch<Object> match = null;
        if (l.isEmpty() && r.isEmpty()) {
            match = new StructuralMatch<Object>(null, null, null);
        } else if (l.isEmpty()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + r.primitiveValue() + "'", this.fhirType() + "." + name));
            this.session.markAdded(r);
        } else if (r.isEmpty()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + l.primitiveValue() + "'", this.fhirType() + "." + name));
            this.session.markDeleted(parent, name, l);
        } else if (!l.hasValue() && !r.hasValue()) {
            match = new StructuralMatch<Object>(null, null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value", this.fhirType() + "." + name));
        } else if (!l.hasValue()) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Left", this.fhirType() + "." + name));
            this.session.markAdded(r);
        } else if (!r.hasValue()) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "No Value on Right", this.fhirType() + "." + name));
            this.session.markDeleted(parent, name, l);
        } else if (l.getValue().equals(r.getValue())) {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), null);
        } else {
            this.session.markChanged(r, l);
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), this.vmI(level, "Values Differ", this.fhirType() + "." + name));
            if (level != ValidationMessage.IssueSeverity.NULL && res != null) {
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, this.fhirType() + "." + name, "Values for " + name + " differ: '" + l.primitiveValue() + "' vs '" + r.primitiveValue() + "'", level));
            }
        }
        if (comp != null) {
            comp.put(name, match);
        }
        return match.isDifferent();
    }

    protected boolean compareDataTypesWithTracking(String name, List<? extends DataType> ll, List<? extends DataType> rl, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, Base parent) {
        boolean def = false;
        ArrayList<DataType> matchR = new ArrayList<DataType>();
        for (DataType dataType : ll) {
            DataType r = this.findInList(rl, dataType);
            if (r == null) {
                this.session.markDeleted(parent, "element", dataType);
                continue;
            }
            matchR.add(r);
            def = this.compareDataTypesWithTracking(name, dataType, r, comp, level, res, parent) || def;
        }
        for (DataType dataType : rl) {
            if (matchR.contains(dataType)) continue;
            this.session.markAdded(dataType);
        }
        return def;
    }

    private DataType findInList(List<? extends DataType> rl, DataType l) {
        for (DataType dataType : rl) {
            if (!dataType.equalsDeep(l)) continue;
            return dataType;
        }
        return null;
    }

    protected boolean compareDataTypesWithTracking(String name, DataType l, DataType r, Map<String, StructuralMatch<String>> comp, ValidationMessage.IssueSeverity level, CanonicalResourceComparison<? extends CanonicalResource> res, Base parent) {
        boolean re;
        StructuralMatch<Object> match = null;
        boolean le = l == null || l.isEmpty();
        boolean bl = re = r == null || r.isEmpty();
        if (le && re) {
            match = new StructuralMatch<Object>(null, null, null);
        } else if (le) {
            match = new StructuralMatch<String>(null, r.primitiveValue(), this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Added the item '" + r.fhirType() + "'", this.fhirType() + "." + name));
            this.session.markAdded(r);
        } else if (re) {
            match = new StructuralMatch<Object>(l.primitiveValue(), null, this.vmI(ValidationMessage.IssueSeverity.INFORMATION, "Removed the item '" + l.fhirType() + "'", this.fhirType() + "." + name));
            this.session.markDeleted(parent, name, l);
        } else if (l.equalsDeep(r)) {
            match = new StructuralMatch<String>(l.primitiveValue(), r.primitiveValue(), null);
        } else {
            this.session.markChanged(r, l);
            match = new StructuralMatch<String>(l.fhirType(), r.fhirType(), this.vmI(level, "Values Differ", this.fhirType() + "." + name));
            if (level != ValidationMessage.IssueSeverity.NULL && res != null) {
                res.getMessages().add(new ValidationMessage(ValidationMessage.Source.ProfileComparer, ValidationMessage.IssueType.INFORMATIONAL, this.fhirType() + "." + name, "Values for " + name + " differ: '" + l.fhirType() + "' vs '" + r.fhirType() + "'", level));
            }
        }
        if (comp != null) {
            comp.put(name, match);
        }
        return match.isDifferent();
    }

    protected abstract String fhirType();

    public XhtmlNode renderMetadata(CanonicalResourceComparison<? extends CanonicalResource> comparison, String id, String prefix) throws FHIRException, IOException {
        HierarchicalTableGenerator gen;
        HierarchicalTableGenerator hierarchicalTableGenerator = gen = new HierarchicalTableGenerator(new RenderingI18nContext(), Utilities.path((String[])new String[]{"[tmp]", "compare"}), false, "c");
        Objects.requireNonNull(hierarchicalTableGenerator);
        HierarchicalTableGenerator.TableModel model = new HierarchicalTableGenerator.TableModel(hierarchicalTableGenerator, id, true);
        model.setAlternating(true);
        List list = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator2);
        list.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator2, null, null, "Name", "Property Name", null, 100));
        List list2 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator3);
        list2.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator3, null, null, "Value", "The value of the property", null, 200, 2));
        List list3 = model.getTitles();
        HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
        Objects.requireNonNull(hierarchicalTableGenerator4);
        list3.add(new HierarchicalTableGenerator.Title(hierarchicalTableGenerator4, null, null, "Comments", "Additional information about the comparison", null, 200));
        for (String n : this.sorted(comparison.getMetadata().keySet())) {
            StructuralMatch<String> t = comparison.getMetadata().get(n);
            this.addRow(gen, model.getRows(), n, t);
        }
        return gen.generate(model, prefix, 0, null);
    }

    private void addRow(HierarchicalTableGenerator gen, List<HierarchicalTableGenerator.Row> rows, String name, StructuralMatch<String> t) {
        HierarchicalTableGenerator.Row r = new HierarchicalTableGenerator.Row(gen);
        rows.add(r);
        List list = r.getCells();
        HierarchicalTableGenerator hierarchicalTableGenerator = gen;
        Objects.requireNonNull(hierarchicalTableGenerator);
        list.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator, null, null, name, null, null));
        if (t.hasLeft() && t.hasRight()) {
            if (t.getLeft().equals(t.getRight())) {
                List list2 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator2 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator2);
                list2.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator2, null, null, t.getLeft(), null, null).span(2));
            } else {
                List list3 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator3 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator3);
                list3.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator3, null, null, t.getLeft(), null, null).setStyle("background-color: #f0b3ff"));
                List list4 = r.getCells();
                HierarchicalTableGenerator hierarchicalTableGenerator4 = gen;
                Objects.requireNonNull(hierarchicalTableGenerator4);
                list4.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator4, null, null, t.getRight(), null, null).setStyle("background-color: #f0b3ff"));
            }
        } else if (t.hasLeft()) {
            r.setColor("#ffecb3");
            List list5 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator5 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator5);
            list5.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator5, null, null, t.getLeft(), null, null));
            r.getCells().add(this.missingCell(gen));
        } else if (t.hasRight()) {
            r.setColor("#ffffb3");
            r.getCells().add(this.missingCell(gen));
            List list6 = r.getCells();
            HierarchicalTableGenerator hierarchicalTableGenerator6 = gen;
            Objects.requireNonNull(hierarchicalTableGenerator6);
            list6.add(new HierarchicalTableGenerator.Cell(hierarchicalTableGenerator6, null, null, t.getRight(), null, null));
        } else {
            r.getCells().add(this.missingCell(gen).span(2));
        }
        r.getCells().add(this.cellForMessages(gen, t.getMessages()));
        int i = 0;
        for (StructuralMatch<String> c : t.getChildren()) {
            this.addRow(gen, r.getSubRows(), name + "[" + i + "]", c);
            ++i;
        }
    }

    private List<String> sorted(Set<String> keys) {
        ArrayList<String> res = new ArrayList<String>();
        res.addAll(keys);
        Collections.sort(res);
        return res;
    }

    public static abstract class CanonicalResourceComparison<T extends CanonicalResource>
    extends ResourceComparer.ResourceComparison {
        protected T left;
        protected T right;
        protected T union;
        protected T intersection;
        private ChangeAnalysisState changedMetadata;
        private ChangeAnalysisState changedDefinitions;
        private ChangeAnalysisState changedContent;
        private ChangeAnalysisState changedContentInterpretation;
        protected Map<String, StructuralMatch<String>> metadata;
        private List<String> chMetadataFields;
        final /* synthetic */ CanonicalResourceComparer this$0;

        public CanonicalResourceComparison(T left, T right) {
            this.this$0 = this$0;
            super(((Resource)left).getId(), ((Resource)right).getId());
            this.changedMetadata = ChangeAnalysisState.Unknown;
            this.changedDefinitions = ChangeAnalysisState.Unknown;
            this.changedContent = ChangeAnalysisState.Unknown;
            this.changedContentInterpretation = ChangeAnalysisState.Unknown;
            this.metadata = new HashMap<String, StructuralMatch<String>>();
            this.left = left;
            this.right = right;
        }

        public T getLeft() {
            return this.left;
        }

        public T getRight() {
            return this.right;
        }

        public T getUnion() {
            return this.union;
        }

        public T getIntersection() {
            return this.intersection;
        }

        public Map<String, StructuralMatch<String>> getMetadata() {
            return this.metadata;
        }

        public void setLeft(T left) {
            this.left = left;
        }

        public void setRight(T right) {
            this.right = right;
        }

        public void setUnion(T union) {
            this.union = union;
        }

        public void setIntersection(T intersection) {
            this.intersection = intersection;
        }

        private ChangeAnalysisState updateState(ChangeAnalysisState newState, ChangeAnalysisState oldState) {
            switch (newState) {
                case CannotEvaluate: {
                    return ChangeAnalysisState.CannotEvaluate;
                }
                case Changed: {
                    if (oldState == ChangeAnalysisState.CannotEvaluate) break;
                    return ChangeAnalysisState.Changed;
                }
                case NotChanged: {
                    if (oldState != ChangeAnalysisState.Unknown) break;
                    return ChangeAnalysisState.NotChanged;
                }
            }
            return oldState;
        }

        public void updatedMetadataState(ChangeAnalysisState state) {
            this.changedMetadata = this.updateState(state, this.changedMetadata);
        }

        public void updateDefinitionsState(ChangeAnalysisState state) {
            this.changedDefinitions = this.updateState(state, this.changedDefinitions);
        }

        public void updateContentState(ChangeAnalysisState state) {
            this.changedContent = this.updateState(state, this.changedContent);
        }

        public void updateContentInterpretationState(ChangeAnalysisState state) {
            this.changedContentInterpretation = this.updateState(state, this.changedContentInterpretation);
        }

        public void updatedMetadataState(boolean changed, List<String> chMetadataFields) {
            this.changedMetadata = this.updateState(changed ? ChangeAnalysisState.Changed : ChangeAnalysisState.NotChanged, this.changedMetadata);
            this.chMetadataFields = chMetadataFields;
        }

        public void updateDefinitionsState(boolean changed) {
            this.changedDefinitions = this.updateState(changed ? ChangeAnalysisState.Changed : ChangeAnalysisState.NotChanged, this.changedDefinitions);
        }

        public void updateContentState(boolean changed) {
            this.changedContent = this.updateState(changed ? ChangeAnalysisState.Changed : ChangeAnalysisState.NotChanged, this.changedContent);
        }

        public void updateContentInterpretationState(boolean changed) {
            this.changedContentInterpretation = this.updateState(changed ? ChangeAnalysisState.Changed : ChangeAnalysisState.NotChanged, this.changedContentInterpretation);
        }

        public boolean anyUpdates() {
            return this.changedMetadata.noteable() || this.changedDefinitions.noteable() || this.changedContent.noteable() || this.changedContentInterpretation.noteable();
        }

        public ChangeAnalysisState getChangedMetadata() {
            return this.changedMetadata;
        }

        public ChangeAnalysisState getChangedDefinitions() {
            return this.changedDefinitions;
        }

        public ChangeAnalysisState getChangedContent() {
            return this.changedContent;
        }

        public ChangeAnalysisState getChangedContentInterpretation() {
            return this.changedContentInterpretation;
        }

        @Override
        protected String toTable() {
            Object s = "";
            s = (String)s + this.refCell((CanonicalResource)this.left);
            s = (String)s + this.refCell((CanonicalResource)this.right);
            s = (String)s + "<td><a href=\"" + this.getId() + ".html\">Comparison</a></td>";
            s = (String)s + "<td><a href=\"" + this.getId() + "-union.html\">Union</a></td>";
            s = (String)s + "<td><a href=\"" + this.getId() + "-intersection.html\">Intersection</a></td>";
            s = (String)s + "<td>" + this.outcomeSummary() + "</td>";
            return "<tr style=\"background-color: " + this.color() + "\">" + (String)s + "</tr>\r\n";
        }

        @Override
        protected void countMessages(ResourceComparer.MessageCounts cnts) {
            for (StructuralMatch<String> sm : this.metadata.values()) {
                sm.countMessages(cnts);
            }
        }

        protected String changeSummary() {
            if (!(this.changedMetadata.noteable() || this.changedDefinitions.noteable() || this.changedContent.noteable() || this.changedContentInterpretation.noteable())) {
                return null;
            }
            CommaSeparatedStringBuilder bc = new CommaSeparatedStringBuilder();
            if (this.changedMetadata == ChangeAnalysisState.CannotEvaluate) {
                bc.append("Metadata");
            }
            if (this.changedDefinitions == ChangeAnalysisState.CannotEvaluate) {
                bc.append("Definitions");
            }
            if (this.changedContent == ChangeAnalysisState.CannotEvaluate) {
                bc.append("Content");
            }
            if (this.changedContentInterpretation == ChangeAnalysisState.CannotEvaluate) {
                bc.append("Interpretation");
            }
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            if (this.changedMetadata == ChangeAnalysisState.Changed) {
                b.append("Metadata");
            }
            if (this.changedDefinitions == ChangeAnalysisState.Changed) {
                b.append("Definitions");
            }
            if (this.changedContent == ChangeAnalysisState.Changed) {
                b.append("Content");
            }
            if (this.changedContentInterpretation == ChangeAnalysisState.Changed) {
                b.append("Interpretation");
            }
            return (String)(bc.length() == 0 ? "" : "Error Checking: " + bc.toString() + "; ") + "Changed: " + b.toString();
        }

        public String getMetadataFieldsAsText() {
            CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder();
            if (this.chMetadataFields != null) {
                for (String s : this.chMetadataFields) {
                    b.append(s);
                }
            }
            return b.toString();
        }

        public boolean noUpdates() {
            return !this.changedMetadata.noteable() && !this.changedDefinitions.noteable() && this.changedContent.noteable() && this.changedContentInterpretation.noteable();
        }

        public boolean noChangeOtherThanMetadata(String[] metadataFields) {
            if (this.changedDefinitions.noteable() || this.changedContent.noteable() || this.changedContentInterpretation.noteable()) {
                return false;
            }
            if (!this.changedMetadata.noteable()) {
                return true;
            }
            for (String s : this.chMetadataFields) {
                if (Utilities.existsInList((String)s, (String[])metadataFields)) continue;
                return false;
            }
            return true;
        }
    }

    public static enum ChangeAnalysisState {
        Unknown,
        NotChanged,
        Changed,
        CannotEvaluate;


        boolean noteable() {
            return this == Changed || this == CannotEvaluate;
        }
    }
}

