/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.context;

import com.google.gson.JsonObject;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.fhir.ucum.UcumService;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.TerminologyServiceException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.CanonicalResourceManager;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.ILoggingService;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.context.OidIndexBuilder;
import org.hl7.fhir.r5.context.SystemOutLoggingService;
import org.hl7.fhir.r5.context.TypeManager;
import org.hl7.fhir.r5.model.ActorDefinition;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.Bundle;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.IdType;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.ImplementationGuide;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Library;
import org.hl7.fhir.r5.model.Measure;
import org.hl7.fhir.r5.model.NamingSystem;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.PackageInformation;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.PlanDefinition;
import org.hl7.fhir.r5.model.PrimitiveType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Requirements;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.StructureMap;
import org.hl7.fhir.r5.model.UriType;
import org.hl7.fhir.r5.model.UrlType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.profilemodel.PEBuilder;
import org.hl7.fhir.r5.renderers.OperationOutcomeRenderer;
import org.hl7.fhir.r5.terminologies.CodeSystemUtilities;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientContext;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientR5;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpander;
import org.hl7.fhir.r5.terminologies.expansion.ValueSetExpansionOutcome;
import org.hl7.fhir.r5.terminologies.utilities.CodingValidationRequest;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyCache;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyOperationContext;
import org.hl7.fhir.r5.terminologies.utilities.TerminologyServiceErrorClass;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.r5.terminologies.validation.VSCheckerException;
import org.hl7.fhir.r5.terminologies.validation.ValueSetValidator;
import org.hl7.fhir.r5.utils.PackageHackerR5;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.client.EFhirClientException;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.utilities.ToolingClientLogger;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.i18n.I18nBase;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;

public abstract class BaseWorkerContext
extends I18nBase
implements IWorkerContext {
    private static final boolean QA_CHECK_REFERENCE_SOURCE = false;
    private Object lock = new Object();
    protected String version;
    protected final TerminologyClientManager terminologyClientManager = new TerminologyClientManager(new TerminologyClientR5.TerminologyClientR5Factory(), UUID.randomUUID().toString());
    private boolean minimalMemory = false;
    private Map<String, Map<String, ResourceProxy>> allResourcesById = new HashMap<String, Map<String, ResourceProxy>>();
    private CanonicalResourceManager<CodeSystem> codeSystems = new CanonicalResourceManager(false, this.minimalMemory);
    private final Set<String> supportedCodeSystems = new HashSet<String>();
    private final Set<String> unsupportedCodeSystems = new HashSet<String>();
    private CanonicalResourceManager<ValueSet> valueSets = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<ConceptMap> maps = new CanonicalResourceManager(false, this.minimalMemory);
    protected CanonicalResourceManager<StructureMap> transforms = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<StructureDefinition> structures = new CanonicalResourceManager(false, this.minimalMemory);
    private TypeManager typeManager = new TypeManager(this.structures);
    private final CanonicalResourceManager<Measure> measures = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Library> libraries = new CanonicalResourceManager(false, this.minimalMemory);
    private CanonicalResourceManager<ImplementationGuide> guides = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<CapabilityStatement> capstmts = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<SearchParameter> searchParameters = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Questionnaire> questionnaires = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<OperationDefinition> operations = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<PlanDefinition> plans = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<ActorDefinition> actors = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<Requirements> requirements = new CanonicalResourceManager(false, this.minimalMemory);
    private final CanonicalResourceManager<NamingSystem> systems = new CanonicalResourceManager(false, this.minimalMemory);
    private Map<String, NamingSystem> systemUrlMap;
    private UcumService ucumService;
    protected Map<String, byte[]> binaries = new HashMap<String, byte[]>();
    protected Map<String, Set<IWorkerContext.OIDDefinition>> oidCacheManual = new HashMap<String, Set<IWorkerContext.OIDDefinition>>();
    protected List<OIDSource> oidSources = new ArrayList<OIDSource>();
    protected Map<String, Map<String, ValidationResult>> validationCache = new HashMap<String, Map<String, ValidationResult>>();
    protected String name;
    private boolean allowLoadingDuplicates;
    private final Set<String> codeSystemsUsed = new HashSet<String>();
    protected ToolingClientLogger txLog;
    protected boolean canRunWithoutTerminology;
    protected boolean noTerminologyServer;
    private int expandCodesLimit = 1000;
    protected ILoggingService logger = new SystemOutLoggingService();
    protected Parameters expParameters;
    private Map<String, PackageInformation> packages = new HashMap<String, PackageInformation>();
    protected TerminologyCache txCache = new TerminologyCache(this, null);
    protected TimeTracker clock;
    private boolean tlogging = true;
    private IWorkerContextManager.ICanonicalResourceLocator locator;
    protected String userAgent;
    private Set<String> notCanonical = new HashSet<String>();
    protected IWorkerContextManager.IPackageLoadingTracker packageTracker;
    private boolean forPublication;
    private boolean cachingAllowed = true;
    private static boolean nsFailHasFailed;

    protected BaseWorkerContext() throws FileNotFoundException, IOException, FHIRException {
        this.setValidationMessageLanguage(this.getLocale());
        this.clock = new TimeTracker();
    }

    protected BaseWorkerContext(Locale locale) throws FileNotFoundException, IOException, FHIRException {
        this.setValidationMessageLanguage(locale);
        this.clock = new TimeTracker();
    }

    protected BaseWorkerContext(CanonicalResourceManager<CodeSystem> codeSystems, CanonicalResourceManager<ValueSet> valueSets, CanonicalResourceManager<ConceptMap> maps, CanonicalResourceManager<StructureDefinition> profiles, CanonicalResourceManager<ImplementationGuide> guides) throws FileNotFoundException, IOException, FHIRException {
        this();
        this.codeSystems = codeSystems;
        this.valueSets = valueSets;
        this.maps = maps;
        this.structures = profiles;
        this.typeManager = new TypeManager(this.structures);
        this.guides = guides;
        this.clock = new TimeTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copy(BaseWorkerContext other) {
        Object object = other.lock;
        synchronized (object) {
            this.allResourcesById.putAll(other.allResourcesById);
            this.codeSystems.copy(other.codeSystems);
            this.valueSets.copy(other.valueSets);
            this.maps.copy(other.maps);
            this.transforms.copy(other.transforms);
            this.structures.copy(other.structures);
            this.typeManager = new TypeManager(this.structures);
            this.searchParameters.copy(other.searchParameters);
            this.plans.copy(other.plans);
            this.questionnaires.copy(other.questionnaires);
            this.operations.copy(other.operations);
            this.systems.copy(other.systems);
            this.systemUrlMap = null;
            this.guides.copy(other.guides);
            this.capstmts.copy(other.capstmts);
            this.measures.copy(other.measures);
            this.libraries.copy(this.libraries);
            this.allowLoadingDuplicates = other.allowLoadingDuplicates;
            this.name = other.name;
            this.txLog = other.txLog;
            this.canRunWithoutTerminology = other.canRunWithoutTerminology;
            this.noTerminologyServer = other.noTerminologyServer;
            if (other.txCache != null) {
                this.txCache = other.txCache;
            }
            this.expandCodesLimit = other.expandCodesLimit;
            this.logger = other.logger;
            this.expParameters = other.expParameters;
            this.version = other.version;
            this.supportedCodeSystems.addAll(other.supportedCodeSystems);
            this.unsupportedCodeSystems.addAll(other.unsupportedCodeSystems);
            this.codeSystemsUsed.addAll(other.codeSystemsUsed);
            this.ucumService = other.ucumService;
            this.binaries.putAll(other.binaries);
            this.oidSources.addAll(other.oidSources);
            this.oidCacheManual.putAll(other.oidCacheManual);
            this.validationCache.putAll(other.validationCache);
            this.tlogging = other.tlogging;
            this.locator = other.locator;
            this.userAgent = other.userAgent;
            this.terminologyClientManager.copy(other.terminologyClientManager);
            this.cachingAllowed = other.cachingAllowed;
        }
    }

    @Override
    public void cacheResource(Resource r) throws FHIRException {
        this.cacheResourceFromPackage(r, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerResourceFromPackage(CanonicalResourceManager.CanonicalResourceProxy r, PackageInformation packageInfo) throws FHIRException {
        PackageHackerR5.fixLoadedResource(r, packageInfo);
        Object object = this.lock;
        synchronized (object) {
            if (packageInfo != null) {
                this.packages.put(packageInfo.getVID(), packageInfo);
            }
            if (r.getId() != null) {
                Map<String, ResourceProxy> map = this.allResourcesById.get(r.getType());
                if (map == null) {
                    map = new HashMap<String, ResourceProxy>();
                    this.allResourcesById.put(r.getType(), map);
                }
                if (packageInfo == null || !packageInfo.isExamplesPackage() || !map.containsKey(r.getId())) {
                    map.put(r.getId(), new ResourceProxy(r));
                }
            }
            String url = r.getUrl();
            if (!this.allowLoadingDuplicates && this.hasResourceVersion(r.getType(), url, r.getVersion()) && !packageInfo.isHTO()) {
                if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                    return;
                }
                CanonicalResource ex = (CanonicalResource)this.fetchResourceWithException(r.getType(), url);
                throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url, r.getVersion(), ex.getVersion(), ex.fhirType()}));
            }
            switch (r.getType()) {
                case "StructureDefinition": {
                    if ("1.4.0".equals(this.version)) {
                        StructureDefinition sd = (StructureDefinition)r.getResource();
                        this.fixOldSD(sd);
                    }
                    this.structures.register(r, packageInfo);
                    this.typeManager.see(r);
                    break;
                }
                case "ValueSet": {
                    this.valueSets.register(r, packageInfo);
                    break;
                }
                case "CodeSystem": {
                    this.codeSystems.register(r, packageInfo);
                    break;
                }
                case "ImplementationGuide": {
                    this.guides.register(r, packageInfo);
                    break;
                }
                case "CapabilityStatement": {
                    this.capstmts.register(r, packageInfo);
                    break;
                }
                case "Measure": {
                    this.measures.register(r, packageInfo);
                    break;
                }
                case "Library": {
                    this.libraries.register(r, packageInfo);
                    break;
                }
                case "SearchParameter": {
                    this.searchParameters.register(r, packageInfo);
                    break;
                }
                case "PlanDefinition": {
                    this.plans.register(r, packageInfo);
                    break;
                }
                case "OperationDefinition": {
                    this.operations.register(r, packageInfo);
                    break;
                }
                case "Questionnaire": {
                    this.questionnaires.register(r, packageInfo);
                    break;
                }
                case "ConceptMap": {
                    this.maps.register(r, packageInfo);
                    break;
                }
                case "StructureMap": {
                    this.transforms.register(r, packageInfo);
                    break;
                }
                case "NamingSystem": {
                    this.systems.register(r, packageInfo);
                    break;
                }
                case "Requirements": {
                    this.requirements.register(r, packageInfo);
                    break;
                }
                case "ActorDefinition": {
                    this.actors.register(r, packageInfo);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cacheResourceFromPackage(Resource r, PackageInformation packageInfo) throws FHIRException {
        Object object = this.lock;
        synchronized (object) {
            if (packageInfo != null) {
                this.packages.put(packageInfo.getVID(), packageInfo);
            }
            if (r.getId() != null) {
                Map<String, ResourceProxy> map = this.allResourcesById.get(r.fhirType());
                if (map == null) {
                    map = new HashMap<String, ResourceProxy>();
                    this.allResourcesById.put(r.fhirType(), map);
                }
                if (packageInfo == null || !packageInfo.isExamplesPackage() || !map.containsKey(r.getId())) {
                    map.put(r.getId(), new ResourceProxy(r));
                } else {
                    this.logger.logDebugMessage(ILoggingService.LogCategory.PROGRESS, "Ignore " + r.fhirType() + "/" + r.getId() + " from package " + packageInfo.toString());
                }
            }
            if (r instanceof CodeSystem || r instanceof NamingSystem) {
                Object ns;
                String url = null;
                HashSet<String> oids = new HashSet<String>();
                if (r instanceof CodeSystem) {
                    CodeSystem cs = (CodeSystem)r;
                    url = cs.getUrl();
                    for (Identifier identifier : cs.getIdentifier()) {
                        if (!identifier.hasValue() || !identifier.getValue().startsWith("urn:oid:")) continue;
                        oids.add(identifier.getValue().substring(8));
                    }
                }
                if (r instanceof NamingSystem && ((NamingSystem)(ns = (NamingSystem)r)).getKind() == NamingSystem.NamingSystemType.CODESYSTEM) {
                    for (NamingSystem.NamingSystemUniqueIdComponent namingSystemUniqueIdComponent : ((NamingSystem)ns).getUniqueId()) {
                        if (namingSystemUniqueIdComponent.getType() == NamingSystem.NamingSystemIdentifierType.URI) {
                            url = namingSystemUniqueIdComponent.getValue();
                        }
                        if (namingSystemUniqueIdComponent.getType() != NamingSystem.NamingSystemIdentifierType.OID) continue;
                        oids.add(namingSystemUniqueIdComponent.getValue());
                    }
                }
                if (url != null) {
                    for (String s : oids) {
                        if (!this.oidCacheManual.containsKey(s)) {
                            this.oidCacheManual.put(s, new HashSet());
                        }
                        this.oidCacheManual.get(s).add(new IWorkerContext.OIDDefinition(r.fhirType(), s, url, ((CanonicalResource)r).getVersion(), null));
                    }
                }
            }
            if (r instanceof CanonicalResource) {
                CanonicalResource m = (CanonicalResource)r;
                String url = m.getUrl();
                if (!this.allowLoadingDuplicates && this.hasResource(r.getClass(), url)) {
                    if (Utilities.existsInList((String)url, (String[])new String[]{"http://hl7.org/fhir/SearchParameter/example"})) {
                        return;
                    }
                    CanonicalResource ex = (CanonicalResource)this.fetchResourceWithException(r.getClass(), url);
                    throw new DefinitionException(this.formatMessage("Duplicate_Resource_", new Object[]{url, ((CanonicalResource)r).getVersion(), ex.getVersion(), ex.fhirType()}));
                }
                if (r instanceof StructureDefinition) {
                    StructureDefinition sd = (StructureDefinition)m;
                    if ("1.4.0".equals(this.version)) {
                        this.fixOldSD(sd);
                    }
                    this.structures.see(sd, packageInfo);
                    this.typeManager.see(sd);
                } else if (r instanceof ValueSet) {
                    this.valueSets.see((ValueSet)m, packageInfo);
                } else if (r instanceof CodeSystem) {
                    CodeSystemUtilities.crossLinkCodeSystem((CodeSystem)r);
                    this.codeSystems.see((CodeSystem)m, packageInfo);
                } else if (r instanceof ImplementationGuide) {
                    this.guides.see((ImplementationGuide)m, packageInfo);
                } else if (r instanceof CapabilityStatement) {
                    this.capstmts.see((CapabilityStatement)m, packageInfo);
                } else if (r instanceof Measure) {
                    this.measures.see((Measure)m, packageInfo);
                } else if (r instanceof Library) {
                    this.libraries.see((Library)m, packageInfo);
                } else if (r instanceof SearchParameter) {
                    this.searchParameters.see((SearchParameter)m, packageInfo);
                } else if (r instanceof PlanDefinition) {
                    this.plans.see((PlanDefinition)m, packageInfo);
                } else if (r instanceof OperationDefinition) {
                    this.operations.see((OperationDefinition)m, packageInfo);
                } else if (r instanceof Questionnaire) {
                    this.questionnaires.see((Questionnaire)m, packageInfo);
                } else if (r instanceof ConceptMap) {
                    this.maps.see((ConceptMap)m, packageInfo);
                } else if (r instanceof StructureMap) {
                    this.transforms.see((StructureMap)m, packageInfo);
                } else if (r instanceof NamingSystem) {
                    this.systems.see((NamingSystem)m, packageInfo);
                    this.systemUrlMap = null;
                } else if (r instanceof Requirements) {
                    this.requirements.see((Requirements)m, packageInfo);
                } else if (r instanceof ActorDefinition) {
                    this.actors.see((ActorDefinition)m, packageInfo);
                    this.systemUrlMap = null;
                }
            }
        }
    }

    @Override
    public Map<String, NamingSystem> getNSUrlMap() {
        block5: {
            if (this.systemUrlMap == null) {
                this.systemUrlMap = new HashMap<String, NamingSystem>();
                try {
                    List<NamingSystem> nsl = this.systems.getList();
                    for (NamingSystem ns : nsl) {
                        for (NamingSystem.NamingSystemUniqueIdComponent uid : ns.getUniqueId()) {
                            if (uid.getType() != NamingSystem.NamingSystemIdentifierType.URI || !uid.hasValue()) continue;
                            this.systemUrlMap.put(uid.getValue(), ns);
                        }
                    }
                }
                catch (Exception e) {
                    if (nsFailHasFailed) break block5;
                    e.printStackTrace();
                    nsFailHasFailed = true;
                }
            }
        }
        return this.systemUrlMap;
    }

    public void fixOldSD(StructureDefinition sd) {
        if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT && sd.getType().equals("Extension") && sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/")) {
            sd.setSnapshot(null);
        }
        for (ElementDefinition ed : sd.getDifferential().getElement()) {
            if (ed.getPath().equals("Extension.url") || ed.getPath().endsWith(".extension.url")) {
                ed.setMin(1);
                if (ed.hasBase()) {
                    ed.getBase().setMin(1);
                }
            }
            if (!"extension".equals(ed.getSliceName())) continue;
            ed.setSliceName(null);
        }
    }

    private boolean laterVersion(String newVersion, String oldVersion) {
        newVersion = newVersion.trim();
        oldVersion = oldVersion.trim();
        if (StringUtils.isNumeric((CharSequence)newVersion) && StringUtils.isNumeric((CharSequence)oldVersion)) {
            return Double.parseDouble(newVersion) > Double.parseDouble(oldVersion);
        }
        if (this.hasDelimiter(newVersion, oldVersion, ".")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\.");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "-")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\-");
        }
        if (this.hasDelimiter(newVersion, oldVersion, "_")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\_");
        }
        if (this.hasDelimiter(newVersion, oldVersion, ":")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\:");
        }
        if (this.hasDelimiter(newVersion, oldVersion, " ")) {
            return this.laterDelimitedVersion(newVersion, oldVersion, "\\ ");
        }
        return newVersion.compareTo(oldVersion) > 0;
    }

    private boolean hasDelimiter(String s1, String s2, String delimiter) {
        return s1.contains(delimiter) && s2.contains(delimiter) && s1.split(delimiter).length == s2.split(delimiter).length;
    }

    private boolean laterDelimitedVersion(String newVersion, String oldVersion, String delimiter) {
        String[] newParts = newVersion.split(delimiter);
        String[] oldParts = oldVersion.split(delimiter);
        for (int i = 0; i < newParts.length; ++i) {
            if (newParts[i].equals(oldParts[i])) continue;
            return this.laterVersion(newParts[i], oldParts[i]);
        }
        throw new Error(this.formatMessage("Delimited_versions_have_exact_match_for_delimiter____vs_", new Object[]{delimiter, newParts, oldParts}));
    }

    protected <T extends CanonicalResource> void seeMetadataResource(T r, Map<String, T> map, List<T> list, boolean addId) throws FHIRException {
        list.add(r);
        if (r.hasUrl()) {
            if (r.hasVersion()) {
                map.put(r.getUrl() + "|" + r.getVersion(), r);
            }
            if (!map.containsKey(r.getUrl())) {
                map.put(r.getUrl(), r);
            } else {
                ArrayList<CanonicalResource> rl = new ArrayList<CanonicalResource>();
                for (CanonicalResource t : list) {
                    if (!t.getUrl().equals(r.getUrl()) || rl.contains(t)) continue;
                    rl.add(t);
                }
                Collections.sort(rl, new MetadataResourceVersionComparator<T>(list));
                map.put(r.getUrl(), (CanonicalResource)rl.get(rl.size() - 1));
                CanonicalResource latest = null;
                for (CanonicalResource t : rl) {
                    if (!VersionUtilities.versionsCompatible((String)t.getVersion(), (String)r.getVersion())) continue;
                    latest = t;
                }
                if (latest != null) {
                    map.put(r.getUrl() + "|" + VersionUtilities.getMajMin((String)latest.getVersion()), (CanonicalResource)rl.get(rl.size() - 1));
                }
            }
        }
    }

    @Override
    public CodeSystem fetchCodeSystem(String system, FhirPublication fhirVersion) {
        return this.fetchCodeSystem(system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSystem fetchCodeSystem(String system) {
        CodeSystem cs;
        if (system == null) {
            return null;
        }
        if (system.contains("|")) {
            String s = system.substring(0, system.indexOf("|"));
            String v = system.substring(system.indexOf("|") + 1);
            return this.fetchCodeSystem(s, v);
        }
        Object object = this.lock;
        synchronized (object) {
            cs = this.codeSystems.get(system);
        }
        if (cs == null && this.locator != null) {
            this.locator.findResource(this, system);
            object = this.lock;
            synchronized (object) {
                cs = this.codeSystems.get(system);
            }
        }
        return cs;
    }

    @Override
    public CodeSystem fetchCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return this.fetchCodeSystem(system, version);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CodeSystem fetchCodeSystem(String system, String version) {
        CodeSystem cs;
        if (version == null) {
            return this.fetchCodeSystem(system);
        }
        Object object = this.lock;
        synchronized (object) {
            cs = this.codeSystems.get(system, version);
        }
        if (cs == null && this.locator != null) {
            this.locator.findResource(this, system);
            object = this.lock;
            synchronized (object) {
                cs = this.codeSystems.get(system);
            }
        }
        return cs;
    }

    @Override
    public CodeSystem fetchSupplementedCodeSystem(String system, FhirPublication fhirVersion) {
        return this.fetchSupplementedCodeSystem(system);
    }

    @Override
    public CodeSystem fetchSupplementedCodeSystem(String system, String version, FhirPublication fhirVersion) {
        return this.fetchSupplementedCodeSystem(system, version);
    }

    @Override
    public CodeSystem fetchSupplementedCodeSystem(String system) {
        List<CodeSystem> supplements;
        CodeSystem cs = this.fetchCodeSystem(system);
        if (cs != null && (supplements = this.codeSystems.getSupplements(cs)).size() > 0) {
            cs = CodeSystemUtilities.mergeSupplements(cs, supplements);
        }
        return cs;
    }

    @Override
    public CodeSystem fetchSupplementedCodeSystem(String system, String version) {
        List<CodeSystem> supplements;
        CodeSystem cs = this.fetchCodeSystem(system, version);
        if (cs != null && (supplements = this.codeSystems.getSupplements(cs)).size() > 0) {
            cs = CodeSystemUtilities.mergeSupplements(cs, supplements);
        }
        return cs;
    }

    @Override
    public boolean supportsSystem(String system, FhirPublication fhirVersion) throws TerminologyServiceException {
        return this.supportsSystem(system);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean supportsSystem(String system) throws TerminologyServiceException {
        Object object = this.lock;
        synchronized (object) {
            if (this.codeSystems.has(system) && this.codeSystems.get(system).getContent() != Enumerations.CodeSystemContentMode.NOTPRESENT) {
                return true;
            }
            if (this.supportedCodeSystems.contains(system)) {
                return true;
            }
            if (system.startsWith("http://example.org") || system.startsWith("http://acme.com") || system.startsWith("http://hl7.org/fhir/valueset-") || system.startsWith("urn:oid:")) {
                return false;
            }
            if (this.noTerminologyServer) {
                return false;
            }
            if (this.terminologyClientManager != null) {
                try {
                    if (this.terminologyClientManager.supportsSystem(system)) {
                        this.supportedCodeSystems.add(system);
                    }
                }
                catch (Exception e) {
                    if (this.canRunWithoutTerminology) {
                        this.noTerminologyServer = true;
                        this.logger.logMessage("==============!! Running without terminology server !! ==============");
                        if (this.terminologyClientManager.getMasterClient() != null) {
                            this.logger.logMessage("txServer = " + this.terminologyClientManager.getMasterClient().getId());
                            this.logger.logMessage("Error = " + e.getMessage());
                        }
                        this.logger.logMessage("=====================================================================");
                        return false;
                    }
                    e.printStackTrace();
                    throw new TerminologyServiceException((Throwable)e);
                }
                if (this.supportedCodeSystems.contains(system)) {
                    return true;
                }
            }
            return false;
        }
    }

    @Override
    public boolean isServerSideSystem(String url) {
        boolean check = this.supportsSystem(url);
        return check && this.supportedCodeSystems.contains(url);
    }

    protected void txLog(String msg) {
        if (this.tlogging) {
            this.logger.logDebugMessage(ILoggingService.LogCategory.TX, msg);
        }
    }

    public int getExpandCodesLimit() {
        return this.expandCodesLimit;
    }

    public void setExpandCodesLimit(int expandCodesLimit) {
        this.expandCodesLimit = expandCodesLimit;
    }

    @Override
    public ValueSetExpansionOutcome expandVS(Resource src, ElementDefinition.ElementDefinitionBindingComponent binding, boolean cacheOk, boolean heirarchical) throws FHIRException {
        ValueSet vs = null;
        vs = this.fetchResource(ValueSet.class, binding.getValueSet(), src);
        if (vs == null) {
            throw new FHIRException(this.formatMessage("Unable_to_resolve_value_Set_", new Object[]{binding.getValueSet()}));
        }
        return this.expandVS(vs, cacheOk, heirarchical);
    }

    @Override
    public ValueSetExpansionOutcome expandVS(ValueSet.ConceptSetComponent inc, boolean hierarchical, boolean noInactive) throws TerminologyServiceException {
        ValueSetExpansionOutcome res;
        TerminologyCache.CacheToken cacheToken;
        block8: {
            ValueSet vs = new ValueSet();
            vs.setStatus(Enumerations.PublicationStatus.ACTIVE);
            vs.setCompose(new ValueSet.ValueSetComposeComponent());
            vs.getCompose().setInactive(!noInactive);
            vs.getCompose().getInclude().add(inc);
            cacheToken = this.txCache.generateExpandToken(vs, hierarchical);
            res = this.txCache.getExpansion(cacheToken);
            if (res != null) {
                return res;
            }
            Set<String> systems = this.findRelevantSystems(vs);
            TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, systems, true);
            if (tc == null) {
                return new ValueSetExpansionOutcome("No server available", TerminologyServiceErrorClass.INTERNAL_ERROR, true);
            }
            Parameters p = this.constructParameters(tc, vs, hierarchical);
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            for (ValueSet.ConceptSetComponent incl : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(incl.getSystem());
            }
            if (this.noTerminologyServer) {
                return new ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE, false);
            }
            p.addParameter("count", this.expandCodesLimit);
            p.addParameter("offset", 0);
            this.txLog("$expand on " + this.txCache.summary(vs) + " on " + tc.getAddress());
            if (this.addDependentResources(tc, p, vs)) {
                p.addParameter().setName("cache-id").setValue(new IdType(this.terminologyClientManager.getCacheId()));
            }
            try {
                ValueSet result = tc.getClient().expandValueset(vs, p);
                res = new ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
            }
            catch (Exception e) {
                res = new ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, true);
                if (this.txLog == null) break block8;
                res.setTxLink(this.txLog.getLastId());
            }
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    @Override
    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical) {
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_Expansion_Parameters_provided", new Object[0]));
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, false, p);
    }

    @Override
    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean heirarchical, boolean incompleteOk) {
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_Expansion_Parameters_provided", new Object[0]));
        }
        Parameters p = this.expParameters.copy();
        return this.expandVS(vs, cacheOk, heirarchical, incompleteOk, p);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean hierarchical, boolean incompleteOk, Parameters pIn) {
        return this.expandVS(vs, cacheOk, hierarchical, incompleteOk, pIn, false);
    }

    public ValueSetExpansionOutcome expandVS(ValueSet vs, boolean cacheOk, boolean hierarchical, boolean incompleteOk, Parameters pIn, boolean noLimits) {
        ValueSetExpansionOutcome res;
        if (pIn == null) {
            throw new Error(this.formatMessage("No_Parameters_provided_to_expandVS", new Object[0]));
        }
        if (vs.hasUrl() && (vs.getUrl().equals("http://hl7.org/fhir/ValueSet/all-time-units") || vs.getUrl().equals("http://hl7.org/fhir/ValueSet/all-distance-units"))) {
            return new ValueSetExpansionOutcome("This value set is not expanded correctly at this time (will be fixed in a future version)", TerminologyServiceErrorClass.VALUESET_UNSUPPORTED, false);
        }
        Parameters p = pIn.copy();
        p.setParameter("_limit", new IntegerType("10000"));
        p.setParameter("_incomplete", new BooleanType("true"));
        if (vs.hasExpansion()) {
            return new ValueSetExpansionOutcome(vs.copy());
        }
        if (!vs.hasUrl()) {
            throw new Error(this.formatMessage("no_value_set", new Object[0]));
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.codeSystemsUsed.add(inc.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.txCache.generateExpandToken(vs, hierarchical);
        if (cacheOk && (res = this.txCache.getExpansion(cacheToken)) != null) {
            return res;
        }
        if (!noLimits) {
            p.addParameter("count", this.expandCodesLimit);
            p.addParameter("offset", 0);
        }
        p.setParameter("excludeNested", !hierarchical);
        if (incompleteOk) {
            p.setParameter("incomplete-ok", true);
        }
        ArrayList<String> allErrors = new ArrayList<String>();
        ValueSetExpander vse = this.constructValueSetExpanderSimple(new ValidationOptions(vs.getFHIRPublicationVersion()));
        res = null;
        try {
            res = vse.expand(vs, p);
        }
        catch (Exception e) {
            allErrors.addAll(vse.getAllErrors());
            e.printStackTrace();
            res = new ValueSetExpansionOutcome(e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, e instanceof EFhirClientException);
        }
        allErrors.addAll(vse.getAllErrors());
        if (res.getValueset() != null) {
            if (!res.getValueset().hasUrl()) {
                throw new Error(this.formatMessage("no_url_in_expand_value_set", new Object[0]));
            }
            this.txCache.cacheExpansion(cacheToken, res, false);
            return res;
        }
        if (res.getErrorClass() == TerminologyServiceErrorClass.INTERNAL_ERROR || this.isNoTerminologyServer()) {
            return new ValueSetExpansionOutcome(res.getError(), res.getErrorClass(), false);
        }
        if (this.noTerminologyServer) {
            return new ValueSetExpansionOutcome(this.formatMessage("Error_expanding_ValueSet_running_without_terminology_services", new Object[0]), TerminologyServiceErrorClass.NOSERVICE, allErrors, false);
        }
        p.addParameter().setName("cache-id").setValue(new IdType(this.terminologyClientManager.getCacheId()));
        Set<String> systems = this.findRelevantSystems(vs);
        TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, systems, true);
        this.addDependentResources(tc, p, vs);
        this.txLog("$expand on " + this.txCache.summary(vs) + " on " + tc.getAddress());
        try {
            ValueSet result = tc.getClient().expandValueset(vs, p);
            if (result != null) {
                if (!result.hasUrl()) {
                    result.setUrl(vs.getUrl());
                }
                if (!result.hasUrl()) {
                    throw new Error(this.formatMessage("no_url_in_expand_value_set_2", new Object[0]));
                }
            }
            res = new ValueSetExpansionOutcome(result).setTxLink(this.txLog.getLastId());
        }
        catch (Exception e) {
            res = res != null && !res.isFromServer() ? new ValueSetExpansionOutcome(res.getError() + " (and " + e.getMessage() + ")", res.getErrorClass(), false) : new ValueSetExpansionOutcome(e.getMessage() == null ? e.getClass().getName() : e.getMessage(), TerminologyServiceErrorClass.UNKNOWN, allErrors, true).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
        }
        this.txCache.cacheExpansion(cacheToken, res, true);
        return res;
    }

    @Override
    public ValidationResult validateCode(ValidationOptions options, String system, String version, String code, String display) {
        assert (options != null);
        Coding c = new Coding(system, version, code, display);
        return this.validateCode(options, c, null);
    }

    @Override
    public ValidationResult validateCode(ValidationOptions options, String system, String version, String code, String display, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(system, version, code, display);
        ValidationResult ret = this.validateCode(options, "$", c, vs);
        ret.trimPath("$");
        return ret;
    }

    @Override
    public ValidationResult validateCode(ValidationOptions options, String code, ValueSet vs) {
        assert (options != null);
        Coding c = new Coding(null, code, null);
        return this.validateCode(options.withGuessSystem(), c, vs);
    }

    @Override
    public void validateCodeBatch(ValidationOptions options, List<? extends CodingValidationRequest> codes, ValueSet vs) {
        if (options == null) {
            options = ValidationOptions.defaults();
        }
        for (CodingValidationRequest codingValidationRequest : codes) {
            codingValidationRequest.setCacheToken(this.txCache != null ? this.txCache.generateValidationToken(options, codingValidationRequest.getCoding(), vs == null ? codingValidationRequest.getVsObj() : vs, this.expParameters) : null);
            if (codingValidationRequest.getCoding().hasSystem()) {
                this.codeSystemsUsed.add(codingValidationRequest.getCoding().getSystem());
            }
            if (this.txCache == null) continue;
            codingValidationRequest.setResult(this.txCache.getValidation(codingValidationRequest.getCacheToken()));
        }
        if (options.isUseClient()) {
            for (CodingValidationRequest codingValidationRequest : codes) {
                if (codingValidationRequest.hasResult()) continue;
                try {
                    ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs == null ? codingValidationRequest.getVsObj() : vs);
                    vsc.setThrowToServer(options.isUseServer() && this.terminologyClientManager.hasClient());
                    ValidationResult validationResult = vsc.validateCode("Coding", codingValidationRequest.getCoding());
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(codingValidationRequest.getCacheToken(), validationResult, false);
                    }
                    codingValidationRequest.setResult(validationResult);
                }
                catch (Exception vsc) {}
            }
        }
        for (CodingValidationRequest codingValidationRequest : codes) {
            Object codeKey;
            if (codingValidationRequest.hasResult()) continue;
            Object object = codeKey = codingValidationRequest.getCoding().hasVersion() ? codingValidationRequest.getCoding().getSystem() + "|" + codingValidationRequest.getCoding().getVersion() : codingValidationRequest.getCoding().getSystem();
            if (!options.isUseServer()) {
                codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[0]), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, null));
                continue;
            }
            if (this.unsupportedCodeSystems.contains(codeKey)) {
                codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("UNKNOWN_CODESYSTEM", new Object[]{codingValidationRequest.getCoding().getSystem()}), TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, null));
                continue;
            }
            if (!this.noTerminologyServer) continue;
            codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[]{codingValidationRequest.getCoding().getCode(), codingValidationRequest.getCoding().getSystem()}), TerminologyServiceErrorClass.NOSERVICE, null));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        Bundle batch = new Bundle();
        batch.setType(Bundle.BundleType.BATCH);
        Set<String> set = this.findRelevantSystems(vs);
        for (CodingValidationRequest codingValidationRequest : codes) {
            if (codingValidationRequest.hasResult()) continue;
            Parameters pIn = this.constructParameters(options, codingValidationRequest, vs == null ? codingValidationRequest.getVsObj() : vs);
            this.setTerminologyOptions(options, pIn);
            Bundle.BundleEntryComponent be = batch.addEntry();
            be.setResource(pIn);
            be.getRequest().setMethod(Bundle.HTTPVerb.POST);
            if (vs != null || codingValidationRequest.getVsObj() != null) {
                be.getRequest().setUrl("ValueSet/$validate-code");
            } else {
                be.getRequest().setUrl("CodeSystem/$validate-code");
            }
            be.setUserData("source", codingValidationRequest);
            set.add(codingValidationRequest.getCoding().getSystem());
            this.findRelevantSystems(set, codingValidationRequest.getCoding());
        }
        if (batch.getEntry().size() > 0) {
            TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, set, false);
            Bundle bundle = this.processBatch(tc, batch, set);
            for (int i = 0; i < batch.getEntry().size(); ++i) {
                CodingValidationRequest t = (CodingValidationRequest)batch.getEntry().get(i).getUserData("source");
                Bundle.BundleEntryComponent r = bundle.getEntry().get(i);
                if (r.getResource() instanceof Parameters) {
                    t.setResult(this.processValidationResult((Parameters)r.getResource(), vs != null ? vs.getUrl() : (t.getVsObj() != null ? t.getVsObj().getUrl() : null), tc.getAddress()));
                    if (this.txCache == null) continue;
                    this.txCache.cacheValidation(t.getCacheToken(), t.getResult(), true);
                    continue;
                }
                t.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.getResponseText(r.getResource()), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()));
            }
        }
    }

    private Bundle processBatch(TerminologyClientContext tc, Bundle batch, Set<String> systems) {
        Bundle resp;
        this.txLog("$batch validate for " + batch.getEntry().size() + " codes on systems " + systems.toString());
        if (this.terminologyClientManager == null) {
            throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
        }
        if (this.txLog != null) {
            this.txLog.clearLastId();
        }
        if ((resp = tc.getClient().validateBatch(batch)) == null) {
            throw new FHIRException(this.formatMessage("TX_SERVER_NO_BATCH_RESPONSE", new Object[0]));
        }
        return resp;
    }

    @Override
    public void validateCodeBatchByRef(ValidationOptions options, List<? extends CodingValidationRequest> codes, String vsUrl) {
        if (options == null) {
            options = ValidationOptions.defaults();
        }
        for (CodingValidationRequest codingValidationRequest : codes) {
            codingValidationRequest.setCacheToken(this.txCache != null ? this.txCache.generateValidationToken(options, codingValidationRequest.getCoding(), vsUrl, this.expParameters) : null);
            if (codingValidationRequest.getCoding().hasSystem()) {
                this.codeSystemsUsed.add(codingValidationRequest.getCoding().getSystem());
            }
            if (this.txCache == null) continue;
            codingValidationRequest.setResult(this.txCache.getValidation(codingValidationRequest.getCacheToken()));
        }
        ValueSet vs = this.fetchResource(ValueSet.class, vsUrl);
        if (options.isUseClient() && vs != null) {
            for (CodingValidationRequest codingValidationRequest : codes) {
                if (codingValidationRequest.hasResult()) continue;
                try {
                    ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs);
                    vsc.setThrowToServer(options.isUseServer() && this.terminologyClientManager.hasClient());
                    ValidationResult validationResult = vsc.validateCode("Coding", codingValidationRequest.getCoding());
                    if (this.txCache != null) {
                        this.txCache.cacheValidation(codingValidationRequest.getCacheToken(), validationResult, false);
                    }
                    codingValidationRequest.setResult(validationResult);
                }
                catch (Exception vsc) {}
            }
        }
        for (CodingValidationRequest codingValidationRequest : codes) {
            Object codeKey;
            if (codingValidationRequest.hasResult()) continue;
            Object object = codeKey = codingValidationRequest.getCoding().hasVersion() ? codingValidationRequest.getCoding().getSystem() + "|" + codingValidationRequest.getCoding().getVersion() : codingValidationRequest.getCoding().getSystem();
            if (!options.isUseServer()) {
                codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[0]), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, null));
                continue;
            }
            if (this.unsupportedCodeSystems.contains(codeKey)) {
                codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("UNKNOWN_CODESYSTEM", new Object[]{codingValidationRequest.getCoding().getSystem()}), TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, null));
                continue;
            }
            if (!this.noTerminologyServer) continue;
            codingValidationRequest.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[]{codingValidationRequest.getCoding().getCode(), codingValidationRequest.getCoding().getSystem()}), TerminologyServiceErrorClass.NOSERVICE, null));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        Bundle bundle = new Bundle();
        bundle.setType(Bundle.BundleType.BATCH);
        HashSet<String> hashSet = vs != null ? this.findRelevantSystems(vs) : new HashSet();
        for (CodingValidationRequest codingValidationRequest : codes) {
            if (codingValidationRequest.hasResult()) continue;
            Parameters pIn = this.constructParameters(options, codingValidationRequest, vsUrl);
            this.setTerminologyOptions(options, pIn);
            Bundle.BundleEntryComponent be = bundle.addEntry();
            be.setResource(pIn);
            be.getRequest().setMethod(Bundle.HTTPVerb.POST);
            if (vsUrl != null) {
                be.getRequest().setUrl("ValueSet/$validate-code");
            } else {
                be.getRequest().setUrl("CodeSystem/$validate-code");
            }
            be.setUserData("source", codingValidationRequest);
            hashSet.add(codingValidationRequest.getCoding().getSystem());
        }
        TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, hashSet, false);
        if (bundle.getEntry().size() > 0) {
            Bundle bundle2 = this.processBatch(tc, bundle, hashSet);
            for (int i = 0; i < bundle.getEntry().size(); ++i) {
                CodingValidationRequest t = (CodingValidationRequest)bundle.getEntry().get(i).getUserData("source");
                Bundle.BundleEntryComponent r = bundle2.getEntry().get(i);
                if (r.getResource() instanceof Parameters) {
                    t.setResult(this.processValidationResult((Parameters)r.getResource(), vsUrl, tc.getAddress()));
                    if (this.txCache == null) continue;
                    this.txCache.cacheValidation(t.getCacheToken(), t.getResult(), true);
                    continue;
                }
                t.setResult(new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.getResponseText(r.getResource()), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()));
            }
        }
    }

    private String getResponseText(Resource resource) {
        if (resource instanceof OperationOutcome) {
            return OperationOutcomeRenderer.toString((OperationOutcome)resource);
        }
        return "Todo";
    }

    @Override
    public ValidationResult validateCode(ValidationOptions options, Coding code, ValueSet vs) {
        ValidationContextCarrier ctxt = new ValidationContextCarrier();
        return this.validateCode(options, "Coding", code, vs, ctxt);
    }

    public ValidationResult validateCode(ValidationOptions options, String path, Coding code, ValueSet vs) {
        ValidationContextCarrier ctxt = new ValidationContextCarrier();
        return this.validateCode(options, path, code, vs, ctxt);
    }

    private final String getCodeKey(Coding code) {
        return code.hasVersion() ? code.getSystem() + "|" + code.getVersion() : code.getSystem();
    }

    @Override
    public ValidationResult validateCode(ValidationOptions optionsArg, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        return this.validateCode(optionsArg, "Coding", code, vs, ctxt);
    }

    public ValidationResult validateCode(ValidationOptions optionsArg, String path, Coding code, ValueSet vs, ValidationContextCarrier ctxt) {
        String csumm;
        ValidationOptions options;
        ValidationOptions validationOptions = options = optionsArg != null ? optionsArg : ValidationOptions.defaults();
        if (code.hasSystem()) {
            this.codeSystemsUsed.add(code.getSystem());
        }
        TerminologyCache.CacheToken cacheToken = this.cachingAllowed && this.txCache != null ? this.txCache.generateValidationToken(options, code, vs, this.expParameters) : null;
        ValidationResult res = null;
        if (this.cachingAllowed && this.txCache != null) {
            res = this.txCache.getValidation(cacheToken);
        }
        if (res != null) {
            this.updateUnsupportedCodeSystems(res, code, this.getCodeKey(code));
            return res;
        }
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        HashSet<String> unknownSystems = new HashSet<String>();
        String localError = null;
        String localWarning = null;
        TerminologyServiceErrorClass type = TerminologyServiceErrorClass.UNKNOWN;
        if (options.isUseClient()) {
            try {
                ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs, ctxt);
                vsc.setUnknownSystems(unknownSystems);
                vsc.setThrowToServer(options.isUseServer() && this.terminologyClientManager.hasClient());
                if (!ValueSetUtilities.isServerSide(code.getSystem())) {
                    res = vsc.validateCode(path, code.copy());
                    if (this.txCache != null && this.cachingAllowed) {
                        this.txCache.cacheValidation(cacheToken, res, false);
                    }
                    return res;
                }
            }
            catch (VSCheckerException e) {
                if (e.isWarning()) {
                    localWarning = e.getMessage();
                } else {
                    localError = e.getMessage();
                }
                if (e.getIssues() != null) {
                    issues.addAll(e.getIssues());
                }
                type = e.getType();
            }
            catch (TerminologyOperationContext.TerminologyServiceProtectionException e) {
                OperationOutcome.OperationOutcomeIssueComponent iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.ERROR, e.getType());
                iss.getDetails().setText(e.getMessage());
                issues.add(iss);
                return new ValidationResult(ValidationMessage.IssueSeverity.FATAL, e.getMessage(), e.getError(), issues);
            }
            catch (Exception e) {
                localError = e.getMessage();
            }
        }
        if (localError != null && !this.terminologyClientManager.hasClient()) {
            if (unknownSystems.size() > 0) {
                return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, issues).setUnknownSystems(unknownSystems);
            }
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.UNKNOWN, issues);
        }
        if (localWarning != null && !this.terminologyClientManager.hasClient()) {
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localWarning}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
        }
        if (!options.isUseServer()) {
            if (localWarning != null) {
                return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localWarning}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
            }
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localError}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
        }
        String codeKey = this.getCodeKey(code);
        if (this.unsupportedCodeSystems.contains(codeKey)) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("UNKNOWN_CODESYSTEM", new Object[]{code.getSystem()}), TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, issues);
        }
        if (this.noTerminologyServer) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, this.formatMessage("Error_validating_code_running_without_terminology_services", new Object[]{code.getCode(), code.getSystem()}), TerminologyServiceErrorClass.NOSERVICE, issues);
        }
        Set<String> systems = this.findRelevantSystems(code, vs);
        TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, systems, false);
        String string = csumm = this.cachingAllowed && this.txCache != null ? this.txCache.summary(code) : null;
        if (this.cachingAllowed && this.txCache != null) {
            this.txLog("$validate " + csumm + (String)(vs == null ? "" : " for " + this.txCache.summary(vs)) + " on " + tc.getAddress());
        } else {
            this.txLog("$validate " + csumm + " before cache exists on " + tc.getAddress());
        }
        try {
            Parameters pIn = this.constructParameters(options, code);
            res = this.validateOnServer(tc, vs, pIn, options);
        }
        catch (Exception e) {
            res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()).setErrorClass(TerminologyServiceErrorClass.SERVER_ERROR);
        }
        if (!res.isOk() && res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && localError != null && !localError.equals("The local terminology server cannot handle this request")) {
            res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, null).setTxLink(this.txLog == null ? null : this.txLog.getLastId()).setErrorClass(type);
        }
        if (!res.isOk() && localError != null) {
            res.setDiagnostics("Local Error: " + localError.trim() + ". Server Error: " + res.getMessage());
        } else if (!res.isOk() && res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && res.getUnknownSystems() != null && res.getUnknownSystems().contains(codeKey) && localWarning != null) {
            res = new ValidationResult(ValidationMessage.IssueSeverity.WARNING, localWarning, null);
            res.setDiagnostics("Local Warning: " + localWarning.trim() + ". Server Error: " + res.getMessage());
            return res;
        }
        this.updateUnsupportedCodeSystems(res, code, codeKey);
        if (this.cachingAllowed && this.txCache != null) {
            this.txCache.cacheValidation(cacheToken, res, true);
        }
        return res;
    }

    @Override
    public Boolean subsumes(ValidationOptions optionsArg, Coding parent, Coding child) {
        CodeSystem cs;
        Boolean res;
        TerminologyCache.CacheToken cacheToken;
        ValidationOptions options;
        ValidationOptions validationOptions = options = optionsArg != null ? optionsArg : ValidationOptions.defaults();
        if (!parent.hasSystem()) {
            return null;
        }
        this.codeSystemsUsed.add(parent.getSystem());
        if (!child.hasSystem()) {
            return null;
        }
        this.codeSystemsUsed.add(child.getSystem());
        TerminologyCache.CacheToken cacheToken2 = cacheToken = this.cachingAllowed && this.txCache != null ? this.txCache.generateSubsumesToken(options, parent, child, this.expParameters) : null;
        if (this.cachingAllowed && this.txCache != null && (res = this.txCache.getSubsumes(cacheToken)) != null) {
            return res;
        }
        if (options.isUseClient() && parent.getSystem().equals(child.getSystem()) && (cs = this.fetchCodeSystem(parent.getSystem())) != null) {
            Boolean b = CodeSystemUtilities.subsumes(cs, parent.getCode(), child.getCode());
            if (this.txCache != null && this.cachingAllowed) {
                this.txCache.cacheSubsumes(cacheToken, b, true);
            }
            return b;
        }
        if (!this.terminologyClientManager.hasClient() || !options.isUseServer() || this.unsupportedCodeSystems.contains(parent.getSystem()) || this.unsupportedCodeSystems.contains(child.getSystem()) || this.noTerminologyServer) {
            return null;
        }
        HashSet<String> systems = new HashSet<String>();
        systems.add(parent.getSystem());
        systems.add(child.getSystem());
        TerminologyClientContext tc = this.terminologyClientManager.chooseServer(null, systems, false);
        this.txLog("$subsumes " + parent.toString() + " > " + child.toString() + " on " + tc.getAddress());
        try {
            Parameters pIn = new Parameters();
            pIn.addParameter().setName("codingA").setValue(parent);
            pIn.addParameter().setName("codingB").setValue(child);
            if (this.txLog != null) {
                this.txLog.clearLastId();
            }
            Parameters pOut = tc.getClient().subsumes(pIn);
            return this.processSubsumesResult(pOut, tc.getClient().getAddress());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public Boolean processSubsumesResult(Parameters pOut, String server) {
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (!p.hasValue() || !p.getName().equals("outcome")) continue;
            return Utilities.existsInList((String)p.getValue().primitiveValue(), (String[])new String[]{"equivalent", "subsumes"});
        }
        return null;
    }

    protected ValueSetExpander constructValueSetExpanderSimple(ValidationOptions options) {
        return new ValueSetExpander(this, new TerminologyOperationContext(this, options)).setDebug(this.logger.isDebugLogging());
    }

    protected ValueSetValidator constructValueSetCheckerSimple(ValidationOptions options, ValueSet vs, ValidationContextCarrier ctxt) {
        return new ValueSetValidator(this, new TerminologyOperationContext(this, options), options, vs, ctxt, this.expParameters, this.terminologyClientManager);
    }

    protected ValueSetValidator constructValueSetCheckerSimple(ValidationOptions options, ValueSet vs) {
        return new ValueSetValidator(this, new TerminologyOperationContext(this, options), options, vs, this.expParameters, this.terminologyClientManager);
    }

    protected Parameters constructParameters(TerminologyClientContext tcd, ValueSet vs, boolean hierarchical) {
        Parameters p = this.expParameters.copy();
        p.setParameter("includeDefinition", false);
        p.setParameter("excludeNested", !hierarchical);
        this.addDependentResources(tcd, p, vs);
        p.addParameter().setName("cache-id").setValue(new IdType(this.terminologyClientManager.getCacheId()));
        return p;
    }

    protected Parameters constructParameters(ValidationOptions options, Coding coding) {
        Parameters pIn = new Parameters();
        if (options.isGuessSystem()) {
            pIn.addParameter().setName("inferSystem").setValue(new BooleanType(true));
            pIn.addParameter().setName("code").setValue(coding.getCodeElement());
        } else {
            pIn.addParameter().setName("coding").setValue(coding);
        }
        this.setTerminologyOptions(options, pIn);
        return pIn;
    }

    protected Parameters constructParameters(ValidationOptions options, CodeableConcept codeableConcept) {
        Parameters pIn = new Parameters();
        pIn.addParameter().setName("codeableConcept").setValue(codeableConcept);
        this.setTerminologyOptions(options, pIn);
        return pIn;
    }

    protected Parameters constructParameters(ValidationOptions options, CodingValidationRequest codingValidationRequest, ValueSet valueSet) {
        Parameters pIn = new Parameters();
        if (options.isGuessSystem()) {
            pIn.addParameter().setName("inferSystem").setValue(new BooleanType(true));
            pIn.addParameter().setName("code").setValue(codingValidationRequest.getCoding().getCodeElement());
        } else {
            pIn.addParameter().setName("coding").setValue(codingValidationRequest.getCoding());
        }
        if (valueSet != null) {
            pIn.addParameter().setName("valueSet").setResource(valueSet);
        }
        pIn.addParameters(this.expParameters);
        return pIn;
    }

    protected Parameters constructParameters(ValidationOptions options, CodingValidationRequest codingValidationRequest, String vsUrl) {
        Parameters pIn = new Parameters();
        if (options.isGuessSystem()) {
            pIn.addParameter().setName("inferSystem").setValue(new BooleanType(true));
            pIn.addParameter().setName("code").setValue(codingValidationRequest.getCoding().getCodeElement());
        } else {
            pIn.addParameter().setName("coding").setValue(codingValidationRequest.getCoding());
        }
        if (vsUrl != null) {
            pIn.addParameter().setName("url").setValue(new CanonicalType(vsUrl));
        }
        pIn.addParameters(this.expParameters);
        return pIn;
    }

    private void updateUnsupportedCodeSystems(ValidationResult res, Coding code, String codeKey) {
        if (res.getErrorClass() == TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED && !code.hasVersion() && this.fetchCodeSystem(codeKey) == null) {
            this.unsupportedCodeSystems.add(codeKey);
        }
    }

    private void setTerminologyOptions(ValidationOptions options, Parameters pIn) {
        if (options.hasLanguages()) {
            pIn.addParameter("displayLanguage", options.getLanguages().toString());
        }
        if (options.isMembershipOnly()) {
            pIn.addParameter("valueset-membership-only", true);
        }
        if (options.isDisplayWarningMode()) {
            pIn.addParameter("lenient-display-validation", true);
        }
        if (options.isVersionFlexible()) {
            pIn.addParameter("default-to-latest-version", true);
        }
    }

    @Override
    public ValidationResult validateCode(ValidationOptions options, CodeableConcept code, ValueSet vs) {
        TerminologyCache.CacheToken cacheToken = this.txCache.generateValidationToken(options, code, vs, this.expParameters);
        ValidationResult res = null;
        if (this.cachingAllowed && (res = this.txCache.getValidation(cacheToken)) != null) {
            return res;
        }
        for (Coding c : code.getCoding()) {
            if (!c.hasSystem()) continue;
            this.codeSystemsUsed.add(c.getSystem());
        }
        HashSet<String> unknownSystems = new HashSet<String>();
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        String localError = null;
        String localWarning = null;
        if (options.isUseClient()) {
            try {
                ValueSetValidator vsc = this.constructValueSetCheckerSimple(options, vs);
                vsc.setUnknownSystems(unknownSystems);
                vsc.setThrowToServer(options.isUseServer() && this.terminologyClientManager.hasClient());
                res = vsc.validateCode("CodeableConcept", code);
                if (this.cachingAllowed) {
                    this.txCache.cacheValidation(cacheToken, res, false);
                }
                return res;
            }
            catch (VSCheckerException e) {
                if (e.isWarning()) {
                    localWarning = e.getMessage();
                } else {
                    localError = e.getMessage();
                }
                if (e.getIssues() != null) {
                    issues.addAll(e.getIssues());
                }
            }
            catch (TerminologyOperationContext.TerminologyServiceProtectionException e) {
                OperationOutcome.OperationOutcomeIssueComponent iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.ERROR, e.getType());
                iss.getDetails().setText(e.getMessage());
                issues.add(iss);
                return new ValidationResult(ValidationMessage.IssueSeverity.FATAL, e.getMessage(), e.getError(), issues);
            }
            catch (Exception e) {
                localError = e.getMessage();
            }
        }
        if (localError != null && !this.terminologyClientManager.hasClient()) {
            if (unknownSystems.size() > 0) {
                return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED, issues).setUnknownSystems(unknownSystems);
            }
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, localError, TerminologyServiceErrorClass.UNKNOWN, issues);
        }
        if (localWarning != null && !this.terminologyClientManager.hasClient()) {
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, this.formatMessage("Unable_to_validate_code_without_using_server", new Object[]{localWarning}), TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, issues);
        }
        if (!options.isUseServer()) {
            return new ValidationResult(ValidationMessage.IssueSeverity.WARNING, "Unable to validate code without using server", TerminologyServiceErrorClass.BLOCKED_BY_OPTIONS, null);
        }
        if (this.noTerminologyServer) {
            return new ValidationResult(ValidationMessage.IssueSeverity.ERROR, "Error validating code: running without terminology services", TerminologyServiceErrorClass.NOSERVICE, null);
        }
        Set<String> systems = this.findRelevantSystems(code, vs);
        TerminologyClientContext tc = this.terminologyClientManager.chooseServer(vs, systems, false);
        this.txLog("$validate " + this.txCache.summary(code) + " for " + this.txCache.summary(vs) + " on " + tc.getAddress());
        try {
            Parameters pIn = this.constructParameters(options, code);
            res = this.validateOnServer(tc, vs, pIn, options);
        }
        catch (Exception e) {
            res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, e.getMessage() == null ? e.getClass().getName() : e.getMessage(), null).setTxLink(this.txLog == null ? null : this.txLog.getLastId());
        }
        if (this.cachingAllowed) {
            this.txCache.cacheValidation(cacheToken, res, true);
        }
        return res;
    }

    private Set<String> findRelevantSystems(ValueSet vs) {
        HashSet<String> set = new HashSet<String>();
        if (vs != null) {
            this.findRelevantSystems(set, vs);
        }
        return set;
    }

    private Set<String> findRelevantSystems(CodeableConcept code, ValueSet vs) {
        HashSet<String> set = new HashSet<String>();
        if (vs != null) {
            this.findRelevantSystems(set, vs);
        }
        for (Coding c : code.getCoding()) {
            this.findRelevantSystems(set, c);
        }
        return set;
    }

    private Set<String> findRelevantSystems(Coding code, ValueSet vs) {
        HashSet<String> set = new HashSet<String>();
        if (vs != null) {
            this.findRelevantSystems(set, vs);
        }
        if (code != null) {
            this.findRelevantSystems(set, code);
        }
        return set;
    }

    private void findRelevantSystems(Set<String> set, ValueSet vs) {
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.findRelevantSystems(set, inc);
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            this.findRelevantSystems(set, inc);
        }
    }

    private void findRelevantSystems(Set<String> set, ValueSet.ConceptSetComponent inc) {
        if (inc.hasSystem()) {
            if (inc.hasVersion()) {
                set.add(inc.getSystem() + "|" + inc.getVersion());
            } else {
                set.add(inc.getSystem());
            }
        }
        for (CanonicalType u : inc.getValueSet()) {
            ValueSet vs = this.fetchResource(ValueSet.class, (String)u.getValue());
            if (vs != null) {
                this.findRelevantSystems(set, vs);
                continue;
            }
            set.add("--unknown--");
        }
    }

    private void findRelevantSystems(Set<String> set, Coding c) {
        if (c.hasSystem()) {
            if (c.hasVersion()) {
                set.add(c.getSystem() + "|" + c.getVersion());
            } else {
                set.add(c.getSystem());
            }
        }
    }

    protected ValidationResult validateOnServer(TerminologyClientContext tc, ValueSet vs, Parameters pin, ValidationOptions options) throws FHIRException {
        if (vs != null) {
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
            for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
                this.codeSystemsUsed.add(inc.getSystem());
            }
        }
        this.addServerValidationParameters(tc, vs, pin, options);
        if (this.txLog != null) {
            this.txLog.clearLastId();
        }
        if (tc == null) {
            throw new FHIRException(this.formatMessage("Attempt_to_use_Terminology_server_when_no_Terminology_server_is_available", new Object[0]));
        }
        Parameters pOut = vs == null ? tc.getClient().validateCS(pin) : tc.getClient().validateVS(pin);
        return this.processValidationResult(pOut, vs == null ? null : vs.getUrl(), tc.getClient().getAddress());
    }

    protected void addServerValidationParameters(TerminologyClientContext terminologyClientContext, ValueSet vs, Parameters pin, ValidationOptions options) {
        boolean cache = false;
        if (vs != null) {
            if (terminologyClientContext != null && terminologyClientContext.isTxCaching() && terminologyClientContext.getCacheId() != null && vs.getUrl() != null && terminologyClientContext.getCached().contains(vs.getUrl() + "|" + vs.getVersion())) {
                pin.addParameter().setName("url").setValue(new UriType(vs.getUrl()));
                if (vs.hasVersion()) {
                    pin.addParameter().setName("valueSetVersion").setValue(new StringType(vs.getVersion()));
                }
            } else if (options.getVsAsUrl()) {
                pin.addParameter().setName("url").setValue(new UriType(vs.getUrl()));
            } else {
                pin.addParameter().setName("valueSet").setResource(vs);
                if (vs.getUrl() != null) {
                    terminologyClientContext.getCached().add(vs.getUrl() + "|" + vs.getVersion());
                }
            }
            cache = true;
            this.addDependentResources(terminologyClientContext, pin, vs);
        }
        pin.addParameter().setName("cache-id").setValue(new IdType(this.terminologyClientManager.getCacheId()));
        for (Parameters.ParametersParameterComponent pp : pin.getParameter()) {
            if (!pp.getName().equals("profile")) continue;
            throw new Error(this.formatMessage("Can_only_specify_profile_in_the_context", new Object[0]));
        }
        if (this.expParameters == null) {
            throw new Error(this.formatMessage("No_ExpansionProfile_provided", new Object[0]));
        }
        pin.addParameters(this.expParameters);
        if (options.isDisplayWarningMode()) {
            pin.addParameter("mode", "lenient-display-validation");
        }
    }

    private boolean addDependentResources(TerminologyClientContext tc, Parameters pin, ValueSet vs) {
        boolean cache = false;
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            cache = this.addDependentResources(tc, pin, inc, vs) || cache;
        }
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getExclude()) {
            cache = this.addDependentResources(tc, pin, inc, vs) || cache;
        }
        return cache;
    }

    private boolean addDependentResources(TerminologyClientContext tc, Parameters pin, ValueSet.ConceptSetComponent inc, Resource src) {
        boolean cache = false;
        for (CanonicalType c : inc.getValueSet()) {
            ValueSet vs = this.fetchResource(ValueSet.class, (String)c.getValue(), src);
            if (vs == null || this.hasCanonicalResource(pin, "tx-resource", vs.getVUrl())) continue;
            cache = this.checkAddToParams(tc, pin, vs) || cache;
            this.addDependentResources(tc, pin, vs);
            for (Extension ext : vs.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/valueset-supplement")) {
                String url;
                CodeSystem supp;
                if (!ext.hasValueCanonicalType() || (supp = this.fetchResource(CodeSystem.class, url = ext.getValueCanonicalType().asStringValue())) == null) continue;
                cache = this.checkAddToParams(tc, pin, supp) || cache;
            }
        }
        CodeSystem cs = this.fetchResource(CodeSystem.class, inc.getSystem(), src);
        if (!(cs == null || this.hasCanonicalResource(pin, "tx-resource", cs.getVUrl()) || cs.getContent() != Enumerations.CodeSystemContentMode.COMPLETE && cs.getContent() != Enumerations.CodeSystemContentMode.FRAGMENT)) {
            cache = this.checkAddToParams(tc, pin, cs) || cache;
        }
        for (CodeSystem supp : this.codeSystems.getSupplements(cs)) {
            assert (supp.getContent() == Enumerations.CodeSystemContentMode.SUPPLEMENT && supp.getSupplements().equals(inc.getSystem()));
            cache = this.checkAddToParams(tc, pin, supp) || cache;
        }
        return cache;
    }

    private boolean checkAddToParams(TerminologyClientContext tc, Parameters pin, CanonicalResource cr) {
        boolean cache = false;
        boolean addToParams = false;
        if (tc.usingCache()) {
            if (!tc.alreadyCached(cr)) {
                tc.addToCache(cr);
                if (this.logger.isDebugLogging()) {
                    this.logger.logMessage("add to cache: " + cr.getVUrl());
                }
                addToParams = true;
                cache = true;
            } else if (this.logger.isDebugLogging()) {
                this.logger.logMessage("already cached: " + cr.getVUrl());
            }
        } else {
            addToParams = true;
        }
        if (addToParams) {
            pin.addParameter().setName("tx-resource").setResource(cr);
        }
        return cache;
    }

    private boolean hasCanonicalResource(Parameters pin, String name, String vUrl) {
        for (Parameters.ParametersParameterComponent p : pin.getParameter()) {
            if (!name.equals(p.getName()) || !p.hasResource() || !(p.getResource() instanceof CanonicalResource) || !vUrl.equals(((CanonicalResource)p.getResource()).getVUrl())) continue;
            return true;
        }
        return false;
    }

    public ValidationResult processValidationResult(Parameters pOut, String vs, String server) {
        boolean ok = false;
        String message = "No Message returned";
        String display = null;
        String system = null;
        String code = null;
        String version = null;
        boolean inactive = false;
        String status = null;
        ArrayList<OperationOutcome.OperationOutcomeIssueComponent> issues = new ArrayList<OperationOutcome.OperationOutcomeIssueComponent>();
        HashSet<String> unknownSystems = new HashSet<String>();
        TerminologyServiceErrorClass err = TerminologyServiceErrorClass.UNKNOWN;
        for (Parameters.ParametersParameterComponent p : pOut.getParameter()) {
            if (p.hasValue()) {
                OperationOutcome.OperationOutcomeIssueComponent iss;
                String msg;
                if (p.getName().equals("result")) {
                    ok = (Boolean)((BooleanType)p.getValue()).getValue();
                    continue;
                }
                if (p.getName().equals("message")) {
                    message = p.getValue().primitiveValue();
                    continue;
                }
                if (p.getName().equals("display")) {
                    display = p.getValue().primitiveValue();
                    continue;
                }
                if (p.getName().equals("system")) {
                    system = ((PrimitiveType)p.getValue()).asStringValue();
                    continue;
                }
                if (p.getName().equals("version")) {
                    version = ((PrimitiveType)p.getValue()).asStringValue();
                    continue;
                }
                if (p.getName().equals("code")) {
                    code = ((PrimitiveType)p.getValue()).asStringValue();
                    continue;
                }
                if (p.getName().equals("inactive")) {
                    inactive = "true".equals(((PrimitiveType)p.getValue()).asStringValue());
                    continue;
                }
                if (p.getName().equals("status")) {
                    status = ((PrimitiveType)p.getValue()).asStringValue();
                    continue;
                }
                if (p.getName().equals("x-caused-by-unknown-system")) {
                    String unkSystem = ((PrimitiveType)p.getValue()).asStringValue();
                    if (unkSystem != null && unkSystem.contains("|")) {
                        err = TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED_VERSION;
                        system = unkSystem.substring(0, unkSystem.indexOf("|"));
                        version = unkSystem.substring(unkSystem.indexOf("|") + 1);
                        continue;
                    }
                    err = TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED;
                    unknownSystems.add(unkSystem);
                    continue;
                }
                if (p.getName().equals("x-unknown-system")) {
                    unknownSystems.add(((PrimitiveType)p.getValue()).asStringValue());
                    continue;
                }
                if (p.getName().equals("warning-withdrawn")) {
                    msg = ((PrimitiveType)p.getValue()).asStringValue();
                    iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE);
                    iss.getDetails().setText(this.formatMessage(vs == null ? "MSG_WITHDRAWN" : "MSG_WITHDRAWN_SRC", new Object[]{msg, vs, this.impliedType(msg)}));
                    issues.add(iss);
                    continue;
                }
                if (p.getName().equals("warning-deprecated")) {
                    msg = ((PrimitiveType)p.getValue()).asStringValue();
                    iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE);
                    iss.getDetails().setText(this.formatMessage(vs == null ? "MSG_DEPRECATED" : "MSG_DEPRECATED_SRC", new Object[]{msg, vs, this.impliedType(msg)}));
                    issues.add(iss);
                    continue;
                }
                if (p.getName().equals("warning-retired")) {
                    msg = ((PrimitiveType)p.getValue()).asStringValue();
                    iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE);
                    iss.getDetails().setText(this.formatMessage(vs == null ? "MSG_RETIRED" : "MSG_RETIRED_SRC", new Object[]{msg, vs, this.impliedType(msg)}));
                    issues.add(iss);
                    continue;
                }
                if (p.getName().equals("warning-experimental")) {
                    msg = ((PrimitiveType)p.getValue()).asStringValue();
                    iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE);
                    iss.getDetails().setText(this.formatMessage(vs == null ? "MSG_EXPERIMENTAL" : "MSG_EXPERIMENTAL_SRC", new Object[]{msg, vs, this.impliedType(msg)}));
                    issues.add(iss);
                    continue;
                }
                if (p.getName().equals("warning-draft")) {
                    msg = ((PrimitiveType)p.getValue()).asStringValue();
                    iss = new OperationOutcome.OperationOutcomeIssueComponent(OperationOutcome.IssueSeverity.INFORMATION, OperationOutcome.IssueType.BUSINESSRULE);
                    iss.getDetails().setText(this.formatMessage(vs == null ? "MSG_DRAFT" : "MSG_DRAFT_SRC", new Object[]{msg, vs, this.impliedType(msg)}));
                    issues.add(iss);
                    continue;
                }
                if (!p.getName().equals("cause")) continue;
                try {
                    ValidationMessage.IssueType it = ValidationMessage.IssueType.fromCode((String)((String)((StringType)p.getValue()).getValue()));
                    if (it == ValidationMessage.IssueType.UNKNOWN) {
                        err = TerminologyServiceErrorClass.UNKNOWN;
                        continue;
                    }
                    if (it == ValidationMessage.IssueType.NOTFOUND) {
                        err = TerminologyServiceErrorClass.CODESYSTEM_UNSUPPORTED;
                        continue;
                    }
                    if (it == ValidationMessage.IssueType.NOTSUPPORTED) {
                        err = TerminologyServiceErrorClass.VALUESET_UNSUPPORTED;
                        continue;
                    }
                    err = null;
                }
                catch (FHIRException it) {}
                continue;
            }
            if (!p.hasResource() || !p.getName().equals("issues")) continue;
            OperationOutcome oo = (OperationOutcome)p.getResource();
            for (OperationOutcome.OperationOutcomeIssueComponent iss : oo.getIssue()) {
                iss.addExtension("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-server", new UrlType(server));
                issues.add(iss);
            }
        }
        ValidationResult res = null;
        if (!ok) {
            res = new ValidationResult(ValidationMessage.IssueSeverity.ERROR, message, err, null).setTxLink(this.txLog.getLastId());
            if (code != null) {
                res.setDefinition(new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code));
                res.setDisplay(display);
            }
            if (system != null) {
                res.setSystem(system);
            }
            if (version != null) {
                res.setVersion(version);
            }
        } else {
            res = message != null && !message.equals("No Message returned") ? new ValidationResult(ValidationMessage.IssueSeverity.WARNING, message, system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code), display, null).setTxLink(this.txLog.getLastId()) : (display != null ? new ValidationResult(system, version, new CodeSystem.ConceptDefinitionComponent().setDisplay(display).setCode(code), display).setTxLink(this.txLog.getLastId()) : new ValidationResult(system, version, new CodeSystem.ConceptDefinitionComponent().setCode(code), null).setTxLink(this.txLog.getLastId()));
        }
        res.setIssues(issues);
        res.setStatus(inactive, status);
        res.setUnknownSystems(unknownSystems);
        res.setServer(server);
        return res;
    }

    private Object impliedType(String msg) {
        if (msg.contains("/CodeSystem")) {
            return "CodeSystem";
        }
        if (msg.contains("/ValueSet")) {
            return "ValueSet";
        }
        return "item";
    }

    public void initTxCache(String cachePath) throws FileNotFoundException, FHIRException, IOException {
        if (cachePath != null) {
            this.txCache = new TerminologyCache(this.lock, cachePath);
            this.initTxCache(this.txCache);
        }
    }

    public void initTxCache(TerminologyCache cache) {
        this.txCache = cache;
        this.terminologyClientManager.setCache(this.txCache);
    }

    public void clearTSCache(String url) throws Exception {
        this.txCache.removeCS(url);
    }

    public boolean isCanRunWithoutTerminology() {
        return this.canRunWithoutTerminology;
    }

    public void setCanRunWithoutTerminology(boolean canRunWithoutTerminology) {
        this.canRunWithoutTerminology = canRunWithoutTerminology;
    }

    @Override
    public void setLogger(@Nonnull ILoggingService logger) {
        this.logger = logger;
    }

    @Override
    public Parameters getExpansionParameters() {
        return this.expParameters;
    }

    @Override
    public void setExpansionParameters(Parameters expParameters) {
        this.expParameters = expParameters;
        this.terminologyClientManager.setExpansionParameters(expParameters);
    }

    @Override
    public boolean isNoTerminologyServer() {
        return this.noTerminologyServer || !this.terminologyClientManager.hasClient();
    }

    public void setNoTerminologyServer(boolean noTerminologyServer) {
        this.noTerminologyServer = noTerminologyServer;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public List<String> getResourceNames(FhirPublication fhirVersion) {
        return this.getResourceNames();
    }

    @Override
    public Set<String> getResourceNamesAsSet(FhirPublication fhirVersion) {
        return this.getResourceNamesAsSet();
    }

    @Override
    public Set<String> getResourceNamesAsSet() {
        HashSet<String> res = new HashSet<String>();
        res.addAll(this.getResourceNames());
        return res;
    }

    public boolean isAllowLoadingDuplicates() {
        return this.allowLoadingDuplicates;
    }

    public void setAllowLoadingDuplicates(boolean allowLoadingDuplicates) {
        this.allowLoadingDuplicates = allowLoadingDuplicates;
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri) throws FHIRException {
        return this.fetchResourceWithException(class_, uri, null);
    }

    public <T extends Resource> T fetchResourceWithException(String cls, String uri) throws FHIRException {
        return this.fetchResourceWithExceptionByVersion(cls, uri, null, null);
    }

    @Override
    public <T extends Resource> T fetchResourceWithException(Class<T> class_, String uri, Resource sourceForReference) throws FHIRException {
        return this.fetchResourceWithExceptionByVersion(class_, uri, null, sourceForReference);
    }

    public <T extends Resource> T fetchResourceWithExceptionByVersion(Class<T> class_, String uri, String version, Resource sourceForReference) throws FHIRException {
        if (uri == null) {
            return null;
        }
        if (uri.startsWith("#")) {
            if (sourceForReference != null && sourceForReference instanceof DomainResource) {
                for (Resource r : ((DomainResource)sourceForReference).getContained()) {
                    CanonicalResource cr;
                    if (r.getClass() != class_ || !("#" + r.getIdBase()).equals(uri)) continue;
                    if (r instanceof CanonicalResource && !(cr = (CanonicalResource)r).hasUrl()) {
                        cr.setUrl(Utilities.makeUuidUrn());
                    }
                    return (T)r;
                }
            }
            return null;
        }
        ArrayList<String> pvlist = new ArrayList<String>();
        if (sourceForReference != null && sourceForReference.getSourcePackage() != null) {
            this.populatePVList(pvlist, sourceForReference.getSourcePackage());
        }
        if (class_ == StructureDefinition.class) {
            uri = ProfileUtilities.sdNs(uri, null);
        }
        Object object = this.lock;
        synchronized (object) {
            if (version == null) {
                if (uri.contains("|")) {
                    version = uri.substring(uri.lastIndexOf("|") + 1);
                    uri = uri.substring(0, uri.lastIndexOf("|"));
                }
            } else assert (!uri.contains("|"));
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (class_ == Resource.class || class_ == null) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version, pvlist);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version, pvlist);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version, pvlist);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version, pvlist);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version, pvlist);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version, pvlist);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version, pvlist);
                }
                if (this.systems.has(uri)) {
                    return (T)this.systems.get(uri, version, pvlist);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version, pvlist);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version, pvlist);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version, pvlist);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version, pvlist);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.actors.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.requirements.has(uri)) {
                    return (T)this.transforms.get(uri, version, pvlist);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version, pvlist);
                }
                for (Map<String, ResourceProxy> rt : this.allResourcesById.values()) {
                    for (ResourceProxy r : rt.values()) {
                        if (!uri.equals(r.getUrl()) || version != null && version != r.getResource().getMeta().getVersionId()) continue;
                        return (T)r.getResource();
                    }
                }
                if (uri.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                return null;
            }
            if (class_ == ImplementationGuide.class) {
                return (T)this.guides.get(uri, version, pvlist);
            }
            if (class_ == CapabilityStatement.class) {
                return (T)this.capstmts.get(uri, version, pvlist);
            }
            if (class_ == Measure.class) {
                return (T)this.measures.get(uri, version, pvlist);
            }
            if (class_ == Library.class) {
                return (T)this.libraries.get(uri, version, pvlist);
            }
            if (class_ == StructureDefinition.class) {
                return (T)this.structures.get(uri, version, pvlist);
            }
            if (class_ == StructureMap.class) {
                return (T)this.transforms.get(uri, version, pvlist);
            }
            if (class_ == NamingSystem.class) {
                return (T)this.systems.get(uri, version, pvlist);
            }
            if (class_ == ValueSet.class) {
                return (T)this.valueSets.get(uri, version, pvlist);
            }
            if (class_ == CodeSystem.class) {
                return (T)this.codeSystems.get(uri, version, pvlist);
            }
            if (class_ == ConceptMap.class) {
                return (T)this.maps.get(uri, version, pvlist);
            }
            if (class_ == ActorDefinition.class) {
                return (T)this.actors.get(uri, version, pvlist);
            }
            if (class_ == Requirements.class) {
                return (T)this.requirements.get(uri, version, pvlist);
            }
            if (class_ == PlanDefinition.class) {
                return (T)this.plans.get(uri, version, pvlist);
            }
            if (class_ == OperationDefinition.class) {
                OperationDefinition od = this.operations.get(uri, version);
                return (T)od;
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version, pvlist);
            }
            if (class_ == SearchParameter.class) {
                SearchParameter res = this.searchParameters.get(uri, version, pvlist);
                return (T)res;
            }
            if (class_ == CodeSystem.class && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version, pvlist);
            }
            if (class_ == ValueSet.class && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version, pvlist);
            }
            if (class_ == Questionnaire.class) {
                return (T)this.questionnaires.get(uri, version, pvlist);
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    private void populatePVList(List<String> pvlist, PackageInformation sourcePackage) {
        pvlist.add(sourcePackage.getVID());
        ArrayList<String> toadd = new ArrayList<String>();
        do {
            toadd.clear();
            for (String s : pvlist) {
                PackageInformation pi = this.packages.get(s);
                if (pi == null) continue;
                for (String v : pi.getDependencies()) {
                    if (pvlist.contains(v) || toadd.contains(v)) continue;
                    toadd.add(v);
                }
            }
            pvlist.addAll(toadd);
        } while (toadd.size() > 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PackageInformation getPackageForUrl(String uri) {
        if (uri == null) {
            return null;
        }
        uri = ProfileUtilities.sdNs(uri, null);
        Object object = this.lock;
        synchronized (object) {
            String version = null;
            if (uri.contains("|")) {
                version = uri.substring(uri.lastIndexOf("|") + 1);
                uri = uri.substring(0, uri.lastIndexOf("|"));
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (this.structures.has(uri)) {
                return this.structures.getPackageInfo(uri, version);
            }
            if (this.guides.has(uri)) {
                return this.guides.getPackageInfo(uri, version);
            }
            if (this.capstmts.has(uri)) {
                return this.capstmts.getPackageInfo(uri, version);
            }
            if (this.measures.has(uri)) {
                return this.measures.getPackageInfo(uri, version);
            }
            if (this.libraries.has(uri)) {
                return this.libraries.getPackageInfo(uri, version);
            }
            if (this.valueSets.has(uri)) {
                return this.valueSets.getPackageInfo(uri, version);
            }
            if (this.codeSystems.has(uri)) {
                return this.codeSystems.getPackageInfo(uri, version);
            }
            if (this.operations.has(uri)) {
                return this.operations.getPackageInfo(uri, version);
            }
            if (this.searchParameters.has(uri)) {
                return this.searchParameters.getPackageInfo(uri, version);
            }
            if (this.plans.has(uri)) {
                return this.plans.getPackageInfo(uri, version);
            }
            if (this.maps.has(uri)) {
                return this.maps.getPackageInfo(uri, version);
            }
            if (this.transforms.has(uri)) {
                return this.transforms.getPackageInfo(uri, version);
            }
            if (this.actors.has(uri)) {
                return this.actors.getPackageInfo(uri, version);
            }
            if (this.requirements.has(uri)) {
                return this.requirements.getPackageInfo(uri, version);
            }
            if (this.questionnaires.has(uri)) {
                return this.questionnaires.getPackageInfo(uri, version);
            }
            return null;
        }
    }

    public <T extends Resource> T fetchResourceWithExceptionByVersion(String cls, String uri, String version, CanonicalResource source) throws FHIRException {
        if (uri == null) {
            return null;
        }
        if ("StructureDefinition".equals(cls)) {
            uri = ProfileUtilities.sdNs(uri, null);
        }
        Object object = this.lock;
        synchronized (object) {
            if (version == null) {
                if (uri.contains("|")) {
                    version = uri.substring(uri.lastIndexOf("|") + 1);
                    uri = uri.substring(0, uri.lastIndexOf("|"));
                }
            } else {
                boolean b;
                boolean bl = b = !uri.contains("|");
                assert (b);
            }
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            if (cls == null || "Resource".equals(cls)) {
                if (this.structures.has(uri)) {
                    return (T)this.structures.get(uri, version);
                }
                if (this.guides.has(uri)) {
                    return (T)this.guides.get(uri, version);
                }
                if (this.capstmts.has(uri)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if (this.measures.has(uri)) {
                    return (T)this.measures.get(uri, version);
                }
                if (this.libraries.has(uri)) {
                    return (T)this.libraries.get(uri, version);
                }
                if (this.valueSets.has(uri)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if (this.codeSystems.has(uri)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if (this.operations.has(uri)) {
                    return (T)this.operations.get(uri, version);
                }
                if (this.searchParameters.has(uri)) {
                    return (T)this.searchParameters.get(uri, version);
                }
                if (this.plans.has(uri)) {
                    return (T)this.plans.get(uri, version);
                }
                if (this.maps.has(uri)) {
                    return (T)this.maps.get(uri, version);
                }
                if (this.transforms.has(uri)) {
                    return (T)this.transforms.get(uri, version);
                }
                if (this.actors.has(uri)) {
                    return (T)this.actors.get(uri, version);
                }
                if (this.requirements.has(uri)) {
                    return (T)this.requirements.get(uri, version);
                }
                if (this.questionnaires.has(uri)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                for (Map<String, ResourceProxy> rt : this.allResourcesById.values()) {
                    for (ResourceProxy r : rt.values()) {
                        if (!uri.equals(r.getUrl())) continue;
                        return (T)r.getResource();
                    }
                }
            } else {
                if ("ImplementationGuide".equals(cls)) {
                    return (T)this.guides.get(uri, version);
                }
                if ("CapabilityStatement".equals(cls)) {
                    return (T)this.capstmts.get(uri, version);
                }
                if ("Measure".equals(cls)) {
                    return (T)this.measures.get(uri, version);
                }
                if ("Library".equals(cls)) {
                    return (T)this.libraries.get(uri, version);
                }
                if ("StructureDefinition".equals(cls)) {
                    return (T)this.structures.get(uri, version);
                }
                if ("StructureMap".equals(cls)) {
                    return (T)this.transforms.get(uri, version);
                }
                if ("Requirements".equals(cls)) {
                    return (T)this.requirements.get(uri, version);
                }
                if ("ActorDefinition".equals(cls)) {
                    return (T)this.actors.get(uri, version);
                }
                if ("ValueSet".equals(cls)) {
                    return (T)this.valueSets.get(uri, version);
                }
                if ("CodeSystem".equals(cls)) {
                    return (T)this.codeSystems.get(uri, version);
                }
                if ("ConceptMap".equals(cls)) {
                    return (T)this.maps.get(uri, version);
                }
                if ("PlanDefinition".equals(cls)) {
                    return (T)this.plans.get(uri, version);
                }
                if ("OperationDefinition".equals(cls)) {
                    OperationDefinition od = this.operations.get(uri, version);
                    return (T)od;
                }
                if ("Questionnaire.class".equals(cls)) {
                    return (T)this.questionnaires.get(uri, version);
                }
                if ("SearchParameter.class".equals(cls)) {
                    SearchParameter res = this.searchParameters.get(uri, version);
                    return (T)res;
                }
            }
            if ("CodeSystem".equals(cls) && this.codeSystems.has(uri)) {
                return (T)this.codeSystems.get(uri, version);
            }
            if ("ValueSet".equals(cls) && this.valueSets.has(uri)) {
                return (T)this.valueSets.get(uri, version);
            }
            if ("Questionnaire".equals(cls)) {
                return (T)this.questionnaires.get(uri, version);
            }
            if (cls == null) {
                T res;
                if (uri.matches("((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-]*\\/)*?)?(Account|ActivityDefinition|ActorDefinition|AdministrableProductDefinition|AdverseEvent|AllergyIntolerance|Appointment|AppointmentResponse|ArtifactAssessment|AuditEvent|Basic|Binary|BiologicallyDerivedProduct|BiologicallyDerivedProductDispense|BodyStructure|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|ChargeItemDefinition|Citation|Claim|ClaimResponse|ClinicalImpression|ClinicalUseDefinition|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition|ConditionDefinition|Consent|Contract|Coverage|CoverageEligibilityRequest|CoverageEligibilityResponse|DetectedIssue|Device|DeviceAssociation|DeviceDefinition|DeviceDispense|DeviceMetric|DeviceRequest|DeviceUsage|DiagnosticReport|DocumentReference|Encounter|EncounterHistory|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|EventDefinition|Evidence|EvidenceReport|EvidenceVariable|ExampleScenario|ExplanationOfBenefit|FamilyMemberHistory|Flag|FormularyItem|GenomicStudy|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingSelection|ImagingStudy|Immunization|ImmunizationEvaluation|ImmunizationRecommendation|ImplementationGuide|Ingredient|InsurancePlan|InventoryItem|InventoryReport|Invoice|Library|Linkage|List|Location|ManufacturedItemDefinition|Measure|MeasureReport|Medication|MedicationAdministration|MedicationDispense|MedicationKnowledge|MedicationRequest|MedicationStatement|MedicinalProductDefinition|MessageDefinition|MessageHeader|MolecularSequence|NamingSystem|NutritionIntake|NutritionOrder|NutritionProduct|Observation|ObservationDefinition|OperationDefinition|OperationOutcome|Organization|OrganizationAffiliation|PackagedProductDefinition|Parameters|Patient|PaymentNotice|PaymentReconciliation|Permission|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|Provenance|Questionnaire|QuestionnaireResponse|RegulatedAuthorization|RelatedPerson|RequestOrchestration|Requirements|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|ServiceRequest|Slot|Specimen|SpecimenDefinition|StructureDefinition|StructureMap|Subscription|SubscriptionStatus|SubscriptionTopic|Substance|SubstanceDefinition|SubstanceNucleicAcid|SubstancePolymer|SubstanceProtein|SubstanceReferenceInformation|SubstanceSourceMaterial|SupplyDelivery|SupplyRequest|Task|TerminologyCapabilities|TestPlan|TestReport|TestScript|Transport|ValueSet|VerificationResult|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?") && !uri.contains("ValueSet")) {
                    return null;
                }
                if ((Utilities.isAbsoluteUrl((String)uri) || uri.startsWith("ValueSet/")) && (res = null) != null) {
                    return res;
                }
                return null;
            }
            if (this.supportedCodeSystems.contains(uri)) {
                return null;
            }
            throw new FHIRException(this.formatMessage("not_done_yet_cant_fetch_", new Object[]{uri}));
        }
    }

    @Override
    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_, FhirPublication fhirVersion) {
        return this.fetchResourcesByType(class_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Resource> List<T> fetchResourcesByType(Class<T> class_) {
        ArrayList<CanonicalResource> res = new ArrayList<CanonicalResource>();
        Object object = this.lock;
        synchronized (object) {
            if (class_ == Resource.class || class_ == DomainResource.class || class_ == CanonicalResource.class || class_ == null) {
                res.addAll(this.structures.getList());
                res.addAll(this.guides.getList());
                res.addAll(this.capstmts.getList());
                res.addAll(this.measures.getList());
                res.addAll(this.libraries.getList());
                res.addAll(this.valueSets.getList());
                res.addAll(this.codeSystems.getList());
                res.addAll(this.operations.getList());
                res.addAll(this.searchParameters.getList());
                res.addAll(this.plans.getList());
                res.addAll(this.maps.getList());
                res.addAll(this.transforms.getList());
                res.addAll(this.questionnaires.getList());
                res.addAll(this.systems.getList());
                res.addAll(this.actors.getList());
                res.addAll(this.requirements.getList());
            } else if (class_ == ImplementationGuide.class) {
                res.addAll(this.guides.getList());
            } else if (class_ == CapabilityStatement.class) {
                res.addAll(this.capstmts.getList());
            } else if (class_ == Measure.class) {
                res.addAll(this.measures.getList());
            } else if (class_ == Library.class) {
                res.addAll(this.libraries.getList());
            } else if (class_ == StructureDefinition.class) {
                res.addAll(this.structures.getList());
            } else if (class_ == StructureMap.class) {
                res.addAll(this.transforms.getList());
            } else if (class_ == ValueSet.class) {
                res.addAll(this.valueSets.getList());
            } else if (class_ == CodeSystem.class) {
                res.addAll(this.codeSystems.getList());
            } else if (class_ == NamingSystem.class) {
                res.addAll(this.systems.getList());
            } else if (class_ == ActorDefinition.class) {
                res.addAll(this.actors.getList());
            } else if (class_ == Requirements.class) {
                res.addAll(this.requirements.getList());
            } else if (class_ == ConceptMap.class) {
                res.addAll(this.maps.getList());
            } else if (class_ == PlanDefinition.class) {
                res.addAll(this.plans.getList());
            } else if (class_ == OperationDefinition.class) {
                res.addAll(this.operations.getList());
            } else if (class_ == Questionnaire.class) {
                res.addAll(this.questionnaires.getList());
            } else if (class_ == SearchParameter.class) {
                res.addAll(this.searchParameters.getList());
            }
        }
        return res;
    }

    @Override
    public Resource fetchResourceById(String type, String uri, FhirPublication fhirVersion) {
        return this.fetchResourceById(type, uri);
    }

    @Override
    public Resource fetchResourceById(String type, String uri) {
        Object object = this.lock;
        synchronized (object) {
            String[] parts = uri.split("\\/");
            if (!Utilities.noString((String)type) && parts.length == 1) {
                if (this.allResourcesById.containsKey(type)) {
                    ResourceProxy res = this.allResourcesById.get(type).get(parts[0]);
                    Resource resource = res == null ? null : res.getResource();
                    return resource;
                }
                return null;
            }
            if (parts.length >= 2) {
                if (!Utilities.noString((String)type) && !type.equals(parts[parts.length - 2])) {
                    throw new Error(this.formatMessage("Resource_type_mismatch_for___", new Object[]{type, uri}));
                }
                return this.allResourcesById.get(parts[parts.length - 2]).get(parts[parts.length - 1]).getResource();
            }
            throw new Error(this.formatMessage("Unable_to_process_request_for_resource_for___", new Object[]{type, uri}));
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, Resource sourceForReference) {
        try {
            return this.fetchResourceWithException(class_, uri, sourceForReference);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        return this.fetchResource(class_, uri);
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri, null);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version, FhirPublication fhirVersion) {
        return this.fetchResource(class_, uri, version);
    }

    @Override
    public <T extends Resource> T fetchResource(Class<T> class_, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, version, null);
        }
        catch (FHIRException e) {
            throw new Error(e);
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResource(String cls, String uri) {
        try {
            return this.fetchResourceWithException(cls, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(Class<T> class_, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(String cls, String uri, String version) {
        try {
            return this.fetchResourceWithExceptionByVersion(cls, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, FhirPublication fhirVersion) {
        try {
            return this.fetchResourceWithException(class_, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResource(String cls, String uri, FhirPublication fhirVersion) {
        try {
            return this.fetchResourceWithException(cls, uri) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(Class<T> class_, String uri, String version, FhirPublication fhirVersion) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public <T extends Resource> boolean hasResourceVersion(String cls, String uri, String version, FhirPublication fhirVersion) {
        try {
            return this.fetchResourceWithExceptionByVersion(cls, uri, version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public <T extends Resource> boolean hasResource(Class<T> class_, String uri, Resource sourceOfReference) {
        try {
            return this.fetchResourceWithExceptionByVersion(class_, uri, this.version, null) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportStatus(JsonObject json) {
        Object object = this.lock;
        synchronized (object) {
            json.addProperty("codeystem-count", (Number)this.codeSystems.size());
            json.addProperty("valueset-count", (Number)this.valueSets.size());
            json.addProperty("conceptmap-count", (Number)this.maps.size());
            json.addProperty("transforms-count", (Number)this.transforms.size());
            json.addProperty("structures-count", (Number)this.structures.size());
            json.addProperty("guides-count", (Number)this.guides.size());
            json.addProperty("statements-count", (Number)this.capstmts.size());
            json.addProperty("measures-count", (Number)this.measures.size());
            json.addProperty("libraries-count", (Number)this.libraries.size());
        }
    }

    public void dropResource(Resource r) throws FHIRException {
        this.dropResource(r.fhirType(), r.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dropResource(String fhirType, String id) {
        Object object = this.lock;
        synchronized (object) {
            Map<String, ResourceProxy> map = this.allResourcesById.get(fhirType);
            if (map == null) {
                map = new HashMap<String, ResourceProxy>();
                this.allResourcesById.put(fhirType, map);
            }
            if (map.containsKey(id)) {
                map.remove(id);
            }
            if (fhirType.equals("StructureDefinition")) {
                this.structures.drop(id);
                this.typeManager.reload();
            } else if (fhirType.equals("ImplementationGuide")) {
                this.guides.drop(id);
            } else if (fhirType.equals("CapabilityStatement")) {
                this.capstmts.drop(id);
            } else if (fhirType.equals("Measure")) {
                this.measures.drop(id);
            } else if (fhirType.equals("Library")) {
                this.libraries.drop(id);
            } else if (fhirType.equals("ValueSet")) {
                this.valueSets.drop(id);
            } else if (fhirType.equals("CodeSystem")) {
                this.codeSystems.drop(id);
            } else if (fhirType.equals("OperationDefinition")) {
                this.operations.drop(id);
            } else if (fhirType.equals("Questionnaire")) {
                this.questionnaires.drop(id);
            } else if (fhirType.equals("ConceptMap")) {
                this.maps.drop(id);
            } else if (fhirType.equals("StructureMap")) {
                this.transforms.drop(id);
            } else if (fhirType.equals("NamingSystem")) {
                this.systems.drop(id);
                this.systemUrlMap = null;
            } else if (fhirType.equals("ActorDefinition")) {
                this.actors.drop(id);
            } else if (fhirType.equals("Requirements")) {
                this.requirements.drop(id);
            }
        }
    }

    private <T extends CanonicalResource> void dropMetadataResource(Map<String, T> map, String id) {
        CanonicalResource res = (CanonicalResource)map.get(id);
        if (res != null) {
            map.remove(id);
            if (map.containsKey(res.getUrl())) {
                map.remove(res.getUrl());
            }
            if (res.getVersion() != null && map.containsKey(res.getUrl() + "|" + res.getVersion())) {
                map.remove(res.getUrl() + "|" + res.getVersion());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String listSupportedSystems() {
        Object object = this.lock;
        synchronized (object) {
            String sl = null;
            for (String s : this.supportedCodeSystems) {
                sl = sl == null ? s : sl + "\r\n" + s;
            }
            return sl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int totalCount() {
        Object object = this.lock;
        synchronized (object) {
            return this.valueSets.size() + this.maps.size() + this.structures.size() + this.transforms.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConceptMap> listMaps() {
        ArrayList<ConceptMap> m = new ArrayList<ConceptMap>();
        Object object = this.lock;
        synchronized (object) {
            this.maps.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<StructureDefinition> listStructures() {
        ArrayList<StructureDefinition> m = new ArrayList<StructureDefinition>();
        Object object = this.lock;
        synchronized (object) {
            this.structures.listAll(m);
        }
        return m;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StructureDefinition getStructure(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.structures.get(code);
        }
    }

    private String getUri(NamingSystem ns) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.URI) continue;
            return id.getValue();
        }
        return null;
    }

    private boolean hasOid(NamingSystem ns, String oid) {
        for (NamingSystem.NamingSystemUniqueIdComponent id : ns.getUniqueId()) {
            if (id.getType() != NamingSystem.NamingSystemIdentifierType.OID || !id.getValue().equals(oid)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cacheVS(JsonObject json, Map<String, ValidationResult> t) {
        Object object = this.lock;
        synchronized (object) {
            this.validationCache.put(json.get("url").getAsString(), t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SearchParameter getSearchParameter(String code) {
        Object object = this.lock;
        synchronized (object) {
            return this.searchParameters.get(code);
        }
    }

    @Override
    public ILoggingService getLogger() {
        return this.logger;
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName, FhirPublication fhirVersion) {
        return this.fetchTypeDefinition(typeName);
    }

    @Override
    public StructureDefinition fetchTypeDefinition(String typeName) {
        StructureDefinition p;
        block9: {
            StructureDefinition res;
            if (Utilities.isAbsoluteUrl((String)typeName) && (res = this.fetchResource(StructureDefinition.class, typeName)) != null) {
                return res;
            }
            p = this.typeManager.fetchTypeDefinition(typeName);
            if (p != null && !p.isGeneratedSnapshot()) {
                if (p.isGeneratingSnapshot()) {
                    throw new FHIRException("Attempt to fetch the profile " + p.getVersionedUrl() + " while generating the snapshot for it");
                }
                try {
                    if (this.logger.isDebugLogging()) {
                        System.out.println("Generating snapshot for " + p.getVersionedUrl());
                    }
                    p.setGeneratingSnapshot(true);
                    try {
                        new ContextUtilities(this).generateSnapshot(p);
                    }
                    finally {
                        p.setGeneratingSnapshot(false);
                    }
                }
                catch (Exception e) {
                    System.out.println("Unable to generate snapshot @5 for " + p.getVersionedUrl() + ": " + e.getMessage());
                    if (!this.logger.isDebugLogging()) break block9;
                    e.printStackTrace();
                }
            }
        }
        return p;
    }

    @Override
    public List<StructureDefinition> fetchTypeDefinitions(String typeName) {
        return this.typeManager.getDefinitions(typeName);
    }

    @Override
    public List<StructureDefinition> fetchTypeDefinitions(String typeName, FhirPublication fhirVersion) {
        return this.typeManager.getDefinitions(typeName);
    }

    @Override
    public boolean isPrimitiveType(String type) {
        return this.typeManager.isPrimitive(type);
    }

    @Override
    public boolean isDataType(String type) {
        return this.typeManager.isDataType(type);
    }

    public boolean isTlogging() {
        return this.tlogging;
    }

    public void setTlogging(boolean tlogging) {
        this.tlogging = tlogging;
    }

    @Override
    public UcumService getUcumService() {
        return this.ucumService;
    }

    @Override
    public void setUcumService(UcumService ucumService) {
        this.ucumService = ucumService;
    }

    public String getLinkForUrl(String corePath, String url) {
        if (url == null) {
            return null;
        }
        if (this.codeSystems.has(url)) {
            return this.codeSystems.get(url).getWebPath();
        }
        if (this.valueSets.has(url)) {
            return this.valueSets.get(url).getWebPath();
        }
        if (this.maps.has(url)) {
            return this.maps.get(url).getWebPath();
        }
        if (this.transforms.has(url)) {
            return this.transforms.get(url).getWebPath();
        }
        if (this.actors.has(url)) {
            return this.actors.get(url).getWebPath();
        }
        if (this.requirements.has(url)) {
            return this.requirements.get(url).getWebPath();
        }
        if (this.structures.has(url)) {
            return this.structures.get(url).getWebPath();
        }
        if (this.guides.has(url)) {
            return this.guides.get(url).getWebPath();
        }
        if (this.capstmts.has(url)) {
            return this.capstmts.get(url).getWebPath();
        }
        if (this.measures.has(url)) {
            return this.measures.get(url).getWebPath();
        }
        if (this.libraries.has(url)) {
            return this.libraries.get(url).getWebPath();
        }
        if (this.searchParameters.has(url)) {
            return this.searchParameters.get(url).getWebPath();
        }
        if (this.questionnaires.has(url)) {
            return this.questionnaires.get(url).getWebPath();
        }
        if (this.operations.has(url)) {
            return this.operations.get(url).getWebPath();
        }
        if (this.plans.has(url)) {
            return this.plans.get(url).getWebPath();
        }
        if (url.equals("http://loinc.org")) {
            return corePath + "loinc.html";
        }
        if (url.equals("http://unitsofmeasure.org")) {
            return corePath + "ucum.html";
        }
        if (url.equals("http://snomed.info/sct")) {
            return corePath + "snomed.html";
        }
        return null;
    }

    public List<ImplementationGuide> allImplementationGuides() {
        ArrayList<ImplementationGuide> res = new ArrayList<ImplementationGuide>();
        this.guides.listAll(res);
        return res;
    }

    @Override
    public Set<String> getBinaryKeysAsSet() {
        return this.binaries.keySet();
    }

    @Override
    public boolean hasBinaryKey(String binaryKey) {
        return this.binaries.containsKey(binaryKey);
    }

    @Override
    public byte[] getBinaryForKey(String binaryKey) {
        return this.binaries.get(binaryKey);
    }

    public void finishLoading(boolean genSnapshots) {
        if (!this.hasResource(StructureDefinition.class, "http://hl7.org/fhir/StructureDefinition/Base")) {
            this.cacheResource(ProfileUtilities.makeBaseDefinition(this.version));
        }
        if (genSnapshots) {
            for (StructureDefinition sd : this.listStructures()) {
                try {
                    if (!sd.getSnapshot().isEmpty()) continue;
                    new ContextUtilities(this).generateSnapshot(sd);
                }
                catch (Exception e) {
                    System.out.println("Unable to generate snapshot @1 for " + this.tail(sd.getUrl()) + " from " + this.tail(sd.getBaseDefinition()) + " because " + e.getMessage());
                    if (!this.logger.isDebugLogging()) continue;
                    e.printStackTrace();
                }
            }
        }
        this.codeSystems.setVersion(this.version);
        this.valueSets.setVersion(this.version);
        this.maps.setVersion(this.version);
        this.transforms.setVersion(this.version);
        this.structures.setVersion(this.version);
        this.typeManager.reload();
        this.measures.setVersion(this.version);
        this.libraries.setVersion(this.version);
        this.guides.setVersion(this.version);
        this.capstmts.setVersion(this.version);
        this.searchParameters.setVersion(this.version);
        this.questionnaires.setVersion(this.version);
        this.operations.setVersion(this.version);
        this.plans.setVersion(this.version);
        this.systems.setVersion(this.version);
        this.actors.setVersion(this.version);
        this.requirements.setVersion(this.version);
    }

    protected String tail(String url) {
        if (Utilities.noString((String)url)) {
            return "noname";
        }
        if (url.contains("/")) {
            return url.substring(url.lastIndexOf("/") + 1);
        }
        return url;
    }

    @Override
    public int getClientRetryCount() {
        return this.terminologyClientManager.getRetryCount();
    }

    @Override
    public IWorkerContext setClientRetryCount(int value) {
        this.terminologyClientManager.setRetryCount(value);
        return this;
    }

    public TerminologyClientManager getTxClientManager() {
        return this.terminologyClientManager;
    }

    public String getCacheId() {
        return this.terminologyClientManager.getCacheId();
    }

    @Override
    public TimeTracker clock() {
        return this.clock;
    }

    public int countAllCaches() {
        return this.codeSystems.size() + this.valueSets.size() + this.maps.size() + this.transforms.size() + this.structures.size() + this.measures.size() + this.libraries.size() + this.guides.size() + this.capstmts.size() + this.searchParameters.size() + this.questionnaires.size() + this.operations.size() + this.plans.size() + this.systems.size() + this.actors.size() + this.requirements.size();
    }

    @Override
    public Set<String> getCodeSystemsUsed() {
        return this.codeSystemsUsed;
    }

    public IWorkerContextManager.ICanonicalResourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(IWorkerContextManager.ICanonicalResourceLocator locator) {
        this.locator = locator;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    protected void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
        this.terminologyClientManager.setUserAgent(userAgent);
    }

    @Override
    public IWorkerContextManager.IPackageLoadingTracker getPackageTracker() {
        return this.packageTracker;
    }

    @Override
    public IWorkerContext setPackageTracker(IWorkerContextManager.IPackageLoadingTracker packageTracker) {
        this.packageTracker = packageTracker;
        return this;
    }

    @Override
    public PEBuilder getProfiledElementBuilder(PEBuilder.PEElementPropertiesPolicy elementProps, boolean fixedProps) {
        return new PEBuilder(this, elementProps, fixedProps);
    }

    @Override
    public boolean isForPublication() {
        return this.forPublication;
    }

    @Override
    public void setForPublication(boolean value) {
        this.forPublication = value;
    }

    public boolean isCachingAllowed() {
        return this.cachingAllowed;
    }

    public void setCachingAllowed(boolean cachingAllowed) {
        this.cachingAllowed = cachingAllowed;
    }

    @Override
    public IWorkerContext.OIDSummary urlsForOid(String oid, String resourceType) {
        IWorkerContext.OIDSummary set = this.urlsForOid(oid, resourceType, true);
        if (set.getDefinitions().size() > 1) {
            set = this.urlsForOid(oid, resourceType, false);
        }
        return set;
    }

    public IWorkerContext.OIDSummary urlsForOid(String oid, String resourceType, boolean retired) {
        IWorkerContext.OIDSummary summary = new IWorkerContext.OIDSummary();
        if (oid != null) {
            if (this.oidCacheManual.containsKey(oid)) {
                summary.addOIDs((Collection<IWorkerContext.OIDDefinition>)this.oidCacheManual.get(oid));
            }
            for (OIDSource os : this.oidSources) {
                if (os.db == null) {
                    os.db = this.connectToOidSource(os.folder);
                }
                if (os.db == null) continue;
                try {
                    PreparedStatement psql = resourceType == null ? os.db.prepareStatement("Select TYPE, URL, VERSION, Status from OIDMap where OID = ?") : os.db.prepareStatement("Select TYPE, URL, VERSION, Status from OIDMap where TYPE = '" + resourceType + "' and OID = ?");
                    psql.setString(1, oid);
                    ResultSet rs = psql.executeQuery();
                    while (rs.next()) {
                        if (!retired && "retired".equals(rs.getString(4))) continue;
                        String rt = rs.getString(1);
                        String url = rs.getString(2);
                        String version = rs.getString(3);
                        summary.addOID(new IWorkerContext.OIDDefinition(rt, oid, url, version, os.pid));
                    }
                }
                catch (Exception exception) {
                }
            }
            switch (oid) {
                case "2.16.840.1.113883.6.1": {
                    summary.addOID(new IWorkerContext.OIDDefinition("CodeSystem", "2.16.840.1.113883.6.1", "http://loinc.org", null, null));
                    break;
                }
                case "2.16.840.1.113883.6.8": {
                    summary.addOID(new IWorkerContext.OIDDefinition("CodeSystem", "2.16.840.1.113883.6.8", "http://unitsofmeasure.org", null, null));
                    break;
                }
                case "2.16.840.1.113883.6.96": {
                    summary.addOID(new IWorkerContext.OIDDefinition("CodeSystem", "2.16.840.1.113883.6.96", "http://snomed.info/sct", null, null));
                    break;
                }
            }
        }
        summary.sort();
        return summary;
    }

    private Connection connectToOidSource(String folder) {
        try {
            File ff = ManagedFileAccess.file((String)folder);
            File of = ManagedFileAccess.file((String)Utilities.path((String[])new String[]{ff.getAbsolutePath(), ".oid-map-2.db"}));
            if (!of.exists()) {
                OidIndexBuilder oidBuilder = new OidIndexBuilder(ff, of);
                oidBuilder.build();
            }
            return DriverManager.getConnection("jdbc:sqlite:" + of.getAbsolutePath());
        }
        catch (Exception e) {
            return null;
        }
    }

    public void unload() {
        this.codeSystems.unload();
        this.valueSets.unload();
        this.maps.unload();
        this.transforms.unload();
        this.structures.unload();
        this.typeManager.unload();
        this.measures.unload();
        this.libraries.unload();
        this.guides.unload();
        this.capstmts.unload();
        this.searchParameters.unload();
        this.questionnaires.unload();
        this.operations.unload();
        this.plans.unload();
        this.actors.unload();
        this.requirements.unload();
        this.systems.unload();
        this.binaries.clear();
        this.validationCache.clear();
        this.txCache.unload();
    }

    private <T extends Resource> T doFindTxResource(Class<T> class_, String canonical) {
        if (class_ == ValueSet.class) {
            TerminologyCache.SourcedValueSet svs = null;
            if (this.txCache.hasValueSet(canonical)) {
                svs = this.txCache.getValueSet(canonical);
            } else {
                svs = this.terminologyClientManager.findValueSetOnServer(canonical);
                this.txCache.cacheValueSet(canonical, svs);
            }
            if (svs != null) {
                String web = ToolingExtensions.readStringExtension((DomainResource)svs.getVs(), "http://hl7.org/fhir/tools/StructureDefinition/web-source");
                if (web == null) {
                    web = Utilities.pathURL((String[])new String[]{svs.getServer(), "ValueSet", svs.getVs().getIdBase()});
                }
                svs.getVs().setWebPath(web);
                svs.getVs().setUserData("External.Link", svs.getServer());
            }
            if (svs == null) {
                return null;
            }
            this.cacheResource(svs.getVs());
            return (T)svs.getVs();
        }
        if (class_ == CodeSystem.class) {
            TerminologyCache.SourcedCodeSystem scs = null;
            if (this.txCache.hasCodeSystem(canonical)) {
                scs = this.txCache.getCodeSystem(canonical);
            } else {
                scs = this.terminologyClientManager.findCodeSystemOnServer(canonical);
                this.txCache.cacheCodeSystem(canonical, scs);
            }
            if (scs != null) {
                String web = ToolingExtensions.readStringExtension((DomainResource)scs.getCs(), "http://hl7.org/fhir/tools/StructureDefinition/web-source");
                if (web == null) {
                    web = Utilities.pathURL((String[])new String[]{scs.getServer(), "ValueSet", scs.getCs().getIdBase()});
                }
                scs.getCs().setWebPath(web);
                scs.getCs().setUserData("External.Link", scs.getServer());
            }
            if (scs == null) {
                return null;
            }
            this.cacheResource(scs.getCs());
            return (T)scs.getCs();
        }
        throw new Error("Not supported");
    }

    @Override
    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, Resource sourceOfReference) {
        if (canonical == null) {
            return null;
        }
        T result = this.fetchResource(class_, canonical, sourceOfReference);
        if (result == null) {
            result = this.doFindTxResource(class_, canonical);
        }
        return result;
    }

    @Override
    public <T extends Resource> T findTxResource(Class<T> class_, String canonical) {
        if (canonical == null) {
            return null;
        }
        T result = this.fetchResource(class_, canonical);
        if (result == null) {
            result = this.doFindTxResource(class_, canonical);
        }
        return result;
    }

    @Override
    public <T extends Resource> T findTxResource(Class<T> class_, String canonical, String version) {
        if (canonical == null) {
            return null;
        }
        T result = this.fetchResource(class_, canonical, version);
        if (result == null) {
            result = this.doFindTxResource(class_, canonical + "|" + version);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T extends Resource> List<T> fetchResourcesByUrl(Class<T> class_, String uri) {
        ArrayList<Resource> res = new ArrayList<Resource>();
        if (uri != null && !uri.startsWith("#")) {
            if (class_ == StructureDefinition.class) {
                uri = ProfileUtilities.sdNs(uri, null);
            }
            assert (!uri.contains("|"));
            if (uri.contains("#")) {
                uri = uri.substring(0, uri.indexOf("#"));
            }
            Object object = this.lock;
            synchronized (object) {
                if (class_ == Resource.class || class_ == null) {
                    for (Map<String, ResourceProxy> map : this.allResourcesById.values()) {
                        for (ResourceProxy r : map.values()) {
                            if (!uri.equals(r.getUrl())) continue;
                            res.add(r.getResource());
                        }
                    }
                }
                if (class_ == ImplementationGuide.class || class_ == Resource.class || class_ == null) {
                    for (ImplementationGuide implementationGuide : this.guides.getForUrl(uri)) {
                        res.add(implementationGuide);
                    }
                } else if (class_ == CapabilityStatement.class || class_ == Resource.class || class_ == null) {
                    for (CapabilityStatement capabilityStatement : this.capstmts.getForUrl(uri)) {
                        res.add(capabilityStatement);
                    }
                } else if (class_ == Measure.class || class_ == Resource.class || class_ == null) {
                    for (Measure measure : this.measures.getForUrl(uri)) {
                        res.add(measure);
                    }
                } else if (class_ == Library.class || class_ == Resource.class || class_ == null) {
                    for (Library library : this.libraries.getForUrl(uri)) {
                        res.add(library);
                    }
                } else if (class_ == StructureDefinition.class || class_ == Resource.class || class_ == null) {
                    for (StructureDefinition structureDefinition : this.structures.getForUrl(uri)) {
                        res.add(structureDefinition);
                    }
                } else if (class_ == StructureMap.class || class_ == Resource.class || class_ == null) {
                    for (StructureMap structureMap : this.transforms.getForUrl(uri)) {
                        res.add(structureMap);
                    }
                } else if (class_ == NamingSystem.class || class_ == Resource.class || class_ == null) {
                    for (NamingSystem namingSystem : this.systems.getForUrl(uri)) {
                        res.add(namingSystem);
                    }
                } else if (class_ == ValueSet.class || class_ == Resource.class || class_ == null) {
                    for (ValueSet valueSet : this.valueSets.getForUrl(uri)) {
                        res.add(valueSet);
                    }
                } else if (class_ == CodeSystem.class || class_ == Resource.class || class_ == null) {
                    for (CodeSystem codeSystem : this.codeSystems.getForUrl(uri)) {
                        res.add(codeSystem);
                    }
                } else if (class_ == ConceptMap.class || class_ == Resource.class || class_ == null) {
                    for (ConceptMap conceptMap : this.maps.getForUrl(uri)) {
                        res.add(conceptMap);
                    }
                } else if (class_ == ActorDefinition.class || class_ == Resource.class || class_ == null) {
                    for (ActorDefinition actorDefinition : this.actors.getForUrl(uri)) {
                        res.add(actorDefinition);
                    }
                } else if (class_ == Requirements.class || class_ == Resource.class || class_ == null) {
                    for (Requirements requirements : this.requirements.getForUrl(uri)) {
                        res.add(requirements);
                    }
                } else if (class_ == PlanDefinition.class || class_ == Resource.class || class_ == null) {
                    for (PlanDefinition planDefinition : this.plans.getForUrl(uri)) {
                        res.add(planDefinition);
                    }
                } else if (class_ == OperationDefinition.class || class_ == Resource.class || class_ == null) {
                    for (OperationDefinition operationDefinition : this.operations.getForUrl(uri)) {
                        res.add(operationDefinition);
                    }
                } else if (class_ == Questionnaire.class || class_ == Resource.class || class_ == null) {
                    for (Questionnaire questionnaire : this.questionnaires.getForUrl(uri)) {
                        res.add(questionnaire);
                    }
                } else if (class_ == SearchParameter.class || class_ == Resource.class || class_ == null) {
                    for (SearchParameter searchParameter : this.searchParameters.getForUrl(uri)) {
                        res.add(searchParameter);
                    }
                }
            }
        }
        return res;
    }

    public TerminologyCache getTxCache() {
        return this.txCache;
    }

    public class MetadataResourceVersionComparator<T extends CanonicalResource>
    implements Comparator<T> {
        private final List<T> list;

        public MetadataResourceVersionComparator(List<T> list) {
            this.list = list;
        }

        @Override
        public int compare(T arg1, T arg2) {
            String v1 = ((CanonicalResource)arg1).getVersion();
            String v2 = ((CanonicalResource)arg2).getVersion();
            if (v1 == null && v2 == null) {
                return Integer.compare(this.list.indexOf(arg1), this.list.indexOf(arg2));
            }
            if (v1 == null) {
                return -1;
            }
            if (v2 == null) {
                return 1;
            }
            String mm1 = VersionUtilities.getMajMin((String)v1);
            String mm2 = VersionUtilities.getMajMin((String)v2);
            if (mm1 == null || mm2 == null) {
                return v1.compareTo(v2);
            }
            return mm1.compareTo(mm2);
        }
    }

    public static class ResourceProxy {
        private Resource resource;
        private CanonicalResourceManager.CanonicalResourceProxy proxy;

        public ResourceProxy(Resource resource) {
            this.resource = resource;
        }

        public ResourceProxy(CanonicalResourceManager.CanonicalResourceProxy proxy) {
            this.proxy = proxy;
        }

        public Resource getResource() {
            return this.resource != null ? this.resource : this.proxy.getResource();
        }

        public CanonicalResourceManager.CanonicalResourceProxy getProxy() {
            return this.proxy;
        }

        public String getUrl() {
            if (this.resource == null) {
                return this.proxy.getUrl();
            }
            if (this.resource instanceof CanonicalResource) {
                return ((CanonicalResource)this.resource).getUrl();
            }
            return null;
        }
    }

    class OIDSource {
        private String folder;
        private Connection db;
        private String pid;

        protected OIDSource(String folder, String pid) {
            this.folder = folder;
            this.pid = pid;
        }
    }
}

