/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.elementmodel;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.FHIRFormatError;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Property;
import org.hl7.fhir.r5.elementmodel.ValidatedFragment;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.IDigitalSignatureServices;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public abstract class ParserBase {
    protected IWorkerContext context;
    protected ValidationPolicy policy;
    protected ILinkResolver linkResolver;
    protected boolean showDecorations;
    protected IdRenderingPolicy idPolicy = IdRenderingPolicy.All;
    protected StructureDefinition logical;
    protected IDigitalSignatureServices signatureServices;
    private ProfileUtilities profileUtilities;
    private ContextUtilities contextUtilities;

    public boolean isPrimitive(String code) {
        return this.context.isPrimitiveType(code);
    }

    public ParserBase(IWorkerContext context, ProfileUtilities utilities) {
        this.context = context;
        this.profileUtilities = utilities;
        this.contextUtilities = new ContextUtilities(context);
        this.policy = ValidationPolicy.NONE;
    }

    public ParserBase(IWorkerContext context) {
        this.context = context;
        this.profileUtilities = new ProfileUtilities(context, null, null, new FHIRPathEngine(context));
        this.contextUtilities = new ContextUtilities(context);
        this.policy = ValidationPolicy.NONE;
    }

    public void setupValidation(ValidationPolicy policy) {
        this.policy = policy;
    }

    public abstract List<ValidatedFragment> parse(InputStream var1) throws IOException, FHIRFormatError, DefinitionException, FHIRException;

    public Element parseSingle(InputStream stream, List<ValidationMessage> errors) throws IOException, FHIRFormatError, DefinitionException, FHIRException {
        List<ValidatedFragment> res = this.parse(stream);
        if (res.size() != 1) {
            throw new FHIRException("Parsing FHIR content returned multiple elements in a context where only one element is allowed");
        }
        ValidatedFragment resE = res.get(0);
        if (resE.getElement() == null) {
            throw new FHIRException("Parsing FHIR content failed: " + this.errorSummary(resE.getErrors()));
        }
        if (res.size() == 0) {
            throw new FHIRException("Parsing FHIR content returned no elements in a context where one element is required because: " + this.errorSummary(resE.getErrors()));
        }
        if (errors != null) {
            errors.addAll(resE.getErrors());
        }
        return resE.getElement();
    }

    private String errorSummary(List<ValidationMessage> errors) {
        if (errors == null || errors.size() == 0) {
            return "(no error description)";
        }
        return errors.get(0).summary();
    }

    public abstract void compose(Element var1, OutputStream var2, IParser.OutputStyle var3, String var4) throws FHIRException, IOException;

    public void logError(List<ValidationMessage> errors, String ruleDate, int line, int col, String path, ValidationMessage.IssueType type, String message, ValidationMessage.IssueSeverity level) throws FHIRFormatError {
        if (errors != null) {
            if (this.policy == ValidationPolicy.EVERYTHING) {
                ValidationMessage msg = new ValidationMessage(ValidationMessage.Source.InstanceValidator, type, line, col, path, message, level);
                msg.setRuleDate(ruleDate);
                errors.add(msg);
            } else if (level == ValidationMessage.IssueSeverity.FATAL || level == ValidationMessage.IssueSeverity.ERROR && this.policy == ValidationPolicy.QUICK) {
                throw new FHIRFormatError(message + String.format(" at line %d col %d", line, col));
            }
        }
    }

    protected StructureDefinition getDefinition(List<ValidationMessage> errors, int line, int col, String ns, String name) throws FHIRFormatError {
        if (this.logical != null) {
            String expectedNamespace;
            String expectedName = ToolingExtensions.readStringExtension((DomainResource)this.logical, "http://hl7.org/fhir/tools/StructureDefinition/xml-name");
            if (expectedName == null && Utilities.isAbsoluteUrl((String)(expectedName = this.logical.getType()))) {
                expectedName = expectedName.substring(expectedName.lastIndexOf("/") + 1);
            }
            if (this.matchesNamespace(expectedNamespace = ToolingExtensions.readStringExtension((DomainResource)this.logical, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace"), ns) && this.matchesName(expectedName, name)) {
                return this.logical;
            }
            if (expectedNamespace == null && ns == null) {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("LOGICAL_MODEL_NAME_MISMATCH", name, expectedName), ValidationMessage.IssueSeverity.FATAL);
            } else {
                this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("LOGICAL_MODEL_QNAME_MISMATCH", this.qn(ns, name), this.qn(expectedNamespace, expectedName)), ValidationMessage.IssueSeverity.FATAL);
            }
            return null;
        }
        if (ns == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This__cannot_be_parsed_as_a_FHIR_object_no_namespace", name), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        if (name == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_cannot_be_parsed_as_a_FHIR_object_no_name", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition/de-")) continue;
            String type = this.urlTail(sd.getType());
            if (name.equals(type) && (ns == null || ns.equals("http://hl7.org/fhir")) && !ToolingExtensions.hasAnyOfExtensions(sd, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace")) {
                return sd;
            }
            String sns = ToolingExtensions.readStringExtension((DomainResource)sd, "http://hl7.org/fhir/tools/StructureDefinition/xml-namespace", "http://hl7.org/fhir/StructureDefinition/elementdefinition-namespace");
            if (!name.equals(type) && !name.equals(sd.getName()) || ns == null || !ns.equals(sns)) continue;
            return sd;
        }
        this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_does_not_appear_to_be_a_FHIR_resource_unknown_namespacename_", ns == null ? "(none)" : ns, name), ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    private Object qn(String ns, String name) {
        return ns == null ? name : ns + "::" + name;
    }

    private boolean matchesNamespace(String expectedNamespace, String ns) {
        if (expectedNamespace == null) {
            return ns == null || "noNamespace".equals(ns);
        }
        return expectedNamespace.equals(ns);
    }

    private boolean matchesName(String expectedName, String name) {
        return expectedName != null && expectedName.equals(name);
    }

    private String urlTail(String type) {
        return type == null || !type.contains("/") ? type : type.substring(type.lastIndexOf("/") + 1);
    }

    protected StructureDefinition getDefinition(List<ValidationMessage> errors, int line, int col, String name) throws FHIRFormatError {
        if (name == null) {
            this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_cannot_be_parsed_as_a_FHIR_object_no_name", new Object[0]), ValidationMessage.IssueSeverity.FATAL);
            return null;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!sd.getUrl().equals("http://hl7.org/fhir/StructureDefinition/" + name)) continue;
            this.contextUtilities.generateSnapshot(sd);
            return sd;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!name.equals(sd.getTypeName()) || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            this.contextUtilities.generateSnapshot(sd);
            return sd;
        }
        for (StructureDefinition sd : this.context.fetchResourcesByType(StructureDefinition.class)) {
            if (!name.equals(sd.getUrl()) || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            this.contextUtilities.generateSnapshot(sd);
            return sd;
        }
        this.logError(errors, ValidationMessage.NO_RULE_DATE, line, col, name, ValidationMessage.IssueType.STRUCTURE, this.context.formatMessage("This_does_not_appear_to_be_a_FHIR_resource_unknown_name_", name), ValidationMessage.IssueSeverity.FATAL);
        return null;
    }

    public ILinkResolver getLinkResolver() {
        return this.linkResolver;
    }

    public ParserBase setLinkResolver(ILinkResolver linkResolver) {
        this.linkResolver = linkResolver;
        return this;
    }

    public boolean isShowDecorations() {
        return this.showDecorations;
    }

    public void setShowDecorations(boolean showDecorations) {
        this.showDecorations = showDecorations;
    }

    public String getImpliedProfile() {
        return null;
    }

    public IdRenderingPolicy getIdPolicy() {
        return this.idPolicy;
    }

    public void setIdPolicy(IdRenderingPolicy idPolicy) {
        this.idPolicy = idPolicy;
    }

    protected boolean wantCompose(String path, Element e) {
        if (!"id".equals(e.getName())) {
            return true;
        }
        if (path != null && path.contains(".")) {
            return this.idPolicy.forInner();
        }
        return this.idPolicy.forRoot();
    }

    public boolean hasLogical() {
        return this.logical != null;
    }

    public StructureDefinition getLogical() {
        return this.logical;
    }

    public ParserBase setLogical(StructureDefinition logical) {
        this.logical = logical;
        return this;
    }

    public IDigitalSignatureServices getSignatureServices() {
        return this.signatureServices;
    }

    public void setSignatureServices(IDigitalSignatureServices signatureServices) {
        this.signatureServices = signatureServices;
    }

    protected String getReferenceForElement(Element element) {
        if (element.isPrimitive()) {
            return element.primitiveValue();
        }
        return element.getNamedChildValue("reference");
    }

    public IWorkerContext getContext() {
        return this.context;
    }

    public ValidationPolicy getPolicy() {
        return this.policy;
    }

    public ProfileUtilities getProfileUtilities() {
        return this.profileUtilities;
    }

    public ContextUtilities getContextUtilities() {
        return this.contextUtilities;
    }

    public static enum ValidationPolicy {
        NONE,
        QUICK,
        EVERYTHING;

    }

    public static interface ILinkResolver {
        public String resolveType(String var1);

        public String resolveProperty(Property var1);

        public String resolvePage(String var1);

        public String resolveReference(String var1);
    }

    public static enum IdRenderingPolicy {
        All,
        None,
        RootOnly,
        NotRoot;


        boolean forRoot() {
            return this == All || this == RootOnly;
        }

        boolean forInner() {
            return this == All || this == NotRoot;
        }
    }
}

