/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.fhirpath;

import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.fhir.ucum.Decimal;
import org.fhir.ucum.Pair;
import org.fhir.ucum.UcumException;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.exceptions.PathEngineException;
import org.hl7.fhir.instance.model.api.IIdType;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRLexer;
import org.hl7.fhir.r5.fhirpath.FHIRPathUtilityClasses;
import org.hl7.fhir.r5.fhirpath.TypeDetails;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BaseDateTimeType;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.DateTimeType;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DecimalType;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Quantity;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.TypeConvertor;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.utilities.ValidationResult;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.MarkDownProcessor;
import org.hl7.fhir.utilities.MergedList;
import org.hl7.fhir.utilities.SourceLocation;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;

public class FHIRPathEngine {
    private IWorkerContext worker;
    private IEvaluationContext hostServices;
    private StringBuilder log = new StringBuilder();
    private Set<String> primitiveTypes = new HashSet<String>();
    private Map<String, StructureDefinition> allTypes = new HashMap<String, StructureDefinition>();
    private boolean legacyMode;
    private ValidationOptions terminologyServiceOptions = new ValidationOptions(FhirPublication.R5);
    private ProfileUtilities profileUtilities;
    private String location;
    private boolean allowPolymorphicNames;
    private boolean doImplicitStringConversion;
    private boolean liquidMode;
    private boolean doNotEnforceAsSingletonRule;
    private boolean doNotEnforceAsCaseSensitive;
    private boolean allowDoubleQuotes;
    private List<IssueMessage> typeWarnings = new ArrayList<IssueMessage>();
    private boolean emitSQLonFHIRWarning;
    private static final String[] FHIR_TYPES_STRING = new String[]{"string", "uri", "code", "oid", "id", "uuid", "sid", "markdown", "base64Binary", "canonical", "url", "xhtml"};
    private static final char[] HEX_ARRAY = "0123456789ABCDEF".toCharArray();
    private ContextUtilities cu;

    public FHIRPathEngine(IWorkerContext worker) {
        this(worker, new ProfileUtilities(worker, null, null));
    }

    public FHIRPathEngine(IWorkerContext worker, ProfileUtilities utilities) {
        this.worker = worker;
        this.profileUtilities = utilities;
        for (StructureDefinition sd : worker.fetchResourcesByType(StructureDefinition.class)) {
            if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.SPECIALIZATION && sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL) {
                this.allTypes.put(sd.getName(), sd);
            }
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
            this.primitiveTypes.add(sd.getName());
        }
        this.initFlags();
        this.cu = new ContextUtilities(worker);
    }

    private void initFlags() {
        if (!VersionUtilities.isR5VerOrLater((String)this.worker.getVersion())) {
            this.doNotEnforceAsCaseSensitive = true;
            this.doNotEnforceAsSingletonRule = true;
        }
    }

    public IEvaluationContext getHostServices() {
        return this.hostServices;
    }

    public void setHostServices(IEvaluationContext constantResolver) {
        this.hostServices = constantResolver;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    protected void getChildrenByName(Base item, String name, List<Base> result) throws FHIRException {
        Base[] list;
        String tn = null;
        if (this.isAllowPolymorphicNames()) {
            for (Property p : item.children()) {
                String n;
                if (!p.getName().endsWith("[x]") || !name.startsWith(n = p.getName().substring(0, p.getName().length() - 3))) continue;
                tn = name.substring(n.length());
                name = n;
                break;
            }
        }
        if ((list = item.listChildrenByName(name, false)) != null) {
            for (Base v : list) {
                if (v == null || tn != null && !v.fhirType().equalsIgnoreCase(tn)) continue;
                result.add(this.filterIdType(v));
            }
        }
    }

    private Base filterIdType(Base v) {
        if (v instanceof IIdType) {
            return (Base)((IIdType)v).toUnqualifiedVersionless().withResourceType(null);
        }
        return v;
    }

    public boolean isLegacyMode() {
        return this.legacyMode;
    }

    public void setLegacyMode(boolean legacyMode) {
        this.legacyMode = legacyMode;
    }

    public boolean isDoImplicitStringConversion() {
        return this.doImplicitStringConversion;
    }

    public void setDoImplicitStringConversion(boolean doImplicitStringConversion) {
        this.doImplicitStringConversion = doImplicitStringConversion;
    }

    public boolean isDoNotEnforceAsSingletonRule() {
        return this.doNotEnforceAsSingletonRule;
    }

    public void setDoNotEnforceAsSingletonRule(boolean doNotEnforceAsSingletonRule) {
        this.doNotEnforceAsSingletonRule = doNotEnforceAsSingletonRule;
    }

    public boolean isDoNotEnforceAsCaseSensitive() {
        return this.doNotEnforceAsCaseSensitive;
    }

    public void setDoNotEnforceAsCaseSensitive(boolean doNotEnforceAsCaseSensitive) {
        this.doNotEnforceAsCaseSensitive = doNotEnforceAsCaseSensitive;
    }

    public ExpressionNode parse(String path) throws FHIRLexer.FHIRLexerException {
        return this.parse(path, null);
    }

    public ExpressionNode parse(String path, String name) throws FHIRLexer.FHIRLexerException {
        FHIRLexer lexer = new FHIRLexer(path, name, false, this.allowDoubleQuotes);
        if (lexer.done()) {
            throw lexer.error("Path cannot be empty");
        }
        ExpressionNode result = this.parseExpression(lexer, true);
        if (!lexer.done()) {
            throw lexer.error("Premature ExpressionNode termination at unexpected token \"" + lexer.getCurrent() + "\"");
        }
        result.check();
        return result;
    }

    public ExpressionNodeWithOffset parsePartial(String path, int i) throws FHIRLexer.FHIRLexerException {
        FHIRLexer lexer = new FHIRLexer(path, i, this.allowDoubleQuotes);
        if (lexer.done()) {
            throw lexer.error("Path cannot be empty");
        }
        ExpressionNode result = this.parseExpression(lexer, true);
        result.check();
        return new ExpressionNodeWithOffset(lexer.getCurrentStart(), result);
    }

    public ExpressionNode parse(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        ExpressionNode result = this.parseExpression(lexer, true);
        result.check();
        return result;
    }

    public TypeDetails check(Object appContext, String resourceType, String context, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        return this.check(appContext, resourceType, context, expr, null);
    }

    public TypeDetails check(Object appContext, String resourceType, String context, ExpressionNode expr, Set<ElementDefinition> elementDependencies) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types;
        if (context == null) {
            types = null;
        } else if (!context.contains(".")) {
            StructureDefinition sd = this.worker.fetchTypeDefinition(context);
            if (sd == null) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT", context);
            }
            types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl());
        } else {
            StructureDefinition sd;
            String ctxt = context.substring(0, context.indexOf(46));
            if (Utilities.isAbsoluteUrl((String)resourceType)) {
                ctxt = resourceType;
            }
            if ((sd = this.cu.findType(ctxt)) == null) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT", context);
            }
            List<ElementDefinitionMatch> edl = this.getElementDefinition(sd, context, true, expr);
            if (edl.size() == 0) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT_ELEMENT", context);
            }
            if (edl.size() > 1) {
                throw new Error("Not handled here yet");
            }
            ElementDefinitionMatch ed = edl.get(0);
            if (ed.fixedType != null) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ed.fixedType);
            } else if (ed.getDefinition().getType().isEmpty() || this.isAbstractType(ed.getDefinition().getType())) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ctxt + "#" + context);
            } else {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                    types.addType(t.getCode());
                }
            }
        }
        return this.executeType(new ExecutionTypeContext(appContext, resourceType, types, types), types, expr, elementDependencies, true, false, expr);
    }

    public TypeDetails checkOnTypes(Object appContext, String resourceType, List<String> typeList, ExpressionNode expr, List<IssueMessage> warnings) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        this.typeWarnings.clear();
        TypeDetails types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
        for (String t : typeList) {
            if (!t.contains(".")) {
                StructureDefinition sd = this.worker.fetchTypeDefinition(t);
                if (sd == null) {
                    throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT", t);
                }
                types.addType(sd.getUrl());
                continue;
            }
            boolean checkTypeName = false;
            String ctxt = null;
            if (t.contains("#")) {
                ctxt = t.substring(0, t.indexOf(35));
                t = t.substring(t.indexOf(35) + 1);
            } else if (Utilities.isAbsoluteUrl((String)t)) {
                ctxt = t;
                t = ctxt.substring(ctxt.lastIndexOf("/") + 1);
                checkTypeName = true;
            } else {
                ctxt = t.substring(0, t.indexOf(46));
            }
            StructureDefinition sd = this.cu.findType(ctxt);
            if (sd == null) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT", t);
            }
            String tn = checkTypeName ? sd.getSnapshot().getElementFirstRep().getPath() : t;
            List<ElementDefinitionMatch> edl = this.getElementDefinition(sd, tn, true, expr);
            if (edl.size() == 0) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT_ELEMENT", t);
            }
            if (edl.size() > 1) {
                throw new Error("not handled here either");
            }
            ElementDefinitionMatch ed = edl.get(0);
            if (ed.fixedType != null) {
                types.addType(ed.fixedType);
                continue;
            }
            if (ed.getDefinition().getType().isEmpty() || this.isAbstractType(ed.getDefinition().getType())) {
                types.addType(sd.getType() + "#" + t);
                continue;
            }
            for (ElementDefinition.TypeRefComponent tt : ed.getDefinition().getType()) {
                types.addType(tt.getCode());
            }
        }
        TypeDetails res = this.executeType(new ExecutionTypeContext(appContext, resourceType, types, types), types, expr, null, true, false, expr);
        warnings.addAll(this.typeWarnings);
        return res;
    }

    public TypeDetails checkOnTypes(Object appContext, String resourceType, TypeDetails types, ExpressionNode expr, List<IssueMessage> warnings) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        this.typeWarnings.clear();
        TypeDetails res = this.executeType(new ExecutionTypeContext(appContext, resourceType, types, types), types, expr, null, true, false, expr);
        warnings.addAll(this.typeWarnings);
        return res;
    }

    public TypeDetails check(Object appContext, String resourceType, List<String> resourceTypes, ExpressionNode expr, Set<ElementDefinition> elementDependencies) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types = null;
        for (String rt : resourceTypes) {
            if (types == null) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, rt);
                continue;
            }
            types.addType(rt);
        }
        return this.executeType(new ExecutionTypeContext(appContext, resourceType, types, types), types, expr, elementDependencies, true, false, expr);
    }

    private FHIRException makeExceptionPlural(Integer num, ExpressionNode holder, String constName, Object ... args) {
        Object fmt = this.worker.formatMessagePlural(num, constName, args);
        if (this.location != null) {
            fmt = (String)fmt + " " + this.worker.formatMessagePlural(num, "FHIRPATH_LOCATION", this.location);
        }
        if (holder != null) {
            return new PathEngineException((String)fmt, constName, holder.getStart(), holder.toString());
        }
        return new PathEngineException((String)fmt, constName);
    }

    private FHIRException makeException(ExpressionNode holder, String constName, Object ... args) {
        Object fmt = this.worker.formatMessage(constName, args);
        if (this.location != null) {
            fmt = (String)fmt + " " + this.worker.formatMessage("FHIRPATH_LOCATION", this.location);
        }
        if (holder != null) {
            return new PathEngineException((String)fmt, constName, holder.getStart(), holder.toString());
        }
        return new PathEngineException((String)fmt, constName);
    }

    public TypeDetails check(Object appContext, StructureDefinition sd, String context, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types;
        if (!context.contains(".")) {
            types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl());
        } else {
            List<ElementDefinitionMatch> edl = this.getElementDefinition(sd, context, true, expr);
            if (edl.size() == 0) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT_ELEMENT", context);
            }
            if (edl.size() > 1) {
                throw new Error("Unhandled case?");
            }
            ElementDefinitionMatch ed = edl.get(0);
            if (ed.fixedType != null) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, ed.fixedType);
            } else if (ed.getDefinition().getType().isEmpty() || this.isAbstractType(ed.getDefinition().getType())) {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, sd.getUrl() + "#" + context);
            } else {
                types = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                    types.addType(t.getCode());
                }
            }
        }
        return this.executeType(new ExecutionTypeContext(appContext, sd.getUrl(), types, types), types, expr, null, true, false, expr);
    }

    public TypeDetails check(Object appContext, StructureDefinition sd, ExpressionNode expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        TypeDetails types = null;
        return this.executeType(new ExecutionTypeContext(appContext, sd == null ? null : sd.getUrl(), null, types), types, expr, null, true, false, expr);
    }

    public TypeDetails check(Object appContext, String resourceType, String context, String expr) throws FHIRLexer.FHIRLexerException, PathEngineException, DefinitionException {
        return this.check(appContext, resourceType, context, this.parse(expr));
    }

    private Integer compareDateTimeElements(Base theL, Base theR, boolean theEquivalenceTest) {
        DateTimeType right;
        DateTimeType left = theL instanceof DateTimeType ? (DateTimeType)theL : new DateTimeType(theL.primitiveValue());
        DateTimeType dateTimeType = right = theR instanceof DateTimeType ? (DateTimeType)theR : new DateTimeType(theR.primitiveValue());
        if (theEquivalenceTest) {
            return left.equalsUsingFhirPathRules(right) == Boolean.TRUE ? 0 : 1;
        }
        if (left.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            left.setTimeZoneZulu(true);
        }
        if (right.getPrecision().ordinal() > TemporalPrecisionEnum.DAY.ordinal()) {
            right.setTimeZoneZulu(true);
        }
        return BaseDateTimeType.compareTimes(left, right, null);
    }

    private Integer compareTimeElements(Base theL, Base theR, boolean theEquivalenceTest) {
        TimeType right;
        TimeType left = theL instanceof TimeType ? (TimeType)theL : new TimeType(theL.primitiveValue());
        TimeType timeType = right = theR instanceof TimeType ? (TimeType)theR : new TimeType(theR.primitiveValue());
        if (left.getHour() < right.getHour()) {
            return -1;
        }
        if (left.getHour() > right.getHour()) {
            return 1;
        }
        if (left.getMinute() < right.getMinute()) {
            return -1;
        }
        if (left.getMinute() > right.getMinute()) {
            return 1;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MINUTE && right.getPrecision() == TemporalPrecisionEnum.MINUTE) {
            return 0;
        }
        if (left.getPrecision() == TemporalPrecisionEnum.MINUTE || right.getPrecision() == TemporalPrecisionEnum.MINUTE) {
            return null;
        }
        if (left.getSecond() < right.getSecond()) {
            return -1;
        }
        if (left.getSecond() > right.getSecond()) {
            return 1;
        }
        return 0;
    }

    public List<Base> evaluate(Base base, ExpressionNode ExpressionNode2) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new ExecutionContext(null, base != null && base.isResource() ? base : null, base != null && base.isResource() ? base : null, base, base), list, ExpressionNode2, true);
    }

    public List<Base> evaluate(Base base, String path) throws FHIRException {
        ExpressionNode exp = this.parse(path);
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new ExecutionContext(null, base.isResource() ? base : null, base.isResource() ? base : null, base, base), list, exp, true);
    }

    public List<Base> evaluate(Object appContext, Resource focusResource, Resource rootResource, Base base, ExpressionNode ExpressionNode2) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new ExecutionContext(appContext, focusResource, rootResource, base, base), list, ExpressionNode2, true);
    }

    public List<Base> evaluate(Object appContext, Base focusResource, Base rootResource, Base base, ExpressionNode expressionNode) throws FHIRException {
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new ExecutionContext(appContext, focusResource, rootResource, base, base), list, expressionNode, true);
    }

    public List<Base> evaluate(Object appContext, Resource focusResource, Resource rootResource, Base base, String path) throws FHIRException {
        ExpressionNode exp = this.parse(path);
        ArrayList<Base> list = new ArrayList<Base>();
        if (base != null) {
            list.add(base);
        }
        this.log = new StringBuilder();
        return this.execute(new ExecutionContext(appContext, focusResource, rootResource, base, base), list, exp, true);
    }

    public boolean evaluateToBoolean(Resource focusResource, Resource rootResource, Base base, String path) throws FHIRException {
        return this.convertToBoolean(this.evaluate(null, focusResource, rootResource, base, path));
    }

    public boolean evaluateToBoolean(Resource focusResource, Resource rootResource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(null, focusResource, rootResource, base, node));
    }

    public boolean evaluateToBoolean(Object appInfo, Resource focusResource, Resource rootResource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(appInfo, focusResource, rootResource, base, node));
    }

    public boolean evaluateToBoolean(Object appInfo, Base focusResource, Base rootResource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToBoolean(this.evaluate(appInfo, focusResource, rootResource, base, node));
    }

    public String evaluateToString(Base base, String path) throws FHIRException {
        return this.convertToString(this.evaluate(base, path));
    }

    public String evaluateToString(Object appInfo, Base focusResource, Base rootResource, Base base, ExpressionNode node) throws FHIRException {
        return this.convertToString(this.evaluate(appInfo, focusResource, rootResource, base, node));
    }

    public String convertToString(List<Base> items) {
        StringBuilder b = new StringBuilder();
        boolean first = true;
        for (Base item : items) {
            if (first) {
                first = false;
            } else {
                b.append(',');
            }
            b.append(this.convertToString(item));
        }
        return b.toString();
    }

    public String convertToString(Base item) {
        if (item instanceof IIdType) {
            return ((IIdType)item).getIdPart();
        }
        if (item.isPrimitive()) {
            return item.primitiveValue();
        }
        if (item instanceof Quantity) {
            Quantity q = (Quantity)item;
            if (q.hasUnit() && Utilities.existsInList((String)q.getUnit(), (String[])new String[]{"year", "years", "month", "months", "week", "weeks", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds", "millisecond", "milliseconds"}) && (!q.hasSystem() || q.getSystem().equals("http://unitsofmeasure.org"))) {
                return q.getValue().toPlainString() + " " + q.getUnit();
            }
            if (q.getSystem().equals("http://unitsofmeasure.org")) {
                String u = "'" + q.getCode() + "'";
                return q.getValue().toPlainString() + " " + u;
            }
            return item.toString();
        }
        return item.toString();
    }

    public boolean convertToBoolean(List<Base> items) {
        if (items == null) {
            return false;
        }
        if (items.size() == 1 && items.get(0) instanceof BooleanType) {
            return (Boolean)((BooleanType)items.get(0)).getValue();
        }
        if (items.size() == 1 && items.get(0).isBooleanPrimitive()) {
            return Boolean.valueOf(items.get(0).primitiveValue());
        }
        return items.size() > 0;
    }

    private void log(String name, List<Base> contents) {
        if (this.hostServices == null || !this.hostServices.log(name, contents)) {
            if (this.log.length() > 0) {
                this.log.append("; ");
            }
            this.log.append(name);
            this.log.append(": ");
            boolean first = true;
            for (Base b : contents) {
                if (first) {
                    first = false;
                } else {
                    this.log.append(",");
                }
                this.log.append(this.convertToString(b));
            }
        }
    }

    public String forLog() {
        if (this.log.length() > 0) {
            return " (" + this.log.toString() + ")";
        }
        return "";
    }

    private ExpressionNode parseExpression(FHIRLexer lexer, boolean proximal) throws FHIRLexer.FHIRLexerException {
        ExpressionNode result = new ExpressionNode(lexer.nextId());
        ExpressionNode wrapper = null;
        SourceLocation c = lexer.getCurrentStartLocation();
        result.setStart(lexer.getCurrentLocation());
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"-", "+"})) {
            wrapper = new ExpressionNode(lexer.nextId());
            wrapper.setKind(ExpressionNode.Kind.Unary);
            wrapper.setOperation(ExpressionNode.Operation.fromCode(lexer.take()));
            wrapper.setStart(lexer.getCurrentLocation());
            wrapper.setProximal(proximal);
        }
        if (lexer.getCurrent() == null) {
            throw lexer.error("Expression terminated unexpectedly");
        }
        if (lexer.isConstant()) {
            boolean isString = lexer.isStringConstant();
            if (!isString && (lexer.getCurrent().startsWith("-") || lexer.getCurrent().startsWith("+"))) {
                wrapper = new ExpressionNode(lexer.nextId());
                wrapper.setKind(ExpressionNode.Kind.Unary);
                wrapper.setOperation(ExpressionNode.Operation.fromCode(lexer.getCurrent().substring(0, 1)));
                wrapper.setProximal(proximal);
                wrapper.setStart(lexer.getCurrentLocation());
                lexer.setCurrent(lexer.getCurrent().substring(1));
            }
            result.setConstant(this.processConstant(lexer));
            result.setKind(ExpressionNode.Kind.Constant);
            if (!isString && !lexer.done() && (result.getConstant() instanceof IntegerType || result.getConstant() instanceof DecimalType) && (lexer.isStringConstant() || lexer.hasToken("year", "years", "month", "months", "week", "weeks", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds", "millisecond", "milliseconds"))) {
                String ucum = null;
                String unit = null;
                if (lexer.hasToken("year", "years", "month", "months", "week", "weeks", "day", "days", "hour", "hours", "minute", "minutes", "second", "seconds", "millisecond", "milliseconds")) {
                    String s;
                    unit = s = lexer.take();
                    if (!(s.equals("year") || s.equals("years") || s.equals("month") || s.equals("months"))) {
                        ucum = s.equals("week") || s.equals("weeks") ? "wk" : (s.equals("day") || s.equals("days") ? "d" : (s.equals("hour") || s.equals("hours") ? "h" : (s.equals("minute") || s.equals("minutes") ? "min" : (s.equals("second") || s.equals("seconds") ? "s" : "ms"))));
                    }
                } else {
                    ucum = lexer.readConstant("units");
                }
                result.setConstant(new Quantity().setValue(new BigDecimal(result.getConstant().primitiveValue())).setUnit(unit).setSystem(ucum == null ? null : "http://unitsofmeasure.org").setCode(ucum));
            }
            result.setEnd(lexer.getCurrentLocation());
        } else if ("(".equals(lexer.getCurrent())) {
            lexer.next();
            result.setKind(ExpressionNode.Kind.Group);
            result.setGroup(this.parseExpression(lexer, true));
            if (!")".equals(lexer.getCurrent())) {
                throw lexer.error("Found " + lexer.getCurrent() + " expecting a \")\"");
            }
            result.setEnd(lexer.getCurrentLocation());
            lexer.next();
        } else {
            if (!lexer.isToken() && !lexer.getCurrent().startsWith("`")) {
                throw lexer.error("Found " + lexer.getCurrent() + " expecting a token name");
            }
            if (lexer.isFixedName()) {
                result.setName(lexer.readFixedName("Path Name"));
            } else {
                result.setName(lexer.take());
            }
            result.setEnd(lexer.getCurrentLocation());
            if (!result.checkName()) {
                throw lexer.error("Found " + result.getName() + " expecting a valid token name");
            }
            if ("(".equals(lexer.getCurrent())) {
                ExpressionNode.Function f = ExpressionNode.Function.fromCode(result.getName());
                FHIRPathUtilityClasses.FunctionDetails details = null;
                if (f == null) {
                    if (this.hostServices != null) {
                        details = this.hostServices.resolveFunction(this, result.getName());
                    }
                    if (details == null) {
                        throw lexer.error("The name " + result.getName() + " is not a valid function name");
                    }
                    f = ExpressionNode.Function.Custom;
                }
                result.setKind(ExpressionNode.Kind.Function);
                result.setFunction(f);
                lexer.next();
                while (!")".equals(lexer.getCurrent())) {
                    result.getParameters().add(this.parseExpression(lexer, true));
                    if (",".equals(lexer.getCurrent())) {
                        lexer.next();
                        continue;
                    }
                    if (")".equals(lexer.getCurrent())) continue;
                    throw lexer.error("The token " + lexer.getCurrent() + " is not expected here - either a \",\" or a \")\" expected");
                }
                result.setEnd(lexer.getCurrentLocation());
                lexer.next();
                this.checkParameters(lexer, c, result, details);
            } else {
                result.setKind(ExpressionNode.Kind.Name);
            }
        }
        ExpressionNode focus = result;
        if ("[".equals(lexer.getCurrent())) {
            lexer.next();
            ExpressionNode item = new ExpressionNode(lexer.nextId());
            item.setKind(ExpressionNode.Kind.Function);
            item.setFunction(ExpressionNode.Function.Item);
            item.getParameters().add(this.parseExpression(lexer, true));
            if (!lexer.getCurrent().equals("]")) {
                throw lexer.error("The token " + lexer.getCurrent() + " is not expected here - a \"]\" expected");
            }
            lexer.next();
            result.setInner(item);
            focus = item;
        }
        if (".".equals(lexer.getCurrent())) {
            lexer.next();
            focus.setInner(this.parseExpression(lexer, false));
        }
        result.setProximal(proximal);
        if (proximal) {
            while (lexer.isOp()) {
                focus.setOperation(ExpressionNode.Operation.fromCode(lexer.getCurrent()));
                focus.setOpStart(lexer.getCurrentStartLocation());
                focus.setOpEnd(lexer.getCurrentLocation());
                lexer.next();
                focus.setOpNext(this.parseExpression(lexer, false));
                focus = focus.getOpNext();
            }
            result = this.organisePrecedence(lexer, result);
        }
        if (wrapper != null) {
            wrapper.setOpNext(result);
            result.setProximal(false);
            result = wrapper;
        }
        return result;
    }

    private ExpressionNode organisePrecedence(FHIRLexer lexer, ExpressionNode node) {
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Times, ExpressionNode.Operation.DivideBy, ExpressionNode.Operation.Div, ExpressionNode.Operation.Mod));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Plus, ExpressionNode.Operation.Minus, ExpressionNode.Operation.Concatenate));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Union));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.LessThan, ExpressionNode.Operation.Greater, ExpressionNode.Operation.LessOrEqual, ExpressionNode.Operation.GreaterOrEqual));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Is));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Equals, ExpressionNode.Operation.Equivalent, ExpressionNode.Operation.NotEquals, ExpressionNode.Operation.NotEquivalent));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.And));
        node = this.gatherPrecedence(lexer, node, EnumSet.of(ExpressionNode.Operation.Xor, ExpressionNode.Operation.Or));
        return node;
    }

    private ExpressionNode gatherPrecedence(FHIRLexer lexer, ExpressionNode start, EnumSet<ExpressionNode.Operation> ops) {
        ExpressionNode node;
        ExpressionNode group;
        ExpressionNode focus;
        assert (start.isProximal());
        boolean work = false;
        if (ops.contains((Object)start.getOperation())) {
            for (focus = start.getOpNext(); focus != null && focus.getOperation() != null; focus = focus.getOpNext()) {
                work = work || !ops.contains((Object)focus.getOperation());
            }
        } else {
            while (focus != null && focus.getOperation() != null) {
                work = work || ops.contains((Object)focus.getOperation());
                focus = focus.getOpNext();
            }
        }
        if (!work) {
            return start;
        }
        if (ops.contains((Object)start.getOperation())) {
            group = this.newGroup(lexer, start);
            group.setProximal(true);
            focus = start;
            start = group;
        } else {
            node = start;
            focus = node.getOpNext();
            while (!ops.contains((Object)focus.getOperation())) {
                node = focus;
                focus = focus.getOpNext();
            }
            group = this.newGroup(lexer, focus);
            node.setOpNext(group);
        }
        while (true) {
            if (ops.contains((Object)focus.getOperation())) {
                focus = focus.getOpNext();
                continue;
            }
            if (focus.getOperation() != null) {
                group.setOperation(focus.getOperation());
                group.setOpNext(focus.getOpNext());
                focus.setOperation(null);
                focus.setOpNext(null);
                node = group;
                if (focus != null) {
                    for (focus = group.getOpNext(); focus != null && !ops.contains((Object)focus.getOperation()); focus = focus.getOpNext()) {
                        node = focus;
                    }
                    if (focus != null) {
                        group = this.newGroup(lexer, focus);
                        node.setOpNext(group);
                    }
                }
            }
            if (focus == null || focus.getOperation() == null) break;
        }
        return start;
    }

    private ExpressionNode newGroup(FHIRLexer lexer, ExpressionNode next) {
        ExpressionNode result = new ExpressionNode(lexer.nextId());
        result.setKind(ExpressionNode.Kind.Group);
        result.setGroup(next);
        result.getGroup().setProximal(true);
        return result;
    }

    private Base processConstant(FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        if (lexer.isStringConstant()) {
            return new StringType(this.processConstantString(lexer.take(), lexer)).noExtensions();
        }
        if (Utilities.isInteger((String)lexer.getCurrent())) {
            return new IntegerType(lexer.take()).noExtensions();
        }
        if (Utilities.isDecimal((String)lexer.getCurrent(), (boolean)false)) {
            return new DecimalType(lexer.take()).noExtensions();
        }
        if (Utilities.existsInList((String)lexer.getCurrent(), (String[])new String[]{"true", "false"})) {
            return new BooleanType(lexer.take()).noExtensions();
        }
        if (lexer.getCurrent().equals("{}")) {
            lexer.take();
            return null;
        }
        if (lexer.getCurrent().startsWith("%") || lexer.getCurrent().startsWith("@")) {
            return new FHIRPathUtilityClasses.FHIRConstant(lexer.take());
        }
        throw lexer.error("Invalid Constant " + lexer.getCurrent());
    }

    private boolean checkParamCount(FHIRLexer lexer, SourceLocation location, ExpressionNode exp, int count) throws FHIRLexer.FHIRLexerException {
        if (exp.getParameters().size() != count) {
            throw lexer.error("The function \"" + exp.getName() + "\" requires " + Integer.toString(count) + " parameters", location.toString(), location);
        }
        return true;
    }

    private boolean checkParamCount(FHIRLexer lexer, SourceLocation location, ExpressionNode exp, int countMin, int countMax) throws FHIRLexer.FHIRLexerException {
        if (exp.getParameters().size() < countMin || exp.getParameters().size() > countMax) {
            throw lexer.error("The function \"" + exp.getName() + "\" requires between " + Integer.toString(countMin) + " and " + Integer.toString(countMax) + " parameters", location.toString(), location);
        }
        return true;
    }

    private boolean checkParameters(FHIRLexer lexer, SourceLocation location, ExpressionNode exp, FHIRPathUtilityClasses.FunctionDetails details) throws FHIRLexer.FHIRLexerException {
        switch (exp.getFunction()) {
            case Empty: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Not: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Exists: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case SubsetOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case SupersetOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case IsDistinct: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Distinct: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Count: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Where: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Select: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case All: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case Repeat: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Aggregate: {
                return this.checkParamCount(lexer, location, exp, 1, 2);
            }
            case Item: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case As: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case OfType: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Type: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Is: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Single: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case First: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Last: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Tail: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Skip: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Take: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Union: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Combine: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Intersect: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Exclude: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Iif: {
                return this.checkParamCount(lexer, location, exp, 2, 3);
            }
            case Lower: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Upper: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToChars: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case IndexOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Substring: {
                return this.checkParamCount(lexer, location, exp, 1, 2);
            }
            case StartsWith: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case EndsWith: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Matches: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case MatchesFull: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case ReplaceMatches: {
                return this.checkParamCount(lexer, location, exp, 2);
            }
            case Contains: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Replace: {
                return this.checkParamCount(lexer, location, exp, 2);
            }
            case Length: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Children: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Descendants: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case MemberOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Trace: {
                return this.checkParamCount(lexer, location, exp, 1, 2);
            }
            case DefineVariable: {
                return this.checkParamCount(lexer, location, exp, 1, 2);
            }
            case Check: {
                return this.checkParamCount(lexer, location, exp, 2);
            }
            case Today: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Now: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Resolve: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Extension: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case AllFalse: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case AnyFalse: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case AllTrue: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case AnyTrue: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case HasValue: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Encode: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Decode: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Escape: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Unescape: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Trim: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Split: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Join: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case HtmlChecks1: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case HtmlChecks2: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Comparable: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case ToInteger: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToDecimal: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToString: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToQuantity: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToBoolean: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToDateTime: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ToTime: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToInteger: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToDecimal: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToString: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToQuantity: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToBoolean: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToDateTime: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToDate: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConvertsToTime: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case ConformsTo: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Round: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case Sqrt: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Abs: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Ceiling: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Exp: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Floor: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Ln: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case Log: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Power: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Truncate: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case LowBoundary: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case HighBoundary: {
                return this.checkParamCount(lexer, location, exp, 0, 1);
            }
            case Precision: {
                return this.checkParamCount(lexer, location, exp, 0);
            }
            case hasTemplateIdOf: {
                return this.checkParamCount(lexer, location, exp, 1);
            }
            case Custom: {
                return this.checkParamCount(lexer, location, exp, details.getMinParameters(), details.getMaxParameters());
            }
        }
        return false;
    }

    private List<Base> execute(ExecutionContext inContext, List<Base> focus, ExpressionNode exp, boolean atEntry) throws FHIRException {
        ExecutionContext context = this.contextForParameter(inContext);
        List<Base> work = new ArrayList<Base>();
        switch (exp.getKind()) {
            case Unary: {
                work.add(new IntegerType(0));
                break;
            }
            case Name: {
                if (atEntry && exp.getName().equals("$this")) {
                    work.add(context.getThisItem());
                    break;
                }
                if (atEntry && exp.getName().equals("$total")) {
                    work.addAll(context.getTotal());
                    break;
                }
                if (atEntry && exp.getName().equals("$index")) {
                    work.add(context.getIndex());
                    break;
                }
                for (Base item : focus) {
                    List<Base> outcome = this.execute(context, item, exp, atEntry);
                    for (Base base : outcome) {
                        if (base == null) continue;
                        work.add(base);
                    }
                }
                break;
            }
            case Function: {
                List<Base> work2 = this.evaluateFunction(context, focus, exp);
                work.addAll(work2);
                break;
            }
            case Constant: {
                work.addAll(this.resolveConstant(context, exp.getConstant(), false, exp));
                break;
            }
            case Group: {
                List<Base> work2 = this.execute(context, focus, exp.getGroup(), atEntry);
                work.addAll(work2);
            }
        }
        if (exp.getInner() != null) {
            work = this.execute(context, work, exp.getInner(), false);
        }
        if (exp.isProximal() && exp.getOperation() != null) {
            ExpressionNode last = exp;
            for (ExpressionNode next = exp.getOpNext(); next != null; next = next.getOpNext()) {
                context = this.contextForParameter(inContext);
                List<Base> work2 = this.preOperate(work, last.getOperation(), exp);
                if (work2 != null) {
                    work = work2;
                } else if (last.getOperation() == ExpressionNode.Operation.Is || last.getOperation() == ExpressionNode.Operation.As) {
                    work2 = this.executeTypeName(context, focus, next, false);
                    work = this.operate(context, work, last.getOperation(), work2, last);
                } else {
                    work2 = this.execute(context, focus, next, true);
                    work = this.operate(context, work, last.getOperation(), work2, last);
                }
                last = next;
            }
        }
        return work;
    }

    private List<Base> executeTypeName(ExecutionContext context, List<Base> focus, ExpressionNode next, boolean atEntry) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (next.getInner() != null) {
            result.add(new StringType(next.getName() + "." + next.getInner().getName()));
        } else {
            result.add(new StringType(next.getName()));
        }
        return result;
    }

    private List<Base> preOperate(List<Base> left, ExpressionNode.Operation operation, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0) {
            return null;
        }
        switch (operation) {
            case And: {
                return this.isBoolean(left, false) ? this.makeBoolean(false) : null;
            }
            case Or: {
                return this.isBoolean(left, true) ? this.makeBoolean(true) : null;
            }
            case Implies: {
                Equality v = this.asBool(left, expr);
                return v == Equality.False ? this.makeBoolean(true) : null;
            }
        }
        return null;
    }

    private List<Base> makeBoolean(boolean b) {
        ArrayList<Base> res = new ArrayList<Base>();
        res.add(new BooleanType(b).noExtensions());
        return res;
    }

    private List<Base> makeNull() {
        ArrayList<Base> res = new ArrayList<Base>();
        return res;
    }

    private TypeDetails executeTypeName(ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp, boolean atEntry) throws PathEngineException, DefinitionException {
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, exp.getName());
    }

    private TypeDetails executeType(ExecutionTypeContext inContext, TypeDetails focus, ExpressionNode exp, Set<ElementDefinition> elementDependencies, boolean atEntry, boolean canBeNone, ExpressionNode container) throws PathEngineException, DefinitionException {
        ExecutionTypeContext context = this.contextForParameter(inContext);
        TypeDetails result = new TypeDetails(null, new String[0]);
        switch (exp.getKind()) {
            case Name: {
                if (atEntry && exp.getName().equals("$this")) {
                    result.update(context.getThisItem());
                } else if (atEntry && exp.getName().equals("$total")) {
                    result.update(this.anything(ExpressionNode.CollectionStatus.UNORDERED));
                } else if (atEntry && exp.getName().equals("$index")) {
                    result.addType("http://hl7.org/fhirpath/System.Integer");
                } else if (atEntry && focus == null) {
                    result.update(this.executeContextType(context, exp.getName(), exp, false));
                } else {
                    for (String s : focus.getTypes()) {
                        result.update(this.executeType(s, exp, atEntry, focus, elementDependencies));
                    }
                    if (result.hasNoTypes() && !canBeNone) {
                        throw this.makeException(exp, "FHIRPATH_UNKNOWN_NAME", exp.getName(), focus.describe());
                    }
                }
                this.doSQLOnFHIRCheck(result, exp);
                break;
            }
            case Function: {
                result.update(this.evaluateFunctionType(context, focus, exp, elementDependencies, container));
                break;
            }
            case Unary: {
                result.addType("http://hl7.org/fhirpath/System.Integer");
                result.addType("http://hl7.org/fhirpath/System.Decimal");
                result.addType("http://hl7.org/fhirpath/System.Quantity");
                break;
            }
            case Constant: {
                result.update(this.resolveConstantType(context, exp.getConstant(), exp, true));
                break;
            }
            case Group: {
                result.update(this.executeType(context, focus, exp.getGroup(), elementDependencies, atEntry, canBeNone, exp));
            }
        }
        exp.setTypes(result);
        if (exp.getInner() != null) {
            result = this.executeType(context, result, exp.getInner(), elementDependencies, false, false, exp);
        }
        if (exp.isProximal() && exp.getOperation() != null) {
            ExpressionNode last = exp;
            for (ExpressionNode next = exp.getOpNext(); next != null; next = next.getOpNext()) {
                context = this.contextForParameter(inContext);
                TypeDetails work = last.getOperation() == ExpressionNode.Operation.Is || last.getOperation() == ExpressionNode.Operation.As ? this.executeTypeName(context, focus, next, atEntry) : this.executeType(context, focus, next, elementDependencies, atEntry, canBeNone, exp);
                result = this.operateTypes(result, last.getOperation(), work, last);
                last = next;
            }
            exp.setOpTypes(result);
        }
        return result;
    }

    private void doSQLOnFHIRCheck(TypeDetails focus, ExpressionNode expr) {
        if (this.emitSQLonFHIRWarning) {
            if (focus.isChoice()) {
                if (expr.getInner() == null || expr.getInner().getFunction() != ExpressionNode.Function.OfType) {
                    this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_CHOICE_NO_TYPE_SPECIFIER", expr.toString()), "FHIRPATH_CHOICE_NO_TYPE_SPECIFIER"));
                }
            } else if (expr.getInner() != null && expr.getInner().getFunction() == ExpressionNode.Function.OfType) {
                this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_CHOICE_SPURIOUS_TYPE_SPECIFIER", expr.toString()), "FHIRPATH_CHOICE_SPURIOUS_TYPE_SPECIFIER"));
            }
        }
    }

    private List<Base> resolveConstant(ExecutionContext context, Base constant, boolean beforeContext, ExpressionNode expr) throws PathEngineException {
        if (constant == null) {
            return new ArrayList<Base>();
        }
        if (!(constant instanceof FHIRPathUtilityClasses.FHIRConstant)) {
            return new ArrayList<Base>(Arrays.asList(constant));
        }
        FHIRPathUtilityClasses.FHIRConstant c = (FHIRPathUtilityClasses.FHIRConstant)constant;
        if (c.getValue().startsWith("%")) {
            String varName = c.getValue().substring(1);
            if (context.hasDefinedVariable(varName)) {
                return context.getDefinedVariable(varName);
            }
            return this.resolveConstant(context, c.getValue(), beforeContext, expr, true);
        }
        if (c.getValue().startsWith("@")) {
            return new ArrayList<Base>(Arrays.asList(this.processDateConstant(context.appInfo, c.getValue().substring(1), expr)));
        }
        throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONSTANT", c.getValue());
    }

    private Base processDateConstant(Object appInfo, String value, ExpressionNode expr) throws PathEngineException {
        String date = null;
        Object time = null;
        String tz = null;
        TemporalPrecisionEnum temp = null;
        if (value.startsWith("T")) {
            time = value.substring(1);
        } else if (!value.contains("T")) {
            date = value;
        } else {
            String[] p = value.split("T");
            date = p[0];
            if (p.length > 1) {
                time = p[1];
            }
        }
        if (time != null) {
            int i = ((String)time).indexOf("-");
            if (i == -1) {
                i = ((String)time).indexOf("+");
            }
            if (i == -1) {
                i = ((String)time).indexOf("Z");
            }
            if (i > -1) {
                tz = ((String)time).substring(i);
                time = ((String)time).substring(0, i);
            }
            if (((String)time).length() == 2) {
                time = (String)time + ":00:00";
                temp = TemporalPrecisionEnum.MINUTE;
            } else if (((String)time).length() == 5) {
                temp = TemporalPrecisionEnum.MINUTE;
                time = (String)time + ":00";
            } else {
                temp = ((String)time).contains(".") ? TemporalPrecisionEnum.MILLI : TemporalPrecisionEnum.SECOND;
            }
        }
        if (date == null) {
            if (tz != null) {
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONTEXT", value);
            }
            TimeType tt = new TimeType((String)time);
            tt.setPrecision(temp);
            return tt.noExtensions();
        }
        if (time != null) {
            DateTimeType dt = new DateTimeType(date + "T" + (String)time + (tz == null ? "" : tz));
            dt.setPrecision(temp);
            return dt.noExtensions();
        }
        return new DateType(date).noExtensions();
    }

    static boolean isSystemVariable(String name) {
        if (name.equals("sct")) {
            return true;
        }
        if (name.equals("loinc")) {
            return true;
        }
        if (name.equals("ucum")) {
            return true;
        }
        if (name.equals("resource")) {
            return true;
        }
        if (name.equals("rootResource")) {
            return true;
        }
        return name.equals("context");
    }

    private List<Base> resolveConstant(ExecutionContext context, String s, boolean beforeContext, ExpressionNode expr, boolean explicitConstant) throws PathEngineException {
        if (s.equals("%sct")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://snomed.info/sct").noExtensions()));
        }
        if (s.equals("%loinc")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://loinc.org").noExtensions()));
        }
        if (s.equals("%ucum")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://unitsofmeasure.org").noExtensions()));
        }
        if (s.equals("%resource")) {
            if (context.focusResource == null) {
                throw this.makeException(expr, "FHIRPATH_CANNOT_USE", "%resource", "no focus resource");
            }
            return new ArrayList<Base>(Arrays.asList(context.focusResource));
        }
        if (s.equals("%rootResource")) {
            if (context.rootResource == null) {
                throw this.makeException(expr, "FHIRPATH_CANNOT_USE", "%rootResource", "no focus rootResource");
            }
            return new ArrayList<Base>(Arrays.asList(context.rootResource));
        }
        if (s.equals("%context")) {
            return new ArrayList<Base>(Arrays.asList(context.context));
        }
        if (s.equals("%us-zip")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("[0-9]{5}(-[0-9]{4}){0,1}").noExtensions()));
        }
        if (s.startsWith("%`vs-")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://hl7.org/fhir/ValueSet/" + s.substring(5, s.length() - 1)).noExtensions()));
        }
        if (s.startsWith("%`cs-")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://hl7.org/fhir/" + s.substring(5, s.length() - 1)).noExtensions()));
        }
        if (s.startsWith("%`ext-")) {
            return new ArrayList<Base>(Arrays.asList(new StringType("http://hl7.org/fhir/StructureDefinition/" + s.substring(6, s.length() - 1)).noExtensions()));
        }
        if (this.hostServices == null) {
            throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONSTANT", s);
        }
        return this.hostServices.resolveConstant(this, context.appInfo, s.substring(1), beforeContext, explicitConstant);
    }

    private String processConstantString(String s, FHIRLexer lexer) throws FHIRLexer.FHIRLexerException {
        StringBuilder b = new StringBuilder();
        int i = 1;
        while (i < s.length() - 1) {
            char ch = s.charAt(i);
            if (ch == '\\') {
                switch (s.charAt(++i)) {
                    case 't': {
                        b.append('\t');
                        break;
                    }
                    case 'r': {
                        b.append('\r');
                        break;
                    }
                    case 'n': {
                        b.append('\n');
                        break;
                    }
                    case 'f': {
                        b.append('\f');
                        break;
                    }
                    case '\'': {
                        b.append('\'');
                        break;
                    }
                    case '\"': {
                        b.append('\"');
                        break;
                    }
                    case '`': {
                        b.append('`');
                        break;
                    }
                    case '\\': {
                        b.append('\\');
                        break;
                    }
                    case '/': {
                        b.append('/');
                        break;
                    }
                    case 'u': {
                        int uc = Integer.parseInt(s.substring(++i, i + 4), 16);
                        b.append(Character.toString(uc));
                        i += 3;
                        break;
                    }
                    default: {
                        throw lexer.error("Unknown FHIRPath character escape \\" + s.charAt(i));
                    }
                }
                ++i;
                continue;
            }
            b.append(ch);
            ++i;
        }
        return b.toString();
    }

    private List<Base> operate(ExecutionContext context, List<Base> left, ExpressionNode.Operation operation, List<Base> right, ExpressionNode holder) throws FHIRException {
        switch (operation) {
            case Equals: {
                return this.opEquals(left, right, holder);
            }
            case Equivalent: {
                return this.opEquivalent(left, right, holder);
            }
            case NotEquals: {
                return this.opNotEquals(left, right, holder);
            }
            case NotEquivalent: {
                return this.opNotEquivalent(left, right, holder);
            }
            case LessThan: {
                return this.opLessThan(left, right, holder);
            }
            case Greater: {
                return this.opGreater(left, right, holder);
            }
            case LessOrEqual: {
                return this.opLessOrEqual(left, right, holder);
            }
            case GreaterOrEqual: {
                return this.opGreaterOrEqual(left, right, holder);
            }
            case Union: {
                return this.opUnion(left, right, holder);
            }
            case In: {
                return this.opIn(left, right, holder);
            }
            case MemberOf: {
                return this.opMemberOf(context, left, right, holder);
            }
            case Contains: {
                return this.opContains(left, right, holder);
            }
            case Or: {
                return this.opOr(left, right, holder);
            }
            case And: {
                return this.opAnd(left, right, holder);
            }
            case Xor: {
                return this.opXor(left, right, holder);
            }
            case Implies: {
                return this.opImplies(left, right, holder);
            }
            case Plus: {
                return this.opPlus(left, right, holder);
            }
            case Times: {
                return this.opTimes(left, right, holder);
            }
            case Minus: {
                return this.opMinus(left, right, holder);
            }
            case Concatenate: {
                return this.opConcatenate(left, right, holder);
            }
            case DivideBy: {
                return this.opDivideBy(left, right, holder);
            }
            case Div: {
                return this.opDiv(left, right, holder);
            }
            case Mod: {
                return this.opMod(left, right, holder);
            }
            case Is: {
                return this.opIs(left, right, holder);
            }
            case As: {
                return this.opAs(left, right, holder);
            }
        }
        throw new Error("Not Done Yet: " + operation.toCode());
    }

    private List<Base> opAs(List<Base> left, List<Base> right, ExpressionNode expr) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (right.size() != 1) {
            return result;
        }
        String tn = this.convertToString(right);
        if (!this.isKnownType(tn)) {
            throw new PathEngineException(this.worker.formatMessage("FHIRPATH_INVALID_TYPE", tn), "FHIRPATH_INVALID_TYPE");
        }
        if (!this.doNotEnforceAsSingletonRule && left.size() > 1) {
            throw new PathEngineException(this.worker.formatMessage("FHIRPATH_AS_COLLECTION", left.size(), expr.toString()), "FHIRPATH_AS_COLLECTION");
        }
        for (Base nextLeft : left) {
            if (!this.compareTypeNames(tn, nextLeft.fhirType())) continue;
            result.add(nextLeft);
        }
        return result;
    }

    private boolean compareTypeNames(String left, String right) {
        if (this.doNotEnforceAsCaseSensitive) {
            return left.equalsIgnoreCase(right);
        }
        return left.equals(right);
    }

    private boolean isKnownType(String tn) {
        if (!tn.contains(".")) {
            if (Utilities.existsInList((String)tn, (String[])new String[]{"String", "Boolean", "Integer", "Decimal", "Quantity", "DateTime", "Time", "SimpleTypeInfo", "ClassInfo"})) {
                return true;
            }
            try {
                return this.worker.fetchTypeDefinition(tn) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        String[] t = tn.split("\\.");
        if (t.length != 2) {
            return false;
        }
        if ("System".equals(t[0])) {
            return Utilities.existsInList((String)t[1], (String[])new String[]{"String", "Boolean", "Integer", "Decimal", "Quantity", "DateTime", "Time", "SimpleTypeInfo", "ClassInfo"});
        }
        if ("FHIR".equals(t[0])) {
            try {
                return this.worker.fetchTypeDefinition(t[1]) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        if ("CDA".equals(t[0])) {
            try {
                return this.worker.fetchTypeDefinition(Utilities.pathURL((String[])new String[]{"http://hl7.org/cda/stds/core", "StructureDefinition", t[1]})) != null;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private List<Base> opIs(List<Base> left, List<Base> right, ExpressionNode expr) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (left.size() != 0 && right.size() != 0) {
            if (left.size() != 1 || right.size() != 1) {
                result.add(new BooleanType(false).noExtensions());
            } else {
                String tn = this.convertToString(right);
                if (left.get(0) instanceof org.hl7.fhir.r5.elementmodel.Element) {
                    result.add(new BooleanType(left.get(0).hasType(tn)).noExtensions());
                } else if (left.get(0) instanceof Element && ((Element)left.get(0)).isDisallowExtensions()) {
                    result.add(new BooleanType(Utilities.capitalize((String)left.get(0).fhirType()).equals(tn) || ("System." + Utilities.capitalize((String)left.get(0).fhirType())).equals(tn)).noExtensions());
                } else if (left.get(0).fhirType().equals(tn)) {
                    result.add(new BooleanType(true).noExtensions());
                } else {
                    StructureDefinition sd = this.worker.fetchTypeDefinition(left.get(0).fhirType());
                    while (sd != null) {
                        if (tn.equals(sd.getType())) {
                            return this.makeBoolean(true);
                        }
                        sd = this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
                    }
                    return this.makeBoolean(false);
                }
            }
        }
        return result;
    }

    private void checkCardinalityForComparabilitySame(TypeDetails left, ExpressionNode.Operation operation, TypeDetails right, ExpressionNode expr) {
        if (left.isList() && !right.isList()) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_OPERATION_LEFT", expr.toString()), "FHIRPATH_COLLECTION_STATUS_OPERATION_LEFT"));
        } else if (!left.isList() && right.isList()) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_OPERATION_RIGHT", expr.toString()), "FHIRPATH_COLLECTION_STATUS_OPERATION_RIGHT"));
        }
    }

    private void checkCardinalityForSingle(TypeDetails left, ExpressionNode.Operation operation, TypeDetails right, ExpressionNode expr) {
        if (left.isList()) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_OPERATION_LEFT", expr.toString()), "FHIRPATH_COLLECTION_STATUS_OPERATION_LEFT"));
        }
        if (right.isList()) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_OPERATION_RIGHT", expr.toString()), "FHIRPATH_COLLECTION_STATUS_OPERATION_RIGHT"));
        }
    }

    private TypeDetails operateTypes(TypeDetails left, ExpressionNode.Operation operation, TypeDetails right, ExpressionNode expr) {
        switch (operation) {
            case Equals: {
                this.checkCardinalityForComparabilitySame(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Equivalent: {
                this.checkCardinalityForComparabilitySame(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case NotEquals: {
                this.checkCardinalityForComparabilitySame(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case NotEquivalent: {
                this.checkCardinalityForComparabilitySame(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case LessThan: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Greater: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case LessOrEqual: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case GreaterOrEqual: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Is: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case As: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails td = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, right.getTypes());
                if (td.typesHaveTargets()) {
                    td.addTargets(left.getTargets());
                }
                return td;
            }
            case Union: {
                return left.union(right);
            }
            case Or: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case And: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Xor: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Implies: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Times: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("http://hl7.org/fhirpath/System.Integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                }
                return result;
            }
            case DivideBy: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                }
                return result;
            }
            case Concatenate: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
                return result;
            }
            case Plus: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("http://hl7.org/fhirpath/System.Integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                } else if (left.hasType(this.worker, "string", "id", "code", "uri") && right.hasType(this.worker, "string", "id", "code", "uri")) {
                    result.addType("http://hl7.org/fhirpath/System.String");
                } else if (left.hasType(this.worker, "date", "dateTime", "instant")) {
                    if (right.hasType(this.worker, "Quantity")) {
                        result.addType(left.getType());
                    } else {
                        throw new PathEngineException(this.worker.formatMessage("FHIRPATH_ARITHMETIC_PLUS", right.getType(), left.getType()), "FHIRPATH_ARITHMETIC_PLUS", expr.getOpStart(), expr.toString());
                    }
                }
                return result;
            }
            case Minus: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("http://hl7.org/fhirpath/System.Integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                } else if (left.hasType(this.worker, "Quantity") && right.hasType(this.worker, "Quantity")) {
                    result.addType("http://hl7.org/fhirpath/System.Quantity");
                } else if (left.hasType(this.worker, "date", "dateTime", "instant")) {
                    if (right.hasType(this.worker, "Quantity")) {
                        result.addType(left.getType());
                    } else {
                        throw new PathEngineException(this.worker.formatMessage("FHIRPATH_ARITHMETIC_MINUS", right.getType(), left.getType()), "FHIRPATH_ARITHMETIC_MINUS", expr.getOpStart(), expr.toString());
                    }
                }
                return result;
            }
            case Div: 
            case Mod: {
                this.checkCardinalityForSingle(left, operation, right, expr);
                TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
                if (left.hasType(this.worker, "integer") && right.hasType(this.worker, "integer")) {
                    result.addType("http://hl7.org/fhirpath/System.Integer");
                } else if (left.hasType(this.worker, "integer", "decimal") && right.hasType(this.worker, "integer", "decimal")) {
                    result.addType("http://hl7.org/fhirpath/System.Decimal");
                }
                return result;
            }
            case In: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case MemberOf: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Contains: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
        }
        return null;
    }

    private List<Base> opEquals(List<Base> left, List<Base> right, ExpressionNode expr) {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() != right.size()) {
            return this.makeBoolean(false);
        }
        boolean res = true;
        boolean nil = false;
        for (int i = 0; i < left.size(); ++i) {
            Boolean eq = this.doEquals(left.get(i), right.get(i));
            if (eq == null) {
                nil = true;
                continue;
            }
            if (eq.booleanValue()) continue;
            res = false;
            break;
        }
        if (!res) {
            return this.makeBoolean(res);
        }
        if (nil) {
            return new ArrayList<Base>();
        }
        return this.makeBoolean(res);
    }

    private List<Base> opNotEquals(List<Base> left, List<Base> right, ExpressionNode expr) {
        if (!(this.legacyMode || left.size() != 0 && right.size() != 0)) {
            return new ArrayList<Base>();
        }
        if (left.size() != right.size()) {
            return this.makeBoolean(true);
        }
        boolean res = true;
        boolean nil = false;
        for (int i = 0; i < left.size(); ++i) {
            Boolean eq = this.doEquals(left.get(i), right.get(i));
            if (eq == null) {
                nil = true;
                continue;
            }
            if (!eq.booleanValue()) continue;
            res = false;
            break;
        }
        if (!res) {
            return this.makeBoolean(res);
        }
        if (nil) {
            return new ArrayList<Base>();
        }
        return this.makeBoolean(res);
    }

    private String removeTrailingZeros(String s) {
        if (Utilities.noString((String)s)) {
            return "";
        }
        int i = s.length() - 1;
        boolean done = false;
        boolean dot = false;
        while (i > 0 && !done) {
            if (s.charAt(i) == '.') {
                --i;
                dot = true;
                continue;
            }
            if (!dot && s.charAt(i) == '0') {
                --i;
                continue;
            }
            done = true;
        }
        return s.substring(0, i + 1);
    }

    private boolean decEqual(String left, String right) {
        left = this.removeTrailingZeros(left);
        right = this.removeTrailingZeros(right);
        return left.equals(right);
    }

    private Boolean datesEqual(BaseDateTimeType left, BaseDateTimeType right) {
        return left.equalsUsingFhirPathRules(right);
    }

    private Boolean doEquals(Base left, Base right) {
        if (left instanceof Quantity && right instanceof Quantity) {
            return this.qtyEqual((Quantity)left, (Quantity)right);
        }
        if (left.isDateTime() && right.isDateTime()) {
            return this.datesEqual(left.dateTimeValue(), right.dateTimeValue());
        }
        if (left instanceof DecimalType || right instanceof DecimalType) {
            return this.decEqual(left.primitiveValue(), right.primitiveValue());
        }
        if (left.isPrimitive() && right.isPrimitive()) {
            return Base.equals(left.primitiveValue(), right.primitiveValue());
        }
        return Base.compareDeep(left, right, false);
    }

    private boolean doEquivalent(Base left, Base right) throws PathEngineException {
        if (left instanceof Quantity && right instanceof Quantity) {
            return this.qtyEquivalent((Quantity)left, (Quantity)right);
        }
        if (left.hasType("integer") && right.hasType("integer")) {
            return this.doEquals(left, right);
        }
        if (left.hasType("boolean") && right.hasType("boolean")) {
            return this.doEquals(left, right);
        }
        if (left.hasType("integer", "decimal", "unsignedInt", "positiveInt") && right.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            return Utilities.equivalentNumber((String)left.primitiveValue(), (String)right.primitiveValue());
        }
        if (left.hasType("date", "dateTime", "time", "instant") && right.hasType("date", "dateTime", "time", "instant")) {
            Integer i = this.compareDateTimeElements(left, right, true);
            if (i == null) {
                i = 0;
            }
            return i == 0;
        }
        if (left.hasType(FHIR_TYPES_STRING) && right.hasType(FHIR_TYPES_STRING)) {
            return Utilities.equivalent((String)this.convertToString(left), (String)this.convertToString(right));
        }
        if (left.isPrimitive() && right.isPrimitive()) {
            return Utilities.equivalent((String)left.primitiveValue(), (String)right.primitiveValue());
        }
        if (!left.isPrimitive() && !right.isPrimitive()) {
            MergedList props = new MergedList(left.children(), right.children(), (MergedList.IMatcher)new Property.PropertyMatcher());
            for (MergedList.MergeNode t : props) {
                if (t.hasLeft() && t.hasRight()) {
                    if (((Property)t.getLeft()).hasValues() && ((Property)t.getRight()).hasValues()) {
                        MergedList values = new MergedList(((Property)t.getLeft()).getValues(), ((Property)t.getRight()).getValues());
                        for (MergedList.MergeNode v : values) {
                            if (!(v.hasLeft() && v.hasRight() ? !this.doEquivalent((Base)v.getLeft(), (Base)v.getRight()) : v.hasLeft() || v.hasRight())) continue;
                            return false;
                        }
                        continue;
                    }
                    if (!((Property)t.getLeft()).hasValues() && !((Property)t.getRight()).hasValues()) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    private Boolean qtyEqual(Quantity left, Quantity right) {
        if (!left.hasValue() && !right.hasValue()) {
            return true;
        }
        if (!left.hasValue() || !right.hasValue()) {
            return null;
        }
        if (this.worker.getUcumService() != null) {
            Pair dl = this.qtyToCanonicalPair(left);
            Pair dr = this.qtyToCanonicalPair(right);
            if (dl != null && dr != null) {
                if (dl.getCode().equals(dr.getCode())) {
                    return this.doEquals(new DecimalType(dl.getValue().asDecimal()), new DecimalType(dr.getValue().asDecimal()));
                }
                return false;
            }
        }
        if (left.hasCode() || right.hasCode() ? !left.hasCode() || !right.hasCode() || !left.getCode().equals(right.getCode()) : !(left.hasUnit() && !right.hasUnit() || left.hasUnit() && right.hasUnit() && left.getUnit().equals(right.getUnit()))) {
            return null;
        }
        return this.doEquals(new DecimalType(left.getValue()), new DecimalType(right.getValue()));
    }

    private Pair qtyToCanonicalPair(Quantity q) {
        if (!"http://unitsofmeasure.org".equals(q.getSystem())) {
            return null;
        }
        try {
            Pair p = new Pair(new Decimal(q.getValue().toPlainString()), q.getCode() == null ? "1" : q.getCode());
            Pair c = this.worker.getUcumService().getCanonicalForm(p);
            return c;
        }
        catch (UcumException e) {
            return null;
        }
    }

    private DecimalType qtyToCanonicalDecimal(Quantity q) {
        if (!"http://unitsofmeasure.org".equals(q.getSystem())) {
            return null;
        }
        try {
            Pair p = new Pair(new Decimal(q.getValue().toPlainString()), q.getCode() == null ? "1" : q.getCode());
            Pair c = this.worker.getUcumService().getCanonicalForm(p);
            return new DecimalType(c.getValue().asDecimal());
        }
        catch (UcumException e) {
            return null;
        }
    }

    private Base pairToQty(Pair p) {
        return new Quantity().setValue(new BigDecimal(p.getValue().toString())).setSystem("http://unitsofmeasure.org").setCode(p.getCode()).noExtensions();
    }

    private Pair qtyToPair(Quantity q) {
        if (!"http://unitsofmeasure.org".equals(q.getSystem())) {
            return null;
        }
        try {
            return new Pair(new Decimal(q.getValue().toPlainString()), q.getCode());
        }
        catch (UcumException e) {
            return null;
        }
    }

    private Boolean qtyEquivalent(Quantity left, Quantity right) throws PathEngineException {
        if (!left.hasValue() && !right.hasValue()) {
            return true;
        }
        if (!left.hasValue() || !right.hasValue()) {
            return null;
        }
        if (this.worker.getUcumService() != null) {
            Pair dl = this.qtyToCanonicalPair(left);
            Pair dr = this.qtyToCanonicalPair(right);
            if (dl != null && dr != null) {
                if (dl.getCode().equals(dr.getCode())) {
                    return this.doEquivalent(new DecimalType(dl.getValue().asDecimal()), new DecimalType(dr.getValue().asDecimal()));
                }
                return false;
            }
        }
        if (left.hasCode() || right.hasCode() ? !left.hasCode() || !right.hasCode() || !left.getCode().equals(right.getCode()) : !(left.hasUnit() && !right.hasUnit() || left.hasUnit() && right.hasUnit() && left.getUnit().equals(right.getUnit()))) {
            return null;
        }
        return this.doEquivalent(new DecimalType(left.getValue()), new DecimalType(right.getValue()));
    }

    private List<Base> opEquivalent(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() != right.size()) {
            return this.makeBoolean(false);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < right.size(); ++j) {
                if (!this.doEquivalent(left.get(i), right.get(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            res = false;
            break;
        }
        return this.makeBoolean(res);
    }

    private List<Base> opNotEquivalent(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() != right.size()) {
            return this.makeBoolean(true);
        }
        boolean res = true;
        for (int i = 0; i < left.size(); ++i) {
            boolean found = false;
            for (int j = 0; j < right.size(); ++j) {
                if (!this.doEquivalent(left.get(i), right.get(j))) continue;
                found = true;
                break;
            }
            if (found) continue;
            res = false;
            break;
        }
        return this.makeBoolean(!res);
    }

    private List<Base> opLessThan(List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType(FHIR_TYPES_STRING) && r.hasType(FHIR_TYPES_STRING)) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) < 0);
            }
            if ((l.hasType("integer") || l.hasType("decimal")) && (r.hasType("integer") || r.hasType("decimal"))) {
                return this.makeBoolean(new Double(l.primitiveValue()) < new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                Integer i = this.compareDateTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i < 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                Integer i = this.compareTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i < 0);
            }
            throw this.makeException(expr, "FHIRPATH_CANT_COMPARE", l.fhirType(), r.fhirType());
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("code");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("code"), true)) {
                return this.opLessThan(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"), expr);
            }
            if (this.worker.getUcumService() == null) {
                return this.makeBoolean(false);
            }
            ArrayList<Base> dl = new ArrayList<Base>();
            dl.add(this.qtyToCanonicalDecimal((Quantity)left.get(0)));
            ArrayList<Base> dr = new ArrayList<Base>();
            dr.add(this.qtyToCanonicalDecimal((Quantity)right.get(0)));
            return this.opLessThan(dl, dr, expr);
        }
        return new ArrayList<Base>();
    }

    private List<Base> opGreater(List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType(FHIR_TYPES_STRING) && r.hasType(FHIR_TYPES_STRING)) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) > 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) > new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                Integer i = this.compareDateTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i > 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                Integer i = this.compareTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i > 0);
            }
            throw this.makeException(expr, "FHIRPATH_CANT_COMPARE", l.fhirType(), r.fhirType());
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("unit");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("unit"), true)) {
                return this.opGreater(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"), expr);
            }
            if (this.worker.getUcumService() == null) {
                return this.makeBoolean(false);
            }
            ArrayList<Base> dl = new ArrayList<Base>();
            dl.add(this.qtyToCanonicalDecimal((Quantity)left.get(0)));
            ArrayList<Base> dr = new ArrayList<Base>();
            dr.add(this.qtyToCanonicalDecimal((Quantity)right.get(0)));
            return this.opGreater(dl, dr, expr);
        }
        return new ArrayList<Base>();
    }

    private List<Base> opLessOrEqual(List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType(FHIR_TYPES_STRING) && r.hasType(FHIR_TYPES_STRING)) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) <= 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) <= new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                Integer i = this.compareDateTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i <= 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                Integer i = this.compareTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i <= 0);
            }
            throw this.makeException(expr, "FHIRPATH_CANT_COMPARE", l.fhirType(), r.fhirType());
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            String runit;
            List<Base> lUnits = left.get(0).listChildrenByName("unit");
            String lunit = lUnits.size() == 1 ? lUnits.get(0).primitiveValue() : null;
            List<Base> rUnits = right.get(0).listChildrenByName("unit");
            String string = runit = rUnits.size() == 1 ? rUnits.get(0).primitiveValue() : null;
            if (lunit == null && runit == null || lunit.equals(runit)) {
                return this.opLessOrEqual(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"), expr);
            }
            if (this.worker.getUcumService() == null) {
                return this.makeBoolean(false);
            }
            ArrayList<Base> dl = new ArrayList<Base>();
            dl.add(this.qtyToCanonicalDecimal((Quantity)left.get(0)));
            ArrayList<Base> dr = new ArrayList<Base>();
            dr.add(this.qtyToCanonicalDecimal((Quantity)right.get(0)));
            return this.opLessOrEqual(dl, dr, expr);
        }
        return new ArrayList<Base>();
    }

    private List<Base> opGreaterOrEqual(List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).isPrimitive() && right.get(0).isPrimitive()) {
            Base l = left.get(0);
            Base r = right.get(0);
            if (l.hasType(FHIR_TYPES_STRING) && r.hasType(FHIR_TYPES_STRING)) {
                return this.makeBoolean(l.primitiveValue().compareTo(r.primitiveValue()) >= 0);
            }
            if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
                return this.makeBoolean(new Double(l.primitiveValue()) >= new Double(r.primitiveValue()));
            }
            if (l.hasType("date", "dateTime", "instant") && r.hasType("date", "dateTime", "instant")) {
                Integer i = this.compareDateTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i >= 0);
            }
            if (l.hasType("time") && r.hasType("time")) {
                Integer i = this.compareTimeElements(l, r, false);
                if (i == null) {
                    return this.makeNull();
                }
                return this.makeBoolean(i >= 0);
            }
            throw this.makeException(expr, "FHIRPATH_CANT_COMPARE", l.fhirType(), r.fhirType());
        }
        if (left.size() == 1 && right.size() == 1 && left.get(0).fhirType().equals("Quantity") && right.get(0).fhirType().equals("Quantity")) {
            List<Base> rUnit;
            List<Base> lUnit = left.get(0).listChildrenByName("unit");
            if (Base.compareDeep(lUnit, rUnit = right.get(0).listChildrenByName("unit"), true)) {
                return this.opGreaterOrEqual(left.get(0).listChildrenByName("value"), right.get(0).listChildrenByName("value"), expr);
            }
            if (this.worker.getUcumService() == null) {
                return this.makeBoolean(false);
            }
            ArrayList<Base> dl = new ArrayList<Base>();
            dl.add(this.qtyToCanonicalDecimal((Quantity)left.get(0)));
            ArrayList<Base> dr = new ArrayList<Base>();
            dr.add(this.qtyToCanonicalDecimal((Quantity)right.get(0)));
            return this.opGreaterOrEqual(dl, dr, expr);
        }
        return new ArrayList<Base>();
    }

    private List<Base> opMemberOf(ExecutionContext context, List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        ValueSet vs;
        boolean ans = false;
        String url = right.get(0).primitiveValue();
        ValueSet valueSet = vs = this.hostServices != null ? this.hostServices.resolveValueSet(this, context.appInfo, url) : this.worker.findTxResource(ValueSet.class, url);
        if (vs != null) {
            for (Base l : left) {
                CodeableConcept cc;
                ValidationResult vr;
                if (Utilities.existsInList((String)l.fhirType(), (String[])new String[]{"code", "string", "uri"})) {
                    if (!this.worker.validateCode(this.terminologyServiceOptions.withGuessSystem(), TypeConvertor.castToCoding(l), vs).isOk()) continue;
                    ans = true;
                    continue;
                }
                if (l.fhirType().equals("Coding")) {
                    if (!this.worker.validateCode(this.terminologyServiceOptions, TypeConvertor.castToCoding(l), vs).isOk()) continue;
                    ans = true;
                    continue;
                }
                if (!l.fhirType().equals("CodeableConcept") || !(vr = this.worker.validateCode(this.terminologyServiceOptions, cc = TypeConvertor.castToCodeableConcept(l), vs)).isOk()) continue;
                ans = true;
            }
        }
        return this.makeBoolean(ans);
    }

    private List<Base> opIn(List<Base> left, List<Base> right, ExpressionNode expr) throws FHIRException {
        if (left.size() == 0) {
            return new ArrayList<Base>();
        }
        if (right.size() == 0) {
            return this.makeBoolean(false);
        }
        boolean ans = true;
        for (Base l : left) {
            boolean f = false;
            for (Base r : right) {
                Boolean eq = this.doEquals(l, r);
                if (eq == null || !eq.booleanValue()) continue;
                f = true;
                break;
            }
            if (f) continue;
            ans = false;
            break;
        }
        return this.makeBoolean(ans);
    }

    private List<Base> opContains(List<Base> left, List<Base> right, ExpressionNode expr) {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        boolean ans = true;
        for (Base r : right) {
            boolean f = false;
            for (Base l : left) {
                Boolean eq = this.doEquals(l, r);
                if (eq == null || !eq.booleanValue()) continue;
                f = true;
                break;
            }
            if (f) continue;
            ans = false;
            break;
        }
        return this.makeBoolean(ans);
    }

    private List<Base> opPlus(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "+");
        }
        if (!left.get(0).isPrimitive()) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "+", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "+");
        }
        if (!(right.get(0).isPrimitive() || (left.get(0).isDateTime() || left.get(0).hasType("date", "dateTime", "instant") || "0".equals(left.get(0).primitiveValue()) || left.get(0).hasType("Quantity")) && right.get(0).hasType("Quantity"))) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "+", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType(FHIR_TYPES_STRING) && r.hasType(FHIR_TYPES_STRING)) {
            result.add(new StringType(l.primitiveValue() + r.primitiveValue()));
        } else if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) + Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).add(new BigDecimal(r.primitiveValue()))));
        } else if (l.hasType("date") && r.hasType("Quantity")) {
            DateType dl = l instanceof DateType ? (DateType)l : new DateType(l.primitiveValue());
            result.add(this.dateAdd(dl, (Quantity)r, false, expr));
        } else if ((l.isDateTime() || l.hasType("dateTime") || l.hasType("instant")) && r.hasType("Quantity")) {
            DateTimeType dl = l instanceof DateTimeType ? (DateTimeType)l : new DateTimeType(l.primitiveValue());
            result.add(this.dateAdd(dl, (Quantity)r, false, expr));
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "+", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private BaseDateTimeType dateAdd(BaseDateTimeType d, Quantity q, boolean negate, ExpressionNode holder) {
        BaseDateTimeType result = (BaseDateTimeType)d.copy();
        int value = negate ? 0 - q.getValue().intValue() : q.getValue().intValue();
        switch (q.hasCode() ? q.getCode() : q.getUnit()) {
            case "years": 
            case "year": {
                result.add(1, value);
                break;
            }
            case "a": {
                throw new PathEngineException(this.worker.formatMessage("FHIRPATH_ARITHMETIC_QTY", q.getCode()), "FHIRPATH_ARITHMETIC_QTY", holder.getOpStart(), holder.toString());
            }
            case "months": 
            case "month": {
                result.add(2, value);
                break;
            }
            case "mo": {
                throw new PathEngineException(this.worker.formatMessage("FHIRPATH_ARITHMETIC_QTY", q.getCode()), "FHIRPATH_ARITHMETIC_QTY", holder.getOpStart(), holder.toString());
            }
            case "weeks": 
            case "week": 
            case "wk": {
                result.add(5, value * 7);
                break;
            }
            case "days": 
            case "day": 
            case "d": {
                result.add(5, value);
                break;
            }
            case "hours": 
            case "hour": 
            case "h": {
                result.add(10, value);
                break;
            }
            case "minutes": 
            case "minute": 
            case "min": {
                result.add(12, value);
                break;
            }
            case "seconds": 
            case "second": 
            case "s": {
                result.add(13, value);
                break;
            }
            case "milliseconds": 
            case "millisecond": 
            case "ms": {
                result.add(14, value);
                break;
            }
            default: {
                throw new PathEngineException(this.worker.formatMessage("FHIRPATH_ARITHMETIC_UNIT", q.getCode()), "FHIRPATH_ARITHMETIC_UNIT", holder.getOpStart(), holder.toString());
            }
        }
        return result;
    }

    private List<Base> opTimes(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "*");
        }
        if (!left.get(0).isPrimitive() && !(left.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "*", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "*");
        }
        if (!right.get(0).isPrimitive() && !(right.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "*", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) * Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).multiply(new BigDecimal(r.primitiveValue()))));
        } else if (l instanceof Quantity && r instanceof Quantity && this.worker.getUcumService() != null) {
            Pair pl = this.qtyToPair((Quantity)l);
            Pair pr = this.qtyToPair((Quantity)r);
            try {
                Pair p = this.worker.getUcumService().multiply(pl, pr);
                result.add(this.pairToQty(p));
            }
            catch (UcumException e) {
                throw new PathEngineException(e.getMessage(), null, expr.getOpStart(), expr.toString(), (Throwable)e);
            }
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "*", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private List<Base> opConcatenate(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "&");
        }
        if (left.size() > 0 && !left.get(0).hasType(FHIR_TYPES_STRING)) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "&", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "&");
        }
        if (right.size() > 0 && !right.get(0).hasType(FHIR_TYPES_STRING)) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "&", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        String l = left.size() == 0 ? "" : left.get(0).primitiveValue();
        String r = right.size() == 0 ? "" : right.get(0).primitiveValue();
        result.add(new StringType(l + r));
        return result;
    }

    private List<Base> opUnion(List<Base> left, List<Base> right, ExpressionNode expr) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : left) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        for (Base item : right) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        return result;
    }

    private boolean doContains(List<Base> list, Base item) {
        for (Base test : list) {
            Boolean eq = this.doEquals(test, item);
            if (eq == null || !eq.booleanValue()) continue;
            return true;
        }
        return false;
    }

    private List<Base> opAnd(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        Equality l = this.asBool(left, expr);
        Equality r = this.asBool(right, expr);
        switch (l) {
            case False: {
                return this.makeBoolean(false);
            }
            case Null: {
                if (r == Equality.False) {
                    return this.makeBoolean(false);
                }
                return this.makeNull();
            }
            case True: {
                switch (r) {
                    case False: {
                        return this.makeBoolean(false);
                    }
                    case Null: {
                        return this.makeNull();
                    }
                    case True: {
                        return this.makeBoolean(true);
                    }
                }
            }
        }
        return this.makeNull();
    }

    private boolean isBoolean(List<Base> list, boolean b) {
        return list.size() == 1 && list.get(0) instanceof BooleanType && ((BooleanType)list.get(0)).booleanValue() == b;
    }

    private List<Base> opOr(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        Equality l = this.asBool(left, expr);
        Equality r = this.asBool(right, expr);
        switch (l) {
            case True: {
                return this.makeBoolean(true);
            }
            case Null: {
                if (r == Equality.True) {
                    return this.makeBoolean(true);
                }
                return this.makeNull();
            }
            case False: {
                switch (r) {
                    case False: {
                        return this.makeBoolean(false);
                    }
                    case Null: {
                        return this.makeNull();
                    }
                    case True: {
                        return this.makeBoolean(true);
                    }
                }
            }
        }
        return this.makeNull();
    }

    private List<Base> opXor(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        Equality l = this.asBool(left, expr);
        Equality r = this.asBool(right, expr);
        switch (l) {
            case True: {
                switch (r) {
                    case False: {
                        return this.makeBoolean(true);
                    }
                    case True: {
                        return this.makeBoolean(false);
                    }
                    case Null: {
                        return this.makeNull();
                    }
                }
            }
            case Null: {
                return this.makeNull();
            }
            case False: {
                switch (r) {
                    case False: {
                        return this.makeBoolean(false);
                    }
                    case True: {
                        return this.makeBoolean(true);
                    }
                    case Null: {
                        return this.makeNull();
                    }
                }
            }
        }
        return this.makeNull();
    }

    private List<Base> opImplies(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        Equality eq = this.asBool(left, expr);
        if (eq == Equality.False) {
            return this.makeBoolean(true);
        }
        if (right.size() == 0) {
            return this.makeNull();
        }
        switch (this.asBool(right, expr)) {
            case False: {
                return eq == Equality.Null ? this.makeNull() : this.makeBoolean(false);
            }
            case Null: {
                return this.makeNull();
            }
            case True: {
                return this.makeBoolean(true);
            }
        }
        return this.makeNull();
    }

    private List<Base> opMinus(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "-");
        }
        if (!left.get(0).isPrimitive() && !left.get(0).hasType("Quantity")) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "-", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "-");
        }
        if (!(right.get(0).isPrimitive() || (left.get(0).isDateTime() || left.get(0).hasType("date", "dateTime", "instant") || "0".equals(left.get(0).primitiveValue()) || left.get(0).hasType("Quantity")) && right.get(0).hasType("Quantity"))) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "-", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) - Integer.parseInt(r.primitiveValue())));
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            result.add(new DecimalType(new BigDecimal(l.primitiveValue()).subtract(new BigDecimal(r.primitiveValue()))));
        } else if (l.hasType("decimal", "integer", "Quantity") && r.hasType("Quantity")) {
            String s = l.primitiveValue();
            if ("0".equals(s)) {
                Quantity qty = (Quantity)r;
                result.add(qty.copy().setValue(qty.getValue().abs()));
            }
        } else if (l.hasType("date") && r.hasType("Quantity")) {
            DateType dl = l instanceof DateType ? (DateType)l : new DateType(l.primitiveValue());
            result.add(this.dateAdd(dl, (Quantity)r, true, expr));
        } else if ((l.isDateTime() || l.hasType("dateTime") || l.hasType("instant")) && r.hasType("Quantity")) {
            DateTimeType dl = l instanceof DateTimeType ? (DateTimeType)l : new DateTimeType(l.primitiveValue());
            result.add(this.dateAdd(dl, (Quantity)r, true, expr));
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "-", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private List<Base> opDivideBy(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "/");
        }
        if (!left.get(0).isPrimitive() && !(left.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "/", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "/");
        }
        if (!right.get(0).isPrimitive() && !(right.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "/", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer", "decimal", "unsignedInt", "positiveInt") && r.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new DecimalType(d1.divide(d2).asDecimal()));
            }
            catch (UcumException d2) {}
        } else if (l instanceof Quantity && r instanceof Quantity && this.worker.getUcumService() != null) {
            Pair pl = this.qtyToPair((Quantity)l);
            Pair pr = this.qtyToPair((Quantity)r);
            try {
                Pair p = this.worker.getUcumService().divideBy(pl, pr);
                result.add(this.pairToQty(p));
            }
            catch (UcumException ucumException) {}
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "/", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private List<Base> opDiv(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "div");
        }
        if (!left.get(0).isPrimitive() && !(left.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "div", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "div");
        }
        if (!right.get(0).isPrimitive() && !(right.get(0) instanceof Quantity)) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "div", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            int divisor = Integer.parseInt(r.primitiveValue());
            if (divisor != 0) {
                result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) / divisor));
            }
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new IntegerType(d1.divInt(d2).asDecimal()));
            }
            catch (UcumException ucumException) {}
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "div", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private List<Base> opMod(List<Base> left, List<Base> right, ExpressionNode expr) throws PathEngineException {
        if (left.size() == 0 || right.size() == 0) {
            return new ArrayList<Base>();
        }
        if (left.size() > 1) {
            throw this.makeExceptionPlural(left.size(), expr, "FHIRPATH_LEFT_VALUE", "mod");
        }
        if (!left.get(0).isPrimitive()) {
            throw this.makeException(expr, "FHIRPATH_LEFT_VALUE_WRONG_TYPE", "mod", left.get(0).fhirType());
        }
        if (right.size() > 1) {
            throw this.makeExceptionPlural(right.size(), expr, "FHIRPATH_RIGHT_VALUE", "mod");
        }
        if (!right.get(0).isPrimitive()) {
            throw this.makeException(expr, "FHIRPATH_RIGHT_VALUE_WRONG_TYPE", "mod", right.get(0).fhirType());
        }
        ArrayList<Base> result = new ArrayList<Base>();
        Base l = left.get(0);
        Base r = right.get(0);
        if (l.hasType("integer") && r.hasType("integer")) {
            int modulus = Integer.parseInt(r.primitiveValue());
            if (modulus != 0) {
                result.add(new IntegerType(Integer.parseInt(l.primitiveValue()) % modulus));
            }
        } else if (l.hasType("decimal", "integer") && r.hasType("decimal", "integer")) {
            try {
                Decimal d1 = new Decimal(l.primitiveValue());
                Decimal d2 = new Decimal(r.primitiveValue());
                result.add(new DecimalType(d1.modulo(d2).asDecimal()));
            }
            catch (UcumException e) {
                throw new PathEngineException((Throwable)e);
            }
        } else {
            throw this.makeException(expr, "FHIRPATH_OP_INCOMPATIBLE", "mod", left.get(0).fhirType(), right.get(0).fhirType());
        }
        return result;
    }

    private TypeDetails resolveConstantType(ExecutionTypeContext context, Base constant, ExpressionNode expr, boolean explicitConstant) throws PathEngineException {
        if (constant instanceof BooleanType) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
        }
        if (constant instanceof IntegerType) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
        }
        if (constant instanceof DecimalType) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
        }
        if (constant instanceof Quantity) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Quantity");
        }
        if (constant instanceof FHIRPathUtilityClasses.FHIRConstant) {
            return this.resolveConstantType(context, ((FHIRPathUtilityClasses.FHIRConstant)constant).getValue(), expr, explicitConstant);
        }
        if (constant == null) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, new String[0]);
        }
        return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
    }

    private TypeDetails resolveConstantType(ExecutionTypeContext context, String s, ExpressionNode expr, boolean explicitConstant) throws PathEngineException {
        if (s.startsWith("@")) {
            if (s.startsWith("@T")) {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Time");
            }
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.DateTime");
        }
        if (s.equals("%sct")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.equals("%loinc")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.equals("%ucum")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.equals("%resource")) {
            if (context.resource == null) {
                throw this.makeException(expr, "FHIRPATH_CANNOT_USE", "%resource", "no focus resource");
            }
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, context.resource);
        }
        if (s.equals("%rootResource")) {
            if (context.resource == null) {
                throw this.makeException(expr, "FHIRPATH_CANNOT_USE", "%rootResource", "no focus rootResource");
            }
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, context.resource);
        }
        if (s.equals("%context")) {
            return context.context;
        }
        if (s.equals("%map-codes")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.equals("%us-zip")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.startsWith("%`vs-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.startsWith("%`cs-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (s.startsWith("%`ext-")) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
        }
        if (this.hostServices == null) {
            String varName = s.substring(1);
            if (context.hasDefinedVariable(varName)) {
                return context.getDefinedVariable(varName);
            }
            throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONSTANT", s);
        }
        String varName = s.substring(1);
        if (context.hasDefinedVariable(varName)) {
            return context.getDefinedVariable(varName);
        }
        TypeDetails v = this.hostServices.resolveConstantType(this, context.appInfo, s, explicitConstant);
        if (v == null) {
            throw this.makeException(expr, "FHIRPATH_UNKNOWN_CONSTANT", s);
        }
        return v;
    }

    private List<Base> execute(ExecutionContext context, Base item, ExpressionNode exp, boolean atEntry) throws FHIRException {
        List<Base> temp;
        ArrayList<Base> result = new ArrayList<Base>();
        if (atEntry && context.appInfo != null && this.hostServices != null && !(temp = this.hostServices.resolveConstant(this, context.appInfo, exp.getName(), true, false)).isEmpty()) {
            result.addAll(temp);
            return result;
        }
        if (atEntry && exp.getName() != null && Character.isUpperCase(exp.getName().charAt(0))) {
            StructureDefinition sd = this.worker.fetchTypeDefinition(item.fhirType());
            if (sd == null) {
                if (exp.getName().equals(item.fhirType())) {
                    result.add(item);
                }
            } else {
                while (sd != null) {
                    if (sd.getType().equals(exp.getName()) || sd.getTypeTail().equals(exp.getName())) {
                        result.add(item);
                        break;
                    }
                    sd = this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
                }
            }
        } else {
            this.getChildrenByName(item, exp.getName(), result);
        }
        if (atEntry && context.appInfo != null && this.hostServices != null && result.isEmpty()) {
            result.addAll(this.hostServices.resolveConstant(this, context.appInfo, exp.getName(), false, false));
        }
        return result;
    }

    private String getParent(String rn) {
        return null;
    }

    private TypeDetails executeContextType(ExecutionTypeContext context, String name, ExpressionNode expr, boolean explicitConstant) throws PathEngineException, DefinitionException {
        if (this.hostServices == null) {
            throw this.makeException(expr, "FHIRPATH_HO_HOST_SERVICES", "Context Reference");
        }
        return this.hostServices.resolveConstantType(this, context.appInfo, name, explicitConstant);
    }

    private TypeDetails executeType(String type, ExpressionNode exp, boolean atEntry, TypeDetails focus, Set<ElementDefinition> elementDependencies) throws PathEngineException, DefinitionException {
        if (atEntry && Character.isUpperCase(exp.getName().charAt(0)) && (this.hashTail(type).equals(exp.getName()) || this.isAncestor(type, exp.getName()))) {
            return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, type);
        }
        TypeDetails result = new TypeDetails(focus.getCollectionStatus(), new String[0]);
        this.getChildTypesByName(type, exp.getName(), result, exp, focus, elementDependencies);
        return result;
    }

    private boolean isAncestor(String wanted, String stated) {
        try {
            StructureDefinition sd = this.worker.fetchTypeDefinition(wanted);
            while (sd != null) {
                if (stated.equals(sd.getTypeName())) {
                    return true;
                }
                sd = this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    private String hashTail(String type) {
        return type.contains("#") ? "" : type.substring(type.lastIndexOf("/") + 1);
    }

    private void evaluateParameters(ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp, Set<ElementDefinition> elementDependencies, List<TypeDetails> paramTypes, boolean canBeNone) {
        int i = 0;
        for (ExpressionNode expr : exp.getParameters()) {
            if (this.isExpressionParameter(exp, i)) {
                paramTypes.add(this.executeType(this.changeThis(context, focus), focus, expr, elementDependencies, true, canBeNone, expr));
            } else {
                paramTypes.add(this.executeType(context, context.thisItem, expr, elementDependencies, true, canBeNone, expr));
            }
            ++i;
        }
    }

    private TypeDetails evaluateFunctionType(ExecutionTypeContext context, TypeDetails focus, ExpressionNode exp, Set<ElementDefinition> elementDependencies, ExpressionNode container) throws PathEngineException, DefinitionException {
        ArrayList<TypeDetails> paramTypes = new ArrayList<TypeDetails>();
        if (exp.getFunction() == ExpressionNode.Function.Is || exp.getFunction() == ExpressionNode.Function.As || exp.getFunction() == ExpressionNode.Function.OfType || exp.getFunction() == ExpressionNode.Function.Custom && this.hostServices.paramIsType(exp.getName(), 0)) {
            paramTypes.add(new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
        } else if (exp.getFunction() == ExpressionNode.Function.Repeat && exp.getParameters().size() == 1) {
            TypeDetails base = TypeDetails.empty();
            TypeDetails lFocus = focus;
            boolean changed = false;
            do {
                this.evaluateParameters(context, lFocus, exp, elementDependencies, paramTypes, true);
                changed = false;
                if (base.contains((TypeDetails)paramTypes.get(0))) continue;
                changed = true;
                base.addTypes((TypeDetails)paramTypes.get(0));
                lFocus = base;
            } while (changed);
            paramTypes.clear();
            paramTypes.add(base);
        } else if (exp.getFunction() == ExpressionNode.Function.Where || exp.getFunction() == ExpressionNode.Function.Select || exp.getFunction() == ExpressionNode.Function.Exists || exp.getFunction() == ExpressionNode.Function.All || exp.getFunction() == ExpressionNode.Function.AllTrue || exp.getFunction() == ExpressionNode.Function.AnyTrue || exp.getFunction() == ExpressionNode.Function.AllFalse || exp.getFunction() == ExpressionNode.Function.AnyFalse) {
            this.evaluateParameters(context, focus.toSingleton(), exp, elementDependencies, paramTypes, false);
        } else {
            this.evaluateParameters(context, focus, exp, elementDependencies, paramTypes, false);
        }
        if ((exp.getFunction() == ExpressionNode.Function.First || exp.getFunction() == ExpressionNode.Function.Last || exp.getFunction() == ExpressionNode.Function.Tail || exp.getFunction() == ExpressionNode.Function.Skip || exp.getFunction() == ExpressionNode.Function.Take) && focus.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_NOT_A_COLLECTION", container.toString()), "FHIRPATH_NOT_A_COLLECTION"));
        }
        switch (exp.getFunction()) {
            case Empty: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Not: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Exists: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case SubsetOf: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, focus.toUnordered());
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case SupersetOf: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, focus);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case IsDistinct: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Distinct: {
                return focus;
            }
            case Count: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case Where: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean"));
                if (focus.hasType("Reference")) {
                    boolean canRestrictTargets = !exp.getParameters().isEmpty();
                    ArrayList<String> targets = new ArrayList<String>();
                    if (canRestrictTargets) {
                        ExpressionNode p = exp.getParameters().get(0);
                        if (p.getKind() == ExpressionNode.Kind.Function && p.getName().equals("resolve") && p.getOperation() == ExpressionNode.Operation.Is) {
                            targets.add(p.getOpNext().getName());
                        } else {
                            canRestrictTargets = false;
                        }
                    }
                    if (canRestrictTargets) {
                        TypeDetails td = focus.copy();
                        td.getTargets().clear();
                        td.getTargets().addAll(targets);
                        return td;
                    }
                    return focus;
                }
                return focus;
            }
            case Select: {
                return (TypeDetails)paramTypes.get(0);
            }
            case All: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Repeat: {
                return (TypeDetails)paramTypes.get(0);
            }
            case Aggregate: {
                return this.anything(focus.getCollectionStatus());
            }
            case Item: {
                this.checkOrdered(focus, "item", exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                return focus;
            }
            case As: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                String tn = this.checkType(focus, exp);
                TypeDetails td = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, tn);
                if (td.typesHaveTargets()) {
                    td.addTargets(focus.getTargets());
                }
                return td;
            }
            case OfType: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                String tn = this.checkType(focus, exp);
                TypeDetails td = new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, tn);
                if (td.typesHaveTargets()) {
                    td.addTargets(focus.getTargets());
                }
                return td;
            }
            case Type: {
                boolean s = false;
                boolean c = false;
                for (TypeDetails.ProfiledType pt : focus.getProfiledTypes()) {
                    s = s || pt.isSystemType();
                    c = c || !pt.isSystemType();
                }
                if (s && c) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.SimpleTypeInfo", "http://hl7.org/fhirpath/System.ClassInfo");
                }
                if (s) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.SimpleTypeInfo");
                }
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.ClassInfo");
            }
            case Is: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Single: {
                return focus.toSingleton();
            }
            case First: {
                this.checkOrdered(focus, "first", exp);
                return focus.toSingleton();
            }
            case Last: {
                this.checkOrdered(focus, "last", exp);
                return focus.toSingleton();
            }
            case Tail: {
                this.checkOrdered(focus, "tail", exp);
                return focus;
            }
            case Skip: {
                this.checkOrdered(focus, "skip", exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                return focus;
            }
            case Take: {
                this.checkOrdered(focus, "take", exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                return focus;
            }
            case Union: {
                return focus.union((TypeDetails)paramTypes.get(0));
            }
            case Combine: {
                return focus.union((TypeDetails)paramTypes.get(0));
            }
            case Intersect: {
                return focus.intersect((TypeDetails)paramTypes.get(0));
            }
            case Exclude: {
                return focus;
            }
            case Iif: {
                TypeDetails types = new TypeDetails(null, new String[0]);
                this.checkSingleton(focus, "iif", exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean"));
                types.update((TypeDetails)paramTypes.get(1));
                if (paramTypes.size() > 2) {
                    types.update((TypeDetails)paramTypes.get(2));
                }
                return types;
            }
            case Lower: {
                this.checkContextString(focus, "lower", exp, true);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Upper: {
                this.checkContextString(focus, "upper", exp, true);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case ToChars: {
                this.checkContextString(focus, "toChars", exp, true);
                return new TypeDetails(ExpressionNode.CollectionStatus.ORDERED, "http://hl7.org/fhirpath/System.String");
            }
            case IndexOf: {
                this.checkContextString(focus, "indexOf", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case Substring: {
                this.checkContextString(focus, "subString", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case StartsWith: {
                this.checkContextString(focus, "startsWith", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case EndsWith: {
                this.checkContextString(focus, "endsWith", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Matches: {
                this.checkContextString(focus, "matches", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case MatchesFull: {
                this.checkContextString(focus, "matches", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case ReplaceMatches: {
                this.checkContextString(focus, "replaceMatches", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Contains: {
                this.checkContextString(focus, "contains", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Replace: {
                this.checkContextString(focus, "replace", exp, true);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"), new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Length: {
                this.checkContextPrimitive(focus, "length", false, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case Children: {
                return this.childTypes(focus, "*", exp);
            }
            case Descendants: {
                return this.childTypes(focus, "**", exp);
            }
            case MemberOf: {
                this.checkContextCoded(focus, "memberOf", exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Trace: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return focus;
            }
            case DefineVariable: {
                String varName;
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.UNORDERED, "http://hl7.org/fhirpath/System.String"));
                ExpressionNode p = exp.getParameters().get(0);
                if (p.getKind() == ExpressionNode.Kind.Constant && p.getConstant() != null && (varName = exp.getParameters().get(0).getConstant().primitiveValue()) != null) {
                    if (paramTypes.size() > 1) {
                        context.setDefinedVariable(varName, (TypeDetails)paramTypes.get(1));
                    } else {
                        context.setDefinedVariable(varName, focus);
                    }
                }
                return focus;
            }
            case Check: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return focus;
            }
            case Today: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.DateTime");
            }
            case Now: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.DateTime");
            }
            case Resolve: {
                this.checkContextReference(focus, "resolve", exp);
                return new TypeDetails(focus.getCollectionStatus(), "Resource");
            }
            case Extension: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                ExpressionNode p = exp.getParameters().get(0);
                if (p.getKind() == ExpressionNode.Kind.Constant && p.getConstant() != null) {
                    String url = exp.getParameters().get(0).getConstant().primitiveValue();
                    ExtensionDefinition ed = this.findExtensionDefinition(focus, url);
                    if (ed != null) {
                        return new TypeDetails(ExpressionNode.CollectionStatus.ORDERED, new TypeDetails.ProfiledType(ed.sd.getUrl()));
                    }
                    this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_UNKNOWN_EXTENSION", url), "FHIRPATH_UNKNOWN_EXTENSION"));
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "Extension");
                }
            }
            case AnyTrue: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case AllTrue: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case AnyFalse: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case AllFalse: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case HasValue: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case HtmlChecks1: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case HtmlChecks2: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Comparable: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Encode: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Decode: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Escape: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Unescape: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Trim: {
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Split: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case Join: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case ToInteger: {
                this.checkContextPrimitive(focus, "toInteger", true, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case ToDecimal: {
                this.checkContextPrimitive(focus, "toDecimal", true, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
            }
            case ToString: {
                this.checkContextPrimitive(focus, "toString", true, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String");
            }
            case ToQuantity: {
                this.checkContextPrimitive(focus, "toQuantity", true, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Quantity");
            }
            case ToBoolean: {
                this.checkContextPrimitive(focus, "toBoolean", false, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case ToDateTime: {
                this.checkContextPrimitive(focus, "ToDateTime", false, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.DateTime");
            }
            case ToTime: {
                this.checkContextPrimitive(focus, "ToTime", false, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Time");
            }
            case ConvertsToString: 
            case ConvertsToQuantity: {
                this.checkContextPrimitive(focus, exp.getFunction().toCode(), true, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case ConvertsToInteger: 
            case ConvertsToDecimal: 
            case ConvertsToBoolean: 
            case ConvertsToDateTime: 
            case ConvertsToDate: 
            case ConvertsToTime: {
                this.checkContextPrimitive(focus, exp.getFunction().toCode(), false, exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case ConformsTo: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Abs: {
                this.checkContextNumerical(focus, "abs", exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, focus.getTypes());
            }
            case Ceiling: 
            case Floor: 
            case Truncate: {
                this.checkContextDecimal(focus, exp.getFunction().toCode(), exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case Round: {
                this.checkContextDecimal(focus, "round", exp);
                if (paramTypes.size() > 0) {
                    this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                }
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
            }
            case Sqrt: 
            case Exp: 
            case Ln: {
                this.checkContextNumerical(focus, exp.getFunction().toCode(), exp);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
            }
            case Log: {
                this.checkContextNumerical(focus, exp.getFunction().toCode(), exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, TypeDetails.FP_NUMBERS));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
            }
            case Power: {
                this.checkContextNumerical(focus, exp.getFunction().toCode(), exp);
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, TypeDetails.FP_NUMBERS));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, focus.getTypes());
            }
            case LowBoundary: 
            case HighBoundary: {
                this.checkContextContinuous(focus, exp.getFunction().toCode(), exp, true);
                if (paramTypes.size() > 0) {
                    this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer"));
                }
                if (focus.hasType("date") || focus.hasType("datetime") || focus.hasType("instant")) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal", "http://hl7.org/fhirpath/System.DateTime");
                }
                if (focus.hasType("decimal") || focus.hasType("integer")) {
                    return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Decimal");
                }
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.DateTime");
            }
            case Precision: {
                this.checkContextContinuous(focus, exp.getFunction().toCode(), exp, false);
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Integer");
            }
            case hasTemplateIdOf: {
                this.checkParamTypes(exp, exp.getFunction().toCode(), paramTypes, new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.String"));
                return new TypeDetails(ExpressionNode.CollectionStatus.SINGLETON, "http://hl7.org/fhirpath/System.Boolean");
            }
            case Custom: {
                return this.hostServices.checkFunction(this, context.appInfo, exp.getName(), focus, paramTypes);
            }
        }
        throw new Error("not Implemented yet");
    }

    private ExtensionDefinition findExtensionDefinition(TypeDetails focus, String url) {
        if (Utilities.isAbsoluteUrl((String)url)) {
            StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, url);
            if (sd == null) {
                return null;
            }
            return new ExtensionDefinition(true, sd, sd.getSnapshot().getElementFirstRep());
        }
        StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, focus.getType());
        if (sd != null) {
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                if (!ed.hasFixed() || !url.equals(ed.getFixed().primitiveValue())) continue;
                return new ExtensionDefinition(false, sd, ed);
            }
        }
        return null;
    }

    private String checkType(TypeDetails focus, ExpressionNode exp) {
        Object tn = exp.getParameters().get(0).getInner() != null ? exp.getParameters().get(0).getName() + "." + exp.getParameters().get(0).getInner().getName() : "FHIR." + exp.getParameters().get(0).getName();
        if (((String)tn).startsWith("System.")) {
            tn = ((String)tn).substring(7);
        } else if (((String)tn).startsWith("FHIR.")) {
            tn = Utilities.pathURL((String[])new String[]{"http://hl7.org/fhir", "StructureDefinition", ((String)tn).substring(5)});
        } else if (((String)tn).startsWith("CDA.")) {
            tn = Utilities.pathURL((String[])new String[]{"http://hl7.org/cda/stds/core", "StructureDefinition", ((String)tn).substring(4)});
        }
        if (this.typeCastIsImpossible(focus, (String)tn)) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_OFTYPE_IMPOSSIBLE", focus.describeMin(), tn, exp.toString()), "FHIRPATH_OFTYPE_IMPOSSIBLE"));
        }
        return tn;
    }

    private boolean typeCastIsImpossible(TypeDetails focus, String tn) {
        return !focus.hasType(tn);
    }

    private boolean isExpressionParameter(ExpressionNode exp, int i) {
        switch (i) {
            case 0: {
                return exp.getFunction() == ExpressionNode.Function.Where || exp.getFunction() == ExpressionNode.Function.Exists || exp.getFunction() == ExpressionNode.Function.All || exp.getFunction() == ExpressionNode.Function.Select || exp.getFunction() == ExpressionNode.Function.Repeat || exp.getFunction() == ExpressionNode.Function.Aggregate;
            }
            case 1: {
                return exp.getFunction() == ExpressionNode.Function.Trace || exp.getFunction() == ExpressionNode.Function.DefineVariable;
            }
        }
        return false;
    }

    private void checkParamTypes(ExpressionNode expr, String funcName, List<TypeDetails> paramTypes, TypeDetails ... typeSet) throws PathEngineException {
        int i = 0;
        for (TypeDetails pt : typeSet) {
            if (i == paramTypes.size()) {
                return;
            }
            TypeDetails actual = paramTypes.get(i);
            ++i;
            for (String a : actual.getTypes()) {
                if (pt.hasType(this.worker, a)) continue;
                throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", funcName, i, a, pt.toString());
            }
            if (actual.getCollectionStatus() == ExpressionNode.CollectionStatus.SINGLETON || pt.getCollectionStatus() != ExpressionNode.CollectionStatus.SINGLETON) continue;
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_PARAMETER", funcName, i, expr.toString()), "FHIRPATH_COLLECTION_STATUS_PARAMETER"));
        }
    }

    private void checkSingleton(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (focus.getCollectionStatus() != ExpressionNode.CollectionStatus.SINGLETON) {
            this.typeWarnings.add(new IssueMessage(this.worker.formatMessage("FHIRPATH_COLLECTION_STATUS_CONTEXT", name, expr.toString()), "FHIRPATH_COLLECTION_STATUS_CONTEXT"));
        }
    }

    private void checkOrdered(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (focus.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED) {
            throw this.makeException(expr, "FHIRPATH_ORDERED_ONLY", name);
        }
    }

    private void checkContextReference(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (!(focus.hasType(this.worker, "string") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "url") || focus.hasType(this.worker, "Reference") || focus.hasType(this.worker, "canonical"))) {
            throw this.makeException(expr, "FHIRPATH_REFERENCE_ONLY", name, focus.describe());
        }
    }

    private void checkContextCoded(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (!(focus.hasType(this.worker, "string") || focus.hasType(this.worker, "code") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "Coding") || focus.hasType(this.worker, "CodeableConcept"))) {
            throw this.makeException(expr, "FHIRPATH_CODED_ONLY", name, focus.describe());
        }
    }

    private void checkContextString(TypeDetails focus, String name, ExpressionNode expr, boolean sing) throws PathEngineException {
        if (!(focus.hasNoTypes() || focus.hasType(this.worker, "string") || focus.hasType(this.worker, "code") || focus.hasType(this.worker, "uri") || focus.hasType(this.worker, "url") || focus.hasType(this.worker, "canonical") || focus.hasType(this.worker, "id"))) {
            throw this.makeException(expr, sing ? "FHIRPATH_STRING_SING_ONLY" : "FHIRPATH_STRING_ORD_ONLY", name, focus.describe());
        }
    }

    private void checkContextPrimitive(TypeDetails focus, String name, boolean canQty, ExpressionNode expr) throws PathEngineException {
        if (!focus.hasNoTypes()) {
            if (canQty) {
                if (!focus.hasType(this.primitiveTypes) && !focus.hasType("Quantity")) {
                    throw this.makeException(expr, "FHIRPATH_PRIMITIVE_ONLY", name, focus.describe(), "Quantity, " + this.primitiveTypes.toString());
                }
            } else if (!focus.hasType(this.primitiveTypes)) {
                throw this.makeException(expr, "FHIRPATH_PRIMITIVE_ONLY", name, focus.describe(), this.primitiveTypes.toString());
            }
        }
    }

    private void checkContextNumerical(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (!(focus.hasNoTypes() || focus.hasType("integer") || focus.hasType("decimal") || focus.hasType("Quantity"))) {
            throw this.makeException(expr, "FHIRPATH_NUMERICAL_ONLY", name, focus.describe());
        }
    }

    private void checkContextDecimal(TypeDetails focus, String name, ExpressionNode expr) throws PathEngineException {
        if (!(focus.hasNoTypes() || focus.hasType("decimal") || focus.hasType("integer"))) {
            throw this.makeException(expr, "FHIRPATH_DECIMAL_ONLY", name, focus.describe());
        }
    }

    private void checkContextContinuous(TypeDetails focus, String name, ExpressionNode expr, boolean allowInteger) throws PathEngineException {
        if (!(focus.hasNoTypes() || focus.hasType("decimal") || focus.hasType("date") || focus.hasType("dateTime") || focus.hasType("time") || focus.hasType("Quantity") || allowInteger && focus.hasType("integer"))) {
            throw this.makeException(expr, "FHIRPATH_CONTINUOUS_ONLY", name, focus.describe());
        }
    }

    private TypeDetails childTypes(TypeDetails focus, String mask, ExpressionNode expr) throws PathEngineException, DefinitionException {
        TypeDetails result = new TypeDetails(ExpressionNode.CollectionStatus.UNORDERED, new String[0]);
        for (String f : focus.getTypes()) {
            this.getChildTypesByName(f, mask, result, expr, null, null);
        }
        return result;
    }

    private TypeDetails anything(ExpressionNode.CollectionStatus status) {
        return new TypeDetails(status, this.allTypes.keySet());
    }

    private List<Base> evaluateFunction(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        switch (exp.getFunction()) {
            case Empty: {
                return this.funcEmpty(context, focus, exp);
            }
            case Not: {
                return this.funcNot(context, focus, exp);
            }
            case Exists: {
                return this.funcExists(context, focus, exp);
            }
            case SubsetOf: {
                return this.funcSubsetOf(context, focus, exp);
            }
            case SupersetOf: {
                return this.funcSupersetOf(context, focus, exp);
            }
            case IsDistinct: {
                return this.funcIsDistinct(context, focus, exp);
            }
            case Distinct: {
                return this.funcDistinct(context, focus, exp);
            }
            case Count: {
                return this.funcCount(context, focus, exp);
            }
            case Where: {
                return this.funcWhere(context, focus, exp);
            }
            case Select: {
                return this.funcSelect(context, focus, exp);
            }
            case All: {
                return this.funcAll(context, focus, exp);
            }
            case Repeat: {
                return this.funcRepeat(context, focus, exp);
            }
            case Aggregate: {
                return this.funcAggregate(context, focus, exp);
            }
            case Item: {
                return this.funcItem(context, focus, exp);
            }
            case As: {
                return this.funcAs(context, focus, exp);
            }
            case OfType: {
                return this.funcOfType(context, focus, exp);
            }
            case Type: {
                return this.funcType(context, focus, exp);
            }
            case Is: {
                return this.funcIs(context, focus, exp);
            }
            case Single: {
                return this.funcSingle(context, focus, exp);
            }
            case First: {
                return this.funcFirst(context, focus, exp);
            }
            case Last: {
                return this.funcLast(context, focus, exp);
            }
            case Tail: {
                return this.funcTail(context, focus, exp);
            }
            case Skip: {
                return this.funcSkip(context, focus, exp);
            }
            case Take: {
                return this.funcTake(context, focus, exp);
            }
            case Union: {
                return this.funcUnion(context, focus, exp);
            }
            case Combine: {
                return this.funcCombine(context, focus, exp);
            }
            case Intersect: {
                return this.funcIntersect(context, focus, exp);
            }
            case Exclude: {
                return this.funcExclude(context, focus, exp);
            }
            case Iif: {
                return this.funcIif(context, focus, exp);
            }
            case Lower: {
                return this.funcLower(context, focus, exp);
            }
            case Upper: {
                return this.funcUpper(context, focus, exp);
            }
            case ToChars: {
                return this.funcToChars(context, focus, exp);
            }
            case IndexOf: {
                return this.funcIndexOf(context, focus, exp);
            }
            case Substring: {
                return this.funcSubstring(context, focus, exp);
            }
            case StartsWith: {
                return this.funcStartsWith(context, focus, exp);
            }
            case EndsWith: {
                return this.funcEndsWith(context, focus, exp);
            }
            case Matches: {
                return this.funcMatches(context, focus, exp);
            }
            case MatchesFull: {
                return this.funcMatchesFull(context, focus, exp);
            }
            case ReplaceMatches: {
                return this.funcReplaceMatches(context, focus, exp);
            }
            case Contains: {
                return this.funcContains(context, focus, exp);
            }
            case Replace: {
                return this.funcReplace(context, focus, exp);
            }
            case Length: {
                return this.funcLength(context, focus, exp);
            }
            case Children: {
                return this.funcChildren(context, focus, exp);
            }
            case Descendants: {
                return this.funcDescendants(context, focus, exp);
            }
            case MemberOf: {
                return this.funcMemberOf(context, focus, exp);
            }
            case Trace: {
                return this.funcTrace(context, focus, exp);
            }
            case DefineVariable: {
                return this.funcDefineVariable(context, focus, exp);
            }
            case Check: {
                return this.funcCheck(context, focus, exp);
            }
            case Today: {
                return this.funcToday(context, focus, exp);
            }
            case Now: {
                return this.funcNow(context, focus, exp);
            }
            case Resolve: {
                return this.funcResolve(context, focus, exp);
            }
            case Extension: {
                return this.funcExtension(context, focus, exp);
            }
            case AnyFalse: {
                return this.funcAnyFalse(context, focus, exp);
            }
            case AllFalse: {
                return this.funcAllFalse(context, focus, exp);
            }
            case AnyTrue: {
                return this.funcAnyTrue(context, focus, exp);
            }
            case AllTrue: {
                return this.funcAllTrue(context, focus, exp);
            }
            case HasValue: {
                return this.funcHasValue(context, focus, exp);
            }
            case Encode: {
                return this.funcEncode(context, focus, exp);
            }
            case Decode: {
                return this.funcDecode(context, focus, exp);
            }
            case Escape: {
                return this.funcEscape(context, focus, exp);
            }
            case Unescape: {
                return this.funcUnescape(context, focus, exp);
            }
            case Trim: {
                return this.funcTrim(context, focus, exp);
            }
            case Split: {
                return this.funcSplit(context, focus, exp);
            }
            case Join: {
                return this.funcJoin(context, focus, exp);
            }
            case HtmlChecks1: {
                return this.funcHtmlChecks1(context, focus, exp);
            }
            case HtmlChecks2: {
                return this.funcHtmlChecks2(context, focus, exp);
            }
            case Comparable: {
                return this.funcComparable(context, focus, exp);
            }
            case ToInteger: {
                return this.funcToInteger(context, focus, exp);
            }
            case ToDecimal: {
                return this.funcToDecimal(context, focus, exp);
            }
            case ToString: {
                return this.funcToString(context, focus, exp);
            }
            case ToBoolean: {
                return this.funcToBoolean(context, focus, exp);
            }
            case ToQuantity: {
                return this.funcToQuantity(context, focus, exp);
            }
            case ToDateTime: {
                return this.funcToDateTime(context, focus, exp);
            }
            case ToTime: {
                return this.funcToTime(context, focus, exp);
            }
            case ConvertsToInteger: {
                return this.funcIsInteger(context, focus, exp);
            }
            case ConvertsToDecimal: {
                return this.funcIsDecimal(context, focus, exp);
            }
            case ConvertsToString: {
                return this.funcIsString(context, focus, exp);
            }
            case ConvertsToBoolean: {
                return this.funcIsBoolean(context, focus, exp);
            }
            case ConvertsToQuantity: {
                return this.funcIsQuantity(context, focus, exp);
            }
            case ConvertsToDateTime: {
                return this.funcIsDateTime(context, focus, exp);
            }
            case ConvertsToDate: {
                return this.funcIsDate(context, focus, exp);
            }
            case ConvertsToTime: {
                return this.funcIsTime(context, focus, exp);
            }
            case ConformsTo: {
                return this.funcConformsTo(context, focus, exp);
            }
            case Round: {
                return this.funcRound(context, focus, exp);
            }
            case Sqrt: {
                return this.funcSqrt(context, focus, exp);
            }
            case Abs: {
                return this.funcAbs(context, focus, exp);
            }
            case Ceiling: {
                return this.funcCeiling(context, focus, exp);
            }
            case Exp: {
                return this.funcExp(context, focus, exp);
            }
            case Floor: {
                return this.funcFloor(context, focus, exp);
            }
            case Ln: {
                return this.funcLn(context, focus, exp);
            }
            case Log: {
                return this.funcLog(context, focus, exp);
            }
            case Power: {
                return this.funcPower(context, focus, exp);
            }
            case Truncate: {
                return this.funcTruncate(context, focus, exp);
            }
            case LowBoundary: {
                return this.funcLowBoundary(context, focus, exp);
            }
            case HighBoundary: {
                return this.funcHighBoundary(context, focus, exp);
            }
            case Precision: {
                return this.funcPrecision(context, focus, exp);
            }
            case hasTemplateIdOf: {
                return this.funcHasTemplateIdOf(context, focus, exp);
            }
            case Custom: {
                ArrayList<List<Base>> params = new ArrayList<List<Base>>();
                if (this.hostServices.paramIsType(exp.getName(), 0)) {
                    if (exp.getParameters().size() > 0) {
                        String tn = exp.getParameters().get(0).getInner() != null ? exp.getParameters().get(0).getName() + "." + exp.getParameters().get(0).getInner().getName() : "FHIR." + exp.getParameters().get(0).getName();
                        ArrayList<CodeType> p = new ArrayList<CodeType>();
                        p.add(new CodeType(tn));
                        params.add(p);
                    }
                } else {
                    for (ExpressionNode p : exp.getParameters()) {
                        params.add(this.execute(context, focus, p, true));
                    }
                }
                return this.hostServices.executeFunction(this, context.appInfo, focus, exp.getName(), params);
            }
        }
        throw new Error("not Implemented yet");
    }

    private List<Base> funcHasTemplateIdOf(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, focus, exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        StructureDefinition sd = this.worker.fetchResource(StructureDefinition.class, sw);
        if (focus.size() == 1 && sd != null) {
            boolean found = false;
            for (Identifier id : sd.getIdentifier()) {
                if (id.getValue().startsWith("urn:hl7ii:")) {
                    String[] p = id.getValue().split("\\:");
                    if (p.length != 4) continue;
                    found = found || this.hasTemplateId(focus.get(0), p[2], p[3]);
                    continue;
                }
                if (!id.getValue().startsWith("urn:oid:")) continue;
                found = found || this.hasTemplateId(focus.get(0), id.getValue().substring(8));
            }
            result.add(new BooleanType(found));
        }
        return result;
    }

    private boolean hasTemplateId(Base base, String rv) {
        List<Base> templateIds = base.listChildrenByName("templateId");
        for (Base templateId : templateIds) {
            Base root = templateId.getChildValueByName("root");
            Base extension = templateId.getChildValueByName("extension");
            if (extension != null || root == null || !rv.equals(root.primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private boolean hasTemplateId(Base base, String rv, String ev) {
        List<Base> templateIds = base.listChildrenByName("templateId");
        for (Base templateId : templateIds) {
            Base root = templateId.getChildValueByName("root");
            Base extension = templateId.getChildValueByName("extension");
            if (extension == null || !ev.equals(extension.primitiveValue()) || root == null || !rv.equals(root.primitiveValue())) continue;
            return true;
        }
        return false;
    }

    private List<Base> funcSqrt(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "sqrt", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(Math.sqrt(d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "sqrt", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcAbs(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "abs", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(Math.abs(d)));
            }
            catch (Exception exception) {}
        } else if (base.hasType("Quantity")) {
            Quantity qty = (Quantity)base;
            result.add(qty.copy().setValue(qty.getValue().abs()));
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "abs", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcCeiling(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "ceiling", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new IntegerType((int)Math.ceil(d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "ceiling", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcFloor(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "floor", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new IntegerType((int)Math.floor(d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "floor", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcExp(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() == 0) {
            return new ArrayList<Base>();
        }
        if (focus.size() > 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "exp", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(Math.exp(d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "exp", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcLn(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "ln", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(Math.log(d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "ln", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcLog(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "log", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
            if (n1.size() != 1) {
                throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "log", "0", "Multiple Values", "integer or decimal");
            }
            Double e = Double.parseDouble(n1.get(0).primitiveValue());
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(FHIRPathEngine.customLog(e, d)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "log", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private static double customLog(double base, double logNumber) {
        return Math.log(logNumber) / Math.log(base);
    }

    private List<Base> funcPower(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "power", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
            if (n1.size() != 1) {
                throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "power", "0", "Multiple Values", "integer or decimal");
            }
            Double e = Double.parseDouble(n1.get(0).primitiveValue());
            Double d = Double.parseDouble(base.primitiveValue());
            try {
                result.add(new DecimalType(Math.pow(d, e)));
            }
            catch (Exception exception) {}
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "power", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcTruncate(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "truncate", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            String s = base.primitiveValue();
            if (s.contains(".")) {
                s = s.substring(0, s.indexOf("."));
            }
            result.add(new IntegerType(s));
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "sqrt", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    private List<Base> funcLowBoundary(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() == 0) {
            return this.makeNull();
        }
        if (focus.size() > 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "lowBoundary", focus.size());
        }
        Integer precision = null;
        if (expr.getParameters().size() > 0) {
            List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
            if (n1.size() != 1) {
                throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "lowBoundary", "0", "Multiple Values", "integer");
            }
            precision = Integer.parseInt(n1.get(0).primitiveValue());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("decimal")) {
            if (precision == null || precision >= 0 && precision < 17) {
                result.add(new DecimalType(Utilities.lowBoundaryForDecimal((String)base.primitiveValue(), (int)(precision == null ? 8 : precision))));
            }
        } else if (base.hasType("integer")) {
            if (precision == null || precision >= 0 && precision < 17) {
                result.add(new DecimalType(Utilities.lowBoundaryForDecimal((String)base.primitiveValue(), (int)(precision == null ? 8 : precision))));
            }
        } else if (base.hasType("date")) {
            result.add(new DateTimeType(Utilities.lowBoundaryForDate((String)base.primitiveValue(), (int)(precision == null ? 10 : precision))));
        } else if (base.hasType("dateTime")) {
            result.add(new DateTimeType(Utilities.lowBoundaryForDate((String)base.primitiveValue(), (int)(precision == null ? 17 : precision))));
        } else if (base.hasType("time")) {
            result.add(new TimeType(Utilities.lowBoundaryForTime((String)base.primitiveValue(), (int)(precision == null ? 9 : precision))));
        } else if (base.hasType("Quantity")) {
            String value = this.getNamedValue(base, "value");
            Base v = base.copy();
            v.setProperty("value", new DecimalType(Utilities.lowBoundaryForDecimal((String)value, (int)(precision == null ? 8 : precision))));
            result.add(v);
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "sqrt", "(focus)", base.fhirType(), "decimal or date");
        }
        return result;
    }

    private List<Base> funcHighBoundary(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() == 0) {
            return this.makeNull();
        }
        if (focus.size() > 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "highBoundary", focus.size());
        }
        Integer precision = null;
        if (expr.getParameters().size() > 0) {
            List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
            if (n1.size() != 1) {
                throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "lowBoundary", "0", "Multiple Values", "integer");
            }
            precision = Integer.parseInt(n1.get(0).primitiveValue());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("decimal")) {
            if (precision == null || precision >= 0 && precision < 17) {
                result.add(new DecimalType(Utilities.highBoundaryForDecimal((String)base.primitiveValue(), (int)(precision == null ? 8 : precision))));
            }
        } else if (base.hasType("integer")) {
            if (precision == null || precision >= 0 && precision < 17) {
                result.add(new DecimalType(Utilities.highBoundaryForDecimal((String)base.primitiveValue(), (int)(precision == null ? 8 : precision))));
            }
        } else if (base.hasType("date")) {
            result.add(new DateTimeType(Utilities.highBoundaryForDate((String)base.primitiveValue(), (int)(precision == null ? 10 : precision))));
        } else if (base.hasType("dateTime")) {
            result.add(new DateTimeType(Utilities.highBoundaryForDate((String)base.primitiveValue(), (int)(precision == null ? 17 : precision))));
        } else if (base.hasType("time")) {
            result.add(new TimeType(Utilities.highBoundaryForTime((String)base.primitiveValue(), (int)(precision == null ? 9 : precision))));
        } else if (base.hasType("Quantity")) {
            String value = this.getNamedValue(base, "value");
            Base v = base.copy();
            v.setProperty("value", new DecimalType(Utilities.highBoundaryForDecimal((String)value, (int)(precision == null ? 8 : precision))));
            result.add(v);
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "sqrt", "(focus)", base.fhirType(), "decimal or date");
        }
        return result;
    }

    private List<Base> funcPrecision(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "highBoundary", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("decimal")) {
            result.add(new IntegerType(Utilities.getDecimalPrecision((String)base.primitiveValue())));
        } else if (base.hasType("date") || base.hasType("dateTime")) {
            result.add(new IntegerType(Utilities.getDatePrecision((String)base.primitiveValue())));
        } else if (base.hasType("time")) {
            result.add(new IntegerType(Utilities.getTimePrecision((String)base.primitiveValue())));
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "sqrt", "(focus)", base.fhirType(), "decimal or date");
        }
        return result;
    }

    private List<Base> funcRound(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        if (focus.size() != 1) {
            throw this.makeExceptionPlural(focus.size(), expr, "FHIRPATH_FOCUS", "round", focus.size());
        }
        Base base = focus.get(0);
        ArrayList<Base> result = new ArrayList<Base>();
        if (base.hasType("integer", "decimal", "unsignedInt", "positiveInt")) {
            int i = 0;
            if (expr.getParameters().size() == 1) {
                List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
                if (n1.size() != 1) {
                    throw this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "power", "0", "Multiple Values", "integer");
                }
                i = Integer.parseInt(n1.get(0).primitiveValue());
            }
            BigDecimal d = new BigDecimal(base.primitiveValue());
            result.add(new DecimalType(d.setScale(i, RoundingMode.HALF_UP)));
        } else {
            this.makeException(expr, "FHIRPATH_WRONG_PARAM_TYPE", "round", "(focus)", base.fhirType(), "integer or decimal");
        }
        return result;
    }

    public static String bytesToHex(byte[] bytes) {
        char[] hexChars = new char[bytes.length * 2];
        for (int j = 0; j < bytes.length; ++j) {
            int v = bytes[j] & 0xFF;
            hexChars[j * 2] = HEX_ARRAY[v >>> 4];
            hexChars[j * 2 + 1] = HEX_ARRAY[v & 0xF];
        }
        return new String(hexChars);
    }

    public static byte[] hexStringToByteArray(String s) {
        int len = s.length();
        byte[] data = new byte[len / 2];
        for (int i = 0; i < len; i += 2) {
            data[i / 2] = (byte)((Character.digit(s.charAt(i), 16) << 4) + Character.digit(s.charAt(i + 1), 16));
        }
        return data;
    }

    private List<Base> funcEncode(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String param = nl.get(0).primitiveValue();
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String cnt = focus.get(0).primitiveValue();
            if ("hex".equals(param)) {
                result.add(new StringType(FHIRPathEngine.bytesToHex(cnt.getBytes())));
            } else if ("base64".equals(param)) {
                Base64.Encoder enc = Base64.getEncoder();
                result.add(new StringType(enc.encodeToString(cnt.getBytes())));
            } else if ("urlbase64".equals(param)) {
                Base64.Encoder enc = Base64.getUrlEncoder();
                result.add(new StringType(enc.encodeToString(cnt.getBytes())));
            }
        }
        return result;
    }

    private List<Base> funcDecode(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String param = nl.get(0).primitiveValue();
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String cnt = focus.get(0).primitiveValue();
            if ("hex".equals(param)) {
                result.add(new StringType(new String(FHIRPathEngine.hexStringToByteArray(cnt))));
            } else if ("base64".equals(param)) {
                Base64.Decoder enc = Base64.getDecoder();
                result.add(new StringType(new String(enc.decode(cnt))));
            } else if ("urlbase64".equals(param)) {
                Base64.Decoder enc = Base64.getUrlDecoder();
                result.add(new StringType(new String(enc.decode(cnt))));
            }
        }
        return result;
    }

    private List<Base> funcEscape(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String param = nl.get(0).primitiveValue();
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String cnt = focus.get(0).primitiveValue();
            if ("html".equals(param)) {
                result.add(new StringType(Utilities.escapeXml((String)cnt)));
            } else if ("json".equals(param)) {
                result.add(new StringType(Utilities.escapeJson((String)cnt)));
            } else if ("url".equals(param)) {
                result.add(new StringType(Utilities.URLEncode((String)cnt)));
            } else if ("md".equals(param)) {
                result.add(new StringType(MarkDownProcessor.makeStringSafeAsMarkdown((String)cnt)));
            }
        }
        return result;
    }

    private List<Base> funcUnescape(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String param = nl.get(0).primitiveValue();
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String cnt = focus.get(0).primitiveValue();
            if ("html".equals(param)) {
                result.add(new StringType(Utilities.unescapeXml((String)cnt)));
            } else if ("json".equals(param)) {
                result.add(new StringType(Utilities.unescapeJson((String)cnt)));
            } else if ("url".equals(param)) {
                result.add(new StringType(Utilities.URLDecode((String)cnt)));
            } else if ("md".equals(param)) {
                result.add(new StringType(MarkDownProcessor.makeMarkdownForString((String)cnt)));
            }
        }
        return result;
    }

    private List<Base> funcTrim(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String cnt = focus.get(0).primitiveValue();
            result.add(new StringType(cnt.trim()));
        }
        return result;
    }

    private List<Base> funcSplit(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String param = nl.get(0).primitiveValue();
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String[] sl;
            String cnt = focus.get(0).primitiveValue();
            for (String s : sl = Utilities.simpleSplit((String)cnt, (String)param)) {
                result.add(new StringType(s));
            }
        }
        return result;
    }

    private List<Base> funcJoin(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        List<Object> nl = exp.getParameters().size() > 0 ? this.execute(context, focus, exp.getParameters().get(0), true) : new ArrayList();
        String param = "";
        String param2 = "";
        if (exp.getParameters().size() > 0) {
            param2 = param = ((Base)nl.get(0)).primitiveValue();
            if (exp.getParameters().size() == 2) {
                nl = this.execute(context, focus, exp.getParameters().get(1), true);
                param2 = ((Base)nl.get(0)).primitiveValue();
            }
        }
        ArrayList<Base> result = new ArrayList<Base>();
        CommaSeparatedStringBuilder b = new CommaSeparatedStringBuilder(param, param2);
        for (Base i : focus) {
            b.append(i.primitiveValue());
        }
        result.add(new StringType(b.toString()));
        return result;
    }

    private List<Base> funcHtmlChecks1(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        if (focus.size() != 1) {
            return this.makeBoolean(false);
        }
        XhtmlNode x = focus.get(0).getXhtml();
        if (x == null) {
            return this.makeBoolean(false);
        }
        boolean ok = this.checkHtmlNames(x, true);
        if (ok && VersionUtilities.isR6Plus((String)this.worker.getVersion())) {
            ok = this.checkForContent(x);
        }
        return this.makeBoolean(ok);
    }

    private List<Base> funcHtmlChecks2(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        if (focus.size() != 1) {
            return this.makeBoolean(false);
        }
        XhtmlNode x = focus.get(0).getXhtml();
        if (x == null) {
            return this.makeBoolean(false);
        }
        return this.makeBoolean(this.checkForContent(x));
    }

    private boolean checkForContent(XhtmlNode x) {
        if (x.getNodeType() == NodeType.Text && !Utilities.noString((String)x.getContent().trim()) || x.getNodeType() == NodeType.Element && "img".equals(x.getName())) {
            return true;
        }
        for (XhtmlNode c : x.getChildNodes()) {
            if (!this.checkForContent(c)) continue;
            return true;
        }
        return false;
    }

    private List<Base> funcComparable(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        if (focus.size() != 1 || !focus.get(0).fhirType().equals("Quantity")) {
            return this.makeBoolean(false);
        }
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        if (nl.size() != 1 || !nl.get(0).fhirType().equals("Quantity")) {
            return this.makeBoolean(false);
        }
        String s1 = this.getNamedValue(focus.get(0), "system");
        String u1 = this.getNamedValue(focus.get(0), "code");
        String s2 = this.getNamedValue(nl.get(0), "system");
        String u2 = this.getNamedValue(nl.get(0), "code");
        if (s1 == null || s2 == null || !s1.equals(s2)) {
            return this.makeBoolean(false);
        }
        if (u1 == null || u2 == null) {
            return this.makeBoolean(false);
        }
        if (u1.equals(u2)) {
            return this.makeBoolean(true);
        }
        if (s1.equals("http://unitsofmeasure.org") && this.worker.getUcumService() != null) {
            try {
                return this.makeBoolean(this.worker.getUcumService().isComparable(u1, u2));
            }
            catch (UcumException e) {
                return this.makeBoolean(false);
            }
        }
        return this.makeBoolean(false);
    }

    private String getNamedValue(Base base, String name) {
        Property p = base.getChildByName(name);
        if (p.hasValues() && p.getValues().size() == 1) {
            return p.getValues().get(0).primitiveValue();
        }
        return null;
    }

    private boolean checkHtmlNames(XhtmlNode node, boolean block) {
        if (node.getNodeType() == NodeType.Comment && node.getContent().startsWith("DOCTYPE")) {
            return false;
        }
        if (node.getNodeType() == NodeType.Element) {
            if (block ? !Utilities.existsInList((String)node.getName(), (String[])new String[]{"p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area"}) : !Utilities.existsInList((String)node.getName(), (String[])new String[]{"a", "span", "b", "em", "i", "strong", "small", "big", "small", "q", "var", "abbr", "acronym", "cite", "kbd", "q", "sub", "sup", "code", "samp", "img", "map", "area"})) {
                return false;
            }
            for (String an : node.getAttributes().keySet()) {
                boolean ok = an.startsWith("xmlns") || Utilities.existsInList((String)an, (String[])new String[]{"title", "style", "class", "id", "idref", "lang", "xml:lang", "xml:space", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan"}) || Utilities.existsInList((String)(node.getName() + "." + an), (String[])new String[]{"a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap"});
                if (ok) continue;
                return false;
            }
            for (XhtmlNode c : node.getChildNodes()) {
                if (this.checkHtmlNames(c, block && !"p".equals(c))) continue;
                return false;
            }
        }
        return true;
    }

    private List<Base> funcAll(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (exp.getParameters().size() == 1) {
            ArrayList<Base> pc = new ArrayList<Base>();
            boolean all = true;
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                Equality eq = this.asBool(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), true), exp);
                if (eq == Equality.True) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        } else {
            boolean all = true;
            for (Base item : focus) {
                Equality eq = this.asBool(item, true);
                if (eq == Equality.True) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        }
        return result;
    }

    private ExecutionContext changeThis(ExecutionContext context, Base newThis) {
        ExecutionContext newContext = new ExecutionContext(context.appInfo, context.focusResource, context.rootResource, context.context, newThis);
        if (context.definedVariables != null) {
            for (String s : context.definedVariables.keySet()) {
                newContext.setDefinedVariable(s, context.definedVariables.get(s));
            }
        }
        return newContext;
    }

    private ExecutionContext contextForParameter(ExecutionContext context) {
        ExecutionContext newContext = new ExecutionContext(context.appInfo, context.focusResource, context.rootResource, context.context, context.thisItem);
        newContext.total = context.total;
        newContext.index = context.index;
        if (context.definedVariables != null) {
            for (String s : context.definedVariables.keySet()) {
                newContext.setDefinedVariable(s, context.definedVariables.get(s));
            }
        }
        return newContext;
    }

    private ExecutionTypeContext changeThis(ExecutionTypeContext context, TypeDetails newThis) {
        ExecutionTypeContext newContext = new ExecutionTypeContext(context.appInfo, context.resource, context.context, newThis);
        if (context.definedVariables != null) {
            for (String s : context.definedVariables.keySet()) {
                newContext.setDefinedVariable(s, context.definedVariables.get(s));
            }
        }
        return newContext;
    }

    private ExecutionTypeContext contextForParameter(ExecutionTypeContext context) {
        ExecutionTypeContext newContext = new ExecutionTypeContext(context.appInfo, context.resource, context.context, context.thisItem);
        if (context.definedVariables != null) {
            for (String s : context.definedVariables.keySet()) {
                newContext.setDefinedVariable(s, context.definedVariables.get(s));
            }
        }
        return newContext;
    }

    private List<Base> funcNow(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(DateTimeType.now());
        return result;
    }

    private List<Base> funcToday(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new DateType(new Date(), TemporalPrecisionEnum.DAY));
        return result;
    }

    private List<Base> funcMemberOf(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ValueSet vs;
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        if (nl.size() != 1 || focus.size() != 1) {
            return new ArrayList<Base>();
        }
        String url = nl.get(0).primitiveValue();
        ValueSet valueSet = vs = this.hostServices != null ? this.hostServices.resolveValueSet(this, context.appInfo, url) : this.worker.findTxResource(ValueSet.class, url);
        if (vs == null) {
            return new ArrayList<Base>();
        }
        Base l = focus.get(0);
        if (Utilities.existsInList((String)l.fhirType(), (String[])new String[]{"code", "string", "uri"})) {
            return this.makeBoolean(this.worker.validateCode(this.terminologyServiceOptions.withGuessSystem(), TypeConvertor.castToCoding(l), vs).isOk());
        }
        if (l.fhirType().equals("Coding")) {
            return this.makeBoolean(this.worker.validateCode(this.terminologyServiceOptions, TypeConvertor.castToCoding(l), vs).isOk());
        }
        if (l.fhirType().equals("CodeableConcept")) {
            return this.makeBoolean(this.worker.validateCode(this.terminologyServiceOptions, TypeConvertor.castToCodeableConcept(l), vs).isOk());
        }
        return new ArrayList<Base>();
    }

    private List<Base> funcDescendants(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> current = new ArrayList<Base>();
        current.addAll(focus);
        ArrayList<Base> added = new ArrayList<Base>();
        boolean more = true;
        while (more) {
            added.clear();
            for (Base item : current) {
                this.getChildrenByName(item, "*", added);
            }
            more = !added.isEmpty();
            result.addAll(added);
            current.clear();
            current.addAll(added);
        }
        return result;
    }

    private List<Base> funcChildren(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base b : focus) {
            this.getChildrenByName(b, "*", result);
        }
        return result;
    }

    private List<Base> funcReplace(ExecutionContext context, List<Base> focus, ExpressionNode expr) throws FHIRException, PathEngineException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> tB = this.execute(context, focus, expr.getParameters().get(0), true);
        String t = this.convertToString(tB);
        List<Base> rB = this.execute(context, focus, expr.getParameters().get(1), true);
        String r = this.convertToString(rB);
        if (focus.size() != 0 && tB.size() != 0 && rB.size() != 0) {
            if (focus.size() == 1) {
                if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                    String f = this.convertToString(focus.get(0));
                    if (Utilities.noString((String)f)) {
                        result.add(new StringType(""));
                    } else {
                        String n = f.replace(t, r);
                        result.add(new StringType(n));
                    }
                }
            } else {
                throw this.makeException(expr, "FHIRPATH_NO_COLLECTION", "replace", focus.size());
            }
        }
        return result;
    }

    private List<Base> funcReplaceMatches(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> regexB = this.execute(context, focus, exp.getParameters().get(0), true);
        String regex = this.convertToString(regexB);
        List<Base> replB = this.execute(context, focus, exp.getParameters().get(1), true);
        String repl = this.convertToString(replB);
        if (focus.size() != 0 && regexB.size() != 0 && replB.size() != 0) {
            if (focus.size() == 1 && !Utilities.noString((String)regex)) {
                if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                    result.add(new StringType(this.convertToString(focus.get(0)).replaceAll(regex, repl)).noExtensions());
                }
            } else {
                result.add(new StringType(this.convertToString(focus.get(0))).noExtensions());
            }
        }
        return result;
    }

    private List<Base> funcEndsWith(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, focus, exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        if (focus.size() != 0 && swb.size() != 0) {
            if (Utilities.noString((String)sw)) {
                result.add(new BooleanType(true).noExtensions());
            } else if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                if (focus.size() == 1 && !Utilities.noString((String)sw)) {
                    result.add(new BooleanType(this.convertToString(focus.get(0)).endsWith(sw)).noExtensions());
                } else {
                    result.add(new BooleanType(false).noExtensions());
                }
            }
        }
        return result;
    }

    private List<Base> funcToString(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new StringType(this.convertToString(focus)).noExtensions());
        return result;
    }

    private List<Base> funcToBoolean(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            if (focus.get(0) instanceof BooleanType) {
                result.add(focus.get(0));
            } else if (focus.get(0) instanceof IntegerType) {
                int i = Integer.parseInt(focus.get(0).primitiveValue());
                if (i == 0) {
                    result.add(new BooleanType(false).noExtensions());
                } else if (i == 1) {
                    result.add(new BooleanType(true).noExtensions());
                }
            } else if (focus.get(0) instanceof DecimalType) {
                if (((BigDecimal)((DecimalType)focus.get(0)).getValue()).compareTo(BigDecimal.ZERO) == 0) {
                    result.add(new BooleanType(false).noExtensions());
                } else if (((BigDecimal)((DecimalType)focus.get(0)).getValue()).compareTo(BigDecimal.ONE) == 0) {
                    result.add(new BooleanType(true).noExtensions());
                }
            } else if (focus.get(0) instanceof StringType) {
                if ("true".equalsIgnoreCase(focus.get(0).primitiveValue())) {
                    result.add(new BooleanType(true).noExtensions());
                } else if ("false".equalsIgnoreCase(focus.get(0).primitiveValue())) {
                    result.add(new BooleanType(false).noExtensions());
                }
            }
        }
        return result;
    }

    private List<Base> funcToQuantity(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            if (focus.get(0) instanceof Quantity) {
                result.add(focus.get(0));
            } else if (focus.get(0) instanceof StringType) {
                Quantity q = this.parseQuantityString(focus.get(0).primitiveValue());
                if (q != null) {
                    result.add(q.noExtensions());
                }
            } else if (focus.get(0) instanceof IntegerType) {
                result.add(new Quantity().setValue(new BigDecimal(focus.get(0).primitiveValue())).setSystem("http://unitsofmeasure.org").setCode("1").noExtensions());
            } else if (focus.get(0) instanceof DecimalType) {
                result.add(new Quantity().setValue(new BigDecimal(focus.get(0).primitiveValue())).setSystem("http://unitsofmeasure.org").setCode("1").noExtensions());
            }
        }
        return result;
    }

    private List<Base> funcToDateTime(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        throw this.makeException(expr, "FHIRPATH_NOT_IMPLEMENTED", "toDateTime");
    }

    private List<Base> funcToTime(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        throw this.makeException(expr, "FHIRPATH_NOT_IMPLEMENTED", "toTime");
    }

    private List<Base> funcToDecimal(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        String s = this.convertToString(focus);
        ArrayList<Base> result = new ArrayList<Base>();
        if (Utilities.isDecimal((String)s, (boolean)true)) {
            result.add(new DecimalType(s).noExtensions());
        }
        if ("true".equals(s)) {
            result.add(new DecimalType(1L).noExtensions());
        }
        if ("false".equals(s)) {
            result.add(new DecimalType(0L).noExtensions());
        }
        return result;
    }

    private List<Base> funcIif(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        if (focus.size() > 1) {
            throw this.makeException(exp, "FHIRPATH_NO_COLLECTION", "iif", focus.size());
        }
        List<Base> n1 = this.execute(focus.isEmpty() ? context : this.changeThis(context, focus.get(0)), focus, exp.getParameters().get(0), true);
        Equality v = this.asBool(n1, exp);
        if (v == Equality.True) {
            return this.execute(context, focus, exp.getParameters().get(1), true);
        }
        if (exp.getParameters().size() < 3) {
            return new ArrayList<Base>();
        }
        return this.execute(context, focus, exp.getParameters().get(2), true);
    }

    private List<Base> funcTake(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 0; i < Math.min(focus.size(), i1); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcUnion(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : focus) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        for (Base item : this.execute(context, this.baseToList(context.thisItem), exp.getParameters().get(0), true)) {
            if (this.doContains(result, item)) continue;
            result.add(item);
        }
        return result;
    }

    private List<Base> funcCombine(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : focus) {
            result.add(item);
        }
        for (Base item : this.execute(context, this.baseToList(context.thisItem), exp.getParameters().get(0), true)) {
            result.add(item);
        }
        return result;
    }

    private List<Base> funcIntersect(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> other = this.execute(context, this.baseToList(context.thisItem), exp.getParameters().get(0), true);
        for (Base item : focus) {
            if (this.doContains(result, item) || !this.doContains(other, item)) continue;
            result.add(item);
        }
        return result;
    }

    private List<Base> funcExclude(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> other = this.execute(context, focus, exp.getParameters().get(0), true);
        for (Base item : focus) {
            if (this.doContains(other, item)) continue;
            result.add(item);
        }
        return result;
    }

    private List<Base> funcSingle(ExecutionContext context, List<Base> focus, ExpressionNode expr) throws PathEngineException {
        if (focus.size() == 1) {
            return focus;
        }
        throw this.makeException(expr, "FHIRPATH_NO_COLLECTION", "single", focus.size());
    }

    private List<Base> funcIs(ExecutionContext context, List<Base> focus, ExpressionNode expr) throws PathEngineException {
        if (focus.size() == 0 || focus.size() > 1) {
            return this.makeNull();
        }
        String ns = null;
        String n = null;
        ExpressionNode texp = expr.getParameters().get(0);
        if (texp.getKind() != ExpressionNode.Kind.Name) {
            throw this.makeException(expr, "FHIRPATH_PARAM_WRONG", new Object[]{texp.getKind(), "0", "is"});
        }
        if (texp.getInner() != null) {
            if (texp.getInner().getKind() != ExpressionNode.Kind.Name) {
                throw this.makeException(expr, "FHIRPATH_PARAM_WRONG", new Object[]{texp.getKind(), "1", "is"});
            }
            ns = texp.getName();
            n = texp.getInner().getName();
        } else if (Utilities.existsInList((String)texp.getName(), (String[])new String[]{"Boolean", "Integer", "Decimal", "String", "DateTime", "Date", "Time", "SimpleTypeInfo", "ClassInfo"})) {
            ns = "System";
            n = texp.getName();
        } else {
            ns = "FHIR";
            n = texp.getName();
        }
        if (ns.equals("System")) {
            if (focus.get(0) instanceof Resource) {
                return this.makeBoolean(false);
            }
            if (!(focus.get(0) instanceof Element) || ((Element)focus.get(0)).isDisallowExtensions()) {
                String t = Utilities.capitalize((String)focus.get(0).fhirType());
                if (n.equals(t)) {
                    return this.makeBoolean(true);
                }
                if ("Date".equals(t) && n.equals("DateTime")) {
                    return this.makeBoolean(true);
                }
                return this.makeBoolean(false);
            }
            return this.makeBoolean(false);
        }
        if (ns.equals("FHIR")) {
            if (n.equals(focus.get(0).fhirType())) {
                return this.makeBoolean(true);
            }
            StructureDefinition sd = this.worker.fetchTypeDefinition(focus.get(0).fhirType());
            while (sd != null) {
                if (n.equals(sd.getType())) {
                    return this.makeBoolean(true);
                }
                sd = this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
            }
            return this.makeBoolean(false);
        }
        return this.makeBoolean(false);
    }

    private List<Base> funcAs(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        ArrayList<Base> result = new ArrayList<Base>();
        String tn = expr.getParameters().get(0).getInner() != null ? expr.getParameters().get(0).getName() + "." + expr.getParameters().get(0).getInner().getName() : "FHIR." + expr.getParameters().get(0).getName();
        if (!this.isKnownType(tn)) {
            throw new PathEngineException(this.worker.formatMessage("FHIRPATH_INVALID_TYPE", tn), "FHIRPATH_INVALID_TYPE");
        }
        if (!this.doNotEnforceAsSingletonRule && focus.size() > 1) {
            throw new PathEngineException(this.worker.formatMessage("FHIRPATH_AS_COLLECTION", focus.size(), expr.toString()), "FHIRPATH_AS_COLLECTION");
        }
        block0: for (Base b : focus) {
            if (tn.startsWith("System.")) {
                if (!(b instanceof Element) || !((Element)b).isDisallowExtensions() || !b.hasType(tn.substring(7))) continue;
                result.add(b);
                continue;
            }
            if (!tn.startsWith("FHIR.")) continue;
            String tnp = tn.substring(5);
            if (b.fhirType().equals(tnp)) {
                result.add(b);
                continue;
            }
            StructureDefinition sd = this.worker.fetchTypeDefinition(b.fhirType());
            while (sd != null) {
                if (this.compareTypeNames(tnp, sd.getType())) {
                    result.add(b);
                    continue block0;
                }
                sd = sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE ? null : this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
            }
        }
        return result;
    }

    private List<Base> funcOfType(ExecutionContext context, List<Base> focus, ExpressionNode expr) {
        ArrayList<Base> result = new ArrayList<Base>();
        String tn = expr.getParameters().get(0).getInner() != null ? expr.getParameters().get(0).getName() + "." + expr.getParameters().get(0).getInner().getName() : "FHIR." + expr.getParameters().get(0).getName();
        if (!this.isKnownType(tn)) {
            throw new PathEngineException(this.worker.formatMessage("FHIRPATH_INVALID_TYPE", tn), "FHIRPATH_INVALID_TYPE");
        }
        block0: for (Base b : focus) {
            StructureDefinition sd;
            String tnp;
            if (tn.startsWith("System.")) {
                if (!(b instanceof Element) || !((Element)b).isDisallowExtensions() || !b.hasType(tn.substring(7))) continue;
                result.add(b);
                continue;
            }
            if (tn.startsWith("FHIR.")) {
                tnp = tn.substring(5);
                if (b.fhirType().equals(tnp)) {
                    result.add(b);
                    continue;
                }
                sd = this.worker.fetchTypeDefinition(b.fhirType());
                while (sd != null) {
                    if (tnp.equals(sd.getType())) {
                        result.add(b);
                        continue block0;
                    }
                    sd = sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE ? null : this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
                }
                continue;
            }
            if (!tn.startsWith("CDA.")) continue;
            tnp = Utilities.pathURL((String[])new String[]{"http://hl7.org/cda/stds/core", "StructureDefinition", tn.substring(4)});
            if (b.fhirType().equals(tnp)) {
                result.add(b);
                continue;
            }
            sd = this.worker.fetchTypeDefinition(b.fhirType());
            while (sd != null) {
                if (tnp.equals(sd.getType())) {
                    result.add(b);
                    continue block0;
                }
                sd = sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE ? null : this.worker.fetchResource(StructureDefinition.class, sd.getBaseDefinition(), sd);
            }
        }
        return result;
    }

    private List<Base> funcType(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (Base item : focus) {
            result.add(new FHIRPathUtilityClasses.ClassTypeInfo(item));
        }
        return result;
    }

    private List<Base> funcRepeat(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> current = new ArrayList<Base>();
        current.addAll(focus);
        ArrayList<Base> added = new ArrayList<Base>();
        boolean more = true;
        while (more) {
            added.clear();
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : current) {
                pc.clear();
                pc.add(item);
                added.addAll(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), false));
            }
            more = false;
            current.clear();
            for (Base b : added) {
                boolean isnew = true;
                for (Base t : result) {
                    if (!b.equalsDeep(t)) continue;
                    isnew = false;
                }
                if (!isnew) continue;
                result.add(b);
                current.add(b);
                more = true;
            }
        }
        return result;
    }

    private List<Base> funcAggregate(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Object> total = new ArrayList();
        if (exp.parameterCount() > 1) {
            total = this.execute(context, focus, exp.getParameters().get(1), false);
        }
        ArrayList<Base> pc = new ArrayList<Base>();
        for (Base item : focus) {
            ExecutionContext c = this.changeThis(context, item);
            c.total = total;
            c.next();
            total = this.execute(c, pc, exp.getParameters().get(0), true);
        }
        return total;
    }

    private List<Base> funcIsDistinct(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        if (focus.size() < 1) {
            return this.makeBoolean(true);
        }
        if (focus.size() == 1) {
            return this.makeBoolean(true);
        }
        boolean distinct = true;
        block0: for (int i = 0; i < focus.size(); ++i) {
            for (int j = i + 1; j < focus.size(); ++j) {
                Boolean eq = this.doEquals(focus.get(j), focus.get(i));
                if (eq == null) {
                    return new ArrayList<Base>();
                }
                if (!eq.booleanValue()) continue;
                distinct = false;
                continue block0;
            }
        }
        return this.makeBoolean(distinct);
    }

    private List<Base> funcSupersetOf(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> target = this.execute(context, focus, exp.getParameters().get(0), true);
        boolean valid = true;
        for (Base item : target) {
            boolean found = false;
            for (Base t : focus) {
                if (!Base.compareDeep(item, t, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valid = false;
            break;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(valid).noExtensions());
        return result;
    }

    private List<Base> funcSubsetOf(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> target = this.execute(context, focus, exp.getParameters().get(0), true);
        boolean valid = true;
        for (Base item : focus) {
            boolean found = false;
            for (Base t : target) {
                if (!Base.compareDeep(item, t, false)) continue;
                found = true;
                break;
            }
            if (found) continue;
            valid = false;
            break;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(valid).noExtensions());
        return result;
    }

    private List<Base> funcExists(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        boolean empty = true;
        ArrayList<Base> pc = new ArrayList<Base>();
        for (Base f : focus) {
            if (exp.getParameters().size() == 1) {
                pc.clear();
                pc.add(f);
                Equality v = this.asBool(this.execute(this.changeThis(context, f), pc, exp.getParameters().get(0), true), exp);
                if (v != Equality.True) continue;
                empty = false;
                continue;
            }
            if (f.isEmpty()) continue;
            empty = false;
        }
        result.add(new BooleanType(!empty).noExtensions());
        return result;
    }

    private List<Base> funcResolve(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        Base refContext = null;
        for (Base item : focus) {
            String s = this.convertToString(item);
            if (item.fhirType().equals("Reference")) {
                refContext = item;
                Property p = item.getChildByName("reference");
                s = p != null && p.hasValues() ? this.convertToString(p.getValues().get(0)) : null;
            }
            if (item.fhirType().equals("canonical")) {
                s = item.primitiveValue();
                refContext = item;
            }
            if (s == null) continue;
            Base res = null;
            if (s.startsWith("#")) {
                String t = s.substring(1);
                Property p = context.rootResource.getChildByName("contained");
                if (p != null) {
                    for (Base c : p.getValues()) {
                        if (!t.equals(c.getIdBase())) continue;
                        res = c;
                        break;
                    }
                }
            } else if (this.hostServices != null) {
                try {
                    res = this.hostServices.resolveReference(this, context.appInfo, s, refContext);
                }
                catch (Exception e) {
                    res = null;
                }
            }
            if (res == null) continue;
            result.add(res);
        }
        return result;
    }

    private List<Base> funcExtension(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String url = nl.get(0).primitiveValue();
        for (Base item : focus) {
            ArrayList<Base> ext = new ArrayList<Base>();
            this.getChildrenByName(item, "extension", ext);
            this.getChildrenByName(item, "modifierExtension", ext);
            for (Base ex : ext) {
                ArrayList<Base> vl = new ArrayList<Base>();
                this.getChildrenByName(ex, "url", vl);
                if (!this.convertToString(vl).equals(url)) continue;
                result.add(ex);
            }
        }
        return result;
    }

    private List<Base> funcAllFalse(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (exp.getParameters().size() == 1) {
            boolean all = true;
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                List<Base> res = this.execute(context, pc, exp.getParameters().get(0), true);
                Equality v = this.asBool(res, exp);
                if (v == Equality.False) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        } else {
            boolean all = true;
            for (Base item : focus) {
                if (!this.canConvertToBoolean(item)) {
                    throw new FHIRException("Unable to convert '" + this.convertToString(item) + "' to a boolean");
                }
                Equality v = this.asBool(item, true);
                if (v == Equality.False) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        }
        return result;
    }

    private List<Base> funcAnyFalse(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (exp.getParameters().size() == 1) {
            boolean any = false;
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                List<Base> res = this.execute(context, pc, exp.getParameters().get(0), true);
                Equality v = this.asBool(res, exp);
                if (v != Equality.False) continue;
                any = true;
                break;
            }
            result.add(new BooleanType(any).noExtensions());
        } else {
            boolean any = false;
            for (Base item : focus) {
                if (!this.canConvertToBoolean(item)) {
                    throw new FHIRException("Unable to convert '" + this.convertToString(item) + "' to a boolean");
                }
                Equality v = this.asBool(item, true);
                if (v != Equality.False) continue;
                any = true;
                break;
            }
            result.add(new BooleanType(any).noExtensions());
        }
        return result;
    }

    private List<Base> funcAllTrue(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (exp.getParameters().size() == 1) {
            boolean all = true;
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                List<Base> res = this.execute(context, pc, exp.getParameters().get(0), true);
                Equality v = this.asBool(res, exp);
                if (v == Equality.True) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        } else {
            boolean all = true;
            for (Base item : focus) {
                if (!this.canConvertToBoolean(item)) {
                    throw new FHIRException("Unable to convert '" + this.convertToString(item) + "' to a boolean");
                }
                Equality v = this.asBool(item, true);
                if (v == Equality.True) continue;
                all = false;
                break;
            }
            result.add(new BooleanType(all).noExtensions());
        }
        return result;
    }

    private List<Base> funcAnyTrue(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (exp.getParameters().size() == 1) {
            boolean any = false;
            ArrayList<Base> pc = new ArrayList<Base>();
            for (Base item : focus) {
                pc.clear();
                pc.add(item);
                List<Base> res = this.execute(context, pc, exp.getParameters().get(0), true);
                Equality v = this.asBool(res, exp);
                if (v != Equality.True) continue;
                any = true;
                break;
            }
            result.add(new BooleanType(any).noExtensions());
        } else {
            boolean any = false;
            for (Base item : focus) {
                if (!this.canConvertToBoolean(item)) {
                    throw new FHIRException("Unable to convert '" + this.convertToString(item) + "' to a boolean");
                }
                Equality v = this.asBool(item, true);
                if (v != Equality.True) continue;
                any = true;
                break;
            }
            result.add(new BooleanType(any).noExtensions());
        }
        return result;
    }

    private boolean canConvertToBoolean(Base item) {
        return item.isBooleanPrimitive();
    }

    private List<Base> funcTrace(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String name = nl.get(0).primitiveValue();
        if (exp.getParameters().size() == 2) {
            List<Base> n2 = this.execute(context, focus, exp.getParameters().get(1), true);
            this.log(name, n2);
        } else {
            this.log(name, focus);
        }
        return focus;
    }

    private List<Base> funcDefineVariable(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> nl = this.execute(context, focus, exp.getParameters().get(0), true);
        String name = nl.get(0).primitiveValue();
        List<Base> value = exp.getParameters().size() == 2 ? this.execute(context, focus, exp.getParameters().get(1), true) : focus;
        context.setDefinedVariable(name, value);
        return focus;
    }

    private List<Base> funcCheck(ExecutionContext context, List<Base> focus, ExpressionNode expr) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, expr.getParameters().get(0), true);
        if (!this.convertToBoolean(n1)) {
            List<Base> n2 = this.execute(context, focus, expr.getParameters().get(1), true);
            String name = n2.get(0).primitiveValue();
            throw this.makeException(expr, "FHIRPATH_CHECK_FAILED", name);
        }
        return focus;
    }

    private List<Base> funcDistinct(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        if (focus.size() <= 1) {
            return focus;
        }
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 0; i < focus.size(); ++i) {
            boolean found = false;
            for (int j = i + 1; j < focus.size(); ++j) {
                Boolean eq = this.doEquals(focus.get(j), focus.get(i));
                if (eq == null) {
                    return new ArrayList<Base>();
                }
                if (!eq.booleanValue()) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcMatches(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, focus, exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        if (focus.size() != 0 && swb.size() != 0) {
            if (focus.size() == 1 && !Utilities.noString((String)sw)) {
                if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                    String st = this.convertToString(focus.get(0));
                    if (Utilities.noString((String)st)) {
                        result.add(new BooleanType(false).noExtensions());
                    } else {
                        Pattern p = Pattern.compile("(?s)" + sw);
                        Matcher m = p.matcher(st);
                        boolean ok = m.find();
                        result.add(new BooleanType(ok).noExtensions());
                    }
                }
            } else {
                result.add(new BooleanType(false).noExtensions());
            }
        }
        return result;
    }

    private List<Base> funcMatchesFull(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String sw = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (focus.size() == 1 && !Utilities.noString((String)sw)) {
            if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                String st = this.convertToString(focus.get(0));
                if (Utilities.noString((String)st)) {
                    result.add(new BooleanType(false).noExtensions());
                } else {
                    Pattern p = Pattern.compile("(?s)" + sw);
                    Matcher m = p.matcher(st);
                    boolean ok = m.matches();
                    result.add(new BooleanType(ok).noExtensions());
                }
            }
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcContains(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, this.baseToList(context.thisItem), exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        if (focus.size() == 1 && swb.size() == 1) {
            if (Utilities.noString((String)sw)) {
                result.add(new BooleanType(true).noExtensions());
            } else if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                String st = this.convertToString(focus.get(0));
                if (Utilities.noString((String)st)) {
                    result.add(new BooleanType(false).noExtensions());
                } else {
                    result.add(new BooleanType(st.contains(sw)).noExtensions());
                }
            }
        }
        return result;
    }

    private List<Base> baseToList(Base b) {
        ArrayList<Base> res = new ArrayList<Base>();
        res.add(b);
        return res;
    }

    private List<Base> funcLength(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1 && (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion)) {
            String s = this.convertToString(focus.get(0));
            result.add(new IntegerType(s.length()).noExtensions());
        }
        return result;
    }

    private List<Base> funcHasValue(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1) {
            String s = this.convertToString(focus.get(0));
            result.add(new BooleanType(!Utilities.noString((String)s)).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcStartsWith(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, focus, exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        if (focus.size() != 0 && swb.size() != 0) {
            if (Utilities.noString((String)sw)) {
                result.add(new BooleanType(true).noExtensions());
            } else if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                String s = this.convertToString(focus.get(0));
                if (s == null) {
                    result.add(new BooleanType(false).noExtensions());
                } else {
                    result.add(new BooleanType(s.startsWith(sw)).noExtensions());
                }
            }
        }
        return result;
    }

    private List<Base> funcLower(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        String s;
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1 && (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) && !Utilities.noString((String)(s = this.convertToString(focus.get(0))))) {
            result.add(new StringType(s.toLowerCase()).noExtensions());
        }
        return result;
    }

    private List<Base> funcUpper(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        String s;
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1 && (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) && !Utilities.noString((String)(s = this.convertToString(focus.get(0))))) {
            result.add(new StringType(s.toUpperCase()).noExtensions());
        }
        return result;
    }

    private List<Base> funcToChars(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() == 1 && (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion)) {
            String s = this.convertToString(focus.get(0));
            for (char c : s.toCharArray()) {
                result.add(new StringType(String.valueOf(c)).noExtensions());
            }
        }
        return result;
    }

    private List<Base> funcIndexOf(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> swb = this.execute(context, focus, exp.getParameters().get(0), true);
        String sw = this.convertToString(swb);
        if (focus.size() != 0 && swb.size() != 0) {
            if (Utilities.noString((String)sw)) {
                result.add(new IntegerType(0).noExtensions());
            } else if (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion) {
                String s = this.convertToString(focus.get(0));
                if (s == null) {
                    result.add(new IntegerType(0).noExtensions());
                } else {
                    result.add(new IntegerType(s.indexOf(sw)).noExtensions());
                }
            }
        }
        return result;
    }

    private List<Base> funcSubstring(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        int i2 = -1;
        if (exp.parameterCount() == 2) {
            List<Base> n2 = this.execute(context, focus, exp.getParameters().get(1), true);
            if (n2.isEmpty() || !n2.get(0).isPrimitive() || !Utilities.isInteger((String)n2.get(0).primitiveValue())) {
                return new ArrayList<Base>();
            }
            i2 = Integer.parseInt(n2.get(0).primitiveValue());
        }
        if (focus.size() == 1 && (focus.get(0).hasType(FHIR_TYPES_STRING) || this.doImplicitStringConversion)) {
            String sw = this.convertToString(focus.get(0));
            if (i1 < 0 || i1 >= sw.length()) {
                return new ArrayList<Base>();
            }
            String s = exp.parameterCount() == 2 ? sw.substring(i1, Math.min(sw.length(), i1 + i2)) : sw.substring(i1);
            if (!Utilities.noString((String)s)) {
                result.add(new StringType(s).noExtensions());
            }
        }
        return result;
    }

    private List<Base> funcToInteger(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        String s = this.convertToString(focus);
        ArrayList<Base> result = new ArrayList<Base>();
        if (Utilities.isInteger((String)s)) {
            result.add(new IntegerType(s).noExtensions());
        } else if ("true".equals(s)) {
            result.add(new IntegerType(1).noExtensions());
        } else if ("false".equals(s)) {
            result.add(new IntegerType(0).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsInteger(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof IntegerType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof BooleanType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(Utilities.isInteger((String)this.convertToString(focus.get(0)))).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsBoolean(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof IntegerType) {
            result.add(new BooleanType((Integer)((IntegerType)focus.get(0)).getValue() >= 0 && (Integer)((IntegerType)focus.get(0)).getValue() <= 1).noExtensions());
        } else if (focus.get(0) instanceof DecimalType) {
            result.add(new BooleanType(((BigDecimal)((DecimalType)focus.get(0)).getValue()).compareTo(BigDecimal.ZERO) == 0 || ((BigDecimal)((DecimalType)focus.get(0)).getValue()).compareTo(BigDecimal.ONE) == 0).noExtensions());
        } else if (focus.get(0) instanceof BooleanType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(Utilities.existsInList((String)this.convertToString(focus.get(0)).toLowerCase(), (String[])new String[]{"true", "false"})).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsDateTime(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof DateTimeType || focus.get(0) instanceof DateType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(this.convertToString(focus.get(0)).matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3])(:[0-5][0-9](:([0-5][0-9]|60))?)?(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?")).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsDate(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof DateTimeType || focus.get(0) instanceof DateType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(this.convertToString(focus.get(0)).matches("([0-9]([0-9]([0-9][1-9]|[1-9]0)|[1-9]00)|[1-9]000)(-(0[1-9]|1[0-2])(-(0[1-9]|[1-2][0-9]|3[0-1])(T([01][0-9]|2[0-3])(:[0-5][0-9](:([0-5][0-9]|60))?)?(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?)?)?)?")).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcConformsTo(ExecutionContext context, List<Base> focus, ExpressionNode expr) throws FHIRException {
        if (this.hostServices == null) {
            throw this.makeException(expr, "FHIRPATH_HO_HOST_SERVICES", "conformsTo");
        }
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else {
            String url = this.convertToString(this.execute(context, focus, expr.getParameters().get(0), true));
            result.add(new BooleanType(this.hostServices.conformsToProfile(this, context.appInfo, focus.get(0), url)).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsTime(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof TimeType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(this.convertToString(focus.get(0)).matches("(T)?([01][0-9]|2[0-3])(:[0-5][0-9](:([0-5][0-9]|60))?)?(\\.[0-9]+)?(Z|(\\+|-)((0[0-9]|1[0-3]):[0-5][0-9]|14:00))?")).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsString(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (!(focus.get(0) instanceof DateTimeType) && !(focus.get(0) instanceof TimeType)) {
            result.add(new BooleanType(true).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcIsQuantity(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof IntegerType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof DecimalType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof Quantity) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof BooleanType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            Quantity q = this.parseQuantityString(focus.get(0).primitiveValue());
            result.add(new BooleanType(q != null).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    public Quantity parseQuantityString(String s) {
        if (s == null) {
            return null;
        }
        if ((s = s.trim()).contains(" ")) {
            String v = s.substring(0, s.indexOf(" ")).trim();
            s = s.substring(s.indexOf(" ")).trim();
            if (!Utilities.isDecimal((String)v, (boolean)false)) {
                return null;
            }
            if (s.startsWith("'") && s.endsWith("'")) {
                return Quantity.fromUcum(v, s.substring(1, s.length() - 1));
            }
            if (s.equals("year") || s.equals("years")) {
                return Quantity.fromUcum(v, "a");
            }
            if (s.equals("month") || s.equals("months")) {
                return Quantity.fromUcum(v, "mo_s");
            }
            if (s.equals("week") || s.equals("weeks")) {
                return Quantity.fromUcum(v, "wk");
            }
            if (s.equals("day") || s.equals("days")) {
                return Quantity.fromUcum(v, "d");
            }
            if (s.equals("hour") || s.equals("hours")) {
                return Quantity.fromUcum(v, "h");
            }
            if (s.equals("minute") || s.equals("minutes")) {
                return Quantity.fromUcum(v, "min");
            }
            if (s.equals("second") || s.equals("seconds")) {
                return Quantity.fromUcum(v, "s");
            }
            if (s.equals("millisecond") || s.equals("milliseconds")) {
                return Quantity.fromUcum(v, "ms");
            }
            return null;
        }
        if (Utilities.isDecimal((String)s, (boolean)true)) {
            return new Quantity().setValue(new BigDecimal(s)).setSystem("http://unitsofmeasure.org").setCode("1");
        }
        return null;
    }

    private List<Base> funcIsDecimal(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() != 1) {
            result.add(new BooleanType(false).noExtensions());
        } else if (focus.get(0) instanceof IntegerType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof BooleanType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof DecimalType) {
            result.add(new BooleanType(true).noExtensions());
        } else if (focus.get(0) instanceof StringType) {
            result.add(new BooleanType(Utilities.isDecimal((String)this.convertToString(focus.get(0)), (boolean)true)).noExtensions());
        } else {
            result.add(new BooleanType(false).noExtensions());
        }
        return result;
    }

    private List<Base> funcCount(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new IntegerType(focus.size()).noExtensions());
        return result;
    }

    private List<Base> funcSkip(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        List<Base> n1 = this.execute(context, focus, exp.getParameters().get(0), true);
        int i1 = Integer.parseInt(n1.get(0).primitiveValue());
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = i1; i < focus.size(); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcTail(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        for (int i = 1; i < focus.size(); ++i) {
            result.add(focus.get(i));
        }
        return result;
    }

    private List<Base> funcLast(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() > 0) {
            result.add(focus.get(focus.size() - 1));
        }
        return result;
    }

    private List<Base> funcFirst(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        if (focus.size() > 0) {
            result.add(focus.get(0));
        }
        return result;
    }

    private List<Base> funcWhere(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> pc = new ArrayList<Base>();
        for (Base item : focus) {
            pc.clear();
            pc.add(item);
            Equality v = this.asBool(this.execute(this.changeThis(context, item), pc, exp.getParameters().get(0), true), exp);
            if (v != Equality.True) continue;
            result.add(item);
        }
        return result;
    }

    private List<Base> funcSelect(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        ArrayList<Base> pc = new ArrayList<Base>();
        int i = 0;
        for (Base item : focus) {
            pc.clear();
            pc.add(item);
            result.addAll(this.execute(this.changeThis(context, item).setIndex(i), pc, exp.getParameters().get(0), true));
            ++i;
        }
        return result;
    }

    private List<Base> funcItem(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws FHIRException {
        ArrayList<Base> result = new ArrayList<Base>();
        String s = this.convertToString(this.execute(context, focus, exp.getParameters().get(0), true));
        if (Utilities.isInteger((String)s) && Integer.parseInt(s) < focus.size()) {
            result.add(focus.get(Integer.parseInt(s)));
        }
        return result;
    }

    private List<Base> funcEmpty(ExecutionContext context, List<Base> focus, ExpressionNode exp) {
        ArrayList<Base> result = new ArrayList<Base>();
        result.add(new BooleanType(ElementUtil.isEmpty(focus)).noExtensions());
        return result;
    }

    private List<Base> funcNot(ExecutionContext context, List<Base> focus, ExpressionNode exp) throws PathEngineException {
        ArrayList<Base> result = new ArrayList<Base>();
        Equality v = this.asBool(focus, exp);
        if (v != Equality.Null) {
            result.add(new BooleanType(v != Equality.True));
        }
        return result;
    }

    private void getChildTypesByName(String type, String name, TypeDetails result, ExpressionNode expr, TypeDetails focus, Set<ElementDefinition> elementDependencies) throws PathEngineException, DefinitionException {
        if (Utilities.noString((String)type)) {
            throw this.makeException(expr, "FHIRPATH_NO_TYPE", "", "getChildTypesByName");
        }
        if (type.equals("http://hl7.org/fhir/StructureDefinition/xhtml")) {
            return;
        }
        if (type.equals("http://hl7.org/fhirpath/System.SimpleTypeInfo")) {
            this.getSimpleTypeChildTypesByName(name, result);
        } else if (type.equals("http://hl7.org/fhirpath/System.ClassInfo")) {
            this.getClassInfoChildTypesByName(name, result);
        } else {
            if (type.startsWith("http://hl7.org/fhirpath/System.")) {
                return;
            }
            String url = null;
            url = type.contains("#") ? type.substring(0, type.indexOf("#")) : type;
            String tail = "";
            StructureDefinition sd = this.worker.fetchTypeDefinition(url);
            if (sd == null) {
                sd = this.worker.fetchResource(StructureDefinition.class, url);
            }
            if (sd == null) {
                if (url.startsWith("http://hl7.org/fhirpath/")) {
                    return;
                }
                throw this.makeException(expr, "FHIRPATH_UNKNOWN_TYPE", url, "getChildTypesByName#1");
            }
            ArrayList<StructureDefinition> sdl = new ArrayList<StructureDefinition>();
            ElementDefinitionMatch m = null;
            if (type.contains("#")) {
                List<ElementDefinitionMatch> list = this.getElementDefinition(sd, type.substring(type.indexOf("#") + 1), false, expr);
                ElementDefinitionMatch elementDefinitionMatch = m = list.size() == 1 ? list.get(0) : null;
            }
            if (m != null && this.hasDataType(m.definition)) {
                if (m.fixedType != null) {
                    StructureDefinition dt = this.worker.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(m.fixedType, null), sd);
                    if (dt == null) {
                        throw this.makeException(expr, "FHIRPATH_UNKNOWN_TYPE", ProfileUtilities.sdNs(m.fixedType, null), "getChildTypesByName#2");
                    }
                    sdl.add(dt);
                } else {
                    for (ElementDefinition.TypeRefComponent t : m.definition.getType()) {
                        StructureDefinition dt = this.worker.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(t.getCode(), null));
                        if (dt == null) {
                            throw this.makeException(expr, "FHIRPATH_UNKNOWN_TYPE", ProfileUtilities.sdNs(t.getCode(), null), "getChildTypesByName#3");
                        }
                        this.addTypeAndDescendents(sdl, dt, this.cu.allStructures());
                    }
                }
            } else {
                this.addTypeAndDescendents(sdl, sd, this.cu.allStructures());
                if (type.contains("#")) {
                    tail = type.substring(type.indexOf("#") + 1);
                    tail = tail.contains(".") ? tail.substring(tail.indexOf(".")) : "";
                }
            }
            for (StructureDefinition sdi : sdl) {
                String path = sdi.getSnapshot().getElement().get(0).getPath() + tail + ".";
                if (name.equals("**")) {
                    assert (result.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED);
                    for (ElementDefinition ed : sdi.getSnapshot().getElement()) {
                        if (!ed.getPath().startsWith(path)) continue;
                        if (ed.hasContentReference()) {
                            Iterator<ElementDefinition.TypeRefComponent> cpath = ed.getContentReference();
                            String tn = sdi.getType() + (String)((Object)cpath);
                            if (result.hasType(this.worker, tn)) continue;
                            if (elementDependencies != null) {
                                elementDependencies.add(ed);
                            }
                            this.getChildTypesByName(result.addType(tn), "**", result, expr, null, elementDependencies);
                            continue;
                        }
                        for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                            if (!t.hasCode() || !t.getCodeElement().hasValue()) continue;
                            Object tn = null;
                            tn = Utilities.existsInList((String)t.getCode(), (String[])new String[]{"Element", "BackboneElement", "Base"}) || this.cu.isAbstractType(t.getCode()) ? sdi.getType() + "#" + ed.getPath() : t.getCode();
                            if (t.getCode().equals("Resource")) {
                                for (String rn : this.worker.getResourceNames()) {
                                    if (result.hasType(this.worker, rn)) continue;
                                    if (elementDependencies != null) {
                                        elementDependencies.add(ed);
                                    }
                                    this.getChildTypesByName(result.addType(rn), "**", result, expr, null, elementDependencies);
                                }
                                continue;
                            }
                            if (result.hasType(this.worker, new String[]{tn})) continue;
                            if (elementDependencies != null) {
                                elementDependencies.add(ed);
                            }
                            this.getChildTypesByName(result.addType((String)tn), "**", result, expr, null, elementDependencies);
                        }
                    }
                    continue;
                }
                if (name.equals("*")) {
                    assert (result.getCollectionStatus() == ExpressionNode.CollectionStatus.UNORDERED);
                    for (ElementDefinition ed : sdi.getSnapshot().getElement()) {
                        if (!ed.getPath().startsWith(path) || ed.getPath().substring(path.length()).contains(".")) continue;
                        for (ElementDefinition.TypeRefComponent t : ed.getType()) {
                            if (Utilities.noString((String)t.getCode())) {
                                if (elementDependencies != null) {
                                    elementDependencies.add(ed);
                                }
                                result.addType("System.string");
                                continue;
                            }
                            if (t.getCode().equals("Element") || t.getCode().equals("BackboneElement")) {
                                if (elementDependencies != null) {
                                    elementDependencies.add(ed);
                                }
                                result.addType(sdi.getType() + "#" + ed.getPath());
                                continue;
                            }
                            if (t.getCode().equals("Resource")) {
                                if (elementDependencies != null) {
                                    elementDependencies.add(ed);
                                }
                                result.addTypes(this.worker.getResourceNames());
                                continue;
                            }
                            if (elementDependencies != null) {
                                elementDependencies.add(ed);
                            }
                            result.addType(t.getCode());
                            this.copyTargetProfiles(ed, t, focus, result);
                        }
                    }
                    continue;
                }
                path = sdi.getSnapshot().getElement().get(0).getPath() + tail + "." + name;
                List<ElementDefinitionMatch> edl = this.getElementDefinition(sdi, path, this.isAllowPolymorphicNames(), expr);
                block7: for (ElementDefinitionMatch ed : edl) {
                    if (ed.getDefinition().isChoice()) {
                        result.setChoice(true);
                    }
                    if (!Utilities.noString((String)ed.getFixedType())) {
                        if (elementDependencies != null) {
                            elementDependencies.add(ed.definition);
                        }
                        result.addType(ed.getFixedType());
                        continue;
                    }
                    if (ed.getSourceDefinition() != null) {
                        TypeDetails.ProfiledType pt = new TypeDetails.ProfiledType(sdi.getType() + "#" + ed.definition.getPath());
                        result.addType(ed.getSourceDefinition().unbounded() ? ExpressionNode.CollectionStatus.ORDERED : ExpressionNode.CollectionStatus.SINGLETON, pt);
                        continue;
                    }
                    for (ElementDefinition.TypeRefComponent t : ed.getDefinition().getType()) {
                        if (Utilities.noString((String)t.getCode())) {
                            if (!Utilities.existsInList((String)ed.getDefinition().getId(), (String[])new String[]{"Element.id", "Extension.url"}) && !Utilities.existsInList((String)ed.getDefinition().getBase().getPath(), (String[])new String[]{"Resource.id", "Element.id", "Extension.url"})) continue block7;
                            if (elementDependencies != null) {
                                elementDependencies.add(ed.definition);
                            }
                            result.addType("http://hl7.org/fhirpath/", "System.String");
                            continue block7;
                        }
                        TypeDetails.ProfiledType pt = null;
                        if (t.getCode().equals("Element") || t.getCode().equals("BackboneElement") || this.isAbstractType(t.getCode())) {
                            pt = new TypeDetails.ProfiledType(sdi.getUrl() + "#" + path);
                        } else if (t.getCode().equals("Resource")) {
                            if (elementDependencies != null) {
                                elementDependencies.add(ed.definition);
                            }
                            result.addTypes(this.worker.getResourceNames());
                        } else {
                            pt = new TypeDetails.ProfiledType(t.getCode());
                        }
                        if (pt == null) continue;
                        if (t.hasProfile()) {
                            pt.addProfiles(t.getProfile());
                        }
                        if (ed.getDefinition().hasBinding()) {
                            pt.addBinding(ed.getDefinition().getBinding());
                        }
                        if (elementDependencies != null) {
                            elementDependencies.add(ed.definition);
                        }
                        result.addType(ed.definition.unbounded() ? ExpressionNode.CollectionStatus.ORDERED : ExpressionNode.CollectionStatus.SINGLETON, pt);
                        this.copyTargetProfiles(ed.getDefinition(), t, focus, result);
                    }
                }
            }
        }
    }

    private void copyTargetProfiles(ElementDefinition ed, ElementDefinition.TypeRefComponent t, TypeDetails focus, TypeDetails result) {
        block3: {
            block2: {
                if (!t.hasTargetProfile()) break block2;
                for (CanonicalType u : t.getTargetProfile()) {
                    result.addTarget(u.primitiveValue());
                }
                break block3;
            }
            if (focus == null || !focus.hasType("CodeableReference") || !ed.getPath().endsWith(".reference") || focus.getTargets() == null) break block3;
            for (String s : focus.getTargets()) {
                result.addTarget(s);
            }
        }
    }

    private void addTypeAndDescendents(List<StructureDefinition> sdl, StructureDefinition dt, List<StructureDefinition> types) {
        sdl.add(dt);
        for (StructureDefinition sd : types) {
            if (!sd.hasBaseDefinition() || !sd.getBaseDefinition().equals(dt.getUrl()) || sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION) continue;
            this.addTypeAndDescendents(sdl, sd, types);
        }
    }

    private void getClassInfoChildTypesByName(String name, TypeDetails result) {
        if (name.equals("namespace")) {
            result.addType("http://hl7.org/fhirpath/System.String");
        }
        if (name.equals("name")) {
            result.addType("http://hl7.org/fhirpath/System.String");
        }
    }

    private void getSimpleTypeChildTypesByName(String name, TypeDetails result) {
        if (name.equals("namespace")) {
            result.addType("http://hl7.org/fhirpath/System.String");
        }
        if (name.equals("name")) {
            result.addType("http://hl7.org/fhirpath/System.String");
        }
    }

    public List<ElementDefinitionMatch> getElementDefinition(StructureDefinition sd, String path, boolean allowTypedName, ExpressionNode expr) throws PathEngineException {
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (ed.getPath().equals(path)) {
                if (ed.hasContentReference()) {
                    ElementDefinitionMatch res = this.getElementDefinitionById(sd, ed.getContentReference());
                    if (res == null) {
                        throw new Error("Unable to find " + ed.getContentReference());
                    }
                    res.sourceDefinition = ed;
                    return this.ml(res);
                }
                return this.ml(new ElementDefinitionMatch(ed, null));
            }
            if (ed.getPath().endsWith("[x]") && path.startsWith(ed.getPath().substring(0, ed.getPath().length() - 3)) && path.length() == ed.getPath().length() - 3) {
                return this.ml(new ElementDefinitionMatch(ed, null));
            }
            if (allowTypedName && ed.getPath().endsWith("[x]") && path.startsWith(ed.getPath().substring(0, ed.getPath().length() - 3)) && path.length() > ed.getPath().length() - 3) {
                String s = Utilities.uncapitalize((String)path.substring(ed.getPath().length() - 3));
                if (this.primitiveTypes.contains(s)) {
                    return this.ml(new ElementDefinitionMatch(ed, s));
                }
                return this.ml(new ElementDefinitionMatch(ed, path.substring(ed.getPath().length() - 3)));
            }
            if (ed.getPath().contains(".") && path.startsWith(ed.getPath() + ".") && ed.getType().size() > 0 && !this.isAbstractType(ed.getType())) {
                if (ed.getType().size() > 1) {
                    ArrayList<ElementDefinitionMatch> list = new ArrayList<ElementDefinitionMatch>();
                    for (ElementDefinition.TypeRefComponent tr : ed.getType()) {
                        StructureDefinition nsd = this.worker.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(tr.getCode(), null), sd);
                        if (nsd == null) {
                            throw this.makeException(expr, "FHIRPATH_NO_TYPE", ed.getType().get(0).getCode(), "getElementDefinition");
                        }
                        List<ElementDefinitionMatch> edl = this.getElementDefinition(nsd, nsd.getId() + path.substring(ed.getPath().length()), allowTypedName, expr);
                        list.addAll(edl);
                    }
                    return list;
                }
                StructureDefinition nsd = this.worker.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getType().get(0).getCode(), null), sd);
                if (nsd == null) {
                    throw this.makeException(expr, "FHIRPATH_NO_TYPE", ed.getType().get(0).getCode(), "getElementDefinition");
                }
                return this.getElementDefinition(nsd, nsd.getId() + path.substring(ed.getPath().length()), allowTypedName, expr);
            }
            if (!ed.hasContentReference() || !path.startsWith(ed.getPath() + ".")) continue;
            ElementDefinitionMatch m = this.getElementDefinitionById(sd, ed.getContentReference());
            List<ElementDefinitionMatch> res = this.getElementDefinition(sd, m.definition.getPath() + path.substring(ed.getPath().length()), allowTypedName, expr);
            if (res.size() == 0) {
                throw new Error("Unable to find " + ed.getContentReference());
            }
            for (ElementDefinitionMatch item : res) {
                item.sourceDefinition = ed;
            }
            return res;
        }
        return this.ml(null);
    }

    private List<ElementDefinitionMatch> ml(ElementDefinitionMatch item) {
        ArrayList<ElementDefinitionMatch> list = new ArrayList<ElementDefinitionMatch>();
        if (item != null) {
            list.add(item);
        }
        return list;
    }

    private boolean isAbstractType(List<ElementDefinition.TypeRefComponent> list) {
        if (list.size() != 1) {
            return false;
        }
        return this.isAbstractType(list.get(0).getCode());
    }

    private boolean isAbstractType(String code) {
        StructureDefinition sd = this.worker.fetchTypeDefinition(code);
        return sd != null && sd.getAbstract() && sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE;
    }

    private boolean hasType(ElementDefinition ed, String s) {
        for (ElementDefinition.TypeRefComponent t : ed.getType()) {
            if (!s.equalsIgnoreCase(t.getCode())) continue;
            return true;
        }
        return false;
    }

    private boolean hasDataType(ElementDefinition ed) {
        return ed.hasType() && !ed.getType().get(0).getCode().equals("Element") && !ed.getType().get(0).getCode().equals("BackboneElement") && !this.isAbstractType(ed.getType().get(0).getCode());
    }

    private ElementDefinitionMatch getElementDefinitionById(StructureDefinition sd, String ref) {
        if (ref.startsWith(sd.getUrl() + "#")) {
            ref = ref.replace(sd.getUrl() + "#", "#");
        }
        for (ElementDefinition ed : sd.getSnapshot().getElement()) {
            if (!ref.equals("#" + ed.getId())) continue;
            return new ElementDefinitionMatch(ed, null);
        }
        return null;
    }

    public boolean hasLog() {
        return this.log != null && this.log.length() > 0;
    }

    public String takeLog() {
        if (!this.hasLog()) {
            return "";
        }
        String s = this.log.toString();
        this.log = new StringBuilder();
        return s;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public FHIRPathUtilityClasses.TypedElementDefinition evaluateDefinition(ExpressionNode expr, StructureDefinition profile, FHIRPathUtilityClasses.TypedElementDefinition element, StructureDefinition source, boolean dontWalkIntoReferences) throws DefinitionException {
        StructureDefinition sd = profile;
        FHIRPathUtilityClasses.TypedElementDefinition focus = null;
        boolean okToNotResolve = false;
        if (expr.getKind() == ExpressionNode.Kind.Name) {
            if (element.getElement().hasSlicing()) {
                ElementDefinition slice = this.pickMandatorySlice(sd, element.getElement());
                if (slice == null) {
                    throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_NAME_ALREADY_SLICED", element.getElement().getId());
                }
                element = new FHIRPathUtilityClasses.TypedElementDefinition(slice);
            }
            if (expr.getName().equals("$this")) {
                focus = element;
            } else {
                ProfileUtilities.SourcedChildDefinitions childDefinitions = this.profileUtilities.getChildMap(sd, element.getElement());
                if (childDefinitions.getList().isEmpty()) {
                    sd = this.fetchStructureByType(element, expr);
                    if (sd == null) {
                        throw this.makeException(expr, "FHIRPATH_RESOLVE_DISCRIMINATOR_CANT_FIND", element.getElement().getType().get(0).getProfile(), element.getElement().getId());
                    }
                    childDefinitions = this.profileUtilities.getChildMap(sd, sd.getSnapshot().getElementFirstRep());
                }
                for (ElementDefinition t : childDefinitions.getList()) {
                    if (!this.tailMatches(t, expr.getName()) || t.hasSlicing()) continue;
                    focus = new FHIRPathUtilityClasses.TypedElementDefinition(t);
                    break;
                }
            }
        } else if (expr.getKind() == ExpressionNode.Kind.Function) {
            if ("resolve".equals(expr.getName())) {
                if (element.getTypes().size() == 0) {
                    throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_RESOLVE_NO_TYPE", element.getElement().getId());
                }
                if (element.getTypes().size() > 1) {
                    throw this.makeExceptionPlural(element.getTypes().size(), expr, "FHIRPATH_DISCRIMINATOR_RESOLVE_MULTIPLE_TYPES", element.getElement().getId());
                }
                if (!element.getTypes().get(0).hasTarget()) {
                    throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_RESOLVE_NOT_REFERENCE", element.getElement().getId(), element.getElement().getType().get(0).getCode() + ")");
                }
                if (element.getTypes().get(0).getTargetProfile().size() > 1) {
                    throw this.makeExceptionPlural(element.getTypes().get(0).getTargetProfile().size(), expr, "FHIRPATH_RESOLVE_DISCRIMINATOR_NO_TARGET", element.getElement().getId());
                }
                sd = this.worker.fetchResource(StructureDefinition.class, (String)element.getTypes().get(0).getTargetProfile().get(0).getValue(), profile);
                if (sd == null) {
                    throw this.makeException(expr, "FHIRPATH_RESOLVE_DISCRIMINATOR_CANT_FIND", element.getTypes().get(0).getTargetProfile(), element.getElement().getId());
                }
                focus = new FHIRPathUtilityClasses.TypedElementDefinition(sd.getSnapshot().getElementFirstRep());
            } else if ("extension".equals(expr.getName())) {
                String targetUrl = expr.getParameters().get(0).getConstant().primitiveValue();
                ProfileUtilities.SourcedChildDefinitions childDefinitions = this.profileUtilities.getChildMap(sd, element.getElement());
                for (ElementDefinition t : childDefinitions.getList()) {
                    StructureDefinition exsd;
                    if (!t.getPath().endsWith(".extension") || !t.hasSliceName()) continue;
                    StructureDefinition structureDefinition = exsd = t.getType() == null || t.getType().isEmpty() || t.getType().get(0).getProfile().isEmpty() ? null : this.worker.fetchResource(StructureDefinition.class, (String)t.getType().get(0).getProfile().get(0).getValue(), profile);
                    while (exsd != null && !exsd.getBaseDefinition().equals("http://hl7.org/fhir/StructureDefinition/Extension")) {
                        exsd = this.worker.fetchResource(StructureDefinition.class, exsd.getBaseDefinition(), exsd);
                    }
                    if (exsd == null || !exsd.getUrl().equals(targetUrl)) continue;
                    if (this.profileUtilities.getChildMap(sd, t).getList().isEmpty()) {
                        sd = exsd;
                    }
                    focus = new FHIRPathUtilityClasses.TypedElementDefinition(t);
                    break;
                }
                if (focus == null) {
                    throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_CANT_FIND_EXTENSION", expr.toString(), targetUrl, element.getElement().getId(), sd.getUrl());
                }
            } else {
                if (!"ofType".equals(expr.getName())) throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_BAD_NAME", expr.getName());
                if (!element.getElement().hasType()) {
                    throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_TYPE_NONE", element.getElement().getId());
                }
                ArrayList<String> atn = new ArrayList<String>();
                for (ElementDefinition.TypeRefComponent tr : element.getTypes()) {
                    if (!tr.hasCode()) {
                        throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_NO_CODE", element.getElement().getId());
                    }
                    atn.add(tr.getCode());
                }
                String stn = expr.getParameters().get(0).getName();
                okToNotResolve = true;
                if (atn.contains(stn)) {
                    focus = element.getTypes().size() > 1 ? new FHIRPathUtilityClasses.TypedElementDefinition(element.getSrc(), element.getElement(), stn) : element;
                }
            }
        } else {
            if (expr.getKind() == ExpressionNode.Kind.Group) {
                throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_BAD_SYNTAX_GROUP", expr.toString());
            }
            if (expr.getKind() == ExpressionNode.Kind.Constant) {
                throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_BAD_SYNTAX_CONST", new Object[0]);
            }
        }
        if (focus == null) {
            if (!okToNotResolve) throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_CANT_FIND", expr.toString(), source.getUrl(), element.getElement().getId(), profile.getUrl());
            return null;
        }
        ExpressionNode next = expr.getInner();
        if (dontWalkIntoReferences && focus.hasType("Reference") && next != null && next.getKind() == ExpressionNode.Kind.Name && next.getName().equals("reference")) {
            next = next.getInner();
        }
        if (next != null) return this.evaluateDefinition(next, sd, focus, profile, dontWalkIntoReferences);
        return focus;
    }

    private ElementDefinition pickMandatorySlice(StructureDefinition sd, ElementDefinition element) throws DefinitionException {
        List<ElementDefinition> list = this.profileUtilities.getSliceList(sd, element);
        for (ElementDefinition ed : list) {
            if (ed.getMin() <= 0) continue;
            return ed;
        }
        return null;
    }

    private StructureDefinition fetchStructureByType(FHIRPathUtilityClasses.TypedElementDefinition ed, ExpressionNode expr) throws DefinitionException {
        if (ed.getTypes().size() == 0) {
            throw this.makeException(expr, "FHIRPATH_DISCRIMINATOR_NOTYPE", ed.getElement().getId());
        }
        if (ed.getTypes().size() > 1) {
            throw this.makeExceptionPlural(ed.getTypes().size(), expr, "FHIRPATH_DISCRIMINATOR_MULTIPLE_TYPES", ed.getElement().getId());
        }
        if (ed.getTypes().get(0).getProfile().size() > 1) {
            throw this.makeExceptionPlural(ed.getTypes().get(0).getProfile().size(), expr, "FHIRPATH_DISCRIMINATOR_MULTIPLE_PROFILES", ed.getElement().getId());
        }
        if (ed.getTypes().get(0).hasProfile()) {
            return this.worker.fetchResource(StructureDefinition.class, (String)ed.getTypes().get(0).getProfile().get(0).getValue(), ed.getSrc());
        }
        return this.worker.fetchResource(StructureDefinition.class, ProfileUtilities.sdNs(ed.getTypes().get(0).getCode(), null), ed.getSrc());
    }

    private boolean tailMatches(ElementDefinition t, String d) {
        String tail = this.tailDot(t.getPath());
        if (d.contains("[")) {
            return tail.startsWith(d.substring(0, d.indexOf(91)));
        }
        if (tail.equals(d)) {
            return true;
        }
        if (t.getType().size() == 1 && t.getType().get(0).getCode() != null && t.getPath() != null && t.getPath().toUpperCase().endsWith(t.getType().get(0).getCode().toUpperCase())) {
            return tail.startsWith(d);
        }
        return t.getPath().endsWith("[x]") && tail.startsWith(d);
    }

    private String tailDot(String path) {
        return path.substring(path.lastIndexOf(".") + 1);
    }

    private Equality asBool(List<Base> items, ExpressionNode expr) throws PathEngineException {
        if (items.size() == 0) {
            return Equality.Null;
        }
        if (items.size() == 1 && items.get(0).isBooleanPrimitive()) {
            return this.asBool(items.get(0), true);
        }
        if (items.size() == 1) {
            return Equality.True;
        }
        throw this.makeException(expr, "FHIRPATH_UNABLE_BOOLEAN", this.convertToString(items));
    }

    private Equality asBoolFromInt(String s) {
        try {
            int i = Integer.parseInt(s);
            switch (i) {
                case 0: {
                    return Equality.False;
                }
                case 1: {
                    return Equality.True;
                }
            }
            return Equality.Null;
        }
        catch (Exception e) {
            return Equality.Null;
        }
    }

    private Equality asBoolFromDec(String s) {
        try {
            BigDecimal d = new BigDecimal(s);
            if (d.compareTo(BigDecimal.ZERO) == 0) {
                return Equality.False;
            }
            if (d.compareTo(BigDecimal.ONE) == 0) {
                return Equality.True;
            }
            return Equality.Null;
        }
        catch (Exception e) {
            return Equality.Null;
        }
    }

    private Equality asBool(Base item, boolean narrow) {
        if (item instanceof BooleanType) {
            return this.boolToTriState(((BooleanType)item).booleanValue());
        }
        if (item.isBooleanPrimitive()) {
            if (Utilities.existsInList((String)item.primitiveValue(), (String[])new String[]{"true"})) {
                return Equality.True;
            }
            if (Utilities.existsInList((String)item.primitiveValue(), (String[])new String[]{"false"})) {
                return Equality.False;
            }
            return Equality.Null;
        }
        if (narrow) {
            return Equality.False;
        }
        if (item instanceof IntegerType || Utilities.existsInList((String)item.fhirType(), (String[])new String[]{"integer", "positiveint", "unsignedInt"})) {
            return this.asBoolFromInt(item.primitiveValue());
        }
        if (item instanceof DecimalType || Utilities.existsInList((String)item.fhirType(), (String[])new String[]{"decimal"})) {
            return this.asBoolFromDec(item.primitiveValue());
        }
        if (Utilities.existsInList((String)item.fhirType(), (String[])FHIR_TYPES_STRING)) {
            if (Utilities.existsInList((String)item.primitiveValue(), (String[])new String[]{"true", "t", "yes", "y"})) {
                return Equality.True;
            }
            if (Utilities.existsInList((String)item.primitiveValue(), (String[])new String[]{"false", "f", "no", "n"})) {
                return Equality.False;
            }
            if (Utilities.isInteger((String)item.primitiveValue())) {
                return this.asBoolFromInt(item.primitiveValue());
            }
            if (Utilities.isDecimal((String)item.primitiveValue(), (boolean)true)) {
                return this.asBoolFromDec(item.primitiveValue());
            }
            return Equality.Null;
        }
        return Equality.Null;
    }

    private Equality boolToTriState(boolean b) {
        return b ? Equality.True : Equality.False;
    }

    public ValidationOptions getTerminologyServiceOptions() {
        return this.terminologyServiceOptions;
    }

    public IWorkerContext getWorker() {
        return this.worker;
    }

    public boolean isAllowPolymorphicNames() {
        return this.allowPolymorphicNames;
    }

    public void setAllowPolymorphicNames(boolean allowPolymorphicNames) {
        this.allowPolymorphicNames = allowPolymorphicNames;
    }

    public boolean isLiquidMode() {
        return this.liquidMode;
    }

    public void setLiquidMode(boolean liquidMode) {
        this.liquidMode = liquidMode;
    }

    public ProfileUtilities getProfileUtilities() {
        return this.profileUtilities;
    }

    public boolean isAllowDoubleQuotes() {
        return this.allowDoubleQuotes;
    }

    public void setAllowDoubleQuotes(boolean allowDoubleQuotes) {
        this.allowDoubleQuotes = allowDoubleQuotes;
    }

    public boolean isEmitSQLonFHIRWarning() {
        return this.emitSQLonFHIRWarning;
    }

    public void setEmitSQLonFHIRWarning(boolean emitSQLonFHIRWarning) {
        this.emitSQLonFHIRWarning = emitSQLonFHIRWarning;
    }

    private class ElementDefinitionMatch {
        private ElementDefinition definition;
        private ElementDefinition sourceDefinition;
        private String fixedType;

        public ElementDefinitionMatch(ElementDefinition definition, String fixedType) {
            this.definition = definition;
            this.fixedType = fixedType;
        }

        public ElementDefinition getDefinition() {
            return this.definition;
        }

        public ElementDefinition getSourceDefinition() {
            return this.sourceDefinition;
        }

        public String getFixedType() {
            return this.fixedType;
        }
    }

    private static class ExecutionTypeContext {
        private Object appInfo;
        private String resource;
        private TypeDetails context;
        private TypeDetails thisItem;
        private TypeDetails total;
        private Map<String, TypeDetails> definedVariables;

        public ExecutionTypeContext(Object appInfo, String resource, TypeDetails context, TypeDetails thisItem) {
            this.appInfo = appInfo;
            this.resource = resource;
            this.context = context;
            this.thisItem = thisItem;
        }

        public String getResource() {
            return this.resource;
        }

        public TypeDetails getThisItem() {
            return this.thisItem;
        }

        public boolean hasDefinedVariable(String name) {
            return this.definedVariables != null && this.definedVariables.containsKey(name);
        }

        public TypeDetails getDefinedVariable(String name) {
            return this.definedVariables == null ? null : this.definedVariables.get(name);
        }

        public void setDefinedVariable(String name, TypeDetails value) {
            if (FHIRPathEngine.isSystemVariable(name)) {
                throw new PathEngineException("Redefine of variable " + name, "FHIRPATH_REDEFINE_VARIABLE");
            }
            if (this.definedVariables == null) {
                this.definedVariables = new HashMap<String, TypeDetails>();
            } else if (this.definedVariables.containsKey(name)) {
                throw new PathEngineException("Redefine of variable " + name, "FHIRPATH_REDEFINE_VARIABLE");
            }
            this.definedVariables.put(name, value);
        }
    }

    private class ExecutionContext {
        private Object appInfo;
        private Base focusResource;
        private Base rootResource;
        private Base context;
        private Base thisItem;
        private List<Base> total;
        private int index;
        private Map<String, List<Base>> definedVariables;

        public ExecutionContext(Object appInfo, Base resource, Base rootResource, Base context, Base thisItem) {
            this.appInfo = appInfo;
            this.context = context;
            this.focusResource = resource;
            this.rootResource = rootResource;
            this.thisItem = thisItem;
            this.index = 0;
        }

        public Base getFocusResource() {
            return this.focusResource;
        }

        public Base getRootResource() {
            return this.rootResource;
        }

        public Base getThisItem() {
            return this.thisItem;
        }

        public List<Base> getTotal() {
            return this.total;
        }

        public void next() {
            ++this.index;
        }

        public Base getIndex() {
            return new IntegerType(this.index);
        }

        public ExecutionContext setIndex(int i) {
            this.index = i;
            return this;
        }

        public boolean hasDefinedVariable(String name) {
            return this.definedVariables != null && this.definedVariables.containsKey(name);
        }

        public List<Base> getDefinedVariable(String name) {
            return this.definedVariables == null ? FHIRPathEngine.this.makeNull() : this.definedVariables.get(name);
        }

        public void setDefinedVariable(String name, List<Base> value) {
            if (FHIRPathEngine.isSystemVariable(name)) {
                throw new PathEngineException(FHIRPathEngine.this.worker.formatMessage("FHIRPATH_REDEFINE_VARIABLE", name), "FHIRPATH_REDEFINE_VARIABLE");
            }
            if (this.definedVariables == null) {
                this.definedVariables = new HashMap<String, List<Base>>();
            } else if (this.definedVariables.containsKey(name)) {
                throw new PathEngineException(FHIRPathEngine.this.worker.formatMessage("FHIRPATH_REDEFINE_VARIABLE", name), "FHIRPATH_REDEFINE_VARIABLE");
            }
            this.definedVariables.put(name, value);
        }
    }

    public static class ExpressionNodeWithOffset {
        private int offset;
        private ExpressionNode node;

        public ExpressionNodeWithOffset(int offset, ExpressionNode node) {
            this.offset = offset;
            this.node = node;
        }

        public int getOffset() {
            return this.offset;
        }

        public ExpressionNode getNode() {
            return this.node;
        }
    }

    public static interface IEvaluationContext {
        public List<Base> resolveConstant(FHIRPathEngine var1, Object var2, String var3, boolean var4, boolean var5) throws PathEngineException;

        public TypeDetails resolveConstantType(FHIRPathEngine var1, Object var2, String var3, boolean var4) throws PathEngineException;

        public boolean log(String var1, List<Base> var2);

        public FHIRPathUtilityClasses.FunctionDetails resolveFunction(FHIRPathEngine var1, String var2);

        public TypeDetails checkFunction(FHIRPathEngine var1, Object var2, String var3, TypeDetails var4, List<TypeDetails> var5) throws PathEngineException;

        public List<Base> executeFunction(FHIRPathEngine var1, Object var2, List<Base> var3, String var4, List<List<Base>> var5);

        public Base resolveReference(FHIRPathEngine var1, Object var2, String var3, Base var4) throws FHIRException;

        public boolean conformsToProfile(FHIRPathEngine var1, Object var2, Base var3, String var4) throws FHIRException;

        public ValueSet resolveValueSet(FHIRPathEngine var1, Object var2, String var3);

        public boolean paramIsType(String var1, int var2);
    }

    private static enum Equality {
        Null,
        True,
        False;

    }

    public class IssueMessage {
        private String message;
        private String id;

        public IssueMessage(String message, String id) {
            this.message = message;
            this.id = id;
        }

        public String getMessage() {
            return this.message;
        }

        public String getId() {
            return this.id;
        }
    }

    public class ExtensionDefinition {
        private boolean root;
        private StructureDefinition sd;
        private ElementDefinition ed;

        public ExtensionDefinition(boolean root, StructureDefinition sd, ElementDefinition ed) {
            this.root = root;
            this.sd = sd;
            this.ed = ed;
        }

        public boolean isRoot() {
            return this.root;
        }

        public StructureDefinition getSd() {
            return this.sd;
        }

        public ElementDefinition getEd() {
            return this.ed;
        }
    }
}

