/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseDatatype;
import org.hl7.fhir.r5.model.Element;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.utils.ToolingExtensions;

@DatatypeDef(name="DataType")
public abstract class DataType
extends Element
implements IBaseDatatype,
IElement {
    private static final long serialVersionUID = 0L;

    @Override
    public String fhirType() {
        return "DataType";
    }

    @Override
    public abstract DataType copy();

    public void copyValues(DataType dst) {
        super.copyValues(dst);
    }

    public String getTranslation(String l) throws FHIRException {
        for (Extension e : this.getExtension()) {
            String lang;
            if (!e.getUrl().equals("http://hl7.org/fhir/StructureDefinition/translation") || !(lang = ToolingExtensions.readStringExtension((Element)e, "lang")).equals(l)) continue;
            return e.getExtensionString("content");
        }
        return null;
    }

    public boolean isTranslatable() {
        return false;
    }
}

