/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.model;

import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Binding;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Compartment;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseBackboneElement;
import org.hl7.fhir.r5.model.Address;
import org.hl7.fhir.r5.model.Attachment;
import org.hl7.fhir.r5.model.BackboneElement;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.BooleanType;
import org.hl7.fhir.r5.model.CodeType;
import org.hl7.fhir.r5.model.CodeableConcept;
import org.hl7.fhir.r5.model.Configuration;
import org.hl7.fhir.r5.model.ContactPoint;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumeration;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.HumanName;
import org.hl7.fhir.r5.model.Identifier;
import org.hl7.fhir.r5.model.Patient;
import org.hl7.fhir.r5.model.Period;
import org.hl7.fhir.r5.model.Property;
import org.hl7.fhir.r5.model.Reference;
import org.hl7.fhir.r5.model.ResourceType;
import org.hl7.fhir.r5.model.TypeConvertor;

@ResourceDef(name="RelatedPerson", profile="http://hl7.org/fhir/StructureDefinition/RelatedPerson")
public class RelatedPerson
extends DomainResource {
    @Child(name="identifier", type={Identifier.class}, order=0, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A human identifier for this person", formalDefinition="Identifier for a person within a particular scope.")
    protected List<Identifier> identifier;
    @Child(name="active", type={BooleanType.class}, order=1, min=0, max=1, modifier=true, summary=true)
    @Description(shortDefinition="Whether this related person's record is in active use", formalDefinition="Whether this related person record is in active use.")
    protected BooleanType active;
    @Child(name="patient", type={Patient.class}, order=2, min=1, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The patient this person is related to", formalDefinition="The patient this person is related to.")
    protected Reference patient;
    @Child(name="relationship", type={CodeableConcept.class}, order=3, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="The relationship of the related person to the patient", formalDefinition="The nature of the relationship between the related person and the patient.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/relatedperson-relationshiptype")
    protected List<CodeableConcept> relationship;
    @Child(name="name", type={HumanName.class}, order=4, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A name associated with the person", formalDefinition="A name associated with the person.")
    protected List<HumanName> name;
    @Child(name="telecom", type={ContactPoint.class}, order=5, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="A contact detail for the person", formalDefinition="A contact detail for the person, e.g. a telephone number or an email address.")
    protected List<ContactPoint> telecom;
    @Child(name="gender", type={CodeType.class}, order=6, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="male | female | other | unknown", formalDefinition="Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.")
    @Binding(valueSet="http://hl7.org/fhir/ValueSet/administrative-gender")
    protected Enumeration<Enumerations.AdministrativeGender> gender;
    @Child(name="birthDate", type={DateType.class}, order=7, min=0, max=1, modifier=false, summary=true)
    @Description(shortDefinition="The date on which the related person was born", formalDefinition="The date on which the related person was born.")
    protected DateType birthDate;
    @Child(name="address", type={Address.class}, order=8, min=0, max=-1, modifier=false, summary=true)
    @Description(shortDefinition="Address where the related person can be contacted or visited", formalDefinition="Address where the related person can be contacted or visited.")
    protected List<Address> address;
    @Child(name="photo", type={Attachment.class}, order=9, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="Image of the person", formalDefinition="Image of the person.")
    protected List<Attachment> photo;
    @Child(name="period", type={Period.class}, order=10, min=0, max=1, modifier=false, summary=false)
    @Description(shortDefinition="Period of time that this relationship is considered valid", formalDefinition="The period of time during which this relationship is or was active. If there are no dates defined, then the interval is unknown.")
    protected Period period;
    @Child(name="communication", type={}, order=11, min=0, max=-1, modifier=false, summary=false)
    @Description(shortDefinition="A language which may be used to communicate with the related person about the patient's health", formalDefinition="A language which may be used to communicate with the related person about the patient's health.")
    protected List<RelatedPersonCommunicationComponent> communication;
    private static final long serialVersionUID = -857475397L;
    @SearchParamDefinition(name="active", path="RelatedPerson.active", description="Indicates if the related person record is active", type="token")
    public static final String SP_ACTIVE = "active";
    public static final TokenClientParam ACTIVE = new TokenClientParam("active");
    @SearchParamDefinition(name="family", path="RelatedPerson.name.family", description="A portion of the family name of the related person", type="string")
    public static final String SP_FAMILY = "family";
    public static final StringClientParam FAMILY = new StringClientParam("family");
    @SearchParamDefinition(name="given", path="RelatedPerson.name.given", description="A portion of the given name of the related person", type="string")
    public static final String SP_GIVEN = "given";
    public static final StringClientParam GIVEN = new StringClientParam("given");
    @SearchParamDefinition(name="name", path="RelatedPerson.name", description="A server defined search that may match any of the string fields in the HumanName, including family, give, prefix, suffix, suffix, and/or text", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="relationship", path="RelatedPerson.relationship", description="The relationship between the patient and the relatedperson", type="token")
    public static final String SP_RELATIONSHIP = "relationship";
    public static final TokenClientParam RELATIONSHIP = new TokenClientParam("relationship");
    @SearchParamDefinition(name="identifier", path="Account.identifier | AdverseEvent.identifier | AllergyIntolerance.identifier | Appointment.identifier | AppointmentResponse.identifier | Basic.identifier | BodyStructure.identifier | CarePlan.identifier | CareTeam.identifier | ChargeItem.identifier | Claim.identifier | ClaimResponse.identifier | ClinicalImpression.identifier | Communication.identifier | CommunicationRequest.identifier | Composition.identifier | Condition.identifier | Consent.identifier | Contract.identifier | Coverage.identifier | CoverageEligibilityRequest.identifier | CoverageEligibilityResponse.identifier | DetectedIssue.identifier | DeviceRequest.identifier | DeviceUsage.identifier | DiagnosticReport.identifier | DocumentReference.identifier | Encounter.identifier | EnrollmentRequest.identifier | EpisodeOfCare.identifier | ExplanationOfBenefit.identifier | FamilyMemberHistory.identifier | Flag.identifier | Goal.identifier | GuidanceResponse.identifier | ImagingSelection.identifier | ImagingStudy.identifier | Immunization.identifier | ImmunizationEvaluation.identifier | ImmunizationRecommendation.identifier | Invoice.identifier | List.identifier | MeasureReport.identifier | Medication.identifier | MedicationAdministration.identifier | MedicationDispense.identifier | MedicationRequest.identifier | MedicationStatement.identifier | MolecularSequence.identifier | NutritionIntake.identifier | NutritionOrder.identifier | Observation.identifier | Person.identifier | Procedure.identifier | QuestionnaireResponse.identifier | RelatedPerson.identifier | RequestOrchestration.identifier | ResearchSubject.identifier | RiskAssessment.identifier | ServiceRequest.identifier | Specimen.identifier | SupplyDelivery.identifier | SupplyRequest.identifier | Task.identifier | VisionPrescription.identifier", description="Multiple Resources: \r\n\r\n* [Account](account.html): Account number\r\n* [AdverseEvent](adverseevent.html): Business identifier for the event\r\n* [AllergyIntolerance](allergyintolerance.html): External ids for this item\r\n* [Appointment](appointment.html): An Identifier of the Appointment\r\n* [AppointmentResponse](appointmentresponse.html): An Identifier in this appointment response\r\n* [Basic](basic.html): Business identifier\r\n* [BodyStructure](bodystructure.html): Bodystructure identifier\r\n* [CarePlan](careplan.html): External Ids for this plan\r\n* [CareTeam](careteam.html): External Ids for this team\r\n* [ChargeItem](chargeitem.html): Business Identifier for item\r\n* [Claim](claim.html): The primary identifier of the financial resource\r\n* [ClaimResponse](claimresponse.html): The identity of the ClaimResponse\r\n* [ClinicalImpression](clinicalimpression.html): Business identifier\r\n* [Communication](communication.html): Unique identifier\r\n* [CommunicationRequest](communicationrequest.html): Unique identifier\r\n* [Composition](composition.html): Version-independent identifier for the Composition\r\n* [Condition](condition.html): A unique identifier of the condition record\r\n* [Consent](consent.html): Identifier for this record (external references)\r\n* [Contract](contract.html): The identity of the contract\r\n* [Coverage](coverage.html): The primary identifier of the insured and the coverage\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The business identifier of the Eligibility\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The business identifier\r\n* [DetectedIssue](detectedissue.html): Unique id for the detected issue\r\n* [DeviceRequest](devicerequest.html): Business identifier for request/order\r\n* [DeviceUsage](deviceusage.html): Search by identifier\r\n* [DiagnosticReport](diagnosticreport.html): An identifier for the report\r\n* [DocumentReference](documentreference.html): Identifier of the attachment binary\r\n* [Encounter](encounter.html): Identifier(s) by which this encounter is known\r\n* [EnrollmentRequest](enrollmentrequest.html): The business identifier of the Enrollment\r\n* [EpisodeOfCare](episodeofcare.html): Business Identifier(s) relevant for this EpisodeOfCare\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The business identifier of the Explanation of Benefit\r\n* [FamilyMemberHistory](familymemberhistory.html): A search by a record identifier\r\n* [Flag](flag.html): Business identifier\r\n* [Goal](goal.html): External Ids for this goal\r\n* [GuidanceResponse](guidanceresponse.html): The identifier of the guidance response\r\n* [ImagingSelection](imagingselection.html): Identifiers for the imaging selection\r\n* [ImagingStudy](imagingstudy.html): Identifiers for the Study, such as DICOM Study Instance UID\r\n* [Immunization](immunization.html): Business identifier\r\n* [ImmunizationEvaluation](immunizationevaluation.html): ID of the evaluation\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Business identifier\r\n* [Invoice](invoice.html): Business Identifier for item\r\n* [List](list.html): Business identifier\r\n* [MeasureReport](measurereport.html): External identifier of the measure report to be returned\r\n* [Medication](medication.html): Returns medications with this external identifier\r\n* [MedicationAdministration](medicationadministration.html): Return administrations with this external identifier\r\n* [MedicationDispense](medicationdispense.html): Returns dispenses with this external identifier\r\n* [MedicationRequest](medicationrequest.html): Return prescriptions with this external identifier\r\n* [MedicationStatement](medicationstatement.html): Return statements with this external identifier\r\n* [MolecularSequence](molecularsequence.html): The unique identity for a particular sequence\r\n* [NutritionIntake](nutritionintake.html): Return statements with this external identifier\r\n* [NutritionOrder](nutritionorder.html): Return nutrition orders with this external identifier\r\n* [Observation](observation.html): The unique id for a particular observation\r\n* [Person](person.html): A person Identifier\r\n* [Procedure](procedure.html): A unique identifier for a procedure\r\n* [QuestionnaireResponse](questionnaireresponse.html): The unique identifier for the questionnaire response\r\n* [RelatedPerson](relatedperson.html): An Identifier of the RelatedPerson\r\n* [RequestOrchestration](requestorchestration.html): External identifiers for the request orchestration\r\n* [ResearchSubject](researchsubject.html): Business Identifier for research subject in a study\r\n* [RiskAssessment](riskassessment.html): Unique identifier for the assessment\r\n* [ServiceRequest](servicerequest.html): Identifiers assigned to this order\r\n* [Specimen](specimen.html): The unique identifier associated with the specimen\r\n* [SupplyDelivery](supplydelivery.html): External identifier\r\n* [SupplyRequest](supplyrequest.html): Business Identifier for SupplyRequest\r\n* [Task](task.html): Search for a task instance by its business identifier\r\n* [VisionPrescription](visionprescription.html): Return prescriptions with this external identifier\r\n", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="patient", path="Account.subject.where(resolve() is Patient) | AdverseEvent.subject.where(resolve() is Patient) | AllergyIntolerance.patient | Appointment.participant.actor.where(resolve() is Patient) | Appointment.subject.where(resolve() is Patient) | AppointmentResponse.actor.where(resolve() is Patient) | AuditEvent.patient | Basic.subject.where(resolve() is Patient) | BodyStructure.patient | CarePlan.subject.where(resolve() is Patient) | CareTeam.subject.where(resolve() is Patient) | ChargeItem.subject.where(resolve() is Patient) | Claim.patient | ClaimResponse.patient | ClinicalImpression.subject.where(resolve() is Patient) | Communication.subject.where(resolve() is Patient) | CommunicationRequest.subject.where(resolve() is Patient) | Composition.subject.where(resolve() is Patient) | Condition.subject.where(resolve() is Patient) | Consent.subject.where(resolve() is Patient) | Contract.subject.where(resolve() is Patient) | Coverage.beneficiary | CoverageEligibilityRequest.patient | CoverageEligibilityResponse.patient | DetectedIssue.subject.where(resolve() is Patient) | DeviceRequest.subject.where(resolve() is Patient) | DeviceUsage.patient | DiagnosticReport.subject.where(resolve() is Patient) | DocumentReference.subject.where(resolve() is Patient) | Encounter.subject.where(resolve() is Patient) | EnrollmentRequest.candidate | EpisodeOfCare.patient | ExplanationOfBenefit.patient | FamilyMemberHistory.patient | Flag.subject.where(resolve() is Patient) | Goal.subject.where(resolve() is Patient) | GuidanceResponse.subject.where(resolve() is Patient) | ImagingSelection.subject.where(resolve() is Patient) | ImagingStudy.subject.where(resolve() is Patient) | Immunization.patient | ImmunizationEvaluation.patient | ImmunizationRecommendation.patient | Invoice.subject.where(resolve() is Patient) | List.subject.where(resolve() is Patient) | MeasureReport.subject.where(resolve() is Patient) | MedicationAdministration.subject.where(resolve() is Patient) | MedicationDispense.subject.where(resolve() is Patient) | MedicationRequest.subject.where(resolve() is Patient) | MedicationStatement.subject.where(resolve() is Patient) | MolecularSequence.subject.where(resolve() is Patient) | NutritionIntake.subject.where(resolve() is Patient) | NutritionOrder.subject.where(resolve() is Patient) | Observation.subject.where(resolve() is Patient) | Person.link.target.where(resolve() is Patient) | Procedure.subject.where(resolve() is Patient) | Provenance.patient | QuestionnaireResponse.subject.where(resolve() is Patient) | RelatedPerson.patient | RequestOrchestration.subject.where(resolve() is Patient) | ResearchSubject.subject.where(resolve() is Patient) | RiskAssessment.subject.where(resolve() is Patient) | ServiceRequest.subject.where(resolve() is Patient) | Specimen.subject.where(resolve() is Patient) | SupplyDelivery.patient | SupplyRequest.deliverFor | Task.for.where(resolve() is Patient) | VisionPrescription.patient", description="Multiple Resources: \r\n\r\n* [Account](account.html): The entity that caused the expenses\r\n* [AdverseEvent](adverseevent.html): Subject impacted by event\r\n* [AllergyIntolerance](allergyintolerance.html): Who the sensitivity is for\r\n* [Appointment](appointment.html): One of the individuals of the appointment is this patient\r\n* [AppointmentResponse](appointmentresponse.html): This Response is for this Patient\r\n* [AuditEvent](auditevent.html): Where the activity involved patient data\r\n* [Basic](basic.html): Identifies the focus of this resource\r\n* [BodyStructure](bodystructure.html): Who this is about\r\n* [CarePlan](careplan.html): Who the care plan is for\r\n* [CareTeam](careteam.html): Who care team is for\r\n* [ChargeItem](chargeitem.html): Individual service was done for/to\r\n* [Claim](claim.html): Patient receiving the products or services\r\n* [ClaimResponse](claimresponse.html): The subject of care\r\n* [ClinicalImpression](clinicalimpression.html): Patient assessed\r\n* [Communication](communication.html): Focus of message\r\n* [CommunicationRequest](communicationrequest.html): Focus of message\r\n* [Composition](composition.html): Who and/or what the composition is about\r\n* [Condition](condition.html): Who has the condition?\r\n* [Consent](consent.html): Who the consent applies to\r\n* [Contract](contract.html): The identity of the subject of the contract (if a patient)\r\n* [Coverage](coverage.html): Retrieve coverages for a patient\r\n* [CoverageEligibilityRequest](coverageeligibilityrequest.html): The reference to the patient\r\n* [CoverageEligibilityResponse](coverageeligibilityresponse.html): The reference to the patient\r\n* [DetectedIssue](detectedissue.html): Associated patient\r\n* [DeviceRequest](devicerequest.html): Individual the service is ordered for\r\n* [DeviceUsage](deviceusage.html): Search by patient who used / uses the device\r\n* [DiagnosticReport](diagnosticreport.html): The subject of the report if a patient\r\n* [DocumentReference](documentreference.html): Who/what is the subject of the document\r\n* [Encounter](encounter.html): The patient present at the encounter\r\n* [EnrollmentRequest](enrollmentrequest.html): The party to be enrolled\r\n* [EpisodeOfCare](episodeofcare.html): The patient who is the focus of this episode of care\r\n* [ExplanationOfBenefit](explanationofbenefit.html): The reference to the patient\r\n* [FamilyMemberHistory](familymemberhistory.html): The identity of a subject to list family member history items for\r\n* [Flag](flag.html): The identity of a subject to list flags for\r\n* [Goal](goal.html): Who this goal is intended for\r\n* [GuidanceResponse](guidanceresponse.html): The identity of a patient to search for guidance response results\r\n* [ImagingSelection](imagingselection.html): Who the study is about\r\n* [ImagingStudy](imagingstudy.html): Who the study is about\r\n* [Immunization](immunization.html): The patient for the vaccination record\r\n* [ImmunizationEvaluation](immunizationevaluation.html): The patient being evaluated\r\n* [ImmunizationRecommendation](immunizationrecommendation.html): Who this profile is for\r\n* [Invoice](invoice.html): Recipient(s) of goods and services\r\n* [List](list.html): If all resources have the same subject\r\n* [MeasureReport](measurereport.html): The identity of a patient to search for individual measure report results for\r\n* [MedicationAdministration](medicationadministration.html): The identity of a patient to list administrations  for\r\n* [MedicationDispense](medicationdispense.html): The identity of a patient to list dispenses  for\r\n* [MedicationRequest](medicationrequest.html): Returns prescriptions for a specific patient\r\n* [MedicationStatement](medicationstatement.html): Returns statements for a specific patient.\r\n* [MolecularSequence](molecularsequence.html): The subject that the sequence is about\r\n* [NutritionIntake](nutritionintake.html): Returns statements for a specific patient.\r\n* [NutritionOrder](nutritionorder.html): The identity of the individual or set of individuals who requires the diet, formula or nutritional supplement\r\n* [Observation](observation.html): The subject that the observation is about (if patient)\r\n* [Person](person.html): The Person links to this Patient\r\n* [Procedure](procedure.html): Search by subject - a patient\r\n* [Provenance](provenance.html): Where the activity involved patient data\r\n* [QuestionnaireResponse](questionnaireresponse.html): The patient that is the subject of the questionnaire response\r\n* [RelatedPerson](relatedperson.html): The patient this related person is related to\r\n* [RequestOrchestration](requestorchestration.html): The identity of a patient to search for request orchestrations\r\n* [ResearchSubject](researchsubject.html): Who or what is part of study\r\n* [RiskAssessment](riskassessment.html): Who/what does assessment apply to?\r\n* [ServiceRequest](servicerequest.html): Search by subject - a patient\r\n* [Specimen](specimen.html): The patient the specimen comes from\r\n* [SupplyDelivery](supplydelivery.html): Patient for whom the item is supplied\r\n* [SupplyRequest](supplyrequest.html): The patient or subject for whom the supply is destined\r\n* [Task](task.html): Search by patient\r\n* [VisionPrescription](visionprescription.html): The identity of a patient to list dispenses for\r\n", type="reference", providesMembershipIn={@Compartment(name="Base FHIR compartment definition for Patient")}, target={Patient.class})
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("RelatedPerson:patient").toLocked();
    @SearchParamDefinition(name="address-city", path="Patient.address.city | Person.address.city | Practitioner.address.city | RelatedPerson.address.city", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A city specified in an address\r\n* [Person](person.html): A city specified in an address\r\n* [Practitioner](practitioner.html): A city specified in an address\r\n* [RelatedPerson](relatedperson.html): A city specified in an address\r\n", type="string")
    public static final String SP_ADDRESS_CITY = "address-city";
    public static final StringClientParam ADDRESS_CITY = new StringClientParam("address-city");
    @SearchParamDefinition(name="address-country", path="Patient.address.country | Person.address.country | Practitioner.address.country | RelatedPerson.address.country", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A country specified in an address\r\n* [Person](person.html): A country specified in an address\r\n* [Practitioner](practitioner.html): A country specified in an address\r\n* [RelatedPerson](relatedperson.html): A country specified in an address\r\n", type="string")
    public static final String SP_ADDRESS_COUNTRY = "address-country";
    public static final StringClientParam ADDRESS_COUNTRY = new StringClientParam("address-country");
    @SearchParamDefinition(name="address-postalcode", path="Patient.address.postalCode | Person.address.postalCode | Practitioner.address.postalCode | RelatedPerson.address.postalCode", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A postalCode specified in an address\r\n* [Person](person.html): A postal code specified in an address\r\n* [Practitioner](practitioner.html): A postalCode specified in an address\r\n* [RelatedPerson](relatedperson.html): A postal code specified in an address\r\n", type="string")
    public static final String SP_ADDRESS_POSTALCODE = "address-postalcode";
    public static final StringClientParam ADDRESS_POSTALCODE = new StringClientParam("address-postalcode");
    @SearchParamDefinition(name="address-state", path="Patient.address.state | Person.address.state | Practitioner.address.state | RelatedPerson.address.state", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A state specified in an address\r\n* [Person](person.html): A state specified in an address\r\n* [Practitioner](practitioner.html): A state specified in an address\r\n* [RelatedPerson](relatedperson.html): A state specified in an address\r\n", type="string")
    public static final String SP_ADDRESS_STATE = "address-state";
    public static final StringClientParam ADDRESS_STATE = new StringClientParam("address-state");
    @SearchParamDefinition(name="address-use", path="Patient.address.use | Person.address.use | Practitioner.address.use | RelatedPerson.address.use", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A use code specified in an address\r\n* [Person](person.html): A use code specified in an address\r\n* [Practitioner](practitioner.html): A use code specified in an address\r\n* [RelatedPerson](relatedperson.html): A use code specified in an address\r\n", type="token")
    public static final String SP_ADDRESS_USE = "address-use";
    public static final TokenClientParam ADDRESS_USE = new TokenClientParam("address-use");
    @SearchParamDefinition(name="address", path="Patient.address | Person.address | Practitioner.address | RelatedPerson.address", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text\r\n* [Person](person.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text\r\n* [Practitioner](practitioner.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text\r\n* [RelatedPerson](relatedperson.html): A server defined search that may match any of the string fields in the Address, including line, city, district, state, country, postalCode, and/or text\r\n", type="string")
    public static final String SP_ADDRESS = "address";
    public static final StringClientParam ADDRESS = new StringClientParam("address");
    @SearchParamDefinition(name="birthdate", path="Patient.birthDate | Person.birthDate | RelatedPerson.birthDate", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): The patient's date of birth\r\n* [Person](person.html): The person's date of birth\r\n* [RelatedPerson](relatedperson.html): The Related Person's date of birth\r\n", type="date")
    public static final String SP_BIRTHDATE = "birthdate";
    public static final DateClientParam BIRTHDATE = new DateClientParam("birthdate");
    @SearchParamDefinition(name="email", path="Patient.telecom.where(system='email') | Person.telecom.where(system='email') | Practitioner.telecom.where(system='email') | PractitionerRole.contact.telecom.where(system='email') | RelatedPerson.telecom.where(system='email')", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A value in an email contact\r\n* [Person](person.html): A value in an email contact\r\n* [Practitioner](practitioner.html): A value in an email contact\r\n* [PractitionerRole](practitionerrole.html): A value in an email contact\r\n* [RelatedPerson](relatedperson.html): A value in an email contact\r\n", type="token")
    public static final String SP_EMAIL = "email";
    public static final TokenClientParam EMAIL = new TokenClientParam("email");
    @SearchParamDefinition(name="gender", path="Patient.gender | Person.gender | Practitioner.gender | RelatedPerson.gender", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): Gender of the patient\r\n* [Person](person.html): The gender of the person\r\n* [Practitioner](practitioner.html): Gender of the practitioner\r\n* [RelatedPerson](relatedperson.html): Gender of the related person\r\n", type="token")
    public static final String SP_GENDER = "gender";
    public static final TokenClientParam GENDER = new TokenClientParam("gender");
    @SearchParamDefinition(name="phone", path="Patient.telecom.where(system='phone') | Person.telecom.where(system='phone') | Practitioner.telecom.where(system='phone') | PractitionerRole.contact.telecom.where(system='phone') | RelatedPerson.telecom.where(system='phone')", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A value in a phone contact\r\n* [Person](person.html): A value in a phone contact\r\n* [Practitioner](practitioner.html): A value in a phone contact\r\n* [PractitionerRole](practitionerrole.html): A value in a phone contact\r\n* [RelatedPerson](relatedperson.html): A value in a phone contact\r\n", type="token")
    public static final String SP_PHONE = "phone";
    public static final TokenClientParam PHONE = new TokenClientParam("phone");
    @SearchParamDefinition(name="phonetic", path="Patient.name | Person.name | Practitioner.name | RelatedPerson.name", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): A portion of either family or given name using some kind of phonetic matching algorithm\r\n* [Person](person.html): A portion of name using some kind of phonetic matching algorithm\r\n* [Practitioner](practitioner.html): A portion of either family or given name using some kind of phonetic matching algorithm\r\n* [RelatedPerson](relatedperson.html): A portion of name using some kind of phonetic matching algorithm\r\n", type="string")
    public static final String SP_PHONETIC = "phonetic";
    public static final StringClientParam PHONETIC = new StringClientParam("phonetic");
    @SearchParamDefinition(name="telecom", path="Patient.telecom | Person.telecom | Practitioner.telecom | PractitionerRole.contact.telecom | RelatedPerson.telecom", description="Multiple Resources: \r\n\r\n* [Patient](patient.html): The value in any kind of telecom details of the patient\r\n* [Person](person.html): The value in any kind of contact\r\n* [Practitioner](practitioner.html): The value in any kind of contact\r\n* [PractitionerRole](practitionerrole.html): The value in any kind of contact\r\n* [RelatedPerson](relatedperson.html): The value in any kind of contact\r\n", type="token")
    public static final String SP_TELECOM = "telecom";
    public static final TokenClientParam TELECOM = new TokenClientParam("telecom");

    public RelatedPerson() {
    }

    public RelatedPerson(Reference patient) {
        this.setPatient(patient);
    }

    public List<Identifier> getIdentifier() {
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        return this.identifier;
    }

    public RelatedPerson setIdentifier(List<Identifier> theIdentifier) {
        this.identifier = theIdentifier;
        return this;
    }

    public boolean hasIdentifier() {
        if (this.identifier == null) {
            return false;
        }
        for (Identifier item : this.identifier) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Identifier addIdentifier() {
        Identifier t = new Identifier();
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return t;
    }

    public RelatedPerson addIdentifier(Identifier t) {
        if (t == null) {
            return this;
        }
        if (this.identifier == null) {
            this.identifier = new ArrayList<Identifier>();
        }
        this.identifier.add(t);
        return this;
    }

    public Identifier getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public BooleanType getActiveElement() {
        if (this.active == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.active");
            }
            if (Configuration.doAutoCreate()) {
                this.active = new BooleanType();
            }
        }
        return this.active;
    }

    public boolean hasActiveElement() {
        return this.active != null && !this.active.isEmpty();
    }

    public boolean hasActive() {
        return this.active != null && !this.active.isEmpty();
    }

    public RelatedPerson setActiveElement(BooleanType value) {
        this.active = value;
        return this;
    }

    public boolean getActive() {
        return this.active == null || this.active.isEmpty() ? false : (Boolean)this.active.getValue();
    }

    public RelatedPerson setActive(boolean value) {
        if (this.active == null) {
            this.active = new BooleanType();
        }
        this.active.setValue((Object)value);
        return this;
    }

    public Reference getPatient() {
        if (this.patient == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.patient");
            }
            if (Configuration.doAutoCreate()) {
                this.patient = new Reference();
            }
        }
        return this.patient;
    }

    public boolean hasPatient() {
        return this.patient != null && !this.patient.isEmpty();
    }

    public RelatedPerson setPatient(Reference value) {
        this.patient = value;
        return this;
    }

    public List<CodeableConcept> getRelationship() {
        if (this.relationship == null) {
            this.relationship = new ArrayList<CodeableConcept>();
        }
        return this.relationship;
    }

    public RelatedPerson setRelationship(List<CodeableConcept> theRelationship) {
        this.relationship = theRelationship;
        return this;
    }

    public boolean hasRelationship() {
        if (this.relationship == null) {
            return false;
        }
        for (CodeableConcept item : this.relationship) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public CodeableConcept addRelationship() {
        CodeableConcept t = new CodeableConcept();
        if (this.relationship == null) {
            this.relationship = new ArrayList<CodeableConcept>();
        }
        this.relationship.add(t);
        return t;
    }

    public RelatedPerson addRelationship(CodeableConcept t) {
        if (t == null) {
            return this;
        }
        if (this.relationship == null) {
            this.relationship = new ArrayList<CodeableConcept>();
        }
        this.relationship.add(t);
        return this;
    }

    public CodeableConcept getRelationshipFirstRep() {
        if (this.getRelationship().isEmpty()) {
            this.addRelationship();
        }
        return this.getRelationship().get(0);
    }

    public List<HumanName> getName() {
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        return this.name;
    }

    public RelatedPerson setName(List<HumanName> theName) {
        this.name = theName;
        return this;
    }

    public boolean hasName() {
        if (this.name == null) {
            return false;
        }
        for (HumanName item : this.name) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public HumanName addName() {
        HumanName t = new HumanName();
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return t;
    }

    public RelatedPerson addName(HumanName t) {
        if (t == null) {
            return this;
        }
        if (this.name == null) {
            this.name = new ArrayList<HumanName>();
        }
        this.name.add(t);
        return this;
    }

    public HumanName getNameFirstRep() {
        if (this.getName().isEmpty()) {
            this.addName();
        }
        return this.getName().get(0);
    }

    public List<ContactPoint> getTelecom() {
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        return this.telecom;
    }

    public RelatedPerson setTelecom(List<ContactPoint> theTelecom) {
        this.telecom = theTelecom;
        return this;
    }

    public boolean hasTelecom() {
        if (this.telecom == null) {
            return false;
        }
        for (ContactPoint item : this.telecom) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public ContactPoint addTelecom() {
        ContactPoint t = new ContactPoint();
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return t;
    }

    public RelatedPerson addTelecom(ContactPoint t) {
        if (t == null) {
            return this;
        }
        if (this.telecom == null) {
            this.telecom = new ArrayList<ContactPoint>();
        }
        this.telecom.add(t);
        return this;
    }

    public ContactPoint getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public Enumeration<Enumerations.AdministrativeGender> getGenderElement() {
        if (this.gender == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.gender");
            }
            if (Configuration.doAutoCreate()) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
        }
        return this.gender;
    }

    public boolean hasGenderElement() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public boolean hasGender() {
        return this.gender != null && !this.gender.isEmpty();
    }

    public RelatedPerson setGenderElement(Enumeration<Enumerations.AdministrativeGender> value) {
        this.gender = value;
        return this;
    }

    public Enumerations.AdministrativeGender getGender() {
        return this.gender == null ? null : (Enumerations.AdministrativeGender)((Object)this.gender.getValue());
    }

    public RelatedPerson setGender(Enumerations.AdministrativeGender value) {
        if (value == null) {
            this.gender = null;
        } else {
            if (this.gender == null) {
                this.gender = new Enumeration<Enumerations.AdministrativeGender>(new Enumerations.AdministrativeGenderEnumFactory());
            }
            this.gender.setValue((Object)value);
        }
        return this;
    }

    public DateType getBirthDateElement() {
        if (this.birthDate == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.birthDate");
            }
            if (Configuration.doAutoCreate()) {
                this.birthDate = new DateType();
            }
        }
        return this.birthDate;
    }

    public boolean hasBirthDateElement() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public boolean hasBirthDate() {
        return this.birthDate != null && !this.birthDate.isEmpty();
    }

    public RelatedPerson setBirthDateElement(DateType value) {
        this.birthDate = value;
        return this;
    }

    public Date getBirthDate() {
        return this.birthDate == null ? null : (Date)this.birthDate.getValue();
    }

    public RelatedPerson setBirthDate(Date value) {
        if (value == null) {
            this.birthDate = null;
        } else {
            if (this.birthDate == null) {
                this.birthDate = new DateType();
            }
            this.birthDate.setValue(value);
        }
        return this;
    }

    public List<Address> getAddress() {
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        return this.address;
    }

    public RelatedPerson setAddress(List<Address> theAddress) {
        this.address = theAddress;
        return this;
    }

    public boolean hasAddress() {
        if (this.address == null) {
            return false;
        }
        for (Address item : this.address) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Address addAddress() {
        Address t = new Address();
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return t;
    }

    public RelatedPerson addAddress(Address t) {
        if (t == null) {
            return this;
        }
        if (this.address == null) {
            this.address = new ArrayList<Address>();
        }
        this.address.add(t);
        return this;
    }

    public Address getAddressFirstRep() {
        if (this.getAddress().isEmpty()) {
            this.addAddress();
        }
        return this.getAddress().get(0);
    }

    public List<Attachment> getPhoto() {
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        return this.photo;
    }

    public RelatedPerson setPhoto(List<Attachment> thePhoto) {
        this.photo = thePhoto;
        return this;
    }

    public boolean hasPhoto() {
        if (this.photo == null) {
            return false;
        }
        for (Attachment item : this.photo) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public Attachment addPhoto() {
        Attachment t = new Attachment();
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return t;
    }

    public RelatedPerson addPhoto(Attachment t) {
        if (t == null) {
            return this;
        }
        if (this.photo == null) {
            this.photo = new ArrayList<Attachment>();
        }
        this.photo.add(t);
        return this;
    }

    public Attachment getPhotoFirstRep() {
        if (this.getPhoto().isEmpty()) {
            this.addPhoto();
        }
        return this.getPhoto().get(0);
    }

    public Period getPeriod() {
        if (this.period == null) {
            if (Configuration.errorOnAutoCreate()) {
                throw new Error("Attempt to auto-create RelatedPerson.period");
            }
            if (Configuration.doAutoCreate()) {
                this.period = new Period();
            }
        }
        return this.period;
    }

    public boolean hasPeriod() {
        return this.period != null && !this.period.isEmpty();
    }

    public RelatedPerson setPeriod(Period value) {
        this.period = value;
        return this;
    }

    public List<RelatedPersonCommunicationComponent> getCommunication() {
        if (this.communication == null) {
            this.communication = new ArrayList<RelatedPersonCommunicationComponent>();
        }
        return this.communication;
    }

    public RelatedPerson setCommunication(List<RelatedPersonCommunicationComponent> theCommunication) {
        this.communication = theCommunication;
        return this;
    }

    public boolean hasCommunication() {
        if (this.communication == null) {
            return false;
        }
        for (RelatedPersonCommunicationComponent item : this.communication) {
            if (item.isEmpty()) continue;
            return true;
        }
        return false;
    }

    public RelatedPersonCommunicationComponent addCommunication() {
        RelatedPersonCommunicationComponent t = new RelatedPersonCommunicationComponent();
        if (this.communication == null) {
            this.communication = new ArrayList<RelatedPersonCommunicationComponent>();
        }
        this.communication.add(t);
        return t;
    }

    public RelatedPerson addCommunication(RelatedPersonCommunicationComponent t) {
        if (t == null) {
            return this;
        }
        if (this.communication == null) {
            this.communication = new ArrayList<RelatedPersonCommunicationComponent>();
        }
        this.communication.add(t);
        return this;
    }

    public RelatedPersonCommunicationComponent getCommunicationFirstRep() {
        if (this.getCommunication().isEmpty()) {
            this.addCommunication();
        }
        return this.getCommunication().get(0);
    }

    @Override
    protected void listChildren(List<Property> children) {
        super.listChildren(children);
        children.add(new Property(SP_IDENTIFIER, "Identifier", "Identifier for a person within a particular scope.", 0, Integer.MAX_VALUE, this.identifier));
        children.add(new Property(SP_ACTIVE, "boolean", "Whether this related person record is in active use.", 0, 1, this.active));
        children.add(new Property(SP_PATIENT, "Reference(Patient)", "The patient this person is related to.", 0, 1, this.patient));
        children.add(new Property(SP_RELATIONSHIP, "CodeableConcept", "The nature of the relationship between the related person and the patient.", 0, Integer.MAX_VALUE, this.relationship));
        children.add(new Property(SP_NAME, "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name));
        children.add(new Property(SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom));
        children.add(new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, 1, this.gender));
        children.add(new Property("birthDate", "date", "The date on which the related person was born.", 0, 1, this.birthDate));
        children.add(new Property(SP_ADDRESS, "Address", "Address where the related person can be contacted or visited.", 0, Integer.MAX_VALUE, this.address));
        children.add(new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo));
        children.add(new Property("period", "Period", "The period of time during which this relationship is or was active. If there are no dates defined, then the interval is unknown.", 0, 1, this.period));
        children.add(new Property("communication", "", "A language which may be used to communicate with the related person about the patient's health.", 0, Integer.MAX_VALUE, this.communication));
    }

    @Override
    public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
        switch (_hash) {
            case -1618432855: {
                return new Property(SP_IDENTIFIER, "Identifier", "Identifier for a person within a particular scope.", 0, Integer.MAX_VALUE, this.identifier);
            }
            case -1422950650: {
                return new Property(SP_ACTIVE, "boolean", "Whether this related person record is in active use.", 0, 1, this.active);
            }
            case -791418107: {
                return new Property(SP_PATIENT, "Reference(Patient)", "The patient this person is related to.", 0, 1, this.patient);
            }
            case -261851592: {
                return new Property(SP_RELATIONSHIP, "CodeableConcept", "The nature of the relationship between the related person and the patient.", 0, Integer.MAX_VALUE, this.relationship);
            }
            case 3373707: {
                return new Property(SP_NAME, "HumanName", "A name associated with the person.", 0, Integer.MAX_VALUE, this.name);
            }
            case -1429363305: {
                return new Property(SP_TELECOM, "ContactPoint", "A contact detail for the person, e.g. a telephone number or an email address.", 0, Integer.MAX_VALUE, this.telecom);
            }
            case -1249512767: {
                return new Property(SP_GENDER, "code", "Administrative Gender - the gender that the person is considered to have for administration and record keeping purposes.", 0, 1, this.gender);
            }
            case -1210031859: {
                return new Property("birthDate", "date", "The date on which the related person was born.", 0, 1, this.birthDate);
            }
            case -1147692044: {
                return new Property(SP_ADDRESS, "Address", "Address where the related person can be contacted or visited.", 0, Integer.MAX_VALUE, this.address);
            }
            case 106642994: {
                return new Property("photo", "Attachment", "Image of the person.", 0, Integer.MAX_VALUE, this.photo);
            }
            case -991726143: {
                return new Property("period", "Period", "The period of time during which this relationship is or was active. If there are no dates defined, then the interval is unknown.", 0, 1, this.period);
            }
            case -1035284522: {
                return new Property("communication", "", "A language which may be used to communicate with the related person about the patient's health.", 0, Integer.MAX_VALUE, this.communication);
            }
        }
        return super.getNamedProperty(_hash, _name, _checkValid);
    }

    @Override
    public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.identifier == null ? new Base[]{} : this.identifier.toArray(new Base[this.identifier.size()]);
            }
            case -1422950650: {
                Base[] baseArray;
                if (this.active == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray2 = new Base[1];
                    baseArray = baseArray2;
                    baseArray2[0] = this.active;
                }
                return baseArray;
            }
            case -791418107: {
                Base[] baseArray;
                if (this.patient == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray3 = new Base[1];
                    baseArray = baseArray3;
                    baseArray3[0] = this.patient;
                }
                return baseArray;
            }
            case -261851592: {
                return this.relationship == null ? new Base[]{} : this.relationship.toArray(new Base[this.relationship.size()]);
            }
            case 3373707: {
                return this.name == null ? new Base[]{} : this.name.toArray(new Base[this.name.size()]);
            }
            case -1429363305: {
                return this.telecom == null ? new Base[]{} : this.telecom.toArray(new Base[this.telecom.size()]);
            }
            case -1249512767: {
                Base[] baseArray;
                if (this.gender == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray4 = new Base[1];
                    baseArray = baseArray4;
                    baseArray4[0] = this.gender;
                }
                return baseArray;
            }
            case -1210031859: {
                Base[] baseArray;
                if (this.birthDate == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray5 = new Base[1];
                    baseArray = baseArray5;
                    baseArray5[0] = this.birthDate;
                }
                return baseArray;
            }
            case -1147692044: {
                return this.address == null ? new Base[]{} : this.address.toArray(new Base[this.address.size()]);
            }
            case 106642994: {
                return this.photo == null ? new Base[]{} : this.photo.toArray(new Base[this.photo.size()]);
            }
            case -991726143: {
                Base[] baseArray;
                if (this.period == null) {
                    baseArray = new Base[]{};
                } else {
                    Base[] baseArray6 = new Base[1];
                    baseArray = baseArray6;
                    baseArray6[0] = this.period;
                }
                return baseArray;
            }
            case -1035284522: {
                return this.communication == null ? new Base[]{} : this.communication.toArray(new Base[this.communication.size()]);
            }
        }
        return super.getProperty(hash, name, checkValid);
    }

    @Override
    public Base setProperty(int hash, String name, Base value) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
                return value;
            }
            case -1422950650: {
                this.active = TypeConvertor.castToBoolean(value);
                return value;
            }
            case -791418107: {
                this.patient = TypeConvertor.castToReference(value);
                return value;
            }
            case -261851592: {
                this.getRelationship().add(TypeConvertor.castToCodeableConcept(value));
                return value;
            }
            case 3373707: {
                this.getName().add(TypeConvertor.castToHumanName(value));
                return value;
            }
            case -1429363305: {
                this.getTelecom().add(TypeConvertor.castToContactPoint(value));
                return value;
            }
            case -1249512767: {
                value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
                this.gender = value;
                return value;
            }
            case -1210031859: {
                this.birthDate = TypeConvertor.castToDate(value);
                return value;
            }
            case -1147692044: {
                this.getAddress().add(TypeConvertor.castToAddress(value));
                return value;
            }
            case 106642994: {
                this.getPhoto().add(TypeConvertor.castToAttachment(value));
                return value;
            }
            case -991726143: {
                this.period = TypeConvertor.castToPeriod(value);
                return value;
            }
            case -1035284522: {
                this.getCommunication().add((RelatedPersonCommunicationComponent)((Object)value));
                return value;
            }
        }
        return super.setProperty(hash, name, value);
    }

    @Override
    public Base setProperty(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().add(TypeConvertor.castToIdentifier(value));
        } else if (name.equals(SP_ACTIVE)) {
            this.active = TypeConvertor.castToBoolean(value);
        } else if (name.equals(SP_PATIENT)) {
            this.patient = TypeConvertor.castToReference(value);
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.getRelationship().add(TypeConvertor.castToCodeableConcept(value));
        } else if (name.equals(SP_NAME)) {
            this.getName().add(TypeConvertor.castToHumanName(value));
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().add(TypeConvertor.castToContactPoint(value));
        } else if (name.equals(SP_GENDER)) {
            value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.gender = value;
        } else if (name.equals("birthDate")) {
            this.birthDate = TypeConvertor.castToDate(value);
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().add(TypeConvertor.castToAddress(value));
        } else if (name.equals("photo")) {
            this.getPhoto().add(TypeConvertor.castToAttachment(value));
        } else if (name.equals("period")) {
            this.period = TypeConvertor.castToPeriod(value);
        } else if (name.equals("communication")) {
            this.getCommunication().add((RelatedPersonCommunicationComponent)((Object)value));
        } else {
            return super.setProperty(name, value);
        }
        return value;
    }

    @Override
    public void removeChild(String name, Base value) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            this.getIdentifier().remove(value);
        } else if (name.equals(SP_ACTIVE)) {
            this.active = null;
        } else if (name.equals(SP_PATIENT)) {
            this.patient = null;
        } else if (name.equals(SP_RELATIONSHIP)) {
            this.getRelationship().remove(value);
        } else if (name.equals(SP_NAME)) {
            this.getName().remove(value);
        } else if (name.equals(SP_TELECOM)) {
            this.getTelecom().remove(value);
        } else if (name.equals(SP_GENDER)) {
            value = new Enumerations.AdministrativeGenderEnumFactory().fromType(TypeConvertor.castToCode(value));
            this.gender = value;
        } else if (name.equals("birthDate")) {
            this.birthDate = null;
        } else if (name.equals(SP_ADDRESS)) {
            this.getAddress().remove(value);
        } else if (name.equals("photo")) {
            this.getPhoto().remove(value);
        } else if (name.equals("period")) {
            this.period = null;
        } else if (name.equals("communication")) {
            this.getCommunication().remove((RelatedPersonCommunicationComponent)((Object)value));
        } else {
            super.removeChild(name, value);
        }
    }

    @Override
    public Base makeProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return this.addIdentifier();
            }
            case -1422950650: {
                return this.getActiveElement();
            }
            case -791418107: {
                return this.getPatient();
            }
            case -261851592: {
                return this.addRelationship();
            }
            case 3373707: {
                return this.addName();
            }
            case -1429363305: {
                return this.addTelecom();
            }
            case -1249512767: {
                return this.getGenderElement();
            }
            case -1210031859: {
                return this.getBirthDateElement();
            }
            case -1147692044: {
                return this.addAddress();
            }
            case 106642994: {
                return this.addPhoto();
            }
            case -991726143: {
                return this.getPeriod();
            }
            case -1035284522: {
                return this.addCommunication();
            }
        }
        return super.makeProperty(hash, name);
    }

    @Override
    public String[] getTypesForProperty(int hash, String name) throws FHIRException {
        switch (hash) {
            case -1618432855: {
                return new String[]{"Identifier"};
            }
            case -1422950650: {
                return new String[]{"boolean"};
            }
            case -791418107: {
                return new String[]{"Reference"};
            }
            case -261851592: {
                return new String[]{"CodeableConcept"};
            }
            case 3373707: {
                return new String[]{"HumanName"};
            }
            case -1429363305: {
                return new String[]{"ContactPoint"};
            }
            case -1249512767: {
                return new String[]{"code"};
            }
            case -1210031859: {
                return new String[]{"date"};
            }
            case -1147692044: {
                return new String[]{"Address"};
            }
            case 106642994: {
                return new String[]{"Attachment"};
            }
            case -991726143: {
                return new String[]{"Period"};
            }
            case -1035284522: {
                return new String[0];
            }
        }
        return super.getTypesForProperty(hash, name);
    }

    @Override
    public Base addChild(String name) throws FHIRException {
        if (name.equals(SP_IDENTIFIER)) {
            return this.addIdentifier();
        }
        if (name.equals(SP_ACTIVE)) {
            throw new FHIRException("Cannot call addChild on a singleton property RelatedPerson.active");
        }
        if (name.equals(SP_PATIENT)) {
            this.patient = new Reference();
            return this.patient;
        }
        if (name.equals(SP_RELATIONSHIP)) {
            return this.addRelationship();
        }
        if (name.equals(SP_NAME)) {
            return this.addName();
        }
        if (name.equals(SP_TELECOM)) {
            return this.addTelecom();
        }
        if (name.equals(SP_GENDER)) {
            throw new FHIRException("Cannot call addChild on a singleton property RelatedPerson.gender");
        }
        if (name.equals("birthDate")) {
            throw new FHIRException("Cannot call addChild on a singleton property RelatedPerson.birthDate");
        }
        if (name.equals(SP_ADDRESS)) {
            return this.addAddress();
        }
        if (name.equals("photo")) {
            return this.addPhoto();
        }
        if (name.equals("period")) {
            this.period = new Period();
            return this.period;
        }
        if (name.equals("communication")) {
            return this.addCommunication();
        }
        return super.addChild(name);
    }

    @Override
    public String fhirType() {
        return "RelatedPerson";
    }

    @Override
    public RelatedPerson copy() {
        RelatedPerson dst = new RelatedPerson();
        this.copyValues(dst);
        return dst;
    }

    public void copyValues(RelatedPerson dst) {
        super.copyValues(dst);
        if (this.identifier != null) {
            dst.identifier = new ArrayList<Identifier>();
            for (Identifier identifier : this.identifier) {
                dst.identifier.add(identifier.copy());
            }
        }
        dst.active = this.active == null ? null : this.active.copy();
        Reference reference = dst.patient = this.patient == null ? null : this.patient.copy();
        if (this.relationship != null) {
            dst.relationship = new ArrayList<CodeableConcept>();
            for (CodeableConcept codeableConcept : this.relationship) {
                dst.relationship.add(codeableConcept.copy());
            }
        }
        if (this.name != null) {
            dst.name = new ArrayList<HumanName>();
            for (HumanName humanName : this.name) {
                dst.name.add(humanName.copy());
            }
        }
        if (this.telecom != null) {
            dst.telecom = new ArrayList<ContactPoint>();
            for (ContactPoint contactPoint : this.telecom) {
                dst.telecom.add(contactPoint.copy());
            }
        }
        dst.gender = this.gender == null ? null : this.gender.copy();
        DateType dateType = dst.birthDate = this.birthDate == null ? null : this.birthDate.copy();
        if (this.address != null) {
            dst.address = new ArrayList<Address>();
            for (Address address : this.address) {
                dst.address.add(address.copy());
            }
        }
        if (this.photo != null) {
            dst.photo = new ArrayList<Attachment>();
            for (Attachment attachment : this.photo) {
                dst.photo.add(attachment.copy());
            }
        }
        Period period = dst.period = this.period == null ? null : this.period.copy();
        if (this.communication != null) {
            dst.communication = new ArrayList<RelatedPersonCommunicationComponent>();
            for (RelatedPersonCommunicationComponent relatedPersonCommunicationComponent : this.communication) {
                dst.communication.add(relatedPersonCommunicationComponent.copy());
            }
        }
    }

    protected RelatedPerson typedCopy() {
        return this.copy();
    }

    @Override
    public boolean equalsDeep(Base other_) {
        if (!super.equalsDeep(other_)) {
            return false;
        }
        if (!(other_ instanceof RelatedPerson)) {
            return false;
        }
        RelatedPerson o = (RelatedPerson)other_;
        return RelatedPerson.compareDeep(this.identifier, o.identifier, true) && RelatedPerson.compareDeep(this.active, o.active, true) && RelatedPerson.compareDeep(this.patient, o.patient, true) && RelatedPerson.compareDeep(this.relationship, o.relationship, true) && RelatedPerson.compareDeep(this.name, o.name, true) && RelatedPerson.compareDeep(this.telecom, o.telecom, true) && RelatedPerson.compareDeep(this.gender, o.gender, true) && RelatedPerson.compareDeep(this.birthDate, o.birthDate, true) && RelatedPerson.compareDeep(this.address, o.address, true) && RelatedPerson.compareDeep(this.photo, o.photo, true) && RelatedPerson.compareDeep(this.period, o.period, true) && RelatedPerson.compareDeep(this.communication, o.communication, true);
    }

    @Override
    public boolean equalsShallow(Base other_) {
        if (!super.equalsShallow(other_)) {
            return false;
        }
        if (!(other_ instanceof RelatedPerson)) {
            return false;
        }
        RelatedPerson o = (RelatedPerson)other_;
        return RelatedPerson.compareValues(this.active, o.active, true) && RelatedPerson.compareValues(this.gender, o.gender, true) && RelatedPerson.compareValues(this.birthDate, o.birthDate, true);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.identifier, this.active, this.patient, this.relationship, this.name, this.telecom, this.gender, this.birthDate, this.address, this.photo, this.period, this.communication});
    }

    @Override
    public ResourceType getResourceType() {
        return ResourceType.RelatedPerson;
    }

    @Block
    public static class RelatedPersonCommunicationComponent
    extends BackboneElement
    implements IBaseBackboneElement {
        @Child(name="language", type={CodeableConcept.class}, order=1, min=1, max=1, modifier=false, summary=false)
        @Description(shortDefinition="The language which can be used to communicate with the related person about the patient's health", formalDefinition="The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-AU\" for Australian English.")
        @Binding(valueSet="http://hl7.org/fhir/ValueSet/all-languages")
        protected CodeableConcept language;
        @Child(name="preferred", type={BooleanType.class}, order=2, min=0, max=1, modifier=false, summary=false)
        @Description(shortDefinition="Language preference indicator", formalDefinition="Indicates whether or not the related person prefers this language (over other languages he or she masters up a certain level).")
        protected BooleanType preferred;
        private static final long serialVersionUID = 633792918L;

        public RelatedPersonCommunicationComponent() {
        }

        public RelatedPersonCommunicationComponent(CodeableConcept language) {
            this.setLanguage(language);
        }

        public CodeableConcept getLanguage() {
            if (this.language == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedPersonCommunicationComponent.language");
                }
                if (Configuration.doAutoCreate()) {
                    this.language = new CodeableConcept();
                }
            }
            return this.language;
        }

        public boolean hasLanguage() {
            return this.language != null && !this.language.isEmpty();
        }

        public RelatedPersonCommunicationComponent setLanguage(CodeableConcept value) {
            this.language = value;
            return this;
        }

        public BooleanType getPreferredElement() {
            if (this.preferred == null) {
                if (Configuration.errorOnAutoCreate()) {
                    throw new Error("Attempt to auto-create RelatedPersonCommunicationComponent.preferred");
                }
                if (Configuration.doAutoCreate()) {
                    this.preferred = new BooleanType();
                }
            }
            return this.preferred;
        }

        public boolean hasPreferredElement() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public boolean hasPreferred() {
            return this.preferred != null && !this.preferred.isEmpty();
        }

        public RelatedPersonCommunicationComponent setPreferredElement(BooleanType value) {
            this.preferred = value;
            return this;
        }

        public boolean getPreferred() {
            return this.preferred == null || this.preferred.isEmpty() ? false : (Boolean)this.preferred.getValue();
        }

        public RelatedPersonCommunicationComponent setPreferred(boolean value) {
            if (this.preferred == null) {
                this.preferred = new BooleanType();
            }
            this.preferred.setValue((Object)value);
            return this;
        }

        @Override
        protected void listChildren(List<Property> children) {
            super.listChildren(children);
            children.add(new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-AU\" for Australian English.", 0, 1, this.language));
            children.add(new Property("preferred", "boolean", "Indicates whether or not the related person prefers this language (over other languages he or she masters up a certain level).", 0, 1, this.preferred));
        }

        @Override
        public Property getNamedProperty(int _hash, String _name, boolean _checkValid) throws FHIRException {
            switch (_hash) {
                case -1613589672: {
                    return new Property("language", "CodeableConcept", "The ISO-639-1 alpha 2 code in lower case for the language, optionally followed by a hyphen and the ISO-3166-1 alpha 2 code for the region in upper case; e.g. \"en\" for English, or \"en-US\" for American English versus \"en-AU\" for Australian English.", 0, 1, this.language);
                }
                case -1294005119: {
                    return new Property("preferred", "boolean", "Indicates whether or not the related person prefers this language (over other languages he or she masters up a certain level).", 0, 1, this.preferred);
                }
            }
            return super.getNamedProperty(_hash, _name, _checkValid);
        }

        @Override
        public Base[] getProperty(int hash, String name, boolean checkValid) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    Base[] baseArray;
                    if (this.language == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray2 = new Base[1];
                        baseArray = baseArray2;
                        baseArray2[0] = this.language;
                    }
                    return baseArray;
                }
                case -1294005119: {
                    Base[] baseArray;
                    if (this.preferred == null) {
                        baseArray = new Base[]{};
                    } else {
                        Base[] baseArray3 = new Base[1];
                        baseArray = baseArray3;
                        baseArray3[0] = this.preferred;
                    }
                    return baseArray;
                }
            }
            return super.getProperty(hash, name, checkValid);
        }

        @Override
        public Base setProperty(int hash, String name, Base value) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    this.language = TypeConvertor.castToCodeableConcept(value);
                    return value;
                }
                case -1294005119: {
                    this.preferred = TypeConvertor.castToBoolean(value);
                    return value;
                }
            }
            return super.setProperty(hash, name, value);
        }

        @Override
        public Base setProperty(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = TypeConvertor.castToCodeableConcept(value);
            } else if (name.equals("preferred")) {
                this.preferred = TypeConvertor.castToBoolean(value);
            } else {
                return super.setProperty(name, value);
            }
            return value;
        }

        @Override
        public void removeChild(String name, Base value) throws FHIRException {
            if (name.equals("language")) {
                this.language = null;
            } else if (name.equals("preferred")) {
                this.preferred = null;
            } else {
                super.removeChild(name, value);
            }
        }

        @Override
        public Base makeProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return this.getLanguage();
                }
                case -1294005119: {
                    return this.getPreferredElement();
                }
            }
            return super.makeProperty(hash, name);
        }

        @Override
        public String[] getTypesForProperty(int hash, String name) throws FHIRException {
            switch (hash) {
                case -1613589672: {
                    return new String[]{"CodeableConcept"};
                }
                case -1294005119: {
                    return new String[]{"boolean"};
                }
            }
            return super.getTypesForProperty(hash, name);
        }

        @Override
        public Base addChild(String name) throws FHIRException {
            if (name.equals("language")) {
                this.language = new CodeableConcept();
                return this.language;
            }
            if (name.equals("preferred")) {
                throw new FHIRException("Cannot call addChild on a singleton property RelatedPerson.communication.preferred");
            }
            return super.addChild(name);
        }

        @Override
        public RelatedPersonCommunicationComponent copy() {
            RelatedPersonCommunicationComponent dst = new RelatedPersonCommunicationComponent();
            this.copyValues(dst);
            return dst;
        }

        public void copyValues(RelatedPersonCommunicationComponent dst) {
            super.copyValues(dst);
            dst.language = this.language == null ? null : this.language.copy();
            dst.preferred = this.preferred == null ? null : this.preferred.copy();
        }

        @Override
        public boolean equalsDeep(Base other_) {
            if (!super.equalsDeep(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedPersonCommunicationComponent)) {
                return false;
            }
            RelatedPersonCommunicationComponent o = (RelatedPersonCommunicationComponent)other_;
            return RelatedPersonCommunicationComponent.compareDeep(this.language, o.language, true) && RelatedPersonCommunicationComponent.compareDeep(this.preferred, o.preferred, true);
        }

        @Override
        public boolean equalsShallow(Base other_) {
            if (!super.equalsShallow(other_)) {
                return false;
            }
            if (!(other_ instanceof RelatedPersonCommunicationComponent)) {
                return false;
            }
            RelatedPersonCommunicationComponent o = (RelatedPersonCommunicationComponent)other_;
            return RelatedPersonCommunicationComponent.compareValues(this.preferred, o.preferred, true);
        }

        @Override
        public boolean isEmpty() {
            return super.isEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.language, this.preferred});
        }

        @Override
        public String fhirType() {
            return "RelatedPerson.communication";
        }
    }
}

