/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.renderers.spreadsheets;

import java.io.IOException;
import java.util.List;
import org.apache.poi.ss.usermodel.Sheet;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.renderers.spreadsheets.CanonicalSpreadsheetGenerator;

public class ValueSetSpreadsheetGenerator
extends CanonicalSpreadsheetGenerator {
    public ValueSetSpreadsheetGenerator(IWorkerContext context) {
        super(context);
    }

    public boolean canGenerate(ValueSet vs) {
        return true;
    }

    public ValueSetSpreadsheetGenerator renderValueSet(ValueSet vs) throws IOException {
        if (vs == null) {
            System.out.println("no valueset!");
        }
        this.addValueSetMetadata(this.renderCanonicalResource(vs, false), vs);
        for (ValueSet.ConceptSetComponent inc : vs.getCompose().getInclude()) {
            this.genInclude(vs, inc, "Include");
        }
        for (ValueSet.ConceptSetComponent exc : vs.getCompose().getExclude()) {
            this.genInclude(vs, exc, "Exclude");
        }
        if (vs.hasExpansion()) {
            if (vs.getExpansion().hasParameter()) {
                this.genExpansionParams(vs.getExpansion().getParameter());
            }
            this.genExpansion(vs.getExpansion().getContains());
        }
        return this;
    }

    private void addValueSetMetadata(Sheet sheet, ValueSet vs) {
        this.addMetadataRow(sheet, "Immutable", vs.getImmutableElement().toString());
    }

    private void genExpansionParams(List<ValueSet.ValueSetExpansionParameterComponent> params) {
        Sheet sheet = this.makeSheet("Expansion Parameters");
        this.addHeaders(sheet, "Parameter", "Value");
        for (ValueSet.ValueSetExpansionParameterComponent p : params) {
            this.addRow(sheet, p.getName(), this.dr.displayDataType(p.getValue()));
        }
    }

    private void genExpansion(List<ValueSet.ValueSetExpansionContainsComponent> list) {
        Sheet sheet = this.makeSheet("Expansion");
        this.addHeaders(sheet, "Level", "System", "version", "Code", "Display", "Abstract", "Inactive");
        this.genExpansionEntry(1, list, sheet);
    }

    public void genExpansionEntry(int level, List<ValueSet.ValueSetExpansionContainsComponent> list, Sheet sheet) {
        for (ValueSet.ValueSetExpansionContainsComponent p : list) {
            this.addRow(sheet, Integer.toString(level), p.getSystem(), p.getVersion(), p.getCode(), p.getDisplay(), this.bool(p.getAbstract()), this.bool(p.getInactive()));
            if (!p.hasContains()) continue;
            this.genExpansionEntry(level + 1, p.getContains(), sheet);
        }
    }

    private String bool(boolean value) {
        return value ? "" : "false";
    }

    private void genInclude(ValueSet vs, ValueSet.ConceptSetComponent inc, String mode) {
        if (inc.hasSystem()) {
            this.genIncludeSystem(vs, inc, mode);
        } else {
            this.genIncludeValueSets(vs, inc, mode);
        }
    }

    private void genIncludeValueSets(ValueSet vs, ValueSet.ConceptSetComponent inc, String mode) {
        Sheet sheet = this.makeSheet(mode + " ValueSets");
        this.addValueSets(sheet, inc.getValueSet());
        this.configureSheet(sheet);
    }

    private void genIncludeSystem(ValueSet vs, ValueSet.ConceptSetComponent inc, String mode) {
        Sheet sheet = this.makeSheet(mode + " from " + this.dr.displaySystem(inc.getSystem()));
        if (inc.hasValueSet()) {
            this.addValueSets(sheet, inc.getValueSet());
        }
        if (inc.hasFilter()) {
            this.addFilters(sheet, inc.getFilter());
        }
        if (inc.hasConcept()) {
            this.addConcepts(sheet, inc.getConcept());
        }
        if (!inc.hasConcept() && !inc.hasFilter()) {
            this.addAllCodes(sheet);
        }
        this.addRow(sheet, "", "");
        this.addRow(sheet, "System URI", inc.getSystem());
        this.configureSheet(sheet);
    }

    private void addAllCodes(Sheet sheet) {
        this.addHeaders(sheet, "Codes");
        this.addRow(sheet, "All codes");
    }

    private void addValueSets(Sheet sheet, List<CanonicalType> valueSets) {
        this.addHeaders(sheet, "ValueSet URL");
        for (CanonicalType u : valueSets) {
            this.addRow(sheet, (String)u.getValue());
        }
    }

    private void configureSheet(Sheet sheet) {
        sheet.setColumnWidth(0, this.columnPixels(30.0));
        sheet.setColumnWidth(1, this.columnPixels(40.0));
        sheet.setColumnWidth(1, this.columnPixels(50.0));
    }

    private void addConcepts(Sheet sheet, List<ValueSet.ConceptReferenceComponent> concepts) {
        this.addHeaders(sheet, "Concept", "Description");
        for (ValueSet.ConceptReferenceComponent cd : concepts) {
            this.addRow(sheet, cd.getCode(), cd.getDisplay());
        }
    }

    private void addFilters(Sheet sheet, List<ValueSet.ConceptSetFilterComponent> filters) {
        this.addHeaders(sheet, "Property", "Operation", "Value");
        for (ValueSet.ConceptSetFilterComponent f : filters) {
            this.addRow(sheet, f.getProperty(), f.getOpElement().asStringValue(), f.getValue());
        }
    }
}

