/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.exceptions.DefinitionException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;

public class DefinitionNavigator {
    private IWorkerContext context;
    private StructureDefinition structure;
    private int index;
    private boolean indexMatches;
    private List<DefinitionNavigator> children;
    private List<DefinitionNavigator> typeChildren;
    private List<DefinitionNavigator> slices;
    private List<String> names = new ArrayList<String>();
    private ElementDefinition.TypeRefComponent typeOfChildren;
    private String path;
    private boolean diff;

    public DefinitionNavigator(IWorkerContext context, StructureDefinition structure, boolean diff) throws DefinitionException {
        if (!diff && !structure.hasSnapshot()) {
            throw new DefinitionException("Snapshot required");
        }
        this.context = context;
        this.structure = structure;
        this.index = 0;
        this.diff = diff;
        if (diff) {
            this.path = structure.getType();
            this.indexMatches = this.path.equals(this.list().get(0).getPath());
        } else {
            this.indexMatches = true;
            this.path = this.current().getPath();
        }
        this.names.add(this.nameTail());
    }

    private DefinitionNavigator(IWorkerContext context, StructureDefinition structure, boolean diff, int index, String path, List<String> names, String type) {
        this.path = path;
        this.context = context;
        this.structure = structure;
        this.diff = diff;
        this.index = index;
        this.indexMatches = true;
        if (type == null) {
            for (String name : names) {
                this.names.add(name + "." + this.nameTail());
            }
        } else {
            this.names.addAll(names);
            this.names.add(type);
        }
    }

    public List<String> getNames() {
        return this.names;
    }

    private List<ElementDefinition> list() {
        if (this.diff) {
            return this.structure.getDifferential().getElement();
        }
        return this.structure.getSnapshot().getElement();
    }

    public ElementDefinition current() {
        return this.indexMatches ? this.list().get(this.index) : null;
    }

    public List<DefinitionNavigator> slices() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.slices;
    }

    public List<DefinitionNavigator> children() throws DefinitionException {
        if (this.children == null) {
            this.loadChildren();
        }
        return this.children;
    }

    private void loadChildren() throws DefinitionException {
        int i;
        this.children = new ArrayList<DefinitionNavigator>();
        String prefix = this.path + ".";
        HashMap<String, DefinitionNavigator> nameMap = new HashMap<String, DefinitionNavigator>();
        DefinitionNavigator last = null;
        int n = i = this.indexMatches ? this.index + 1 : this.index;
        while (i < this.list().size()) {
            String path = this.list().get(i).getPath();
            if (path.startsWith(prefix)) {
                DefinitionNavigator dn;
                if (!path.substring(prefix.length()).contains(".")) {
                    last = dn = new DefinitionNavigator(this.context, this.structure, this.diff, i, this.path + "." + this.tail(path), this.names, null);
                    if (nameMap.containsKey(path)) {
                        DefinitionNavigator master = (DefinitionNavigator)nameMap.get(path);
                        ElementDefinition cm = master.current();
                        if (this.diff) {
                            this.children.add(dn);
                        } else {
                            if (!cm.hasSlicing()) {
                                throw new DefinitionException("Found slices with no slicing details at " + dn.current().getPath());
                            }
                            if (master.slices == null) {
                                master.slices = new ArrayList<DefinitionNavigator>();
                            }
                            master.slices.add(dn);
                        }
                    } else {
                        nameMap.put(path, dn);
                        this.children.add(dn);
                    }
                } else if (last == null || !path.startsWith(last.path)) {
                    dn = new DefinitionNavigator(this.context, this.structure, this.diff, i, this.path + "." + this.tail(path), this.names, null);
                    nameMap.put(path, dn);
                    this.children.add(dn);
                }
            } else if (path.length() < prefix.length()) break;
            ++i;
        }
    }

    public String path() {
        return this.path;
    }

    private String tail(String p) {
        if (p.contains(".")) {
            return p.substring(p.lastIndexOf(46) + 1);
        }
        return p;
    }

    public String nameTail() {
        return this.tail(this.path);
    }

    public boolean hasTypeChildren(ElementDefinition.TypeRefComponent type, Resource res) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type, res);
        }
        return !this.typeChildren.isEmpty();
    }

    private void loadTypedChildren(ElementDefinition.TypeRefComponent type, Resource src) throws DefinitionException {
        this.typeOfChildren = null;
        StructureDefinition sd = this.context.fetchResource(StructureDefinition.class, type.getWorkingCode(), src);
        if (sd == null) {
            throw new DefinitionException("Unable to find definition for " + type.getWorkingCode() + (String)(type.hasProfile() ? "(" + type.getProfile() + ")" : ""));
        }
        DefinitionNavigator dn = new DefinitionNavigator(this.context, sd, this.diff, 0, this.path, this.names, sd.getType());
        this.typeChildren = dn.children();
        this.typeOfChildren = type;
    }

    public List<DefinitionNavigator> childrenFromType(ElementDefinition.TypeRefComponent type, Resource res) throws DefinitionException {
        if (this.typeChildren == null || this.typeOfChildren != type) {
            this.loadTypedChildren(type, res);
        }
        return this.typeChildren;
    }

    public StructureDefinition getStructure() {
        return this.structure;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return this.current() == null ? this.path : (this.current().hasSliceName() ? this.current().getPath() + ":" + this.current().getSliceName() : this.current().getPath());
    }

    public Base parent() {
        return null;
    }
}

