/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.utilities.Utilities;

public class VersionUtilities {
    public static String packageForVersion(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "hl7.fhir.r2.core";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "hl7.fhir.r2b.core";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "hl7.fhir.r3.core";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "hl7.fhir.r4.core";
        }
        if (VersionUtilities.isR4BVer(v)) {
            return "hl7.fhir.r4b.core";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "hl7.fhir.r5.core";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "hl7.fhir.r6.core";
        }
        if ("current".equals(v)) {
            return "hl7.fhir.r5.core";
        }
        return null;
    }

    public static String getCurrentVersion(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "1.0.2";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "1.4.0";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "3.0.2";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "4.0.1";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "5.0.0";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "6.0.0";
        }
        return v;
    }

    public static String getCurrentPackageVersion(String v) {
        if (VersionUtilities.isR2Ver(v)) {
            return "1.0";
        }
        if (VersionUtilities.isR2BVer(v)) {
            return "1.4";
        }
        if (VersionUtilities.isR3Ver(v)) {
            return "3.0";
        }
        if (VersionUtilities.isR4Ver(v)) {
            return "4.0";
        }
        if (VersionUtilities.isR5Ver(v)) {
            return "5.0";
        }
        if (VersionUtilities.isR6Ver(v)) {
            return "6.0";
        }
        return v;
    }

    public static boolean isSupportedVersion(String version) {
        if (version.contains("-")) {
            version = version.substring(0, version.indexOf("-"));
        }
        return Utilities.existsInList(version, "1.0.2", "1.4.0", "3.0.2", "4.0.1", "4.1.0", "4.3.0", "5.0.0", "6.0.0");
    }

    public static String listSupportedVersions() {
        return "1.0.2, 1.4.0, 3.0.2, 4.0.1, 4.1.0, 4.3.0, 5.0, 6.0";
    }

    public static boolean isR6Ver(String ver) {
        return ver != null && ver.startsWith("6.0");
    }

    public static boolean isR5Ver(String ver) {
        return ver != null && ver.startsWith("5.0");
    }

    public static boolean isR4BVer(String ver) {
        return ver != null && (ver.startsWith("4.1") || ver.startsWith("4.3"));
    }

    public static boolean isR4Ver(String ver) {
        return ver != null && ver.startsWith("4.0");
    }

    public static boolean isR3Ver(String ver) {
        return ver != null && ver.startsWith("3.0");
    }

    public static boolean isR2BVer(String ver) {
        return ver != null && ver.startsWith("1.4");
    }

    public static boolean isR2Ver(String ver) {
        return ver != null && ver.startsWith("1.0");
    }

    public static boolean versionsCompatible(String v1, String v2) {
        if (v1 == null || v2 == null) {
            return false;
        }
        String[] v1l = v1.split("\\|");
        String[] v2l = v2.split("\\|");
        for (String vs1 : v1l) {
            for (String vs2 : v2l) {
                String mm1 = VersionUtilities.getMajMin(vs1);
                String mm2 = VersionUtilities.getMajMin(vs2);
                if (mm1 == null || mm2 == null) {
                    return false;
                }
                if (!mm1.equals(mm2)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isCorePackage(String s) {
        if (s.contains("#")) {
            s = s.substring(0, s.indexOf("#"));
        }
        return Utilities.existsInList(s, "hl7.fhir.core", "hl7.fhir.r2.core", "hl7.fhir.r2b.core", "hl7.fhir.r3.core", "hl7.fhir.r4.core", "hl7.fhir.r4b.core", "hl7.fhir.r5.core", "hl7.fhir.r6.core");
    }

    public static String getMajMin(String version) {
        if (version == null) {
            return null;
        }
        if (Utilities.charCount(version, '.') == 1) {
            String[] p = version.split("\\.");
            return p[0] + "." + p[1];
        }
        if (Utilities.charCount(version, '.') == 2) {
            String[] p = version.split("\\.");
            return p[0] + "." + p[1];
        }
        if (Utilities.existsInList(version, "R2", "R2B", "R3", "R4", "R4B", "R5", "R6")) {
            switch (version) {
                case "R2": {
                    return "1.0";
                }
                case "R2B": {
                    return "1.4";
                }
                case "R3": {
                    return "3.0";
                }
                case "R4": {
                    return "4.0";
                }
                case "R4B": {
                    return "4.3";
                }
                case "R5": {
                    return "5.0";
                }
                case "R6": {
                    return "6.0";
                }
            }
        }
        return null;
    }

    public static String getPatch(String version) {
        if (version == null) {
            return null;
        }
        if (Utilities.charCount(version, '.') == 2) {
            String[] p = version.split("\\.");
            return p[2];
        }
        return null;
    }

    public static boolean isSemVer(String version) {
        if (Utilities.charCount(version, '.') != 2) {
            return false;
        }
        String[] p = version.split("\\.");
        if (p[2].contains("-")) {
            p[2] = p[2].substring(0, p[2].indexOf("-"));
        }
        return Utilities.isInteger(p[0]) && Utilities.isInteger(p[1]) && Utilities.isInteger(p[2]);
    }

    public static boolean isThisOrLater(String test, String current) {
        if (test == null || current == null) {
            return false;
        }
        String t = VersionUtilities.getMajMin(test);
        String c = VersionUtilities.getMajMin(current);
        if (t == null || c == null) {
            return false;
        }
        if (c.compareTo(t) == 0) {
            return VersionUtilities.isMajMinOrLaterPatch(test, current);
        }
        String[] testParts = t.split("\\.");
        String[] currentParts = c.split("\\.");
        for (int i = 0; i < Math.max(testParts.length, currentParts.length); ++i) {
            if (i == testParts.length) {
                return true;
            }
            if (i == currentParts.length) {
                return false;
            }
            String testPart = testParts[i];
            String currentPart = currentParts[i];
            if (testPart.equals(currentPart)) continue;
            return VersionUtilities.compareVersionPart(testPart, currentPart);
        }
        return true;
    }

    private static boolean compareVersionPart(String theTestPart, String theCurrentPart) {
        if (StringUtils.isNumeric((CharSequence)theTestPart) && StringUtils.isNumeric((CharSequence)theCurrentPart)) {
            return Integer.parseInt(theCurrentPart) - Integer.parseInt(theTestPart) >= 0;
        }
        return theCurrentPart.compareTo(theTestPart) >= 0;
    }

    public static boolean isMajMinOrLaterPatch(String test, String current) {
        String t = VersionUtilities.getMajMin(test);
        String c = VersionUtilities.getMajMin(current);
        if (c != null && t != null && c.compareTo(t) == 0) {
            String pt = VersionUtilities.getPatch(test);
            String pc = VersionUtilities.getPatch(current);
            if (pt == null || "x".equals(pt)) {
                return true;
            }
            if (pc != null) {
                if (pt.contains("-") && !pc.contains("-")) {
                    return (pt = pt.substring(0, pt.indexOf("-"))).compareTo(pc) >= 0;
                }
                return VersionUtilities.compareVersionPart(pt, pc);
            }
        }
        return false;
    }

    public static String incMajorVersion(String v) {
        assert (VersionUtilities.isSemVer(v));
        int[] parts = VersionUtilities.splitParts(v);
        return Integer.toString(parts[0] + 1) + ".0.0";
    }

    public static String incMinorVersion(String v) {
        assert (VersionUtilities.isSemVer(v));
        int[] parts = VersionUtilities.splitParts(v);
        return Integer.toString(parts[0]) + "." + Integer.toString(parts[1] + 1) + ".0";
    }

    public static String incPatchVersion(String v) {
        assert (VersionUtilities.isSemVer(v));
        int[] parts = VersionUtilities.splitParts(v);
        return Integer.toString(parts[0]) + "." + Integer.toString(parts[1]) + "." + Integer.toString(parts[2] + 1);
    }

    private static int[] splitParts(String v) {
        String[] p = v.split("\\.");
        int[] i = new int[]{Integer.parseInt(p[0]), Integer.parseInt(p[1]), Integer.parseInt(p[2])};
        return i;
    }

    public static String versionFromCode(String version) {
        if ("r2".equals(version)) {
            return "1.0.2";
        }
        if ("r2b".equals(version)) {
            return "1.4.0";
        }
        if ("r3".equals(version)) {
            return "3.0.2";
        }
        if ("r4".equals(version)) {
            return "4.0.1";
        }
        if ("r4".equals(version)) {
            return "4.0.1";
        }
        if ("r4b".equals(version)) {
            return "4.3.0";
        }
        if ("r5".equals(version)) {
            return "5.0.0";
        }
        if ("r6".equals(version)) {
            return "6.0.0-cibuild";
        }
        throw new FHIRException("Unknown version " + version);
    }

    public static VersionURLInfo parseVersionUrl(String url) {
        if (url.length() < 24) {
            return null;
        }
        String v = url.substring(20, 24);
        if (v.endsWith("/")) {
            v = v.substring(0, v.length() - 1);
            if (Utilities.existsInList(v, "1.0", "1.4", "3.0", "4.0", "5.0", "6.0")) {
                return new VersionURLInfo(v, "http://hl7.org/fhir/" + url.substring(24));
            }
        }
        return null;
    }

    public static List<String> getCanonicalResourceNames(String version) {
        ArrayList<String> res = new ArrayList<String>();
        if (VersionUtilities.isR2Ver(version) || VersionUtilities.isR2BVer(version)) {
            res.add("ValueSet");
            res.add("ConceptMap");
            res.add("NamingSystem");
            res.add("StructureDefinition");
            res.add("DataElement");
            res.add("Conformance");
            res.add("OperationDefinition");
            res.add("SearchParameter");
            res.add("ImplementationGuide");
            res.add("TestScript");
        }
        if (VersionUtilities.isR3Ver(version)) {
            res.add("CodeSystem");
            res.add("CapabilityStatement");
            res.add("StructureDefinition");
            res.add("ImplementationGuide");
            res.add("SearchParameter");
            res.add("MessageDefinition");
            res.add("OperationDefinition");
            res.add("CompartmentDefinition");
            res.add("StructureMap");
            res.add("GraphDefinition");
            res.add("DataElement");
            res.add("CodeSystem");
            res.add("ValueSet");
            res.add("ConceptMap");
            res.add("ExpansionProfile");
            res.add("Questionnaire");
            res.add("ActivityDefinition");
            res.add("ServiceDefinition");
            res.add("PlanDefinition");
            res.add("Measure");
            res.add("TestScript");
        }
        if (VersionUtilities.isR4Ver(version)) {
            res.add("CodeSystem");
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("EffectEvidenceSynthesis");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("ResearchDefinition");
            res.add("ResearchElementDefinition");
            res.add("RiskEvidenceSynthesis");
            res.add("SearchParameter");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("TerminologyCapabilities");
            res.add("TestScript");
            res.add("ValueSet");
        }
        if (VersionUtilities.isR4BVer(version)) {
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("Citation");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceReport");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("ResearchDefinition");
            res.add("ResearchElementDefinition");
            res.add("SearchParameter");
            res.add("SpecimenDefinition");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("SubscriptionTopic");
            res.add("TerminologyCapabilities");
            res.add("TestScript");
            res.add("ValueSet");
        }
        if (VersionUtilities.isR5Ver(version) || VersionUtilities.isR6Ver(version)) {
            res.add("ActorDefinition");
            res.add("ActivityDefinition");
            res.add("CapabilityStatement");
            res.add("ChargeItemDefinition");
            res.add("Citation");
            res.add("ClinicalUseDefinition");
            res.add("CodeSystem");
            res.add("CompartmentDefinition");
            res.add("ConceptMap");
            res.add("ConditionDefinition");
            res.add("EventDefinition");
            res.add("Evidence");
            res.add("EvidenceReport");
            res.add("EvidenceVariable");
            res.add("ExampleScenario");
            res.add("GraphDefinition");
            res.add("ImplementationGuide");
            res.add("Library");
            res.add("Measure");
            res.add("MessageDefinition");
            res.add("NamingSystem");
            res.add("ObservationDefinition");
            res.add("OperationDefinition");
            res.add("PlanDefinition");
            res.add("Questionnaire");
            res.add("Requirements");
            res.add("SearchParameter");
            res.add("SpecimenDefinition");
            res.add("StructureDefinition");
            res.add("StructureMap");
            res.add("SubscriptionTopic");
            res.add("TerminologyCapabilities");
            res.add("TestPlan");
            res.add("TestScript");
            res.add("ValueSet");
        }
        return res;
    }

    public static String getVersionForPackage(String pid) {
        if (pid.startsWith("hl7.fhir.r")) {
            String[] p = pid.split("\\.");
            return VersionUtilities.versionFromCode(p[2]);
        }
        return null;
    }

    public static boolean versionsMatch(String v1, String v2) {
        String mm1 = VersionUtilities.getMajMin(v1);
        String mm2 = VersionUtilities.getMajMin(v2);
        return mm1 != null && mm2 != null && mm1.equals(mm2);
    }

    public static boolean isR5VerOrLater(String version) {
        if (version == null) {
            return false;
        }
        String v = VersionUtilities.getMajMin(version);
        return v.compareTo("4.5") >= 0;
    }

    public static String removeVersionFromCanonical(String url) {
        if (url == null) {
            return null;
        }
        if (url.contains("|")) {
            return url.substring(0, url.indexOf("|"));
        }
        return url;
    }

    public static boolean isR4Plus(String version) {
        return version != null && (version.startsWith("4.") || version.startsWith("5.") || "current".equals(version));
    }

    public static boolean refersTo(String refVer, String v) {
        if (v.length() > refVer.length()) {
            v = v.substring(0, refVer.length());
        }
        return refVer.equals(v);
    }

    public static String getSpecUrl(String v) {
        if (v.contains("-cibuild")) {
            return "http://build.fhir.org";
        }
        if (v.contains("-")) {
            return "http://hl7.org/fhir/" + v;
        }
        switch (VersionUtilities.getMajMin(v)) {
            case "1.0": {
                return "http://hl7.org/fhir/DSTU1";
            }
            case "1.4": {
                return "http://hl7.org/fhir/DSTU2";
            }
            case "3.0": {
                return "http://hl7.org/fhir/STU3";
            }
            case "4.0": {
                return "http://hl7.org/fhir/R4";
            }
            case "4.3": {
                return "http://hl7.org/fhir/R4B";
            }
            case "5.0": {
                return "http://hl7.org/fhir/R5";
            }
            case "6.0": {
                return "http://hl7.org/fhir/R6";
            }
        }
        return "http://hl7.org/fhir";
    }

    public static String getNameForVersion(String v) {
        switch (VersionUtilities.getMajMin(v)) {
            case "1.0": {
                return "R2";
            }
            case "1.4": {
                return "R2B";
            }
            case "3.0": {
                return "R3";
            }
            case "4.0": {
                return "R4";
            }
            case "4.3": {
                return "R4B";
            }
            case "5.0": {
                return "R5";
            }
            case "6.0": {
                return "R6";
            }
        }
        return "R?";
    }

    public static boolean isR5Plus(String version) {
        return version != null && (version.startsWith("5.") || version.startsWith("6.") || "current".equals(version));
    }

    public static boolean isR6Plus(String version) {
        return version != null && version.startsWith("6.");
    }

    public static class VersionURLInfo {
        private String version;
        private String url;

        public VersionURLInfo(String version, String url) {
            this.version = version;
            this.url = url;
        }

        public String getVersion() {
            return this.version;
        }

        public String getUrl() {
            return this.url;
        }
    }
}

