/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.json.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonBoolean;
import org.hl7.fhir.utilities.json.model.JsonComment;
import org.hl7.fhir.utilities.json.model.JsonElementType;
import org.hl7.fhir.utilities.json.model.JsonLocationData;
import org.hl7.fhir.utilities.json.model.JsonNull;
import org.hl7.fhir.utilities.json.model.JsonNumber;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.model.JsonPrimitive;
import org.hl7.fhir.utilities.json.model.JsonString;

public abstract class JsonElement {
    private List<JsonComment> comments;
    private JsonLocationData start;
    private JsonLocationData end;
    private Map<String, Object> userData;

    public abstract JsonElementType type();

    public List<JsonComment> getComments() {
        if (this.comments == null) {
            this.comments = new ArrayList<JsonComment>();
        }
        return this.comments;
    }

    public JsonLocationData getStart() {
        return this.start;
    }

    public void setStart(JsonLocationData start) {
        this.start = start;
    }

    public JsonLocationData getEnd() {
        return this.end;
    }

    public void setEnd(JsonLocationData end) {
        this.end = end;
    }

    protected void check(boolean test, String msg) throws JsonException {
        if (!test) {
            throw new JsonException(msg);
        }
    }

    public boolean hasComments() {
        return this.comments != null && !this.comments.isEmpty();
    }

    public JsonElement deepCopy() {
        return this.make().copy(this);
    }

    protected abstract JsonElement copy(JsonElement var1);

    protected abstract JsonElement make();

    public boolean isJsonObject() {
        return this.type() == JsonElementType.OBJECT;
    }

    public boolean isJsonArray() {
        return this.type() == JsonElementType.ARRAY;
    }

    public boolean isJsonPrimitive() {
        return this.isJsonBoolean() || this.isJsonString() || this.isJsonNull() || this.isJsonNumber();
    }

    public boolean isJsonBoolean() {
        return this.type() == JsonElementType.BOOLEAN;
    }

    public boolean isJsonString() {
        return this.type() == JsonElementType.STRING;
    }

    public boolean isJsonNumber() {
        return this.type() == JsonElementType.NUMBER;
    }

    public boolean isJsonNull() {
        return this.type() == JsonElementType.NULL;
    }

    public JsonObject asJsonObject() {
        return this.isJsonObject() ? (JsonObject)this : null;
    }

    public JsonArray asJsonArray() {
        return this.isJsonArray() ? (JsonArray)this : null;
    }

    public JsonPrimitive asJsonPrimitive() {
        return this.isJsonPrimitive() ? (JsonPrimitive)this : null;
    }

    public JsonBoolean asJsonBoolean() {
        return this.isJsonBoolean() ? (JsonBoolean)this : null;
    }

    public JsonString asJsonString() {
        return this.isJsonString() ? (JsonString)this : null;
    }

    public JsonNumber asJsonNumber() {
        return this.isJsonNumber() ? (JsonNumber)this : null;
    }

    public JsonNull asJsonNull() {
        return this.isJsonNull() ? (JsonNull)this : null;
    }

    public String asString() {
        return this.isJsonPrimitive() ? ((JsonPrimitive)this).getValue() : null;
    }

    public Object getUserData(String name) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(name);
    }

    public void setUserData(String name, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public void clearUserData(String name) {
        if (this.userData != null) {
            this.userData.remove(name);
        }
    }

    public void setUserDataINN(String name, Object value) {
        if (value == null) {
            return;
        }
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(name, value);
    }

    public boolean hasUserData(String name) {
        if (this.userData == null) {
            return false;
        }
        return this.userData.containsKey(name) && this.userData.get(name) != null;
    }

    public String getUserString(String name) {
        Object ud = this.getUserData(name);
        if (ud == null) {
            return null;
        }
        if (ud instanceof String) {
            return (String)ud;
        }
        return ud.toString();
    }

    public int getUserInt(String name) {
        if (!this.hasUserData(name)) {
            return 0;
        }
        return (Integer)this.getUserData(name);
    }

    public void copyUserData(JsonElement other) {
        if (other.userData != null) {
            if (this.userData == null) {
                this.userData = new HashMap<String, Object>();
            }
            this.userData.putAll(other.userData);
        }
    }
}

