/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;

public class FilesystemPackageCacheManagerLocks {
    private static final ConcurrentHashMap<File, FilesystemPackageCacheManagerLocks> cacheFolderLockManagers = new ConcurrentHashMap();
    private final CacheLock cacheLock = new CacheLock();
    private final ConcurrentHashMap<File, PackageLock> packageLocks = new ConcurrentHashMap();
    private final File cacheFolder;
    private final Long lockTimeoutTime;
    private final TimeUnit lockTimeoutTimeUnit;

    public FilesystemPackageCacheManagerLocks(File cacheFolder) throws IOException {
        this(cacheFolder, 60L, TimeUnit.SECONDS);
    }

    private FilesystemPackageCacheManagerLocks(File cacheFolder, Long lockTimeoutTime, TimeUnit lockTimeoutTimeUnit) throws IOException {
        this.cacheFolder = cacheFolder;
        this.lockTimeoutTime = lockTimeoutTime;
        this.lockTimeoutTimeUnit = lockTimeoutTimeUnit;
    }

    protected FilesystemPackageCacheManagerLocks withLockTimeout(Long lockTimeoutTime, TimeUnit lockTimeoutTimeUnit) throws IOException {
        return new FilesystemPackageCacheManagerLocks(this.cacheFolder, lockTimeoutTime, lockTimeoutTimeUnit);
    }

    public static FilesystemPackageCacheManagerLocks getFilesystemPackageCacheManagerLocks(File cacheFolder) throws IOException {
        return cacheFolderLockManagers.computeIfAbsent(cacheFolder, k -> {
            try {
                return new FilesystemPackageCacheManagerLocks((File)k);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public synchronized PackageLock getPackageLock(String packageName) throws IOException {
        File lockFile = new File(Utilities.path(this.cacheFolder.getAbsolutePath(), packageName + ".lock"));
        return this.packageLocks.computeIfAbsent(lockFile, k -> new PackageLock((File)k, new ReentrantReadWriteLock()));
    }

    public CacheLock getCacheLock() {
        return this.cacheLock;
    }

    public class PackageLock {
        private final File lockFile;
        private final ReadWriteLock lock;

        protected PackageLock(File lockFile, ReadWriteLock lock) {
            this.lockFile = lockFile;
            this.lock = lock;
        }

        private void checkForLockFileWaitForDeleteIfExists(File lockFile) throws IOException {
            if (!lockFile.exists()) {
                return;
            }
            try (WatchService watchService = FileSystems.getDefault().newWatchService();){
                Path dir = lockFile.getParentFile().toPath();
                dir.register(watchService, StandardWatchEventKinds.ENTRY_DELETE);
                WatchKey key = watchService.poll(FilesystemPackageCacheManagerLocks.this.lockTimeoutTime, FilesystemPackageCacheManagerLocks.this.lockTimeoutTimeUnit);
                if (key == null) {
                    if (lockFile.exists()) {
                        throw new TimeoutException("Timeout waiting for lock file deletion: " + lockFile.getName());
                    }
                } else {
                    for (WatchEvent<?> event : key.pollEvents()) {
                        Path deletedFilePath;
                        WatchEvent.Kind<?> kind = event.kind();
                        if (kind == StandardWatchEventKinds.ENTRY_DELETE && (deletedFilePath = (Path)event.context()).toString().equals(lockFile.getName())) {
                            return;
                        }
                        key.reset();
                    }
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Error reading package.", e);
            }
            catch (TimeoutException e) {
                throw new IOException("Error reading package.", e);
            }
        }

        public <T> T doReadWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> f) throws IOException {
            FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().readLock().lock();
            this.lock.readLock().lock();
            this.checkForLockFileWaitForDeleteIfExists(this.lockFile);
            T result = null;
            try {
                result = f.get();
            }
            finally {
                this.lock.readLock().unlock();
                FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().readLock().unlock();
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T> T doWriteWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> f) throws IOException {
            FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().writeLock().lock();
            this.lock.writeLock().lock();
            if (!this.lockFile.isFile()) {
                try {
                    TextFile.stringToFile("", this.lockFile);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
            try (FileChannel channel = new RandomAccessFile(this.lockFile, "rw").getChannel();){
                FileLock fileLock = null;
                while (fileLock == null) {
                    fileLock = channel.tryLock(0L, Long.MAX_VALUE, true);
                    if (fileLock != null) continue;
                    Thread.sleep(100L);
                }
                T result = null;
                try {
                    result = f.get();
                }
                finally {
                    fileLock.release();
                    channel.close();
                    if (!this.lockFile.delete()) {
                        this.lockFile.deleteOnExit();
                    }
                    this.lock.writeLock().unlock();
                    FilesystemPackageCacheManagerLocks.this.cacheLock.getLock().writeLock().unlock();
                }
                T t = result;
                return t;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new IOException("Thread interrupted while waiting for lock", e);
            }
        }

        public File getLockFile() {
            return this.lockFile;
        }
    }

    public class CacheLock {
        private final ReadWriteLock lock = new ReentrantReadWriteLock();

        protected CacheLock() {
        }

        public ReadWriteLock getLock() {
            return this.lock;
        }

        public <T> T doWriteWithLock(FilesystemPackageCacheManager.CacheLockFunction<T> f) throws IOException {
            this.lock.writeLock().lock();
            T result = null;
            try {
                result = f.get();
            }
            finally {
                this.lock.writeLock().unlock();
            }
            return result;
        }
    }
}

