/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.npm;

import java.io.File;
import java.io.IOException;
import java.text.ParseException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonArray;
import org.hl7.fhir.utilities.json.model.JsonElement;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;

public class PackageList {
    private String source;
    private JsonObject json;
    private List<PackageListEntry> list = new ArrayList<PackageListEntry>();
    private List<PackageListEntry> versions = new ArrayList<PackageListEntry>();
    private PackageListEntry cibuild;

    public PackageList() {
        this.json = new JsonObject();
        this.json.add("list", new JsonArray());
    }

    public PackageList(JsonObject json) {
        this.json = json;
        for (JsonObject o : json.getJsonObjects("list")) {
            PackageListEntry e = new PackageListEntry(o);
            this.list.add(e);
            if ("current".equals(o.asString("version"))) {
                this.cibuild = e;
                continue;
            }
            this.versions.add(e);
        }
    }

    public static PackageList fromFile(File f) throws JsonException, IOException {
        return new PackageList(JsonParser.parseObject(f)).setSource(f.getAbsolutePath());
    }

    public PackageList setSource(String src) {
        this.source = src;
        return this;
    }

    public static PackageList fromFile(String f) throws JsonException, IOException {
        return new PackageList(JsonParser.parseObjectFromFile(f)).setSource(f);
    }

    public static PackageList fromContent(byte[] cnt) throws JsonException, IOException {
        return new PackageList(JsonParser.parseObject(cnt)).setSource("unknown");
    }

    public static PackageList fromUrl(String url) throws JsonException, IOException {
        return new PackageList(JsonParser.parseObjectFromUrl(url)).setSource(url);
    }

    public String source() {
        return this.source;
    }

    public String canonical() {
        return this.json.asString("canonical");
    }

    public String pid() {
        return this.json.asString("package-id");
    }

    public boolean hasPid() {
        return this.json.has("package-id");
    }

    public String category() {
        return this.json.asString("category");
    }

    public List<PackageListEntry> list() {
        return this.list;
    }

    public List<PackageListEntry> versions() {
        return this.versions;
    }

    public PackageListEntry ciBuild() {
        return this.cibuild;
    }

    public String toJson() {
        return JsonParser.compose((JsonElement)this.json, true);
    }

    public PackageListEntry newVersion(String version, String path, String status, String sequence, FhirPublication fhirVersion) {
        JsonObject o = new JsonObject();
        PackageListEntry e = new PackageListEntry(o);
        this.versions.add(0, e);
        if (this.cibuild != null) {
            this.json.getJsonArray("list").add(1, o);
            this.list.add(1, e);
        } else {
            this.json.getJsonArray("list").add(0, o);
            this.list.add(0, e);
        }
        e.init(version, path, status, sequence, fhirVersion);
        return e;
    }

    public void init(String name, String canonical, String title, String category, String introduction) {
        this.json.add("package-id", name);
        this.json.add("canonical", canonical);
        this.json.add("title", title);
        this.json.add("category", category);
        this.json.add("introduction", introduction);
    }

    public void addCIBuild(String version, String path, String desc, String status) {
        if (this.cibuild != null) {
            this.json.getJsonArray("list").remove(this.cibuild.json);
        }
        this.cibuild = new PackageListEntry(new JsonObject());
        this.cibuild.init(version, path, status, status, null);
        this.json.getJsonArray("list").add(0, this.cibuild.json);
    }

    public PackageListEntry findByVersion(String version) {
        for (PackageListEntry p : this.versions) {
            if (!version.equals(p.version())) continue;
            return p;
        }
        return null;
    }

    public void save(String filepath) throws IOException {
        TextFile.stringToFile(this.toJson(), filepath);
    }

    public String determineLocalPath(String url, String root) throws IOException {
        if (this.canonical().startsWith(url + "/")) {
            String tail = this.canonical().substring(url.length() + 1);
            return Utilities.path(root, tail);
        }
        return null;
    }

    public String title() {
        return this.json.asString("title");
    }

    public PackageListEntry current() {
        for (PackageListEntry e : this.list) {
            if (!e.current() || "ci-build".equals(e.status())) continue;
            return e;
        }
        return null;
    }

    public PackageListEntry latest() {
        for (PackageListEntry e : this.list) {
            if ("ci-build".equals(e.status())) continue;
            return e;
        }
        return null;
    }

    public String intro() {
        return this.json.asString("introduction");
    }

    public List<PackageListEntry> milestones() {
        ArrayList<PackageListEntry> list = new ArrayList<PackageListEntry>();
        for (PackageListEntry t : this.versions) {
            if (t.name() == null) continue;
            list.add(t);
        }
        return list;
    }

    public boolean hasPath(String pathVer) {
        for (PackageListEntry t : this.versions) {
            if (t.path() == null || !t.path().equals(pathVer)) continue;
            return true;
        }
        return false;
    }

    public static class PackageListEntry {
        private JsonObject json;

        private PackageListEntry(JsonObject json) {
            this.json = json;
        }

        public String version() {
            return this.json.asString("version");
        }

        public String path() {
            return this.json.asString("path");
        }

        public boolean current() {
            return this.json.has("current") && this.json.asBoolean("current");
        }

        public boolean cibuild() {
            return "ci-build".equals(this.json.asString("status"));
        }

        public String sequence() {
            return this.json.asString("sequence");
        }

        public String fhirVersion() {
            if (this.json.has("fhir-version")) {
                return this.json.asString("fhir-version");
            }
            return this.json.asString("fhirversion");
        }

        public String status() {
            return this.json.asString("status");
        }

        public String desc() {
            return this.json.asString("desc");
        }

        public String date() {
            return this.json.asString("date");
        }

        public void setDate(String date) {
            this.json.set("date", date);
        }

        public String name() {
            return this.json.asString("name");
        }

        public List<String> subPackages() {
            ArrayList<String> list = new ArrayList<String>();
            if (this.json.has("sub-packages")) {
                list.addAll(this.json.getStrings("sub-packages"));
            }
            return list;
        }

        public void clearSubPackages() {
            this.json.remove("sub-packages");
        }

        public void addSubPackage(String s) {
            this.json.forceArray("sub-packages").add(s);
        }

        private boolean isPartofMainSpec() {
            return Utilities.startsWithInList(this.path(), "http://hl7.org/fhir/DSTU2", "http://hl7.org/fhir/2015Sep", "http://hl7.org/fhir/2015May");
        }

        public String determineLocalPath(String url, String root) throws IOException {
            if (!this.isPartofMainSpec() && this.path().startsWith(url + "/")) {
                String tail = this.path().substring(url.length() + 1);
                return Utilities.path(root, tail);
            }
            return null;
        }

        public void setCurrent(boolean b) {
            if (b) {
                this.json.set("current", true);
            } else if (this.json.has("current")) {
                this.json.remove("current");
            }
        }

        public void init(String version, String path, String status, String sequence, FhirPublication fhirVersion) {
            this.json.set("version", version);
            this.json.set("path", path);
            this.json.set("status", status);
            this.json.set("sequence", sequence);
            if (fhirVersion != null) {
                this.json.set("fhirversion", fhirVersion.toCode());
            }
        }

        public void describe(String desc, String descMD, String changes) {
            if (!Utilities.noString(desc)) {
                this.json.set("desc", desc);
            }
            if (!Utilities.noString(descMD)) {
                this.json.set("descmd", descMD);
            }
            if (!Utilities.noString(changes)) {
                this.json.set("changes", changes);
            }
        }

        public JsonObject json() {
            return this.json;
        }

        public Instant instant() throws ParseException {
            return this.json.asInstant("date");
        }

        public void update(String version, String path, String status, String sequence, FhirPublication fhirVersion, String tcPath, String date) {
            JsonObject tc = new JsonObject();
            this.json.forceArray("corrections").add(tc);
            tc.set("version", this.json.asString("version"));
            tc.set("path", tcPath);
            tc.set("date", date);
            this.json.set("version", version);
            this.json.set("path", path);
            this.json.set("status", status);
            this.json.set("sequence", sequence);
            if (fhirVersion != null) {
                this.json.set("fhirversion", fhirVersion.toCode());
            }
            this.setDate(date);
        }
    }
}

