/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.utilities.xhtml;

import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.primitive.XhtmlDt;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.instance.model.api.IBaseXhtml;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.xhtml.NodeType;
import org.hl7.fhir.utilities.xhtml.XhtmlComposer;
import org.hl7.fhir.utilities.xhtml.XhtmlDocument;
import org.hl7.fhir.utilities.xhtml.XhtmlFluent;
import org.hl7.fhir.utilities.xhtml.XhtmlNodeList;
import org.hl7.fhir.utilities.xhtml.XhtmlParser;

@DatatypeDef(name="xhtml")
public class XhtmlNode
extends XhtmlFluent
implements IBaseXhtml {
    private static final long serialVersionUID = -4362547161441436492L;
    private static boolean checkParaGeneral = false;
    private boolean checkParaTree = false;
    public static final String NBSP = Character.toString('\u00a0');
    public static final String XMLNS = "http://www.w3.org/1999/xhtml";
    private static final String DECL_XMLNS = " xmlns=\"http://www.w3.org/1999/xhtml\"";
    private Location location;
    private NodeType nodeType;
    private String name;
    protected Map<String, String> attributes;
    protected XhtmlNodeList childNodes;
    private String content;
    private boolean notPretty;
    private boolean seperated;
    private Boolean emptyExpanded;
    private Map<String, XhtmlNode> namedParams;
    private Map<String, String> namedParamValues;
    private Map<String, Object> userData;
    private boolean isInPara;

    public XhtmlNode() {
        this.checkParaTree = checkParaGeneral;
    }

    public XhtmlNode(NodeType nodeType, String name) {
        this.nodeType = nodeType;
        this.name = name;
    }

    public XhtmlNode(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public NodeType getNodeType() {
        return this.nodeType;
    }

    public void setNodeType(NodeType nodeType) {
        this.nodeType = nodeType;
    }

    public String getName() {
        return this.name;
    }

    public XhtmlNode setName(String name) {
        assert (!name.contains(":")) : "Name should not contain any : but was " + name;
        if (this.checkParaTree && "p".equals(name)) {
            this.isInPara = true;
        }
        this.name = name;
        return this;
    }

    public boolean hasAttributes() {
        return this.attributes != null && !this.attributes.isEmpty();
    }

    public Map<String, String> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        return this.attributes;
    }

    public boolean hasChildren() {
        return this.childNodes != null && !this.childNodes.isEmpty();
    }

    public XhtmlNodeList getChildNodes() {
        if (this.childNodes == null) {
            this.childNodes = new XhtmlNodeList();
        }
        return this.childNodes;
    }

    public String getContent() {
        return this.content;
    }

    public XhtmlNode setContent(String content) {
        if (this.nodeType == NodeType.Text && this.nodeType == NodeType.Comment) {
            throw new Error("Wrong node type");
        }
        this.content = content;
        return this;
    }

    public void validate(List<String> errors, String path, boolean inResource, boolean inPara, boolean inLink) {
        if (this.nodeType == NodeType.Element || this.nodeType == NodeType.Document) {
            String string = path = Utilities.noString(path) ? this.name : path + "/" + this.name;
            if (inResource) {
                if (!Utilities.existsInList(this.name, "p", "br", "div", "h1", "h2", "h3", "h4", "h5", "h6", "a", "span", "b", "em", "i", "strong", "small", "big", "tt", "small", "dfn", "q", "var", "abbr", "acronym", "cite", "blockquote", "hr", "address", "bdo", "kbd", "q", "sub", "sup", "ul", "ol", "li", "dl", "dt", "dd", "pre", "table", "caption", "colgroup", "col", "thead", "tr", "tfoot", "tbody", "th", "td", "code", "samp", "img", "map", "area")) {
                    errors.add("Error at " + path + ": Found " + this.name + " in a resource");
                }
                if (this.hasAttributes()) {
                    for (String an : this.attributes.keySet()) {
                        boolean ok = an.startsWith("xmlns") || Utilities.existsInList(an, "title", "style", "class", "ID", "lang", "xml:lang", "dir", "accesskey", "tabindex", "span", "width", "align", "valign", "char", "charoff", "abbr", "axis", "headers", "scope", "rowspan", "colspan") || Utilities.existsInList(this.name + "." + an, "a.href", "a.name", "img.src", "img.border", "div.xmlns", "blockquote.cite", "q.cite", "a.charset", "a.type", "a.name", "a.href", "a.hreflang", "a.rel", "a.rev", "a.shape", "a.coords", "img.src", "img.alt", "img.longdesc", "img.height", "img.width", "img.usemap", "img.ismap", "map.name", "area.shape", "area.coords", "area.href", "area.nohref", "area.alt", "table.summary", "table.width", "table.border", "table.frame", "table.rules", "table.cellspacing", "table.cellpadding", "pre.space", "td.nowrap");
                        if (ok) continue;
                        errors.add("Error at " + path + ": Found attribute " + this.name + "." + an + " in a resource");
                    }
                }
            }
            if (inPara && Utilities.existsInList(this.name, "div", "blockquote", "table", "ol", "ul", "p")) {
                errors.add("Error at " + path + ": Found " + this.name + " inside an html paragraph");
            }
            if (inLink && Utilities.existsInList(this.name, "a")) {
                errors.add("Error at " + path + ": Found an <a> inside an <a> paragraph");
            }
            if (this.hasChildren()) {
                if ("p".equals(this.name)) {
                    inPara = true;
                }
                if ("a".equals(this.name)) {
                    inLink = true;
                }
                for (XhtmlNode child : this.childNodes) {
                    child.validate(errors, path, inResource, inPara, inLink);
                }
            }
        }
    }

    private XhtmlNode makeTag(String name) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type - node is " + this.nodeType.toString() + " ('" + this.getName() + "/" + this.getContent() + "')");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Element);
        node.setName(name);
        if (this.getChildNodes().isInPara() || name.equals("p")) {
            node.getChildNodes().setInPara(true);
        }
        if (this.getChildNodes().isInLink() || name.equals("a")) {
            node.getChildNodes().setInLink(true);
        }
        if (Utilities.existsInList(name, "b", "big", "i", "small", "tt", "abbr", "acronym", "cite", "code", "dfn", "em", "kbd", "strong", "samp", "var", "a", "bdo", "br", "img", "map", "object", "q", "script", "span", "sub", "sup", " button", "input", "label", "select", "textarea")) {
            node.notPretty();
        }
        return node;
    }

    @Override
    public XhtmlNode addTag(String name) {
        XhtmlNode node = this.makeTag(name);
        this.addChildNode(node);
        return node;
    }

    @Override
    public XhtmlNode addTag(int index, String name) {
        XhtmlNode node = this.makeTag(name);
        this.addChildNode(index, node);
        return node;
    }

    public XhtmlNode addComment(String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Comment);
        node.setContent(content);
        this.addChildNode(node);
        return node;
    }

    public XhtmlNode addDocType(String content) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.DocType);
        node.setContent(content);
        this.addChildNode(node);
        return node;
    }

    public XhtmlNode addInstruction(String content) {
        if (this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Instruction);
        node.setContent(content);
        this.addChildNode(node);
        return node;
    }

    @Override
    public XhtmlNode addText(String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (content != null) {
            XhtmlNode node = new XhtmlNode(NodeType.Text);
            node.setContent(content);
            this.addChildNode(node);
            return node;
        }
        return null;
    }

    public XhtmlNode addText(int index, String content) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (content == null) {
            throw new Error("Content cannot be null");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Text);
        node.setContent(content);
        this.addChildNode(index, node);
        return node;
    }

    public boolean allChildrenAreText() {
        boolean res = true;
        if (this.hasChildren()) {
            for (XhtmlNode n : this.childNodes) {
                res = res && n.getNodeType() == NodeType.Text;
            }
        }
        return res;
    }

    public XhtmlNode getElement(String name) {
        if (this.hasChildren()) {
            for (XhtmlNode n : this.childNodes) {
                if (n.getNodeType() != NodeType.Element || !name.equals(n.getName())) continue;
                return n;
            }
        }
        return null;
    }

    public XhtmlNode getFirstElement() {
        if (this.hasChildren()) {
            for (XhtmlNode n : this.childNodes) {
                if (n.getNodeType() != NodeType.Element) continue;
                return n;
            }
        }
        return null;
    }

    public String allText() {
        if (!this.hasChildren()) {
            if (this.getContent() == null) {
                return "";
            }
            return this.getContent();
        }
        StringBuilder b = new StringBuilder();
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() == NodeType.Element && Utilities.existsInList(n.getName(), "li")) {
                b.append("* ");
            }
            if (n.getNodeType() == NodeType.Text && n.getContent() != null) {
                b.append(n.getContent());
            }
            if (n.getNodeType() != NodeType.Element) continue;
            b.append(n.allText());
            if (Utilities.existsInList(n.getName(), "p", "div", "tr", "th", "ul", "ol", "li", "h1", "h2", "h3", "h4", "h5", "h6")) {
                b.append("\r\n");
                continue;
            }
            if (!Utilities.existsInList(n.getName(), "th", "td", "span")) continue;
            b.append(" ");
        }
        return b.toString();
    }

    public XhtmlNode attribute(String name, String value) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (name == null) {
            throw new Error("name is null");
        }
        if (value == null) {
            throw new Error("value is null");
        }
        this.getAttributes().put(name, value);
        return this;
    }

    public XhtmlNode attributeNN(String name, String value) {
        if (this.nodeType != NodeType.Element && this.nodeType != NodeType.Document) {
            throw new Error("Wrong node type");
        }
        if (name == null) {
            throw new Error("name is null");
        }
        if (value != null) {
            this.getAttributes().put(name, value);
        }
        return this;
    }

    public boolean hasAttribute(String name) {
        return this.hasAttributes() && this.getAttributes().containsKey(name);
    }

    public boolean hasAttribute(String name, String value) {
        return this.hasAttributes() && this.getAttributes().containsKey(name) && value.equals(this.getAttributes().get(name));
    }

    public String getAttribute(String name) {
        return this.hasAttributes() ? this.getAttributes().get(name) : null;
    }

    public XhtmlNode setAttribute(String name, String value) {
        if (this.nodeType != NodeType.Element) {
            throw new Error("Attempt to set an attribute on something that is not an element");
        }
        this.getAttributes().put(name, value);
        return this;
    }

    public XhtmlNode copy() {
        XhtmlNode dst = new XhtmlNode(this.nodeType);
        dst.name = this.name;
        if (this.hasAttributes()) {
            for (String string : this.attributes.keySet()) {
                dst.getAttributes().put(string, this.attributes.get(string));
            }
        }
        if (this.hasChildren()) {
            for (XhtmlNode xhtmlNode : this.childNodes) {
                dst.addChildNode(xhtmlNode.copy());
            }
        }
        dst.content = this.content;
        return dst;
    }

    public boolean isEmpty() {
        return !this.hasChildren() && this.content == null;
    }

    public boolean equalsDeep(XhtmlNode other) {
        if (other == null) {
            return false;
        }
        if (this.nodeType != other.nodeType || !this.compare(this.name, other.name) || !this.compare(this.content, other.content)) {
            return false;
        }
        if (this.hasAttributes() != other.hasAttributes()) {
            return false;
        }
        if (this.hasAttributes()) {
            if (this.attributes.size() != other.attributes.size()) {
                return false;
            }
            for (String an : this.attributes.keySet()) {
                if (this.attributes.get(an).equals(other.attributes.get(an))) continue;
                return false;
            }
        }
        if (this.hasChildren() != other.hasChildren()) {
            return false;
        }
        if (this.hasChildren()) {
            if (this.childNodes.size() != other.childNodes.size()) {
                return false;
            }
            for (int i = 0; i < this.childNodes.size(); ++i) {
                if (XhtmlNode.compareDeep(this.childNodes.get(i), other.childNodes.get(i))) continue;
                return false;
            }
        }
        return true;
    }

    private boolean compare(String s1, String s2) {
        if (s1 == null && s2 == null) {
            return true;
        }
        if (s1 == null || s2 == null) {
            return false;
        }
        return s1.equals(s2);
    }

    private static boolean compareDeep(XhtmlNode e1, XhtmlNode e2) {
        if (e1 == null && e2 == null) {
            return true;
        }
        if (e1 == null || e2 == null) {
            return false;
        }
        return e1.equalsDeep(e2);
    }

    public String getNsDecl() {
        if (this.hasAttributes()) {
            for (String an : this.attributes.keySet()) {
                if (!an.equals("xmlns")) continue;
                return this.attributes.get(an);
            }
        }
        return null;
    }

    public Boolean getEmptyExpanded() {
        return this.emptyExpanded;
    }

    public boolean hasEmptyExpanded() {
        return this.emptyExpanded != null;
    }

    public void setEmptyExpanded(Boolean emptyExpanded) {
        this.emptyExpanded = emptyExpanded;
    }

    public String getValueAsString() {
        if (this.isEmpty()) {
            return null;
        }
        try {
            String retVal = new XhtmlComposer(true).compose(this);
            retVal = XhtmlDt.preprocessXhtmlNamespaceDeclaration((String)retVal);
            return retVal;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValueAsString(String theValue) throws IllegalArgumentException {
        this.attributes = null;
        this.childNodes = null;
        this.content = null;
        this.name = null;
        this.nodeType = null;
        if (theValue == null || theValue.length() == 0) {
            return;
        }
        Object val = theValue.trim();
        if (!((String)val).startsWith("<")) {
            val = "<div xmlns=\"http://www.w3.org/1999/xhtml\">" + (String)val + "</div>";
        }
        if (((String)val).startsWith("<?") && ((String)val).endsWith("?>")) {
            return;
        }
        val = XhtmlDt.preprocessXhtmlNamespaceDeclaration((String)val);
        try {
            XhtmlDocument fragment = new XhtmlParser().parse((String)val, "div");
            XhtmlNodeList nodes = fragment.getChildNodes();
            XhtmlNode root = nodes.get(nodes.size() > 0 && nodes.get(0) != null && nodes.get(0).getNodeType() == NodeType.Instruction ? 1 : 0);
            this.attributes = root.attributes;
            this.childNodes = root.childNodes;
            this.content = root.getContent();
            this.name = root.getName();
            this.nodeType = root.getNodeType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public XhtmlNode getElementByIndex(int i) {
        int c = 0;
        for (XhtmlNode n : this.childNodes) {
            if (n.getNodeType() != NodeType.Element) continue;
            if (c == i) {
                return n;
            }
            ++c;
        }
        return null;
    }

    public String getValue() {
        return this.getValueAsString();
    }

    public boolean hasValue() {
        return StringUtils.isNotBlank((CharSequence)this.getValueAsString());
    }

    public XhtmlNode setValue(String theValue) throws IllegalArgumentException {
        this.setValueAsString(theValue);
        return this;
    }

    public boolean hasFormatComment() {
        return false;
    }

    public List<String> getFormatCommentsPre() {
        throw new UnsupportedOperationException();
    }

    public List<String> getFormatCommentsPost() {
        throw new UnsupportedOperationException();
    }

    public Object getUserData(String theName) {
        if (this.hasUserData(theName)) {
            return this.userData.get(theName);
        }
        return null;
    }

    public boolean hasUserData(String theName) {
        return this.userData != null && this.userData.containsKey(theName);
    }

    public void setUserData(String theName, Object theValue) {
        if (this.userData == null) {
            this.userData = new HashMap<String, Object>();
        }
        this.userData.put(theName, theValue);
    }

    public Location getLocation() {
        return this.location;
    }

    public void setLocation(Location location) {
        this.location = location;
    }

    public String toString() {
        if (this.nodeType == null) {
            return super.toString();
        }
        switch (this.nodeType) {
            case Document: 
            case Element: {
                try {
                    return new XhtmlComposer(false).compose(this);
                }
                catch (IOException e) {
                    return super.toString();
                }
            }
            case Text: {
                return this.content;
            }
            case Comment: {
                return "<!-- " + this.content + " -->";
            }
            case DocType: {
                return "<? " + this.content + " />";
            }
            case Instruction: {
                return "<? " + this.content + " />";
            }
        }
        return super.toString();
    }

    public XhtmlNode getNextElement(XhtmlNode c) {
        boolean f = false;
        for (XhtmlNode n : this.childNodes) {
            if (n == c) {
                f = true;
                continue;
            }
            if (!f || n.getNodeType() != NodeType.Element) continue;
            return n;
        }
        return null;
    }

    public XhtmlNode notPretty() {
        this.notPretty = true;
        return this;
    }

    public boolean isNoPretty() {
        return this.notPretty;
    }

    public XhtmlNode style(String style) {
        if (this.hasAttribute("style")) {
            this.setAttribute("style", this.getAttribute("style") + "; " + style);
        } else {
            this.setAttribute("style", style);
        }
        return this;
    }

    public XhtmlNode nbsp() {
        this.addText(NBSP);
        return this;
    }

    public XhtmlNode para(String text) {
        XhtmlNode p = this.para();
        p.addText(text);
        return p;
    }

    public XhtmlNode add(XhtmlNode n) {
        this.addChildNode(n);
        return this;
    }

    public XhtmlNode addChildren(List<XhtmlNode> children) {
        this.addChildNodes(children);
        return this;
    }

    public XhtmlNode addChildren(XhtmlNode x) {
        if (x != null) {
            this.addChildNodes(x.getChildNodes());
        }
        return this;
    }

    public XhtmlNode input(String name, String type, String placeholder, int size) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "input");
        p.attribute("name", name);
        p.attribute("type", type);
        p.attribute("placeholder", placeholder);
        p.attribute("size", Integer.toString(size));
        this.addChildNode(p);
        return p;
    }

    public XhtmlNode select(String name) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "select");
        p.attribute("name", name);
        p.attribute("size", "1");
        this.addChildNode(p);
        return p;
    }

    public XhtmlNode option(String value, String text, boolean selected) {
        XhtmlNode p = new XhtmlNode(NodeType.Element, "option");
        p.attribute("value", value);
        p.attribute("selected", Boolean.toString(selected));
        p.tx(text);
        this.addChildNode(p);
        return p;
    }

    public XhtmlNode remove(XhtmlNode x) {
        this.getChildNodes().remove(x);
        return this;
    }

    public void clear() {
        this.getChildNodes().clear();
    }

    public XhtmlNode backgroundColor(String color) {
        this.style("background-color: " + color);
        return this;
    }

    public boolean isPara() {
        return "p".equals(this.name);
    }

    public XhtmlNode sep(String separator) {
        if (!this.seperated) {
            this.seperated = true;
            return this;
        }
        return this.tx(separator);
    }

    public XhtmlNode colspan(String n) {
        return this.setAttribute("colspan", n);
    }

    public XhtmlNode colspan(int n) {
        return this.setAttribute("colspan", Integer.toString(n));
    }

    public XhtmlNode rowspan(int n) {
        if (n > 1) {
            return this.setAttribute("rowspan", Integer.toString(n));
        }
        return this;
    }

    @Override
    protected void addChildren(XhtmlNodeList childNodes) {
        this.addChildNodes(childNodes);
    }

    public XhtmlNode color(String color) {
        return this.span("color: " + color, null);
    }

    public void startScript(String name) {
        if (this.namedParams != null) {
            throw new Error("Sequence Error - script is already open @ " + name);
        }
        this.namedParams = new HashMap<String, XhtmlNode>();
        this.namedParamValues = new HashMap<String, String>();
    }

    public XhtmlNode param(String name) {
        if (this.namedParams == null) {
            throw new Error("Sequence Error - script is not already open");
        }
        XhtmlNode node = new XhtmlNode(NodeType.Element, "p");
        this.namedParams.put(name, node);
        return node;
    }

    public void paramValue(String name, String value) {
        if (this.namedParamValues == null) {
            throw new Error("Sequence Error - script is not already open");
        }
        this.namedParamValues.put(name, value);
    }

    public void paramValue(String name, int value) {
        if (this.namedParamValues == null) {
            throw new Error("Sequence Error - script is not already open");
        }
        this.namedParamValues.put(name, Integer.toString(value));
    }

    public void execScript(String structure) throws FHIRException, IOException {
        XhtmlNode script = new XhtmlParser().parseFragment("<div>" + structure + "</div>");
        this.parseNodes(script.getChildNodes(), this.getChildNodes());
    }

    private void parseNodes(XhtmlNodeList source, XhtmlNodeList dest) {
        for (XhtmlNode n : source) {
            if ("param".equals(n.getName())) {
                XhtmlNode node = this.namedParams.get(n.getAttribute("name"));
                if (node == null) continue;
                this.parseNodes(node.getChildNodes(), dest);
                continue;
            }
            if ("if".equals(n.getName())) {
                String test = n.getAttribute("test");
                if (!this.passesTest(test)) continue;
                this.parseNodes(n.getChildNodes(), dest);
                continue;
            }
            dest.add(n);
        }
    }

    public void closeScript() {
        if (this.namedParams == null) {
            throw new Error("Sequence Error - script is not already open");
        }
        this.namedParams = null;
        this.namedParamValues = null;
    }

    private boolean passesTest(String test) {
        String[] p = test.split("\\s+");
        if (p.length != 3) {
            return false;
        }
        if (!this.namedParamValues.containsKey(p[0])) {
            return false;
        }
        String pv = this.namedParamValues.get(p[0]);
        switch (p[1]) {
            case "=": {
                return p[2].equalsIgnoreCase(pv);
            }
            case "!=": {
                return !p[2].equalsIgnoreCase(pv);
            }
            case "<": {
                return Utilities.isInteger(p[2]) && Utilities.isInteger(pv) && Integer.parseInt(pv) < Integer.parseInt(p[2]);
            }
            case "<=": {
                return Utilities.isInteger(p[2]) && Utilities.isInteger(pv) && Integer.parseInt(pv) <= Integer.parseInt(p[2]);
            }
            case ">": {
                return Utilities.isInteger(p[2]) && Utilities.isInteger(pv) && Integer.parseInt(pv) > Integer.parseInt(p[2]);
            }
            case ">=": {
                return Utilities.isInteger(p[2]) && Utilities.isInteger(pv) && Integer.parseInt(pv) >= Integer.parseInt(p[2]);
            }
        }
        return false;
    }

    public XhtmlNode getElementById(String id) {
        if (id.equals(this.getAttribute("id"))) {
            return this;
        }
        if (this.childNodes != null) {
            for (XhtmlNode x : this.childNodes) {
                XhtmlNode r = x.getElementById(id);
                if (r == null) continue;
                return r;
            }
        }
        return null;
    }

    public List<XhtmlNode> getChildren(String name) {
        ArrayList<XhtmlNode> res = new ArrayList<XhtmlNode>();
        XhtmlNode x = this.getFirstElement();
        while (x != null) {
            if (name.equals(x.getName())) {
                res.add(x);
            }
            x = this.getNextElement(x);
        }
        return res;
    }

    public XhtmlNode strikethrough() {
        return this.addTag("s");
    }

    public XhtmlNode svg() {
        return this.addTag("svg");
    }

    public XhtmlNode path(String value) {
        return this.addTag("path").attribute("d", value);
    }

    public void copyAllContent(XhtmlNode other) {
        this.addChildNodes(other.getChildNodes());
        this.getAttributes().putAll(other.getAttributes());
        if (!Utilities.noString(other.getContent())) {
            this.tx(other.getContent());
        }
    }

    public boolean isClass(String name) {
        return this.hasAttribute("class", name);
    }

    public void styleCells(XhtmlNode x) {
        this.setUserData("cells", x);
    }

    public XhtmlNode td(int index) {
        XhtmlNode x = this.addTag(index, "td");
        XhtmlNode t = (XhtmlNode)this.getUserData("cells");
        if (t != null) {
            x.copyAllContent(t);
        }
        return x;
    }

    @Override
    public XhtmlNode td() {
        XhtmlNode x = this.addTag("td");
        XhtmlNode t = (XhtmlNode)this.getUserData("cells");
        if (t != null) {
            x.copyAllContent(t);
        }
        return x;
    }

    public XhtmlNode td(int index, String width) {
        XhtmlNode x = this.addTag(index, "td");
        x.attribute("width", width);
        XhtmlNode t = (XhtmlNode)this.getUserData("cells");
        if (t != null) {
            x.copyAllContent(t);
        }
        return x;
    }

    public XhtmlNode tdW(int width) {
        XhtmlNode x = this.addTag("td");
        x.attribute("width", Integer.toString(width));
        XhtmlNode t = (XhtmlNode)this.getUserData("cells");
        if (t != null) {
            x.copyAllContent(t);
        }
        return x;
    }

    @Override
    public XhtmlNode txN(String cnt) {
        this.addText(cnt);
        return this;
    }

    public XhtmlNode txOrCode(boolean code, String cnt) {
        if (code) {
            XhtmlNode c = this.code();
            boolean first = true;
            for (String line : cnt.split("\\r?\\n")) {
                if (first) {
                    first = false;
                } else {
                    c.br();
                }
                c.tx(line.replace(" ", Character.toString(160)));
            }
        } else {
            this.addText(cnt);
        }
        return this;
    }

    @Override
    public XhtmlNode iff(boolean test) {
        if (test) {
            return this;
        }
        return new XhtmlNode(NodeType.Element, "span");
    }

    public XhtmlNode button(String class_, String title) {
        XhtmlNode btn = this.addTag("button");
        btn.attribute("class", class_);
        if (title != null) {
            btn.attribute("title", title);
        }
        return btn;
    }

    public XhtmlNode head() {
        return this.addTag("head");
    }

    public XhtmlNode body() {
        return this.addTag("body");
    }

    public XhtmlNode title(String title) {
        return this.addTag("title").tx(title);
    }

    public XhtmlNode link(String rel, String href) {
        return this.addTag("link").attribute("rel", rel).attribute("href", href);
    }

    public XhtmlNode ahOrNot(String href) {
        if (href == null) {
            return this;
        }
        XhtmlNode x = this.addTag("a").attribute("href", href);
        return x;
    }

    public void wbr() {
        this.addTag("wbr");
    }

    @Override
    protected int indexOfNode(XhtmlNode node) {
        return this.getChildNodes().indexOf(node);
    }

    public int compareTo(XhtmlNode other) {
        return XhtmlNode.compare(this, other);
    }

    private static int compare(XhtmlNode base, XhtmlNode other) {
        if (base == null || other == null) {
            return 0;
        }
        if (base.getNodeType() != other.getNodeType()) {
            return base.getNodeType().ordinal() - other.getNodeType().ordinal();
        }
        switch (base.getNodeType()) {
            case Comment: {
                return base.getContent().compareTo(other.getContent());
            }
            case DocType: {
                return 0;
            }
            case Element: {
                int r = base.getName().compareTo(other.getName());
                if (r != 0) {
                    return r;
                }
            }
            case Document: {
                int r;
                if (base.getAttributes().size() != other.getAttributes().size()) {
                    return base.getAttributes().size() - other.getAttributes().size();
                }
                for (String n : base.getAttributes().keySet()) {
                    String vb = base.getAttributes().get(n);
                    String vo = other.getAttributes().get(n);
                    r = vo == null ? -1 : vb.compareTo(vo);
                    if (r == 0) continue;
                    return r;
                }
                if (base.getChildNodes().size() != other.getChildNodes().size()) {
                    return base.getChildNodes().size() - other.getChildNodes().size();
                }
                for (int i = 0; i < base.getChildNodes().size(); ++i) {
                    r = XhtmlNode.compare(base, other);
                    if (r == 0) continue;
                    return r;
                }
                return 0;
            }
            case Instruction: {
                return 0;
            }
            case Text: {
                return base.getContent().compareTo(other.getContent());
            }
        }
        return 0;
    }

    public void stripAnchorsByName(Set<String> anchors) {
        if (this.hasChildren()) {
            this.childNodes.removeIf(n -> "a".equals(n.getName()) && anchors.contains(n.getAttribute("name")));
            for (XhtmlNode c : this.childNodes) {
                c.stripAnchorsByName(anchors);
            }
        }
    }

    public void addChildNodes(List<XhtmlNode> nodes) {
        for (XhtmlNode node : nodes) {
            this.addChildNode(node);
        }
    }

    public void addChildNode(XhtmlNode node) {
        this.checkWhenAddingNode(node);
        this.getChildNodes().add(node);
    }

    private void checkWhenAddingNode(XhtmlNode node) {
        node.checkParaTree = this.checkParaTree;
        if (this.checkParaTree && this.isInPara) {
            if (Utilities.existsInList(node.name, "div", "blockquote", "table", "ol", "ul", "p")) {
                throw new Error("Error: attempt to add " + node.name + " inside an html paragraph");
            }
            node.isInPara = true;
        }
    }

    public void addChildNode(int index, XhtmlNode node) {
        this.checkWhenAddingNode(node);
        this.getChildNodes().add(index, node);
    }

    public static boolean isCheckParaGeneral() {
        return checkParaGeneral;
    }

    public static void setCheckParaGeneral(boolean checkParaGeneral) {
        XhtmlNode.checkParaGeneral = checkParaGeneral;
    }

    public boolean isCheckParaTree() {
        return this.checkParaTree;
    }

    public void setCheckParaTree(boolean checkParaTree) {
        this.checkParaTree = checkParaTree;
    }

    public static class Location
    implements Serializable {
        private static final long serialVersionUID = -4079302502900219721L;
        private int line;
        private int column;

        public Location(int line, int column) {
            this.line = line;
            this.column = column;
        }

        public int getLine() {
            return this.line;
        }

        public int getColumn() {
            return this.column;
        }

        public String toString() {
            return "Line " + Integer.toString(this.line) + ", column " + Integer.toString(this.column);
        }
    }
}

