/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.validation;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.validation.BaseValidator;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class ProfileValidator
extends BaseValidator {
    IWorkerContext context;
    private boolean checkAggregation = false;
    private boolean checkMustSupport = false;

    public void setContext(IWorkerContext context) {
        this.context = context;
    }

    public boolean isCheckAggregation() {
        return this.checkAggregation;
    }

    public boolean isCheckMustSupport() {
        return this.checkMustSupport;
    }

    public void setCheckAggregation(boolean checkAggregation) {
        this.checkAggregation = checkAggregation;
    }

    public void setCheckMustSupport(boolean checkMustSupport) {
        this.checkMustSupport = checkMustSupport;
    }

    @Override
    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean b, String msg) {
        String rn = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        return super.rule(errors, type, path, b, msg, "<a href=\"" + rn.toLowerCase() + ".html\">" + rn + "</a>: " + Utilities.escapeXml((String)msg));
    }

    public List<ValidationMessage> validate(StructureDefinition profile, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getUrl(), profile.hasFhirVersion(), "Profiles SHOULD state the FHIR Version on which they are based");
        this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getUrl(), profile.hasVersion(), "Profiles SHOULD state their own version");
        for (ElementDefinition ec : profile.getDifferential().getElement()) {
            this.checkExtensions(profile, errors, "differential", ec);
        }
        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "missing Snapshot at " + profile.getName() + "." + profile.getName());
        for (ElementDefinition ec : profile.getSnapshot().getElement()) {
            this.checkExtensions(profile, errors, "snapshot", ec);
        }
        if (this.rule(errors, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "A snapshot is required")) {
            Hashtable<String, ElementDefinition> snapshotElements = new Hashtable<String, ElementDefinition>();
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                snapshotElements.put(ed.getId(), ed);
                this.checkExtensions(profile, errors, "snapshot", ed);
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (!forBuild || this.inExemptList(inv.getKey()) || !this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId() + "::" + ed.getPath() + "::" + inv.getKey(), inv.hasExpression(), "The invariant has no FHIR Path expression (" + inv.getXpath() + ")")) continue;
                    try {
                        new FHIRPathEngine(this.context).check(null, profile.getType(), ed.getPath(), inv.getExpression());
                    }
                    catch (Exception exception) {}
                }
            }
            for (ElementDefinition diffElement : profile.getDifferential().getElement()) {
                ElementDefinition snapElement = (ElementDefinition)snapshotElements.get(diffElement.getId());
                if (snapElement == null) continue;
                this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, diffElement.getId(), !this.checkMustSupport || snapElement.hasMustSupport(), "Elements included in the differential should declare mustSupport");
                if (!this.checkAggregation) continue;
                for (ElementDefinition.TypeRefComponent type : snapElement.getType()) {
                    if (!"http://hl7.org/fhir/Reference".equals(type.getCode()) && !"http://hl7.org/fhir/canonical".equals(type.getCode())) continue;
                    this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, diffElement.getId(), type.hasAggregation(), "Elements with type Reference or canonical should declare aggregation");
                }
            }
        }
        return errors;
    }

    private boolean inExemptList(String key) {
        return key.startsWith("txt-");
    }

    private void checkExtensions(StructureDefinition profile, List<ValidationMessage> errors, String kind, ElementDefinition ec) {
        if (!ec.getType().isEmpty() && "Extension".equals(((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getCode()) && ((ElementDefinition.TypeRefComponent)ec.getType().get(0)).hasProfile()) {
            String url = (String)((CanonicalType)((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getProfile().get(0)).getValue();
            StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), defn != null, "Unable to find Extension '" + url + "' referenced at " + profile.getUrl() + " " + kind + " " + ec.getPath() + " (" + ec.getSliceName() + ")");
        }
    }
}

