/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.parser;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.parser.DefaultModelClassFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CanonicalModelClassFactory
extends DefaultModelClassFactory {
    private static final long serialVersionUID = -1795680089524220526L;
    private String myVersion;
    private Class<? extends Message> myMessageClass;

    public CanonicalModelClassFactory() {
        this.myVersion = CanonicalModelClassFactory.getHighestKnownVersion();
    }

    public CanonicalModelClassFactory(String theVersion) {
        if (theVersion == null || !Version.supportsVersion(theVersion)) {
            throw new IllegalArgumentException("Unknown version: " + theVersion);
        }
        this.myVersion = theVersion;
    }

    public CanonicalModelClassFactory(Class<? extends Message> theClass) {
        if (theClass == null) {
            throw new NullPointerException("Class may not be null");
        }
        this.myMessageClass = theClass;
    }

    @Override
    public Class<? extends Group> getGroupClass(String theName, String theVersion) throws HL7Exception {
        return super.getGroupClass(theName, this.myVersion);
    }

    @Override
    public Class<? extends Message> getMessageClass(String theName, String theVersion, boolean theIsExplicit) throws HL7Exception {
        if (this.myMessageClass != null) {
            return this.myMessageClass;
        }
        return super.getMessageClass(theName, this.myVersion, theIsExplicit);
    }

    @Override
    public Class<? extends Segment> getSegmentClass(String theName, String theVersion) throws HL7Exception {
        return super.getSegmentClass(theName, this.myVersion);
    }

    @Override
    public Class<? extends Type> getTypeClass(String theName, String theVersion) throws HL7Exception {
        return super.getTypeClass(theName, this.myVersion);
    }
}

