/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.util;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.Composite;
import ca.uhn.hl7v2.model.DataTypeException;
import ca.uhn.hl7v2.model.GenericComposite;
import ca.uhn.hl7v2.model.GenericPrimitive;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.Segment;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Varies;
import ca.uhn.hl7v2.util.SegmentFinder;
import java.util.StringTokenizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Terser {
    private SegmentFinder finder;
    private static Logger log = LoggerFactory.getLogger(Terser.class);

    public Terser(Message message) {
        if (message == null) {
            throw new NullPointerException("Message may not be null");
        }
        this.finder = new SegmentFinder(message);
    }

    public static String get(Segment segment, int field, int rep, int component, int subcomponent) throws HL7Exception {
        if (segment == null) {
            throw new NullPointerException("segment may not be null");
        }
        if (rep < 0) {
            throw new IllegalArgumentException("rep must not be negative");
        }
        if (component < 1) {
            throw new IllegalArgumentException("component must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        if (subcomponent < 1) {
            throw new IllegalArgumentException("subcomponent must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        Primitive prim = Terser.getPrimitive(segment, field, rep, component, subcomponent);
        return prim.getValue();
    }

    public static void set(Segment segment, int field, int rep, int component, int subcomponent, String value) throws HL7Exception {
        if (segment == null) {
            throw new NullPointerException("segment may not be null");
        }
        if (rep < 0) {
            throw new IllegalArgumentException("rep must not be negative");
        }
        if (component < 1) {
            throw new IllegalArgumentException("component must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        if (subcomponent < 1) {
            throw new IllegalArgumentException("subcomponent must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        Primitive prim = Terser.getPrimitive(segment, field, rep, component, subcomponent);
        prim.setValue(value);
    }

    private static Primitive getPrimitive(Segment segment, int field, int rep, int component, int subcomponent) throws HL7Exception {
        Type type = segment.getField(field, rep);
        return Terser.getPrimitive(type, component, subcomponent);
    }

    public static Primitive getPrimitive(Type type, int component, int subcomponent) {
        if (type == null) {
            throw new NullPointerException("type may not be null");
        }
        if (component < 1) {
            throw new IllegalArgumentException("component must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        if (subcomponent < 1) {
            throw new IllegalArgumentException("subcomponent must not be 1 or more (note that this parameter is 1-indexed, not 0-indexed)");
        }
        Type comp = Terser.getComponent(type, component);
        if (type instanceof Varies && comp instanceof GenericPrimitive && subcomponent > 1) {
            try {
                Varies varies = (Varies)type;
                GenericComposite comp2 = new GenericComposite(type.getMessage());
                varies.setData(comp2);
                comp = Terser.getComponent(type, component);
            }
            catch (DataTypeException de) {
                String message = "Unexpected exception copying data to generic composite. This is probably a bug within HAPI. " + de.getMessage();
                log.error(message, (Throwable)de);
                throw new Error(message);
            }
        }
        Type sub = Terser.getComponent(comp, subcomponent);
        return Terser.getPrimitive(sub);
    }

    private static Primitive getPrimitive(Type type) {
        if (type instanceof Primitive) {
            return (Primitive)type;
        }
        if (type instanceof Composite) {
            try {
                return Terser.getPrimitive(((Composite)type).getComponent(0));
            }
            catch (HL7Exception e) {
                throw new RuntimeException("Internal error: HL7Exception thrown on Composite.getComponent(0).");
            }
        }
        return Terser.getPrimitive(((Varies)type).getData());
    }

    private static Type getComponent(Type type, int comp) {
        if (type instanceof Primitive && comp == 1) {
            return type;
        }
        if (type instanceof Composite && (comp <= Terser.numStandardComponents(type) || type instanceof GenericComposite)) {
            try {
                return ((Composite)type).getComponent(comp - 1);
            }
            catch (DataTypeException e) {
                throw new RuntimeException("Internal error: HL7Exception thrown on getComponent(x) where x < # standard components.", e);
            }
        }
        if (Varies.class.isAssignableFrom(type.getClass())) {
            Varies v = (Varies)type;
            try {
                if (comp > 1 && GenericPrimitive.class.isAssignableFrom(v.getData().getClass())) {
                    v.setData(new GenericComposite(v.getMessage()));
                }
            }
            catch (DataTypeException e) {
                throw new RuntimeException("Unexpected exception copying data to generic composite: " + e.getMessage(), e);
            }
            return Terser.getComponent(v.getData(), comp);
        }
        return type.getExtraComponents().getComponent(comp - Terser.numStandardComponents(type) - 1);
    }

    public String get(String spec) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        Segment segment = this.getSegment(tok.nextToken());
        int[] ind = Terser.getIndices(spec);
        return Terser.get(segment, ind[0], ind[1], ind[2], ind[3]);
    }

    public Segment getSegment(String segSpec) throws HL7Exception {
        Segment seg = null;
        if (segSpec.startsWith("/")) {
            this.getFinder().reset();
        }
        StringTokenizer tok = new StringTokenizer(segSpec, "/", false);
        SegmentFinder finder = this.getFinder();
        while (tok.hasMoreTokens()) {
            String pathSpec = tok.nextToken();
            PathSpec ps = this.parsePathSpec(pathSpec);
            ps.isGroup = tok.hasMoreTokens();
            if (ps.isGroup) {
                Group g = ps.find ? finder.findGroup(ps.pattern, ps.rep) : finder.getGroup(ps.pattern, ps.rep);
                finder = new SegmentFinder(g);
                continue;
            }
            seg = ps.find ? finder.findSegment(ps.pattern, ps.rep) : finder.getSegment(ps.pattern, ps.rep);
        }
        return seg;
    }

    private PathSpec parsePathSpec(String spec) throws HL7Exception {
        PathSpec ps = new PathSpec();
        if (spec.startsWith(".")) {
            ps.find = true;
            spec = spec.substring(1);
        } else {
            ps.find = false;
        }
        if (spec.length() == 0) {
            throw new HL7Exception("Invalid path (some path element is either empty or contains only a dot)");
        }
        StringTokenizer tok = new StringTokenizer(spec, "()", false);
        ps.pattern = tok.nextToken();
        if (tok.hasMoreTokens()) {
            String repString = tok.nextToken();
            try {
                ps.rep = Integer.parseInt(repString);
            }
            catch (NumberFormatException e) {
                throw new HL7Exception(repString + " is not a valid rep #");
            }
        } else {
            ps.rep = 0;
        }
        return ps;
    }

    public static int[] getIndices(String spec) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        tok.nextToken();
        if (!tok.hasMoreTokens()) {
            throw new HL7Exception("Must specify field in spec " + spec);
        }
        try {
            StringTokenizer fieldSpec = new StringTokenizer(tok.nextToken(), "()", false);
            int fieldNum = Integer.parseInt(fieldSpec.nextToken());
            int fieldRep = fieldSpec.hasMoreTokens() ? Integer.parseInt(fieldSpec.nextToken()) : 0;
            int component = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 1;
            int subcomponent = tok.hasMoreTokens() ? Integer.parseInt(tok.nextToken()) : 1;
            return new int[]{fieldNum, fieldRep, component, subcomponent};
        }
        catch (NumberFormatException e) {
            throw new HL7Exception("Invalid integer in spec " + spec);
        }
    }

    public void set(String spec, String value) throws HL7Exception {
        StringTokenizer tok = new StringTokenizer(spec, "-", false);
        Segment segment = this.getSegment(tok.nextToken());
        int[] ind = Terser.getIndices(spec);
        log.trace("Setting {} seg: {} ind: {} {} {} {}", new Object[]{spec, segment.getName(), ind[0], ind[1], ind[2], ind[3]});
        Terser.set(segment, ind[0], ind[1], ind[2], ind[3], value);
    }

    public static int numSubComponents(Type type, int component) {
        if (component == 1 && Primitive.class.isAssignableFrom(type.getClass())) {
            return 1;
        }
        Type comp = Terser.getComponent(type, component);
        return Terser.numComponents(comp);
    }

    public static int numComponents(Type t) {
        if (!(t instanceof Varies)) {
            return Terser.numStandardComponents(t) + t.getExtraComponents().numComponents();
        }
        return Terser.numComponents(((Varies)t).getData());
    }

    private static int numStandardComponents(Type t) {
        if (t instanceof Composite) {
            return ((Composite)t).getComponents().length;
        }
        if (t instanceof Varies) {
            return Terser.numStandardComponents(((Varies)t).getData());
        }
        return 1;
    }

    public SegmentFinder getFinder() {
        return this.finder;
    }

    private class PathSpec {
        public String pattern;
        public boolean isGroup;
        public boolean find;
        public int rep;

        private PathSpec() {
        }
    }
}

