/*
 * Decompiled with CFR 0.152.
 */
package cloud.localstack;

import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;

public class CommonUtils {
    private static final String[] EXCLUDED_DIRECTORIES = new String[]{".github", ".git", ".idea", ".venv", "target", "node_modules"};

    public static void disableSslCertChecking() {
        System.setProperty("com.amazonaws.sdk.disableCertChecking", "true");
    }

    public static void setEnv(String key, String value) {
        HashMap<String, String> newEnv = new HashMap<String, String>(System.getenv());
        newEnv.put(key, value);
        CommonUtils.setEnv(newEnv);
    }

    protected static void setEnv(Map<String, String> newEnv) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            Field theEnvironmentField = processEnvironmentClass.getDeclaredField("theEnvironment");
            theEnvironmentField.setAccessible(true);
            Map env = (Map)theEnvironmentField.get(null);
            env.putAll(newEnv);
            Field theCaseInsensitiveEnvironmentField = processEnvironmentClass.getDeclaredField("theCaseInsensitiveEnvironment");
            theCaseInsensitiveEnvironmentField.setAccessible(true);
            Map cienv = (Map)theCaseInsensitiveEnvironmentField.get(null);
            cienv.putAll(newEnv);
        }
        catch (NoSuchFieldException e) {
            try {
                Class<?>[] classes = Collections.class.getDeclaredClasses();
                Map<String, String> env = System.getenv();
                for (Class<?> cl : classes) {
                    if (!"java.util.Collections$UnmodifiableMap".equals(cl.getName())) continue;
                    Field field = cl.getDeclaredField("m");
                    field.setAccessible(true);
                    Object obj = field.get(env);
                    Map map = (Map)obj;
                    map.clear();
                    map.putAll(newEnv);
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void copyFolder(Path src, Path dest) throws IOException {
        try (Stream<Path> stream = Files.walk(src, new FileVisitOption[0]);){
            stream.forEach(source -> {
                boolean isExcluded = Arrays.stream(EXCLUDED_DIRECTORIES).anyMatch(excluded -> source.toAbsolutePath().toString().contains((CharSequence)excluded));
                if (!isExcluded) {
                    CommonUtils.copy(source, dest.resolve(src.relativize((Path)source)));
                }
            });
        }
    }

    public static void copy(Path source, Path dest) {
        block29: {
            try {
                CopyOption[] options = new CopyOption[]{StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING};
                if (Files.isDirectory(dest, new LinkOption[0])) {
                    return;
                }
                if (Files.exists(dest, new LinkOption[0])) {
                    try (FileChannel sourceFile = FileChannel.open(source, new OpenOption[0]);
                         FileChannel destFile = FileChannel.open(dest, new OpenOption[0]);){
                        if (!Files.getLastModifiedTime(source, new LinkOption[0]).equals(Files.getLastModifiedTime(dest, new LinkOption[0])) || sourceFile.size() != destFile.size()) {
                            Files.copy(source, dest, options);
                        }
                        break block29;
                    }
                }
                Files.copy(source, dest, options);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage(), e);
            }
        }
    }
}

