/*
 * Decompiled with CFR 0.152.
 */
package cn.dev33.satoken.sso;

import cn.dev33.satoken.config.SaSsoConfig;
import cn.dev33.satoken.context.SaHolder;
import cn.dev33.satoken.context.model.SaRequest;
import cn.dev33.satoken.context.model.SaResponse;
import cn.dev33.satoken.sso.SaSsoConsts;
import cn.dev33.satoken.sso.SaSsoManager;
import cn.dev33.satoken.sso.SaSsoUtil;
import cn.dev33.satoken.sso.exception.SaSsoException;
import cn.dev33.satoken.stp.StpLogic;
import cn.dev33.satoken.util.SaFoxUtil;
import cn.dev33.satoken.util.SaResult;

public class SaSsoHandle {
    public static Object serverRequest() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        if (req.isPath(SaSsoConsts.Api.ssoAuth)) {
            return SaSsoHandle.ssoAuth();
        }
        if (req.isPath(SaSsoConsts.Api.ssoDoLogin)) {
            return SaSsoHandle.ssoDoLogin();
        }
        if (req.isPath(SaSsoConsts.Api.ssoCheckTicket) && cfg.getIsHttp().booleanValue()) {
            return SaSsoHandle.ssoCheckTicket();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.getIsSlo().booleanValue() && !req.hasParam(SaSsoConsts.ParamName.loginId)) {
            return SaSsoHandle.ssoLogoutByUserVisit();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.getIsHttp().booleanValue() && cfg.getIsSlo().booleanValue() && req.hasParam(SaSsoConsts.ParamName.loginId)) {
            return SaSsoHandle.ssoLogoutByClientHttp();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object ssoAuth() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (!stpLogic.isLogin()) {
            return cfg.getNotLoginView().get();
        }
        String mode = req.getParam(SaSsoConsts.ParamName.mode, "");
        if (mode.equals("simple")) {
            String redirect = req.getParam(SaSsoConsts.ParamName.redirect);
            SaSsoUtil.checkRedirectUrl(redirect);
            return res.redirect(redirect);
        }
        String redirectUrl = SaSsoUtil.buildRedirectUrl(stpLogic.getLoginId(), req.getParam(SaSsoConsts.ParamName.redirect));
        return res.redirect(redirectUrl);
    }

    public static Object ssoDoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        return cfg.getDoLoginHandle().apply(req.getParam(SaSsoConsts.ParamName.name), req.getParam(SaSsoConsts.ParamName.pwd));
    }

    public static Object ssoCheckTicket() {
        SaRequest req = SaHolder.getRequest();
        String ticket = req.getParamNotNull(SaSsoConsts.ParamName.ticket);
        String sloCallback = req.getParam(SaSsoConsts.ParamName.ssoLogoutCall);
        Object loginId = SaSsoUtil.checkTicket(ticket);
        SaSsoUtil.registerSloCallbackUrl(loginId, sloCallback);
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            return SaResult.error((String)("\u65e0\u6548ticket\uff1a" + ticket));
        }
        return SaResult.data((Object)loginId);
    }

    public static Object ssoLogoutByUserVisit() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        Object loginId = SaSsoUtil.saSsoTemplate.stpLogic.getLoginIdDefaultNull();
        if (SaFoxUtil.isNotEmpty((Object)loginId)) {
            SaSsoUtil.ssoLogout(loginId);
        }
        return SaSsoHandle.ssoLogoutBack(req, res);
    }

    public static Object ssoLogoutByClientHttp() {
        SaRequest req = SaHolder.getRequest();
        String loginId = req.getParam(SaSsoConsts.ParamName.loginId);
        SaSsoUtil.checkSign(req);
        SaSsoUtil.ssoLogout(loginId);
        return SaResult.ok();
    }

    public static Object clientRequest() {
        SaRequest req = SaHolder.getRequest();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        if (req.isPath(SaSsoConsts.Api.ssoLogin)) {
            return SaSsoHandle.ssoLogin();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.getIsSlo().booleanValue() && !cfg.getIsHttp().booleanValue()) {
            return SaSsoHandle.ssoLogoutType2();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogout) && cfg.getIsSlo().booleanValue() && cfg.getIsHttp().booleanValue()) {
            return SaSsoHandle.ssoLogoutType3();
        }
        if (req.isPath(SaSsoConsts.Api.ssoLogoutCall) && cfg.getIsSlo().booleanValue() && cfg.getIsHttp().booleanValue()) {
            return SaSsoHandle.ssoLogoutCall();
        }
        return "{\"msg\": \"not handle\"}";
    }

    public static Object ssoLogin() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        SaSsoConfig cfg = SaSsoManager.getConfig();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        String back = req.getParam(SaSsoConsts.ParamName.back, "/");
        String ticket = req.getParam(SaSsoConsts.ParamName.ticket);
        if (stpLogic.isLogin()) {
            return res.redirect(back);
        }
        if (ticket == null) {
            String serverAuthUrl = SaSsoUtil.buildServerAuthUrl(SaHolder.getRequest().getUrl(), back);
            return res.redirect(serverAuthUrl);
        }
        Object loginId = SaSsoHandle.checkTicket(ticket, SaSsoConsts.Api.ssoLogin);
        if (cfg.getTicketResultHandle() != null) {
            return cfg.getTicketResultHandle().apply(loginId, back);
        }
        if (SaFoxUtil.isEmpty((Object)loginId)) {
            throw new SaSsoException("\u65e0\u6548ticket\uff1a" + ticket).setCode(20004);
        }
        stpLogic.login(loginId);
        return res.redirect(back);
    }

    public static Object ssoLogoutType2() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        stpLogic.logout();
        return SaSsoHandle.ssoLogoutBack(req, res);
    }

    public static Object ssoLogoutType3() {
        SaRequest req = SaHolder.getRequest();
        SaResponse res = SaHolder.getResponse();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        if (!stpLogic.isLogin()) {
            return SaResult.ok();
        }
        String url = SaSsoUtil.buildSloUrl(stpLogic.getLoginId());
        SaResult result = SaSsoUtil.request(url);
        if (result.getCode() == 200) {
            if (stpLogic.isLogin()) {
                stpLogic.logout();
            }
            return SaSsoHandle.ssoLogoutBack(req, res);
        }
        throw new SaSsoException(result.getMsg()).setCode(20006);
    }

    public static Object ssoLogoutCall() {
        SaRequest req = SaHolder.getRequest();
        StpLogic stpLogic = SaSsoUtil.saSsoTemplate.stpLogic;
        String loginId = req.getParamNotNull(SaSsoConsts.ParamName.loginId);
        SaSsoUtil.checkSign(req);
        stpLogic.logout((Object)loginId);
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u56de\u8c03\u6210\u529f");
    }

    public static Object ssoLogoutBack(SaRequest req, SaResponse res) {
        String back = req.getParam(SaSsoConsts.ParamName.back);
        if (SaFoxUtil.isNotEmpty((Object)back)) {
            if (back.equals("self")) {
                return "<script>if(document.referrer != location.href){ location.replace(document.referrer || '/'); }</script>";
            }
            return res.redirect(back);
        }
        return SaResult.ok((String)"\u5355\u70b9\u6ce8\u9500\u6210\u529f");
    }

    public static Object checkTicket(String ticket, String currUri) {
        SaSsoConfig cfg = SaSsoManager.getConfig();
        if (cfg.getIsHttp().booleanValue()) {
            String checkUrl;
            SaResult result;
            String ssoLogoutCall = null;
            if (cfg.getIsSlo().booleanValue()) {
                if (SaFoxUtil.isNotEmpty((Object)cfg.getSsoLogoutCall())) {
                    ssoLogoutCall = cfg.getSsoLogoutCall();
                } else if (SaFoxUtil.isNotEmpty((Object)currUri)) {
                    ssoLogoutCall = SaHolder.getRequest().getUrl().replace(currUri, SaSsoConsts.Api.ssoLogoutCall);
                }
            }
            if ((result = SaSsoUtil.request(checkUrl = SaSsoUtil.buildCheckTicketUrl(ticket, ssoLogoutCall))).getCode() == 200) {
                return result.getData();
            }
            throw new SaSsoException(result.getMsg()).setCode(20005);
        }
        return SaSsoUtil.checkTicket(ticket);
    }
}

