/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.convert.impl;

import cn.hutool.core.convert.AbstractConverter;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;

public class DateConverter
extends AbstractConverter<Date> {
    private Class<? extends Date> targetType;
    private String format;

    public DateConverter(Class<? extends Date> targetType) {
        this.targetType = targetType;
    }

    public DateConverter(Class<? extends Date> targetType, String format) {
        this.targetType = targetType;
        this.format = format;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    @Override
    protected Date convertInternal(Object value) {
        Long mills = null;
        if (value instanceof Calendar) {
            mills = ((Calendar)value).getTimeInMillis();
        } else if (value instanceof Long) {
            mills = (Long)value;
        } else {
            String valueStr = this.convertToStr(value);
            try {
                mills = StrUtil.isBlank(this.format) ? DateUtil.parse(valueStr).getTime() : DateUtil.parse(valueStr, this.format).getTime();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == mills) {
            return null;
        }
        if (Date.class == this.targetType) {
            return new Date(mills);
        }
        if (DateTime.class == this.targetType) {
            return new DateTime(mills);
        }
        if (java.sql.Date.class == this.targetType) {
            return new java.sql.Date(mills);
        }
        if (Time.class == this.targetType) {
            return new Time(mills);
        }
        if (Timestamp.class == this.targetType) {
            return new Timestamp(mills);
        }
        throw new UnsupportedOperationException(StrUtil.format((CharSequence)"Unsupport Date type: {}", this.targetType.getName()));
    }
}

