/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.core.lang.tree;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeNodeConfig;
import cn.hutool.core.lang.tree.parser.DefaultNodeParser;
import cn.hutool.core.lang.tree.parser.NodeParser;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

public class TreeUtil {
    public static List<Tree<Integer>> build(List<TreeNode<Integer>> list) {
        return TreeUtil.build(list, 0);
    }

    public static <E> List<Tree<E>> build(List<TreeNode<E>> list, E parentId) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, new DefaultNodeParser());
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, NodeParser<T, E> nodeParser) {
        return TreeUtil.build(list, parentId, TreeNodeConfig.DEFAULT_CONFIG, nodeParser);
    }

    public static <T, E> List<Tree<E>> build(List<T> list, E parentId, TreeNodeConfig treeNodeConfig, NodeParser<T, E> nodeParser) {
        ArrayList<Tree<T>> treeNodes = CollUtil.newArrayList(new Tree[0]);
        for (T obj : list) {
            Tree tree = new Tree(treeNodeConfig);
            nodeParser.parse(obj, tree);
            treeNodes.add(tree);
        }
        ArrayList<Tree<Tree>> finalTreeNodes = CollUtil.newArrayList(new Tree[0]);
        for (Tree tree : treeNodes) {
            if (!parentId.equals(tree.getParentId())) continue;
            finalTreeNodes.add(tree);
            TreeUtil.innerBuild(treeNodes, tree, 0, treeNodeConfig.getDeep());
        }
        finalTreeNodes = finalTreeNodes.stream().sorted().collect(Collectors.toList());
        return finalTreeNodes;
    }

    private static <T> void innerBuild(List<Tree<T>> treeNodes, Tree<T> parentNode, int deep, Integer maxDeep) {
        if (CollUtil.isEmpty(treeNodes)) {
            return;
        }
        if (maxDeep != null && deep >= maxDeep) {
            return;
        }
        treeNodes = treeNodes.stream().sorted().collect(Collectors.toList());
        for (Tree<T> childNode : treeNodes) {
            if (!parentNode.getId().equals(childNode.getParentId())) continue;
            List<Tree<T>> children = parentNode.getChildren();
            if (children == null) {
                children = CollUtil.newArrayList(new Tree[0]);
                parentNode.setChildren(children);
            }
            children.add(childNode);
            childNode.setParentId(parentNode.getId());
            TreeUtil.innerBuild(treeNodes, childNode, deep + 1, maxDeep);
        }
    }
}

