/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.db.nosql.mongo;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import cn.hutool.db.nosql.mongo.MongoDS;
import cn.hutool.setting.Setting;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MongoFactory {
    private static final String GROUP_SEPRATER = ",";
    private static Map<String, MongoDS> dsMap = new ConcurrentHashMap<String, MongoDS>();

    public static MongoDS getDS(String host, int port) {
        String key = host + ":" + port;
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(host, port);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(String ... groups) {
        String key = ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Collection<String> groups) {
        return MongoFactory.getDS(groups.toArray(new String[groups.size()]));
    }

    public static MongoDS getDS(Setting setting, String ... groups) {
        String key = setting.getSettingPath() + GROUP_SEPRATER + ArrayUtil.join(groups, (CharSequence)GROUP_SEPRATER);
        MongoDS ds = dsMap.get(key);
        if (null == ds) {
            ds = new MongoDS(setting, groups);
            dsMap.put(key, ds);
        }
        return ds;
    }

    public static MongoDS getDS(Setting setting, Collection<String> groups) {
        return MongoFactory.getDS(setting, groups.toArray(new String[groups.size()]));
    }

    public static void closeAll() {
        if (CollectionUtil.isNotEmpty(dsMap)) {
            for (MongoDS ds : dsMap.values()) {
                ds.close();
            }
            dsMap.clear();
        }
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                MongoFactory.closeAll();
            }
        });
    }
}

