/*
 * Decompiled with CFR 0.152.
 */
package cn.hutool.poi.excel;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IORuntimeException;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.poi.exceptions.POIException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class WorkbookUtil {
    public static Workbook createBook(String excelFilePath) {
        return WorkbookUtil.createBook(FileUtil.file(excelFilePath), null);
    }

    public static Workbook createBook(File excelFile) {
        return WorkbookUtil.createBook(excelFile, null);
    }

    public static Workbook createBookForWriter(File excelFile) {
        if (null == excelFile) {
            return WorkbookUtil.createBook(true);
        }
        if (excelFile.exists()) {
            return WorkbookUtil.createBook(FileUtil.getInputStream(excelFile));
        }
        return WorkbookUtil.createBook(StrUtil.endWithIgnoreCase(excelFile.getName(), ".xlsx"));
    }

    public static Workbook createBook(File excelFile, String password) {
        try {
            return WorkbookFactory.create((File)excelFile, (String)password);
        }
        catch (Exception e) {
            throw new POIException(e);
        }
    }

    @Deprecated
    public static Workbook createBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createBook(in, null);
    }

    public static Workbook createBook(InputStream in) {
        return WorkbookUtil.createBook(in, null);
    }

    @Deprecated
    public static Workbook createBook(InputStream in, String password, boolean closeAfterRead) {
        return WorkbookUtil.createBook(in, password);
    }

    public static Workbook createBook(InputStream in, String password) {
        try {
            Workbook workbook = WorkbookFactory.create((InputStream)IoUtil.toMarkSupportStream(in), (String)password);
            return workbook;
        }
        catch (Exception e) {
            throw new POIException(e);
        }
        finally {
            IoUtil.close(in);
        }
    }

    public static Workbook createBook(boolean isXlsx) {
        Object workbook = isXlsx ? new XSSFWorkbook() : new HSSFWorkbook();
        return workbook;
    }

    public static SXSSFWorkbook createSXSSFBook(String excelFilePath) {
        return WorkbookUtil.createSXSSFBook(FileUtil.file(excelFilePath), null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile) {
        return WorkbookUtil.createSXSSFBook(excelFile, null);
    }

    public static SXSSFWorkbook createSXSSFBook(File excelFile, String password) {
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(excelFile, password));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, boolean closeAfterRead) {
        return WorkbookUtil.createSXSSFBook(in, null, closeAfterRead);
    }

    @Deprecated
    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password, boolean closeAfterRead) {
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(in, password, closeAfterRead));
    }

    public static SXSSFWorkbook createSXSSFBook(InputStream in, String password) {
        return WorkbookUtil.toSXSSFBook(WorkbookUtil.createBook(in, password));
    }

    public static SXSSFWorkbook createSXSSFBook() {
        return new SXSSFWorkbook();
    }

    public static SXSSFWorkbook createSXSSFBook(int rowAccessWindowSize) {
        return new SXSSFWorkbook(rowAccessWindowSize);
    }

    public static void writeBook(Workbook book, OutputStream out) throws IORuntimeException {
        try {
            book.write(out);
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }

    public static Sheet getOrCreateSheet(Workbook book, String sheetName) {
        if (null == book) {
            return null;
        }
        Sheet sheet = book.getSheet(sheetName = StrUtil.isBlank(sheetName) ? "sheet1" : sheetName);
        if (null == sheet) {
            sheet = book.createSheet(sheetName);
        }
        return sheet;
    }

    public static Sheet getOrCreateSheet(Workbook book, int sheetIndex) {
        Sheet sheet = null;
        try {
            sheet = book.getSheetAt(sheetIndex);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (null == sheet) {
            sheet = book.createSheet();
        }
        return sheet;
    }

    public static boolean isEmpty(Sheet sheet) {
        return null == sheet || sheet.getLastRowNum() == 0 && sheet.getPhysicalNumberOfRows() == 0;
    }

    private static SXSSFWorkbook toSXSSFBook(Workbook book) {
        if (book instanceof SXSSFWorkbook) {
            return (SXSSFWorkbook)book;
        }
        if (book instanceof XSSFWorkbook) {
            return new SXSSFWorkbook((XSSFWorkbook)book);
        }
        throw new POIException("The input is not a [xlsx] format.");
    }
}

