/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.connector;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.connector.SyncJobUpdateStatsResponse;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SyncJobUpdateStatsRequest
extends RequestBase
implements JsonpSerializable {
    private final String connectorSyncJobId;
    private final long deletedDocumentCount;
    private final long indexedDocumentCount;
    private final long indexedDocumentVolume;
    @Nullable
    private final Time lastSeen;
    private final Map<String, JsonData> metadata;
    @Nullable
    private final Integer totalDocumentCount;
    public static final JsonpDeserializer<SyncJobUpdateStatsRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SyncJobUpdateStatsRequest::setupSyncJobUpdateStatsRequestDeserializer);
    public static final Endpoint<SyncJobUpdateStatsRequest, SyncJobUpdateStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SyncJobUpdateStatsRequest, SyncJobUpdateStatsResponse>("es/connector.sync_job_update_stats", request -> "PUT", request -> {
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_connector");
            buf.append("/_sync_job");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.connectorSyncJobId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _connectorSyncJobId = true;
        boolean propsSet = false;
        if (propsSet |= true) {
            params.put("connectorSyncJobId", request.connectorSyncJobId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, SyncJobUpdateStatsResponse._DESERIALIZER);

    private SyncJobUpdateStatsRequest(Builder builder) {
        this.connectorSyncJobId = ApiTypeHelper.requireNonNull(builder.connectorSyncJobId, this, "connectorSyncJobId");
        this.deletedDocumentCount = ApiTypeHelper.requireNonNull(builder.deletedDocumentCount, this, "deletedDocumentCount");
        this.indexedDocumentCount = ApiTypeHelper.requireNonNull(builder.indexedDocumentCount, this, "indexedDocumentCount");
        this.indexedDocumentVolume = ApiTypeHelper.requireNonNull(builder.indexedDocumentVolume, this, "indexedDocumentVolume");
        this.lastSeen = builder.lastSeen;
        this.metadata = ApiTypeHelper.unmodifiable(builder.metadata);
        this.totalDocumentCount = builder.totalDocumentCount;
    }

    public static SyncJobUpdateStatsRequest of(Function<Builder, ObjectBuilder<SyncJobUpdateStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String connectorSyncJobId() {
        return this.connectorSyncJobId;
    }

    public final long deletedDocumentCount() {
        return this.deletedDocumentCount;
    }

    public final long indexedDocumentCount() {
        return this.indexedDocumentCount;
    }

    public final long indexedDocumentVolume() {
        return this.indexedDocumentVolume;
    }

    @Nullable
    public final Time lastSeen() {
        return this.lastSeen;
    }

    public final Map<String, JsonData> metadata() {
        return this.metadata;
    }

    @Nullable
    public final Integer totalDocumentCount() {
        return this.totalDocumentCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("deleted_document_count");
        generator.write(this.deletedDocumentCount);
        generator.writeKey("indexed_document_count");
        generator.write(this.indexedDocumentCount);
        generator.writeKey("indexed_document_volume");
        generator.write(this.indexedDocumentVolume);
        if (this.lastSeen != null) {
            generator.writeKey("last_seen");
            this.lastSeen.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.metadata)) {
            generator.writeKey("metadata");
            generator.writeStartObject();
            for (Map.Entry<String, JsonData> item0 : this.metadata.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.totalDocumentCount != null) {
            generator.writeKey("total_document_count");
            generator.write(this.totalDocumentCount.intValue());
        }
    }

    protected static void setupSyncJobUpdateStatsRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deletedDocumentCount, JsonpDeserializer.longDeserializer(), "deleted_document_count");
        op.add(Builder::indexedDocumentCount, JsonpDeserializer.longDeserializer(), "indexed_document_count");
        op.add(Builder::indexedDocumentVolume, JsonpDeserializer.longDeserializer(), "indexed_document_volume");
        op.add(Builder::lastSeen, Time._DESERIALIZER, "last_seen");
        op.add(Builder::metadata, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "metadata");
        op.add(Builder::totalDocumentCount, JsonpDeserializer.integerDeserializer(), "total_document_count");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SyncJobUpdateStatsRequest> {
        private String connectorSyncJobId;
        private Long deletedDocumentCount;
        private Long indexedDocumentCount;
        private Long indexedDocumentVolume;
        @Nullable
        private Time lastSeen;
        @Nullable
        private Map<String, JsonData> metadata;
        @Nullable
        private Integer totalDocumentCount;

        public final Builder connectorSyncJobId(String value) {
            this.connectorSyncJobId = value;
            return this;
        }

        public final Builder deletedDocumentCount(long value) {
            this.deletedDocumentCount = value;
            return this;
        }

        public final Builder indexedDocumentCount(long value) {
            this.indexedDocumentCount = value;
            return this;
        }

        public final Builder indexedDocumentVolume(long value) {
            this.indexedDocumentVolume = value;
            return this;
        }

        public final Builder lastSeen(@Nullable Time value) {
            this.lastSeen = value;
            return this;
        }

        public final Builder lastSeen(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.lastSeen(fn.apply(new Time.Builder()).build());
        }

        public final Builder metadata(Map<String, JsonData> map) {
            this.metadata = Builder._mapPutAll(this.metadata, map);
            return this;
        }

        public final Builder metadata(String key, JsonData value) {
            this.metadata = Builder._mapPut(this.metadata, key, value);
            return this;
        }

        public final Builder totalDocumentCount(@Nullable Integer value) {
            this.totalDocumentCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SyncJobUpdateStatsRequest build() {
            this._checkSingleUse();
            return new SyncJobUpdateStatsRequest(this);
        }
    }
}

