/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.health_report;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class SlmIndicatorUnhealthyPolicies
implements JsonpSerializable {
    private final long count;
    private final Map<String, Long> invocationsSinceLastSuccess;
    public static final JsonpDeserializer<SlmIndicatorUnhealthyPolicies> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, SlmIndicatorUnhealthyPolicies::setupSlmIndicatorUnhealthyPoliciesDeserializer);

    private SlmIndicatorUnhealthyPolicies(Builder builder) {
        this.count = ApiTypeHelper.requireNonNull(builder.count, (Object)this, "count", 0L);
        this.invocationsSinceLastSuccess = ApiTypeHelper.unmodifiable(builder.invocationsSinceLastSuccess);
    }

    public static SlmIndicatorUnhealthyPolicies of(Function<Builder, ObjectBuilder<SlmIndicatorUnhealthyPolicies>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final long count() {
        return this.count;
    }

    public final Map<String, Long> invocationsSinceLastSuccess() {
        return this.invocationsSinceLastSuccess;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("count");
        generator.write(this.count);
        if (ApiTypeHelper.isDefined(this.invocationsSinceLastSuccess)) {
            generator.writeKey("invocations_since_last_success");
            generator.writeStartObject();
            for (Map.Entry<String, Long> item0 : this.invocationsSinceLastSuccess.entrySet()) {
                generator.writeKey(item0.getKey());
                generator.write(item0.getValue().longValue());
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupSlmIndicatorUnhealthyPoliciesDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::count, JsonpDeserializer.longDeserializer(), "count");
        op.add(Builder::invocationsSinceLastSuccess, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.longDeserializer()), "invocations_since_last_success");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<SlmIndicatorUnhealthyPolicies> {
        private Long count;
        @Nullable
        private Map<String, Long> invocationsSinceLastSuccess;

        public final Builder count(long value) {
            this.count = value;
            return this;
        }

        public final Builder invocationsSinceLastSuccess(Map<String, Long> map) {
            this.invocationsSinceLastSuccess = Builder._mapPutAll(this.invocationsSinceLastSuccess, map);
            return this;
        }

        public final Builder invocationsSinceLastSuccess(String key, Long value) {
            this.invocationsSinceLastSuccess = Builder._mapPut(this.invocationsSinceLastSuccess, key, value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SlmIndicatorUnhealthyPolicies build() {
            this._checkSingleUse();
            return new SlmIndicatorUnhealthyPolicies(this);
        }
    }
}

