/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.Hyperparameter;
import co.elastic.clients.elasticsearch.ml.TotalFeatureImportance;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelConfigMetadata
implements JsonpSerializable {
    private final List<String> modelAliases;
    private final Map<String, String> featureImportanceBaseline;
    private final List<Hyperparameter> hyperparameters;
    private final List<TotalFeatureImportance> totalFeatureImportance;
    public static final JsonpDeserializer<TrainedModelConfigMetadata> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelConfigMetadata::setupTrainedModelConfigMetadataDeserializer);

    private TrainedModelConfigMetadata(Builder builder) {
        this.modelAliases = ApiTypeHelper.unmodifiable(builder.modelAliases);
        this.featureImportanceBaseline = ApiTypeHelper.unmodifiable(builder.featureImportanceBaseline);
        this.hyperparameters = ApiTypeHelper.unmodifiable(builder.hyperparameters);
        this.totalFeatureImportance = ApiTypeHelper.unmodifiable(builder.totalFeatureImportance);
    }

    public static TrainedModelConfigMetadata of(Function<Builder, ObjectBuilder<TrainedModelConfigMetadata>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final List<String> modelAliases() {
        return this.modelAliases;
    }

    public final Map<String, String> featureImportanceBaseline() {
        return this.featureImportanceBaseline;
    }

    public final List<Hyperparameter> hyperparameters() {
        return this.hyperparameters;
    }

    public final List<TotalFeatureImportance> totalFeatureImportance() {
        return this.totalFeatureImportance;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.modelAliases)) {
            generator.writeKey("model_aliases");
            generator.writeStartArray();
            for (String string : this.modelAliases) {
                generator.write(string);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.featureImportanceBaseline)) {
            generator.writeKey("feature_importance_baseline");
            generator.writeStartObject();
            for (Map.Entry entry : this.featureImportanceBaseline.entrySet()) {
                generator.writeKey((String)entry.getKey());
                generator.write((String)entry.getValue());
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.hyperparameters)) {
            generator.writeKey("hyperparameters");
            generator.writeStartArray();
            for (Hyperparameter hyperparameter : this.hyperparameters) {
                hyperparameter.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.totalFeatureImportance)) {
            generator.writeKey("total_feature_importance");
            generator.writeStartArray();
            for (TotalFeatureImportance totalFeatureImportance : this.totalFeatureImportance) {
                totalFeatureImportance.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelConfigMetadataDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::modelAliases, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "model_aliases");
        op.add(Builder::featureImportanceBaseline, JsonpDeserializer.stringMapDeserializer(JsonpDeserializer.stringDeserializer()), "feature_importance_baseline");
        op.add(Builder::hyperparameters, JsonpDeserializer.arrayDeserializer(Hyperparameter._DESERIALIZER), "hyperparameters");
        op.add(Builder::totalFeatureImportance, JsonpDeserializer.arrayDeserializer(TotalFeatureImportance._DESERIALIZER), "total_feature_importance");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelConfigMetadata> {
        @Nullable
        private List<String> modelAliases;
        @Nullable
        private Map<String, String> featureImportanceBaseline;
        @Nullable
        private List<Hyperparameter> hyperparameters;
        @Nullable
        private List<TotalFeatureImportance> totalFeatureImportance;

        public final Builder modelAliases(List<String> list) {
            this.modelAliases = Builder._listAddAll(this.modelAliases, list);
            return this;
        }

        public final Builder modelAliases(String value, String ... values) {
            this.modelAliases = Builder._listAdd(this.modelAliases, value, values);
            return this;
        }

        public final Builder featureImportanceBaseline(Map<String, String> map) {
            this.featureImportanceBaseline = Builder._mapPutAll(this.featureImportanceBaseline, map);
            return this;
        }

        public final Builder featureImportanceBaseline(String key, String value) {
            this.featureImportanceBaseline = Builder._mapPut(this.featureImportanceBaseline, key, value);
            return this;
        }

        public final Builder hyperparameters(List<Hyperparameter> list) {
            this.hyperparameters = Builder._listAddAll(this.hyperparameters, list);
            return this;
        }

        public final Builder hyperparameters(Hyperparameter value, Hyperparameter ... values) {
            this.hyperparameters = Builder._listAdd(this.hyperparameters, value, values);
            return this;
        }

        public final Builder hyperparameters(Function<Hyperparameter.Builder, ObjectBuilder<Hyperparameter>> fn) {
            return this.hyperparameters(fn.apply(new Hyperparameter.Builder()).build(), new Hyperparameter[0]);
        }

        public final Builder totalFeatureImportance(List<TotalFeatureImportance> list) {
            this.totalFeatureImportance = Builder._listAddAll(this.totalFeatureImportance, list);
            return this;
        }

        public final Builder totalFeatureImportance(TotalFeatureImportance value, TotalFeatureImportance ... values) {
            this.totalFeatureImportance = Builder._listAdd(this.totalFeatureImportance, value, values);
            return this;
        }

        public final Builder totalFeatureImportance(Function<TotalFeatureImportance.Builder, ObjectBuilder<TotalFeatureImportance>> fn) {
            return this.totalFeatureImportance(fn.apply(new TotalFeatureImportance.Builder()).build(), new TotalFeatureImportance[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelConfigMetadata build() {
            this._checkSingleUse();
            return new TrainedModelConfigMetadata(this);
        }
    }
}

