/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.snapshot;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Time;
import co.elastic.clients.elasticsearch.snapshot.SnapshotStatusResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public class SnapshotStatusRequest
extends RequestBase {
    @Nullable
    private final Boolean ignoreUnavailable;
    @Nullable
    private final Time masterTimeout;
    @Nullable
    private final String repository;
    private final List<String> snapshot;
    public static final Endpoint<SnapshotStatusRequest, SnapshotStatusResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<SnapshotStatusRequest, SnapshotStatusResponse>("es/snapshot.status", request -> "GET", request -> {
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        if (request.repository() != null) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.snapshot())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/_status");
            return buf.toString();
        }
        if (propsSet == 1) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/_status");
            return buf.toString();
        }
        if (propsSet == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_snapshot");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.repository, buf);
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")), buf);
            buf.append("/_status");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _repository = true;
        int _snapshot = 2;
        int propsSet = 0;
        if (request.repository() != null) {
            propsSet |= 1;
        }
        if (ApiTypeHelper.isDefined(request.snapshot())) {
            propsSet |= 2;
        }
        if (propsSet == 0) {
            // empty if block
        }
        if (propsSet == 1) {
            params.put("repository", request.repository);
        }
        if (propsSet == 3) {
            params.put("repository", request.repository);
            params.put("snapshot", request.snapshot.stream().map(v -> v).collect(Collectors.joining(",")));
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.masterTimeout != null) {
            params.put("master_timeout", request.masterTimeout._toJsonString());
        }
        if (request.ignoreUnavailable != null) {
            params.put("ignore_unavailable", String.valueOf(request.ignoreUnavailable));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, SnapshotStatusResponse._DESERIALIZER);

    private SnapshotStatusRequest(Builder builder) {
        this.ignoreUnavailable = builder.ignoreUnavailable;
        this.masterTimeout = builder.masterTimeout;
        this.repository = builder.repository;
        this.snapshot = ApiTypeHelper.unmodifiable(builder.snapshot);
    }

    public static SnapshotStatusRequest of(Function<Builder, ObjectBuilder<SnapshotStatusRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean ignoreUnavailable() {
        return this.ignoreUnavailable;
    }

    @Nullable
    public final Time masterTimeout() {
        return this.masterTimeout;
    }

    @Nullable
    public final String repository() {
        return this.repository;
    }

    public final List<String> snapshot() {
        return this.snapshot;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<SnapshotStatusRequest> {
        @Nullable
        private Boolean ignoreUnavailable;
        @Nullable
        private Time masterTimeout;
        @Nullable
        private String repository;
        @Nullable
        private List<String> snapshot;

        public final Builder ignoreUnavailable(@Nullable Boolean value) {
            this.ignoreUnavailable = value;
            return this;
        }

        public final Builder masterTimeout(@Nullable Time value) {
            this.masterTimeout = value;
            return this;
        }

        public final Builder masterTimeout(Function<Time.Builder, ObjectBuilder<Time>> fn) {
            return this.masterTimeout(fn.apply(new Time.Builder()).build());
        }

        public final Builder repository(@Nullable String value) {
            this.repository = value;
            return this;
        }

        public final Builder snapshot(List<String> list) {
            this.snapshot = Builder._listAddAll(this.snapshot, list);
            return this;
        }

        public final Builder snapshot(String value, String ... values) {
            this.snapshot = Builder._listAdd(this.snapshot, value, values);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public SnapshotStatusRequest build() {
            this._checkSingleUse();
            return new SnapshotStatusRequest(this);
        }
    }
}

