/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.indices;

import co.elastic.clients.elasticsearch._types.AcknowledgedResponse;
import co.elastic.clients.elasticsearch.indices.add_block.AddIndicesBlockStatus;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class AddBlockResponse
implements AcknowledgedResponse,
JsonpSerializable {
    private final boolean acknowledged;
    private final boolean shardsAcknowledged;
    private final List<AddIndicesBlockStatus> indices;
    public static final JsonpDeserializer<AddBlockResponse> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, AddBlockResponse::setupAddBlockResponseDeserializer);

    private AddBlockResponse(Builder builder) {
        this.acknowledged = ApiTypeHelper.requireNonNull(builder.acknowledged, (Object)this, "acknowledged", false);
        this.shardsAcknowledged = ApiTypeHelper.requireNonNull(builder.shardsAcknowledged, (Object)this, "shardsAcknowledged", false);
        this.indices = ApiTypeHelper.unmodifiableRequired(builder.indices, (Object)this, "indices");
    }

    public static AddBlockResponse of(Function<Builder, ObjectBuilder<AddBlockResponse>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public final boolean acknowledged() {
        return this.acknowledged;
    }

    public final boolean shardsAcknowledged() {
        return this.shardsAcknowledged;
    }

    public final List<AddIndicesBlockStatus> indices() {
        return this.indices;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("acknowledged");
        generator.write(this.acknowledged);
        generator.writeKey("shards_acknowledged");
        generator.write(this.shardsAcknowledged);
        if (ApiTypeHelper.isDefined(this.indices)) {
            generator.writeKey("indices");
            generator.writeStartArray();
            for (AddIndicesBlockStatus item0 : this.indices) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupAddBlockResponseDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::acknowledged, JsonpDeserializer.booleanDeserializer(), "acknowledged");
        op.add(Builder::shardsAcknowledged, JsonpDeserializer.booleanDeserializer(), "shards_acknowledged");
        op.add(Builder::indices, JsonpDeserializer.arrayDeserializer(AddIndicesBlockStatus._DESERIALIZER), "indices");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<AddBlockResponse> {
        private Boolean acknowledged;
        private Boolean shardsAcknowledged;
        private List<AddIndicesBlockStatus> indices;

        public final Builder acknowledged(boolean value) {
            this.acknowledged = value;
            return this;
        }

        public final Builder shardsAcknowledged(boolean value) {
            this.shardsAcknowledged = value;
            return this;
        }

        public final Builder indices(List<AddIndicesBlockStatus> list) {
            this.indices = Builder._listAddAll(this.indices, list);
            return this;
        }

        public final Builder indices(AddIndicesBlockStatus value, AddIndicesBlockStatus ... values) {
            this.indices = Builder._listAdd(this.indices, value, values);
            return this;
        }

        public final Builder indices(Function<AddIndicesBlockStatus.Builder, ObjectBuilder<AddIndicesBlockStatus>> fn) {
            return this.indices(fn.apply(new AddIndicesBlockStatus.Builder()).build(), new AddIndicesBlockStatus[0]);
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public AddBlockResponse build() {
            this._checkSingleUse();
            return new AddBlockResponse(this);
        }
    }
}

