/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.GetJobStatsResponse;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ObjectBuilder;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

public class GetJobStatsRequest
extends RequestBase {
    @Nullable
    private final Boolean allowNoMatch;
    @Nullable
    private final String jobId;
    public static final Endpoint<GetJobStatsRequest, GetJobStatsResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<GetJobStatsRequest, GetJobStatsResponse>("es/ml.get_job_stats", request -> "GET", request -> {
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/_stats");
            return buf.toString();
        }
        if (propsSet) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/_stats");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _jobId = true;
        boolean propsSet = false;
        if (request.jobId() != null) {
            propsSet |= true;
        }
        if (!propsSet) {
            // empty if block
        }
        if (propsSet) {
            params.put("jobId", request.jobId);
        }
        return params;
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        if (request.allowNoMatch != null) {
            params.put("allow_no_match", String.valueOf(request.allowNoMatch));
        }
        return params;
    }, SimpleEndpoint.emptyMap(), false, GetJobStatsResponse._DESERIALIZER);

    private GetJobStatsRequest(Builder builder) {
        this.allowNoMatch = builder.allowNoMatch;
        this.jobId = builder.jobId;
    }

    public static GetJobStatsRequest of(Function<Builder, ObjectBuilder<GetJobStatsRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean allowNoMatch() {
        return this.allowNoMatch;
    }

    @Nullable
    public final String jobId() {
        return this.jobId;
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<GetJobStatsRequest> {
        @Nullable
        private Boolean allowNoMatch;
        @Nullable
        private String jobId;

        public final Builder allowNoMatch(@Nullable Boolean value) {
            this.allowNoMatch = value;
            return this;
        }

        public final Builder jobId(@Nullable String value) {
            this.jobId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public GetJobStatsRequest build() {
            this._checkSingleUse();
            return new GetJobStatsRequest(this);
        }
    }
}

