/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;

@JsonpDeserializable
public class RescoreVector
implements JsonpSerializable {
    private final float oversample;
    public static final JsonpDeserializer<RescoreVector> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RescoreVector::setupRescoreVectorDeserializer);

    private RescoreVector(Builder builder) {
        this.oversample = ApiTypeHelper.requireNonNull(builder.oversample, (Object)this, "oversample", 0.0f);
    }

    public static RescoreVector of(Function<Builder, ObjectBuilder<RescoreVector>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final float oversample() {
        return this.oversample;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("oversample");
        generator.write((double)this.oversample);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRescoreVectorDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::oversample, JsonpDeserializer.floatDeserializer(), "oversample");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<RescoreVector> {
        private Float oversample;

        public final Builder oversample(float value) {
            this.oversample = Float.valueOf(value);
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RescoreVector build() {
            this._checkSingleUse();
            return new RescoreVector(this);
        }
    }
}

