/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.TopLeftBottomRightGeoBounds;
import co.elastic.clients.elasticsearch._types.aggregations.Aggregate;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateBase;
import co.elastic.clients.elasticsearch._types.aggregations.AggregateVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class CartesianBoundsAggregate
extends AggregateBase
implements AggregateVariant {
    @Nullable
    private final TopLeftBottomRightGeoBounds bounds;
    public static final JsonpDeserializer<CartesianBoundsAggregate> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, CartesianBoundsAggregate::setupCartesianBoundsAggregateDeserializer);

    private CartesianBoundsAggregate(Builder builder) {
        super(builder);
        this.bounds = builder.bounds;
    }

    public static CartesianBoundsAggregate of(Function<Builder, ObjectBuilder<CartesianBoundsAggregate>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregate.Kind _aggregateKind() {
        return Aggregate.Kind.CartesianBounds;
    }

    @Nullable
    public final TopLeftBottomRightGeoBounds bounds() {
        return this.bounds;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.bounds != null) {
            generator.writeKey("bounds");
            this.bounds.serialize(generator, mapper);
        }
    }

    protected static void setupCartesianBoundsAggregateDeserializer(ObjectDeserializer<Builder> op) {
        AggregateBase.setupAggregateBaseDeserializer(op);
        op.add(Builder::bounds, TopLeftBottomRightGeoBounds._DESERIALIZER, "bounds");
    }

    public static class Builder
    extends AggregateBase.AbstractBuilder<Builder>
    implements ObjectBuilder<CartesianBoundsAggregate> {
        @Nullable
        private TopLeftBottomRightGeoBounds bounds;

        public final Builder bounds(@Nullable TopLeftBottomRightGeoBounds value) {
            this.bounds = value;
            return this;
        }

        public final Builder bounds(Function<TopLeftBottomRightGeoBounds.Builder, ObjectBuilder<TopLeftBottomRightGeoBounds>> fn) {
            return this.bounds(fn.apply(new TopLeftBottomRightGeoBounds.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public CartesianBoundsAggregate build() {
            this._checkSingleUse();
            return new CartesianBoundsAggregate(this);
        }
    }
}

