/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.analysis;

import co.elastic.clients.elasticsearch._types.analysis.TokenFilterBase;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import javax.annotation.Nullable;

public abstract class WordDelimiterTokenFilterBase
extends TokenFilterBase {
    @Nullable
    private final Boolean catenateAll;
    @Nullable
    private final Boolean catenateNumbers;
    @Nullable
    private final Boolean catenateWords;
    @Nullable
    private final Boolean generateNumberParts;
    @Nullable
    private final Boolean generateWordParts;
    @Nullable
    private final Boolean preserveOriginal;
    private final List<String> protectedWords;
    @Nullable
    private final String protectedWordsPath;
    @Nullable
    private final Boolean splitOnCaseChange;
    @Nullable
    private final Boolean splitOnNumerics;
    @Nullable
    private final Boolean stemEnglishPossessive;
    private final List<String> typeTable;
    @Nullable
    private final String typeTablePath;

    protected WordDelimiterTokenFilterBase(AbstractBuilder<?> builder) {
        super(builder);
        this.catenateAll = builder.catenateAll;
        this.catenateNumbers = builder.catenateNumbers;
        this.catenateWords = builder.catenateWords;
        this.generateNumberParts = builder.generateNumberParts;
        this.generateWordParts = builder.generateWordParts;
        this.preserveOriginal = builder.preserveOriginal;
        this.protectedWords = ApiTypeHelper.unmodifiable(builder.protectedWords);
        this.protectedWordsPath = builder.protectedWordsPath;
        this.splitOnCaseChange = builder.splitOnCaseChange;
        this.splitOnNumerics = builder.splitOnNumerics;
        this.stemEnglishPossessive = builder.stemEnglishPossessive;
        this.typeTable = ApiTypeHelper.unmodifiable(builder.typeTable);
        this.typeTablePath = builder.typeTablePath;
    }

    @Nullable
    public final Boolean catenateAll() {
        return this.catenateAll;
    }

    @Nullable
    public final Boolean catenateNumbers() {
        return this.catenateNumbers;
    }

    @Nullable
    public final Boolean catenateWords() {
        return this.catenateWords;
    }

    @Nullable
    public final Boolean generateNumberParts() {
        return this.generateNumberParts;
    }

    @Nullable
    public final Boolean generateWordParts() {
        return this.generateWordParts;
    }

    @Nullable
    public final Boolean preserveOriginal() {
        return this.preserveOriginal;
    }

    public final List<String> protectedWords() {
        return this.protectedWords;
    }

    @Nullable
    public final String protectedWordsPath() {
        return this.protectedWordsPath;
    }

    @Nullable
    public final Boolean splitOnCaseChange() {
        return this.splitOnCaseChange;
    }

    @Nullable
    public final Boolean splitOnNumerics() {
        return this.splitOnNumerics;
    }

    @Nullable
    public final Boolean stemEnglishPossessive() {
        return this.stemEnglishPossessive;
    }

    public final List<String> typeTable() {
        return this.typeTable;
    }

    @Nullable
    public final String typeTablePath() {
        return this.typeTablePath;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.catenateAll != null) {
            generator.writeKey("catenate_all");
            generator.write(this.catenateAll.booleanValue());
        }
        if (this.catenateNumbers != null) {
            generator.writeKey("catenate_numbers");
            generator.write(this.catenateNumbers.booleanValue());
        }
        if (this.catenateWords != null) {
            generator.writeKey("catenate_words");
            generator.write(this.catenateWords.booleanValue());
        }
        if (this.generateNumberParts != null) {
            generator.writeKey("generate_number_parts");
            generator.write(this.generateNumberParts.booleanValue());
        }
        if (this.generateWordParts != null) {
            generator.writeKey("generate_word_parts");
            generator.write(this.generateWordParts.booleanValue());
        }
        if (this.preserveOriginal != null) {
            generator.writeKey("preserve_original");
            generator.write(this.preserveOriginal.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.protectedWords)) {
            generator.writeKey("protected_words");
            generator.writeStartArray();
            for (String item0 : this.protectedWords) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.protectedWordsPath != null) {
            generator.writeKey("protected_words_path");
            generator.write(this.protectedWordsPath);
        }
        if (this.splitOnCaseChange != null) {
            generator.writeKey("split_on_case_change");
            generator.write(this.splitOnCaseChange.booleanValue());
        }
        if (this.splitOnNumerics != null) {
            generator.writeKey("split_on_numerics");
            generator.write(this.splitOnNumerics.booleanValue());
        }
        if (this.stemEnglishPossessive != null) {
            generator.writeKey("stem_english_possessive");
            generator.write(this.stemEnglishPossessive.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.typeTable)) {
            generator.writeKey("type_table");
            generator.writeStartArray();
            for (String item0 : this.typeTable) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.typeTablePath != null) {
            generator.writeKey("type_table_path");
            generator.write(this.typeTablePath);
        }
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupWordDelimiterTokenFilterBaseDeserializer(ObjectDeserializer<BuilderT> op) {
        TokenFilterBase.setupTokenFilterBaseDeserializer(op);
        op.add(AbstractBuilder::catenateAll, JsonpDeserializer.booleanDeserializer(), "catenate_all");
        op.add(AbstractBuilder::catenateNumbers, JsonpDeserializer.booleanDeserializer(), "catenate_numbers");
        op.add(AbstractBuilder::catenateWords, JsonpDeserializer.booleanDeserializer(), "catenate_words");
        op.add(AbstractBuilder::generateNumberParts, JsonpDeserializer.booleanDeserializer(), "generate_number_parts");
        op.add(AbstractBuilder::generateWordParts, JsonpDeserializer.booleanDeserializer(), "generate_word_parts");
        op.add(AbstractBuilder::preserveOriginal, JsonpDeserializer.booleanDeserializer(), "preserve_original");
        op.add(AbstractBuilder::protectedWords, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "protected_words");
        op.add(AbstractBuilder::protectedWordsPath, JsonpDeserializer.stringDeserializer(), "protected_words_path");
        op.add(AbstractBuilder::splitOnCaseChange, JsonpDeserializer.booleanDeserializer(), "split_on_case_change");
        op.add(AbstractBuilder::splitOnNumerics, JsonpDeserializer.booleanDeserializer(), "split_on_numerics");
        op.add(AbstractBuilder::stemEnglishPossessive, JsonpDeserializer.booleanDeserializer(), "stem_english_possessive");
        op.add(AbstractBuilder::typeTable, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "type_table");
        op.add(AbstractBuilder::typeTablePath, JsonpDeserializer.stringDeserializer(), "type_table_path");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends TokenFilterBase.AbstractBuilder<BuilderT> {
        @Nullable
        private Boolean catenateAll;
        @Nullable
        private Boolean catenateNumbers;
        @Nullable
        private Boolean catenateWords;
        @Nullable
        private Boolean generateNumberParts;
        @Nullable
        private Boolean generateWordParts;
        @Nullable
        private Boolean preserveOriginal;
        @Nullable
        private List<String> protectedWords;
        @Nullable
        private String protectedWordsPath;
        @Nullable
        private Boolean splitOnCaseChange;
        @Nullable
        private Boolean splitOnNumerics;
        @Nullable
        private Boolean stemEnglishPossessive;
        @Nullable
        private List<String> typeTable;
        @Nullable
        private String typeTablePath;

        public final BuilderT catenateAll(@Nullable Boolean value) {
            this.catenateAll = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT catenateNumbers(@Nullable Boolean value) {
            this.catenateNumbers = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT catenateWords(@Nullable Boolean value) {
            this.catenateWords = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT generateNumberParts(@Nullable Boolean value) {
            this.generateNumberParts = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT generateWordParts(@Nullable Boolean value) {
            this.generateWordParts = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT preserveOriginal(@Nullable Boolean value) {
            this.preserveOriginal = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT protectedWords(List<String> list) {
            this.protectedWords = AbstractBuilder._listAddAll(this.protectedWords, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT protectedWords(String value, String ... values) {
            this.protectedWords = AbstractBuilder._listAdd(this.protectedWords, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT protectedWordsPath(@Nullable String value) {
            this.protectedWordsPath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT splitOnCaseChange(@Nullable Boolean value) {
            this.splitOnCaseChange = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT splitOnNumerics(@Nullable Boolean value) {
            this.splitOnNumerics = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT stemEnglishPossessive(@Nullable Boolean value) {
            this.stemEnglishPossessive = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT typeTable(List<String> list) {
            this.typeTable = AbstractBuilder._listAddAll(this.typeTable, list);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT typeTable(String value, String ... values) {
            this.typeTable = AbstractBuilder._listAdd(this.typeTable, value, values);
            return (BuilderT)((AbstractBuilder)this.self());
        }

        public final BuilderT typeTablePath(@Nullable String value) {
            this.typeTablePath = value;
            return (BuilderT)((AbstractBuilder)this.self());
        }
    }
}

