/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.core.search;

import co.elastic.clients.elasticsearch.core.search.LearningToRank;
import co.elastic.clients.elasticsearch.core.search.RescoreQuery;
import co.elastic.clients.elasticsearch.core.search.RescoreVariant;
import co.elastic.clients.elasticsearch.core.search.ScriptRescore;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.OpenTaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import jakarta.json.stream.JsonParser;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class Rescore
implements OpenTaggedUnion<Kind, Object>,
JsonpSerializable {
    private final Kind _kind;
    private final Object _value;
    @Nullable
    private final Integer windowSize;
    @Nullable
    private final String _customKind;
    public static final JsonpDeserializer<Rescore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, Rescore::setupRescoreDeserializer, Builder::build);

    @Override
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    public final Object _get() {
        return this._value;
    }

    public Rescore(RescoreVariant value) {
        this._kind = ApiTypeHelper.requireNonNull(value._rescoreKind(), this, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        this._customKind = null;
        this.windowSize = null;
    }

    private Rescore(Builder builder) {
        this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
        this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        this._customKind = builder._customKind;
        this.windowSize = builder.windowSize;
    }

    public static Rescore of(Function<Builder, ObjectBuilder<Rescore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Integer windowSize() {
        return this.windowSize;
    }

    public boolean isQuery() {
        return this._kind == Kind.Query;
    }

    public RescoreQuery query() {
        return (RescoreQuery)TaggedUnionUtils.get(this, Kind.Query);
    }

    public boolean isLearningToRank() {
        return this._kind == Kind.LearningToRank;
    }

    public LearningToRank learningToRank() {
        return (LearningToRank)TaggedUnionUtils.get(this, Kind.LearningToRank);
    }

    public boolean isScript() {
        return this._kind == Kind.Script;
    }

    public ScriptRescore script() {
        return (ScriptRescore)TaggedUnionUtils.get(this, Kind.Script);
    }

    public boolean _isCustom() {
        return this._kind == Kind._Custom;
    }

    @Override
    @Nullable
    public final String _customKind() {
        return this._customKind;
    }

    public JsonData _custom() {
        return (JsonData)TaggedUnionUtils.get(this, Kind._Custom);
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.windowSize != null) {
            generator.writeKey("window_size");
            generator.write(this.windowSize.intValue());
        }
        generator.writeKey(this._kind == Kind._Custom ? this._customKind : this._kind.jsonValue());
        if (this._value instanceof JsonpSerializable) {
            ((JsonpSerializable)this._value).serialize(generator, mapper);
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupRescoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::windowSize, JsonpDeserializer.integerDeserializer(), "window_size");
        op.add(Builder::query, RescoreQuery._DESERIALIZER, "query");
        op.add(Builder::learningToRank, LearningToRank._DESERIALIZER, "learning_to_rank");
        op.add(Builder::script, ScriptRescore._DESERIALIZER, "script");
        op.setUnknownFieldHandler((builder, name, parser, mapper) -> {
            JsonpUtils.ensureCustomVariantsAllowed(parser, mapper);
            builder._custom((String)name, JsonData._DESERIALIZER.deserialize((JsonParser)parser, (JsonpMapper)mapper));
        });
    }

    public static enum Kind implements JsonEnum
    {
        Query("query"),
        LearningToRank("learning_to_rank"),
        Script("script"),
        _Custom(null);

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        @Override
        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<Rescore> {
        private Kind _kind;
        private Object _value;
        private String _customKind;
        @Nullable
        private Integer windowSize;

        public final Builder windowSize(@Nullable Integer value) {
            this.windowSize = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder query(RescoreQuery v) {
            this._kind = Kind.Query;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder query(Function<RescoreQuery.Builder, ObjectBuilder<RescoreQuery>> fn) {
            return this.query(fn.apply(new RescoreQuery.Builder()).build());
        }

        public ContainerBuilder learningToRank(LearningToRank v) {
            this._kind = Kind.LearningToRank;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder learningToRank(Function<LearningToRank.Builder, ObjectBuilder<LearningToRank>> fn) {
            return this.learningToRank(fn.apply(new LearningToRank.Builder()).build());
        }

        public ContainerBuilder script(ScriptRescore v) {
            this._kind = Kind.Script;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder script(Function<ScriptRescore.Builder, ObjectBuilder<ScriptRescore>> fn) {
            return this.script(fn.apply(new ScriptRescore.Builder()).build());
        }

        public ContainerBuilder _custom(String name, Object data) {
            this._kind = Kind._Custom;
            this._customKind = name;
            this._value = JsonData.of(data);
            return new ContainerBuilder();
        }

        @Override
        public Rescore build() {
            this._checkSingleUse();
            return new Rescore(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<Rescore> {
            public final ContainerBuilder windowSize(@Nullable Integer value) {
                Builder.this.windowSize = value;
                return this;
            }

            @Override
            public Rescore build() {
                return Builder.this.build();
            }
        }
    }
}

