/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch._types.ErrorResponse;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.ml.RevertModelSnapshotResponse;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.transport.Endpoint;
import co.elastic.clients.transport.endpoints.SimpleEndpoint;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import jakarta.json.stream.JsonGenerator;
import java.util.Collections;
import java.util.HashMap;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class RevertModelSnapshotRequest
extends RequestBase
implements JsonpSerializable {
    @Nullable
    private final Boolean deleteInterveningResults;
    private final String jobId;
    private final String snapshotId;
    public static final JsonpDeserializer<RevertModelSnapshotRequest> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, RevertModelSnapshotRequest::setupRevertModelSnapshotRequestDeserializer);
    public static final Endpoint<RevertModelSnapshotRequest, RevertModelSnapshotResponse, ErrorResponse> _ENDPOINT = new SimpleEndpoint<RevertModelSnapshotRequest, RevertModelSnapshotResponse>("es/ml.revert_model_snapshot", request -> "POST", request -> {
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            StringBuilder buf = new StringBuilder();
            buf.append("/_ml");
            buf.append("/anomaly_detectors");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.jobId, buf);
            buf.append("/model_snapshots");
            buf.append("/");
            SimpleEndpoint.pathEncode(request.snapshotId, buf);
            buf.append("/_revert");
            return buf.toString();
        }
        throw SimpleEndpoint.noPathTemplateFound("path");
    }, request -> {
        HashMap<String, String> params = new HashMap<String, String>();
        boolean _snapshotId = true;
        int _jobId = 2;
        int propsSet = 0;
        propsSet |= 1;
        if ((propsSet |= 2) == 3) {
            params.put("jobId", request.jobId);
            params.put("snapshotId", request.snapshotId);
        }
        return params;
    }, request -> Collections.emptyMap(), SimpleEndpoint.emptyMap(), true, RevertModelSnapshotResponse._DESERIALIZER);

    private RevertModelSnapshotRequest(Builder builder) {
        this.deleteInterveningResults = builder.deleteInterveningResults;
        this.jobId = ApiTypeHelper.requireNonNull(builder.jobId, this, "jobId");
        this.snapshotId = ApiTypeHelper.requireNonNull(builder.snapshotId, this, "snapshotId");
    }

    public static RevertModelSnapshotRequest of(Function<Builder, ObjectBuilder<RevertModelSnapshotRequest>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Boolean deleteInterveningResults() {
        return this.deleteInterveningResults;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String snapshotId() {
        return this.snapshotId;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.deleteInterveningResults != null) {
            generator.writeKey("delete_intervening_results");
            generator.write(this.deleteInterveningResults.booleanValue());
        }
    }

    protected static void setupRevertModelSnapshotRequestDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::deleteInterveningResults, JsonpDeserializer.booleanDeserializer(), "delete_intervening_results");
    }

    public static class Builder
    extends RequestBase.AbstractBuilder<Builder>
    implements ObjectBuilder<RevertModelSnapshotRequest> {
        @Nullable
        private Boolean deleteInterveningResults;
        private String jobId;
        private String snapshotId;

        public final Builder deleteInterveningResults(@Nullable Boolean value) {
            this.deleteInterveningResults = value;
            return this;
        }

        public final Builder jobId(String value) {
            this.jobId = value;
            return this;
        }

        public final Builder snapshotId(String value) {
            this.snapshotId = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public RevertModelSnapshotRequest build() {
            this._checkSingleUse();
            return new RevertModelSnapshotRequest(this);
        }
    }
}

