/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml;

import co.elastic.clients.elasticsearch.ml.InferenceConfigCreate;
import co.elastic.clients.elasticsearch.ml.InferenceConfigCreateVariant;
import co.elastic.clients.elasticsearch.ml.TokenizationConfig;
import co.elastic.clients.elasticsearch.ml.TokenizationConfigVariant;
import co.elastic.clients.elasticsearch.ml.Vocabulary;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TextExpansionInferenceOptions
implements InferenceConfigCreateVariant,
JsonpSerializable {
    @Nullable
    private final TokenizationConfig tokenization;
    @Nullable
    private final String resultsField;
    @Nullable
    private final Vocabulary vocabulary;
    public static final JsonpDeserializer<TextExpansionInferenceOptions> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TextExpansionInferenceOptions::setupTextExpansionInferenceOptionsDeserializer);

    private TextExpansionInferenceOptions(Builder builder) {
        this.tokenization = builder.tokenization;
        this.resultsField = builder.resultsField;
        this.vocabulary = builder.vocabulary;
    }

    public static TextExpansionInferenceOptions of(Function<Builder, ObjectBuilder<TextExpansionInferenceOptions>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public InferenceConfigCreate.Kind _inferenceConfigCreateKind() {
        return InferenceConfigCreate.Kind.TextExpansion;
    }

    @Nullable
    public final TokenizationConfig tokenization() {
        return this.tokenization;
    }

    @Nullable
    public final String resultsField() {
        return this.resultsField;
    }

    @Nullable
    public final Vocabulary vocabulary() {
        return this.vocabulary;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.tokenization != null) {
            generator.writeKey("tokenization");
            this.tokenization.serialize(generator, mapper);
        }
        if (this.resultsField != null) {
            generator.writeKey("results_field");
            generator.write(this.resultsField);
        }
        if (this.vocabulary != null) {
            generator.writeKey("vocabulary");
            this.vocabulary.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTextExpansionInferenceOptionsDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::tokenization, TokenizationConfig._DESERIALIZER, "tokenization");
        op.add(Builder::resultsField, JsonpDeserializer.stringDeserializer(), "results_field");
        op.add(Builder::vocabulary, Vocabulary._DESERIALIZER, "vocabulary");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TextExpansionInferenceOptions> {
        @Nullable
        private TokenizationConfig tokenization;
        @Nullable
        private String resultsField;
        @Nullable
        private Vocabulary vocabulary;

        public final Builder tokenization(@Nullable TokenizationConfig value) {
            this.tokenization = value;
            return this;
        }

        public final Builder tokenization(Function<TokenizationConfig.Builder, ObjectBuilder<TokenizationConfig>> fn) {
            return this.tokenization(fn.apply(new TokenizationConfig.Builder()).build());
        }

        public final Builder tokenization(TokenizationConfigVariant value) {
            this.tokenization = value._toTokenizationConfig();
            return this;
        }

        public final Builder resultsField(@Nullable String value) {
            this.resultsField = value;
            return this;
        }

        public final Builder vocabulary(@Nullable Vocabulary value) {
            this.vocabulary = value;
            return this;
        }

        public final Builder vocabulary(Function<Vocabulary.Builder, ObjectBuilder<Vocabulary>> fn) {
            return this.vocabulary(fn.apply(new Vocabulary.Builder()).build());
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TextExpansionInferenceOptions build() {
            this._checkSingleUse();
            return new TextExpansionInferenceOptions(this);
        }
    }
}

