/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.json.jackson;

import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.jackson.Jackson3JsonpLocation;
import jakarta.json.JsonArray;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonNumber;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import jakarta.json.spi.JsonProvider;
import jakarta.json.stream.JsonLocation;
import jakarta.json.stream.JsonParsingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;

class Jackson3JsonValueParser {
    private final JsonProvider systemProvider = JsonpUtils.systemProvider();

    Jackson3JsonValueParser() {
    }

    public JsonObject parseObject(JsonParser parser) {
        JsonToken token;
        JsonObjectBuilder ob = this.systemProvider.createObjectBuilder();
        while ((token = parser.nextToken()) != JsonToken.END_OBJECT) {
            if (token != JsonToken.PROPERTY_NAME) {
                throw new JsonParsingException("Expected a property name", (JsonLocation)new Jackson3JsonpLocation(parser));
            }
            String name = parser.currentName();
            parser.nextToken();
            ob.add(name, this.parseValue(parser));
        }
        return ob.build();
    }

    public JsonArray parseArray(JsonParser parser) {
        JsonArrayBuilder ab = this.systemProvider.createArrayBuilder();
        while (parser.nextToken() != JsonToken.END_ARRAY) {
            ab.add(this.parseValue(parser));
        }
        return ab.build();
    }

    public JsonValue parseValue(JsonParser parser) {
        JsonToken jsonToken = parser.currentToken();
        switch (parser.currentToken()) {
            case START_OBJECT: {
                return this.parseObject(parser);
            }
            case START_ARRAY: {
                return this.parseArray(parser);
            }
            case VALUE_TRUE: {
                return JsonValue.TRUE;
            }
            case VALUE_FALSE: {
                return JsonValue.FALSE;
            }
            case VALUE_NULL: {
                return JsonValue.NULL;
            }
            case VALUE_STRING: {
                return this.systemProvider.createValue(parser.getText());
            }
            case VALUE_NUMBER_FLOAT: 
            case VALUE_NUMBER_INT: {
                switch (parser.getNumberType()) {
                    case INT: {
                        return this.systemProvider.createValue(parser.getIntValue());
                    }
                    case LONG: {
                        return this.systemProvider.createValue(parser.getLongValue());
                    }
                    case FLOAT: 
                    case DOUBLE: {
                        return new DoubleNumber(parser.getDoubleValue());
                    }
                    case BIG_DECIMAL: {
                        return this.systemProvider.createValue(parser.getDecimalValue());
                    }
                    case BIG_INTEGER: {
                        return this.systemProvider.createValue(parser.getBigIntegerValue());
                    }
                }
            }
        }
        throw new JsonParsingException("Unexpected token '" + String.valueOf(parser.currentToken()) + "'", (JsonLocation)new Jackson3JsonpLocation(parser));
    }

    private static class DoubleNumber
    implements JsonNumber {
        private final double value;

        DoubleNumber(double value) {
            this.value = value;
        }

        public boolean isIntegral() {
            return false;
        }

        public int intValue() {
            return (int)this.value;
        }

        public int intValueExact() {
            int result = (int)this.value;
            if ((double)result == this.value) {
                return result;
            }
            throw new ArithmeticException();
        }

        public long longValue() {
            return (long)this.value;
        }

        public long longValueExact() {
            long result = (long)this.value;
            if ((double)result == this.value) {
                return result;
            }
            throw new ArithmeticException();
        }

        public BigInteger bigIntegerValue() {
            return this.bigDecimalValue().toBigInteger();
        }

        public BigInteger bigIntegerValueExact() {
            return this.bigDecimalValue().toBigIntegerExact();
        }

        public double doubleValue() {
            return this.value;
        }

        public BigDecimal bigDecimalValue() {
            return new BigDecimal(this.value);
        }

        public JsonValue.ValueType getValueType() {
            return JsonValue.ValueType.NUMBER;
        }

        public Number numberValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public int hashCode() {
            return Double.hashCode(this.value);
        }

        public boolean equals(Object obj) {
            return obj instanceof DoubleNumber && ((DoubleNumber)obj).value == this.value;
        }
    }
}

