/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.evaluate_data_frame;

import co.elastic.clients.elasticsearch.ml.evaluate_data_frame.ConfusionMatrixPrediction;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;

@JsonpDeserializable
public class ConfusionMatrixItem
implements JsonpSerializable {
    private final String actualClass;
    private final int actualClassDocCount;
    private final List<ConfusionMatrixPrediction> predictedClasses;
    private final int otherPredictedClassDocCount;
    public static final JsonpDeserializer<ConfusionMatrixItem> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ConfusionMatrixItem::setupConfusionMatrixItemDeserializer);

    private ConfusionMatrixItem(Builder builder) {
        this.actualClass = ApiTypeHelper.requireNonNull(builder.actualClass, this, "actualClass");
        this.actualClassDocCount = ApiTypeHelper.requireNonNull(builder.actualClassDocCount, (Object)this, "actualClassDocCount", 0);
        this.predictedClasses = ApiTypeHelper.unmodifiableRequired(builder.predictedClasses, (Object)this, "predictedClasses");
        this.otherPredictedClassDocCount = ApiTypeHelper.requireNonNull(builder.otherPredictedClassDocCount, (Object)this, "otherPredictedClassDocCount", 0);
    }

    public static ConfusionMatrixItem of(Function<Builder, ObjectBuilder<ConfusionMatrixItem>> fn) {
        return fn.apply(new Builder()).build();
    }

    public final String actualClass() {
        return this.actualClass;
    }

    public final int actualClassDocCount() {
        return this.actualClassDocCount;
    }

    public final List<ConfusionMatrixPrediction> predictedClasses() {
        return this.predictedClasses;
    }

    public final int otherPredictedClassDocCount() {
        return this.otherPredictedClassDocCount;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("actual_class");
        generator.write(this.actualClass);
        generator.writeKey("actual_class_doc_count");
        generator.write(this.actualClassDocCount);
        if (ApiTypeHelper.isDefined(this.predictedClasses)) {
            generator.writeKey("predicted_classes");
            generator.writeStartArray();
            for (ConfusionMatrixPrediction item0 : this.predictedClasses) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        generator.writeKey("other_predicted_class_doc_count");
        generator.write(this.otherPredictedClassDocCount);
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupConfusionMatrixItemDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::actualClass, JsonpDeserializer.stringDeserializer(), "actual_class");
        op.add(Builder::actualClassDocCount, JsonpDeserializer.integerDeserializer(), "actual_class_doc_count");
        op.add(Builder::predictedClasses, JsonpDeserializer.arrayDeserializer(ConfusionMatrixPrediction._DESERIALIZER), "predicted_classes");
        op.add(Builder::otherPredictedClassDocCount, JsonpDeserializer.integerDeserializer(), "other_predicted_class_doc_count");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<ConfusionMatrixItem> {
        private String actualClass;
        private Integer actualClassDocCount;
        private List<ConfusionMatrixPrediction> predictedClasses;
        private Integer otherPredictedClassDocCount;

        public final Builder actualClass(String value) {
            this.actualClass = value;
            return this;
        }

        public final Builder actualClassDocCount(int value) {
            this.actualClassDocCount = value;
            return this;
        }

        public final Builder predictedClasses(List<ConfusionMatrixPrediction> list) {
            this.predictedClasses = Builder._listAddAll(this.predictedClasses, list);
            return this;
        }

        public final Builder predictedClasses(ConfusionMatrixPrediction value, ConfusionMatrixPrediction ... values) {
            this.predictedClasses = Builder._listAdd(this.predictedClasses, value, values);
            return this;
        }

        public final Builder predictedClasses(Function<ConfusionMatrixPrediction.Builder, ObjectBuilder<ConfusionMatrixPrediction>> fn) {
            return this.predictedClasses(fn.apply(new ConfusionMatrixPrediction.Builder()).build(), new ConfusionMatrixPrediction[0]);
        }

        public final Builder otherPredictedClassDocCount(int value) {
            this.otherPredictedClassDocCount = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public ConfusionMatrixItem build() {
            this._checkSingleUse();
            return new ConfusionMatrixItem(this);
        }
    }
}

