/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.project.tags;

import co.elastic.clients.elasticsearch.project.tags.Tags;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.NamedValue;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.function.Function;
import javax.annotation.Nullable;

public abstract class ProjectTags
implements JsonpSerializable {
    private final NamedValue<Tags> origin;
    private final Map<String, Tags> linkedProjects;

    protected ProjectTags(AbstractBuilder<?> builder) {
        this.origin = ApiTypeHelper.requireNonNull(builder.origin, this, "origin");
        this.linkedProjects = ApiTypeHelper.unmodifiable(builder.linkedProjects);
    }

    public final NamedValue<Tags> origin() {
        return this.origin;
    }

    public final Map<String, Tags> linkedProjects() {
        return this.linkedProjects;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeKey("origin");
        generator.writeStartObject();
        generator.writeKey(this.origin.name());
        this.origin.value().serialize(generator, mapper);
        generator.writeEnd();
        if (ApiTypeHelper.isDefined(this.linkedProjects)) {
            generator.writeKey("linked_projects");
            generator.writeStartObject();
            for (Map.Entry<String, Tags> item0 : this.linkedProjects.entrySet()) {
                generator.writeKey(item0.getKey());
                item0.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static <BuilderT extends AbstractBuilder<BuilderT>> void setupProjectTagsDeserializer(ObjectDeserializer<BuilderT> op) {
        op.add(AbstractBuilder::origin, NamedValue.deserializer(() -> Tags._DESERIALIZER), "origin");
        op.add(AbstractBuilder::linkedProjects, JsonpDeserializer.stringMapDeserializer(Tags._DESERIALIZER), "linked_projects");
    }

    public static abstract class AbstractBuilder<BuilderT extends AbstractBuilder<BuilderT>>
    extends WithJsonObjectBuilderBase<BuilderT> {
        private NamedValue<Tags> origin;
        @Nullable
        private Map<String, Tags> linkedProjects;

        public final BuilderT origin(NamedValue<Tags> value) {
            this.origin = value;
            return (BuilderT)this.self();
        }

        public BuilderT origin(String name, Tags value) {
            this.origin = new NamedValue<Tags>(name, value);
            return (BuilderT)this.self();
        }

        public BuilderT origin(String name, Function<Tags.Builder, ObjectBuilder<Tags>> fn) {
            return this.origin(name, fn.apply(new Tags.Builder()).build());
        }

        public final BuilderT linkedProjects(Map<String, Tags> map) {
            this.linkedProjects = AbstractBuilder._mapPutAll(this.linkedProjects, map);
            return (BuilderT)this.self();
        }

        public final BuilderT linkedProjects(String key, Tags value) {
            this.linkedProjects = AbstractBuilder._mapPut(this.linkedProjects, key, value);
            return (BuilderT)this.self();
        }

        public final BuilderT linkedProjects(String key, Function<Tags.Builder, ObjectBuilder<Tags>> fn) {
            return this.linkedProjects(key, fn.apply(new Tags.Builder()).build());
        }

        @Override
        protected abstract BuilderT self();
    }
}

