/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.aggregations;

import co.elastic.clients.elasticsearch._types.aggregations.Aggregation;
import co.elastic.clients.elasticsearch._types.aggregations.AggregationVariant;
import co.elastic.clients.elasticsearch._types.aggregations.FrequentItemSetsField;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FrequentItemSetsAggregation
implements AggregationVariant,
JsonpSerializable {
    private final List<FrequentItemSetsField> fields;
    @Nullable
    private final Integer minimumSetSize;
    @Nullable
    private final Double minimumSupport;
    @Nullable
    private final Integer size;
    @Nullable
    private final Query filter;
    public static final JsonpDeserializer<FrequentItemSetsAggregation> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FrequentItemSetsAggregation::setupFrequentItemSetsAggregationDeserializer);

    private FrequentItemSetsAggregation(Builder builder) {
        this.fields = ApiTypeHelper.unmodifiableRequired(builder.fields, (Object)this, "fields");
        this.minimumSetSize = builder.minimumSetSize;
        this.minimumSupport = builder.minimumSupport;
        this.size = builder.size;
        this.filter = builder.filter;
    }

    public static FrequentItemSetsAggregation of(Function<Builder, ObjectBuilder<FrequentItemSetsAggregation>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Aggregation.Kind _aggregationKind() {
        return Aggregation.Kind.FrequentItemSets;
    }

    public final List<FrequentItemSetsField> fields() {
        return this.fields;
    }

    @Nullable
    public final Integer minimumSetSize() {
        return this.minimumSetSize;
    }

    @Nullable
    public final Double minimumSupport() {
        return this.minimumSupport;
    }

    @Nullable
    public final Integer size() {
        return this.size;
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.fields)) {
            generator.writeKey("fields");
            generator.writeStartArray();
            for (FrequentItemSetsField item0 : this.fields) {
                item0.serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.minimumSetSize != null) {
            generator.writeKey("minimum_set_size");
            generator.write(this.minimumSetSize.intValue());
        }
        if (this.minimumSupport != null) {
            generator.writeKey("minimum_support");
            generator.write(this.minimumSupport.doubleValue());
        }
        if (this.size != null) {
            generator.writeKey("size");
            generator.write(this.size.intValue());
        }
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupFrequentItemSetsAggregationDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::fields, JsonpDeserializer.arrayDeserializer(FrequentItemSetsField._DESERIALIZER), "fields");
        op.add(Builder::minimumSetSize, JsonpDeserializer.integerDeserializer(), "minimum_set_size");
        op.add(Builder::minimumSupport, JsonpDeserializer.doubleDeserializer(), "minimum_support");
        op.add(Builder::size, JsonpDeserializer.integerDeserializer(), "size");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FrequentItemSetsAggregation> {
        private List<FrequentItemSetsField> fields;
        @Nullable
        private Integer minimumSetSize;
        @Nullable
        private Double minimumSupport;
        @Nullable
        private Integer size;
        @Nullable
        private Query filter;

        public final Builder fields(List<FrequentItemSetsField> list) {
            this.fields = Builder._listAddAll(this.fields, list);
            return this;
        }

        public final Builder fields(FrequentItemSetsField value, FrequentItemSetsField ... values) {
            this.fields = Builder._listAdd(this.fields, value, values);
            return this;
        }

        public final Builder fields(Function<FrequentItemSetsField.Builder, ObjectBuilder<FrequentItemSetsField>> fn) {
            return this.fields(fn.apply(new FrequentItemSetsField.Builder()).build(), new FrequentItemSetsField[0]);
        }

        public final Builder minimumSetSize(@Nullable Integer value) {
            this.minimumSetSize = value;
            return this;
        }

        public final Builder minimumSupport(@Nullable Double value) {
            this.minimumSupport = value;
            return this;
        }

        public final Builder size(@Nullable Integer value) {
            this.size = value;
            return this;
        }

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public FrequentItemSetsAggregation build() {
            this._checkSingleUse();
            return new FrequentItemSetsAggregation(this);
        }
    }
}

